;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/bit.scm                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 27 11:06:41 1995                          */
;*    Last change :  Mon May  7 18:54:09 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Bit management                                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __bit
   
   (import  __error)
   
   (use     __type
	    __bigloo
	    __tvector
	    __r4_numbers_6_5_fixnum
	    __r4_equivalence_6_2
	    __r4_characters_6_6
	    __r4_vectors_6_8
	    __r4_booleans_6_1
	    __r4_pairs_and_lists_6_3
	    __r4_symbols_6_4
	    __r4_strings_6_7
	    __evenv)
   
   (extern  (infix macro c-bitor::long   (::long ::long)    " | ")
	    (infix macro c-bitand::long  (::long ::long)    " & ")
	    (infix macro c-bitxor::long  (::long ::long)    " ^ ")
	    (macro c-bitnot::long  (::long)                 "~")
	    (infix macro c-bitrsh::long  (::long ::int)     " >> ")
	    (infix macro c-bitursh::ulong (::ulong ::int)   " >> ")
	    (infix macro c-bitlsh::long  (::long ::int)     " << "))
   
   (java    (class foreign
	       (method static c-bitor::long   (::long ::long)  "BITOR")
	       (method static c-bitand::long  (::long ::long)  "BITAND")
	       (method static c-bitxor::long  (::long ::long)  "BITXOR")
	       (method static c-bitnot::long  (::long)         "BITNOT")
	       (method static c-bitrsh::long  (::long ::int)   "BITRSH")
	       (method static c-bitursh::ulong (::ulong ::int) "BITURSH")
	       (method static c-bitlsh::long  (::long ::int)   "BITLSH")))
   
   (export  (inline bit-or::long    ::long ::long)
	    (inline bit-and::long   ::long ::long)
	    (inline bit-xor::long   ::long ::long)
	    (inline bit-not::long   ::long)
	    (inline bit-rsh::long   ::long ::long)
	    (inline bit-ursh::ulong ::ulong ::ulong)
	    (inline bit-lsh::long   ::long ::long))
   
   (pragma  (c-bitor side-effect-free no-cfa-top nesting)
	    (c-bitand side-effect-free no-cfa-top nesting)
	    (c-bitxor side-effect-free no-cfa-top nesting)
	    (c-bitnot side-effect-free no-cfa-top nesting)
	    (c-bitrsh side-effect-free no-cfa-top nesting)
	    (c-bitursh side-effect-free no-cfa-top nesting)
	    (c-bitlsh side-effect-free no-cfa-top nesting)
	    (bit-or side-effect-free no-cfa-top nesting)
	    (bit-and side-effect-free no-cfa-top nesting)
	    (bit-xor side-effect-free no-cfa-top nesting)
	    (bit-not side-effect-free no-cfa-top nesting)
	    (bit-rsh side-effect-free no-cfa-top nesting)
	    (bit-ursh side-effect-free no-cfa-top nesting)
	    (bit-lsh side-effect-free no-cfa-top nesting)))

;*---------------------------------------------------------------------*/
;*    bit-or ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (bit-or x y)
   (c-bitor x y))

;*---------------------------------------------------------------------*/
;*    bit-and ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (bit-and x y)
   (c-bitand x y))

;*---------------------------------------------------------------------*/
;*    bit-xor ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (bit-xor x y)
   (c-bitxor x y))

;*---------------------------------------------------------------------*/
;*    bit-not ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (bit-not x)
   (c-bitnot x))
   
;*---------------------------------------------------------------------*/
;*    bit-rsh ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (bit-rsh x y)
   (c-bitrsh x y))
       
;*---------------------------------------------------------------------*/
;*    bit-ursh ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (bit-ursh x y)
   (c-bitursh x y))
       
;*---------------------------------------------------------------------*/
;*    bit-lsh ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (bit-lsh x y)
   (c-bitlsh x y))

