/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/cforeign.c              */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Oct 19 08:45:22 1993                          */
/*    Last change :  Sun May  7 09:50:52 2000 (serrano)                */
/*    -------------------------------------------------------------    */
/*    La gestion de l'interface etrangere                              */
/*=====================================================================*/
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    cobj_to_foreign ...                                              */
/*---------------------------------------------------------------------*/
obj_t
cobj_to_foreign( obj_t id, void *cobj )
{
   obj_t handle;

   handle = GC_MALLOC( FOREIGN_SIZE );
   
   handle->foreign_t.header = MAKE_HEADER( FOREIGN_TYPE, FOREIGN_SIZE );
   handle->foreign_t.cobj   = (void *)cobj;
   handle->foreign_t.id     = id;

   return BGL_HEAP_DEBUG_MARK_OBJ( BREF( handle ) );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    void_star_to_obj ...                                             */
/*---------------------------------------------------------------------*/
obj_t
void_star_to_obj( void *cobj )
{
   static obj_t id = BUNSPEC;

   if( !SYMBOLP( id ) )
      id = string_to_symbol( "VOID*" );

   return cobj_to_foreign( id, cobj );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    obj_to_cobj ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
obj_to_cobj( obj_t obj )
{
   if( INTEGERP( obj ) )
      return (obj_t)CINT( obj );
   if( BOOLEANP( obj ) )
      return (obj_t)((long)CBOOL( obj ));
   if( STRINGP( obj ) )
      return (obj_t)BSTRING_TO_STRING( obj );
   if( CHARP( obj ) )
      return (obj_t)((long)CCHAR( obj ));
   if( FOREIGNP( obj ) )
      return (obj_t)FOREIGN_TO_COBJ( obj );
   if( REALP( obj ) )
      return the_failure( string_to_bstring( "obj->cobj" ),
			  string_to_bstring( "Can't cast a real to foreign" ),
			  obj);
   else
      return the_failure( string_to_bstring( "obj->cobj" ),
			  string_to_bstring( "Illegal object type" ),
			  obj);
}
 
