;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/hash.scm                     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Nov 26 11:50:50 1994                          */
;*    Last change :  Wed Nov  7 15:55:48 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On test les tables de hash                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module hash
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-hash)))

;*---------------------------------------------------------------------*/
;*    test1-old ...                                                    */
;*---------------------------------------------------------------------*/
(define (test1-old)
   (let ((table (make-hash-table 256 string->0..255 car string=?)))
      ;; on remplis la table
      (let loop ((i 1024))
	 (if (=fx i 0)
	     (and (eq? (cdr (get-hash "object834" table)) 834)
		  (eq? (cdr (get-hash "object835" table)) 835)
		  (eq? (cdr (get-hash "object836" table)) 836)
		  (eq? (cdr (get-hash "object837" table)) 837)
		  (not (eq? (cdr (get-hash "object134" table)) 834))
		  (not (eq? (cdr (get-hash "object135" table)) 835))
		  (not (eq? (cdr (get-hash "object136" table)) 836))
		  (not (eq? (cdr (get-hash "object137" table)) 837)))
	     (begin
		(put-hash! (cons (string-append "object"
						(number->string i))
				 i)
			   table)
		(loop (-fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    test1-new ...                                                    */
;*---------------------------------------------------------------------*/
(define (test1-new)
   (let ((table (make-hashtable 2)))
      ;; on remplis la table
      (let loop ((i 1024))
	 (if (=fx i 0)
	     (and (=fx (hashtable-get table "object834") 834)
		  (=fx (hashtable-get table "object835") 835)
		  (=fx (hashtable-get table "object836") 836)
		  (=fx (hashtable-get table "object837") 837)
		  (not (=fx (hashtable-get table "object134") 834))
		  (not (=fx (hashtable-get table "object135") 835))
		  (not (=fx (hashtable-get table "object136") 836))
		  (not (=fx (hashtable-get table "object137") 837)))
	     (begin
		(hashtable-put! table
				(string-append "object" (number->string i))
				i)
		(loop (-fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    test2-old ...                                                    */
;*---------------------------------------------------------------------*/
(define (test2-old)
   (let ((table (make-hash-table 4096 (lambda (o)
					 (string->0..2^x-1 o 12))
				 car string=? 256)))
      ;; on remplis la table
      (let loop ((i 10024))
	 (if (=fx i 0)
	     (and (= (cdr (get-hash "object5834" table)) 5834)
		  (= (cdr (get-hash "object5835" table)) 5835)
		  (= (cdr (get-hash "object5836" table)) 5836)
		  (= (cdr (get-hash "object5837" table)) 5837)
		  (not (= (cdr (get-hash "object9134" table)) 5834))
		  (not (= (cdr (get-hash "object9135" table)) 5835))
		  (not (= (cdr (get-hash "object9136" table)) 5836))
		  (not (= (cdr (get-hash "object9137" table)) 5837)))
	     (begin
		(put-hash! (cons (string-append "object"
						(number->string i))
				 i)
			   table)
		(loop (-fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    test2-new ...                                                    */
;*---------------------------------------------------------------------*/
(define (test2-new)
   (let ((table (make-hashtable)))
      ;; on remplis la table
      (let loop ((i 10024))
	 (if (=fx i 0)
	     (and (= (hashtable-get table "object5834") 5834)
		  (= (hashtable-get table "object5835") 5835)
		  (= (hashtable-get table "object5836") 5836)
		  (= (hashtable-get table "object5837") 5837)
		  (not (= (hashtable-get table "object9134") 5834))
		  (not (= (hashtable-get table "object9135") 5835))
		  (not (= (hashtable-get table "object9136") 5836))
		  (not (= (hashtable-get table "object9137") 5837)))
	     (begin
		(hashtable-put! table
				(string-append "object"
					       (number->string i))
			       i)
		(loop (-fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    test3-old ...                                                    */
;*---------------------------------------------------------------------*/
(define (test3-old)
   (let ((table (make-hash-table 256 obj->0..255 (lambda (x) x) eq?)))
      (put-hash! 123 table)
      (if (eq? (get-hash 123 table) 123)
	  (begin
	     (rem-obj-hash! 123 table)
	     (if (not (get-hash 123 table))
		 #t
		 #f))
	  #f)))
      
;*---------------------------------------------------------------------*/
;*    test3-new ...                                                    */
;*---------------------------------------------------------------------*/
(define (test3-new)
   (let ((table (make-hashtable)))
      (hashtable-put! table 123 123)
      (let ((v (hashtable-get table 123)))
	 (if (and (fixnum? v) (=fx v 123))
	     (begin
		(hashtable-remove! table 123)
		(if (not (hashtable-get table 123))
		    #t
		    #f))
	     #f))))

;*---------------------------------------------------------------------*/
;*    test4-new ...                                                    */
;*---------------------------------------------------------------------*/
(define (test4-new)
   (let ((table (make-hashtable))
	 (cell (cons 1 2)))
      (hashtable-put! table "toto" 1)
      (hashtable-put! table 'toto 2)
      (hashtable-put! table 123 3)
      (hashtable-put! table cell 5)
      (hashtable-put! table cell 4)
      (and (=fx (hashtable-get table "toto") 1)
	   (=fx (hashtable-get table 'toto) 2)
	   (=fx (hashtable-get table 123) 3)
	   (=fx (hashtable-get table cell) 4)
	   (begin
	      (hashtable-remove! table "toto")
	      (hashtable-remove! table 'toto)
	      (hashtable-remove! table 123)
	      (hashtable-remove! table cell)
	      (and (not (hashtable-get table "toto"))
		   (not (hashtable-get table 'toto))
		   (not (hashtable-get table 123))
		   (not (hashtable-get table cell)))))))

;*---------------------------------------------------------------------*/
;*    test-update ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-update)
   (let ((table (make-hashtable)))
      (hashtable-update! table 'foo (lambda (x) (+ 1 x)) 1)
      (hashtable-put! table 'bar 1)
      (let ((r1 (hashtable-get table 'foo)))
	 (hashtable-update! table 'foo (lambda (x) (+ 1 x)) 1)
	 (hashtable-update! table 'bar (lambda (x) (+ 1 x)) 1)
	 (let ((r2 (hashtable-get table 'foo))
	       (r3 (hashtable-get table 'bar)))
	    (and (=fx r1 1) (=fx r2 2) (=fx r3 2))))))
		   
;*---------------------------------------------------------------------*/
;*    test-hash ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-hash)
   (test-module "hash" "hash.scm")
   (test "hash" (test1-old) #t)
   (test "hash" (test2-old) #t)
   (test "remove" (test3-old) #t)
   (test "hash" (test1-new) #t)
   (test "hash" (test2-new) #t)
   (test "remove" (test3-new) #t)
   (test "heterogeneous" (test4-new) #t)
   (test "update" (test-update) #t))

