;*=====================================================================*/
;*    serrano/prgm/project/bigloo2.3/comptime/Tools/misc.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Dec 29 16:54:25 1994                          */
;*    Last change :  Mon Jul 17 11:03:20 2000 (serrano)                */
;*    Copyright   :  1994-2000 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    Various general tools                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module tools_misc
   (export (replace! p1 p2)
	   (epairify p1::pair p2)
	   (epairify* def . srcs)
	   (build-path-from-shell-variable::pair-nil ::bstring)))
   
;*---------------------------------------------------------------------*/
;*    replace! ...                                                     */
;*---------------------------------------------------------------------*/
(define (replace! p1 p2)
   (if (and (pair? p1) (pair? p2) (not (epair? p2)))
       (begin
	  (set-car! p1 (car p2))
	  (set-cdr! p1 (cdr p2))
	  p1)
       p2))

;*---------------------------------------------------------------------*/
;*    epairify ...                                                     */
;*    -------------------------------------------------------------    */
;*    If the struct definition was an extended pair (that is if we     */
;*    were tracking the source location of the structure), we          */
;*    propagate inside the generated function, the define-struct       */
;*    location.                                                        */
;*---------------------------------------------------------------------*/
(define (epairify pair::pair epair)
   (if (epair? epair)
       (econs (car pair) (cdr pair) (cer epair))
       pair))

;*---------------------------------------------------------------------*/
;*    epairify* ...                                                    */
;*---------------------------------------------------------------------*/
(define (epairify* def . srcs)
   (let loop ((srcs srcs))
      (cond
	 ((null? srcs)
	  def)
	 ((epair? (car srcs))
	  (econs (car def) (cdr def) (cer (car srcs))))
	 (else
	  (loop (cdr srcs))))))

;*---------------------------------------------------------------------*/
;*    build-path-from-shell-variable ...                               */
;*---------------------------------------------------------------------*/
(define (build-path-from-shell-variable::pair-nil var::bstring)
   (let ((val (getenv var)))
      (if (string? val)
	  (string-case val
	     ((+ (out #\:))
	      (let* ((str (the-string))
		     (res (ignore)))
		 (cons str res)))
	     (#\:
	      (ignore))
	     (else
	      '()))
	  '())))

