;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime.case1.4/Read/src.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 26 10:44:03 1994                          */
;*    Last change :  Fri Jul  6 08:24:06 2001 (serrano)                */
;*    Copyright   :  1994-2001 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    We read the source file                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module read_src
   (import  read_reader
	    engine_param
	    engine_engine
 	    init_main)
   (export  (read-src)))

;*---------------------------------------------------------------------*/
;*    read-src ...                                                     */
;*    -------------------------------------------------------------    */
;*    If the first source file start by an expression like             */
;*    #!...                                                            */
;*    we must evaluate the file rather than compile it. Hence,         */
;*    read_src returns `#f' to the compiler which means that the       */
;*    compiler will stop and jump to the interpreter.                  */
;*---------------------------------------------------------------------*/
(define (read-src)
   [assert (*src-files*) (pair? *src-files*)]
   ;; we read the first source file (which must be containing the
   ;; module clause).
   (let ((module (read-module-clause)))
      (if (not (pair? module))
	  module
	  (let loop ((src    (read-src/port))
		     (sfiles (cdr *src-files*)))
	     (if (null? sfiles)
		 (cons module (reverse! src))
		 (loop (append (read-src-file (car sfiles)) src)
		       (cdr sfiles)))))))

;*---------------------------------------------------------------------*/
;*    read-handler ...                                                 */
;*---------------------------------------------------------------------*/
(define read-handler
   (lambda (escape proc mes obj)
      ;; before producing the error, we display the
      ;; source file name
      (hello-world)
      ;; then we display the error.
      (notify-error proc mes obj)
      (close-src-port)
      (exit-bigloo -3)))

;*---------------------------------------------------------------------*/
;*    read-module-clause ...                                           */
;*---------------------------------------------------------------------*/
(define (read-module-clause)
   (open-src-file (car *src-files*))
   (let ((module (try (compiler-read *port* #t)
		      read-handler)))
      (if *bigloo-interpreter*
	  ;; the `*bigloo-interpreter* variable is setted by the
	  ;; reader when it seees a #!... expression
	  #f
	  module)))

;*---------------------------------------------------------------------*/
;*    read-src/port ...                                                */
;*---------------------------------------------------------------------*/
(define (read-src/port)
   (let ((port *port*))
      (try (let loop ((r   (compiler-read port #t))
		      (acc '()))
	      (if (eof-object? r)
		  (begin
		     (close-src-port)
		     acc)
		  (loop (compiler-read port #t)
			(cons r acc))))
	   read-handler)))

;*---------------------------------------------------------------------*/
;*    read-src-file ...                                                */
;*---------------------------------------------------------------------*/
(define (read-src-file sfile)
   (open-src-file (find-file/path sfile *load-path*))
   (read-src/port))

;*---------------------------------------------------------------------*/
;*    *port* ...                                                       */
;*---------------------------------------------------------------------*/
(define *port* #f)
		  
;*---------------------------------------------------------------------*/
;*    open-src-file ...                                                */
;*---------------------------------------------------------------------*/
(define (open-src-file sfile)
   (reader-reset!)
   (set! *port* (if (string? sfile)
		    (if (file-exists? sfile)
			(let ((port (open-input-file sfile)))
			   (if (input-port? port)
			       (begin
				  (reader-reset!)
				  port)
			       (error "src-file->memory"
				      "Can't open such file"
				      sfile)))
			(error "src-file->memory"
			       "Can't find such file"
			       sfile))
		    (current-input-port))))

;*---------------------------------------------------------------------*/
;*    close-src-port ...                                               */
;*---------------------------------------------------------------------*/
(define (close-src-port)
   (if (and (input-port? *port*)
	    (not (eq? *port* (current-input-port))))
       (close-input-port *port*)))

   
