;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime.case1.4/Module/with.scm     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jun  4 16:28:03 1996                          */
;*    Last change :  Fri Jul  6 09:29:44 2001 (serrano)                */
;*    Copyright   :  1996-2001 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The with clauses compilation.                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module module_with
   (import module_module
	   engine_param
	   tools_error
	   tools_location
	   module_impuse
	   read_access)
   (export (make-with-compiler)
	   (early-with-clauses)))

;*---------------------------------------------------------------------*/
;*    make-with-compiler ...                                           */
;*---------------------------------------------------------------------*/
(define (make-with-compiler)
   (instantiate::ccomp (id 'with) (producer with-producer)))

;*---------------------------------------------------------------------*/
;*    with-producer ...                                                */
;*---------------------------------------------------------------------*/
(define (with-producer clause)
   (match-case clause
      ((?- . ?protos)
       (for-each (lambda (proto) (with-parser proto clause)) protos))
      (else
       (user-error/location (find-location/loc clause
					       (find-location *module-clause*))
			    "Parse error"
			    (string-append "Illegal `with' clause")
			    clause
			    '()))))
   
;*---------------------------------------------------------------------*/
;*    with-parser ...                                                  */
;*---------------------------------------------------------------------*/
(define (with-parser proto clause)
   (let ((loc (find-location/loc proto (find-location *module-clause*))))
      (match-case proto
	 (((and ?name (? symbol?)) (and ?file (? string?)) . ?rest)
	  (let loop ((rest   rest)
		     (fnames (list file)))
	     (cond
		((null? rest)
		 (add-access! name (reverse! fnames)))
		((string? (car rest))
		 (loop (cdr rest)
		       (cons (car rest) fnames)))
		(else
		 (user-error/location loc
				      "Parse error"
				      (string-append "Illegal `with' clause")
				      clause
				      '()))))
	  (set! *with-files* (cons (o-name file) *with-files*))
	  (import-with-module! name proto))
	 (else
	  (if (not (symbol? proto))
	      (user-error/location loc
				   "Parse error"
				   (string-append "Illegal `with' clause")
				   clause
				   '())
	      (let ((b (assq proto *access-table*)))
		 (if (not b)
		     (user-error/location loc
					  proto
					  "can't access module"
					  clause
					  '())
		     (begin
			(set! *with-files* (cons (o-name (cadr b))
						 *with-files*))
			(import-with-module! proto proto)))))))))

;*---------------------------------------------------------------------*/
;*    o-name ...                                                       */
;*---------------------------------------------------------------------*/
(define (o-name file)   
   (string-append (prefix file) ".o"))
	     
;*---------------------------------------------------------------------*/
;*    early-with-clauses ...                                           */
;*    -------------------------------------------------------------    */
;*    Compute the early with clause by simply collecting the           */
;*    *EARLY-WITH-MODULES* values (see init_parser-args.scm and        */
;*    engine_param).                                                   */
;*---------------------------------------------------------------------*/
(define (early-with-clauses)
   `(with ,@*early-with-modules*))
	    
   
   
