;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Expand/garith.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Aug 26 09:16:36 1994                          */
;*    Last change :  Mon May 15 07:45:14 2000 (serrano)                */
;*    Copyright   :  1994-2000 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    Les expandeurs arithmetiques (generiques)                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_garithmetique
   (export (expand-g+  ::obj ::procedure)
	   (expand-g-  ::obj ::procedure)
	   (expand-g*  ::obj ::procedure)
	   (expand-g/  ::obj ::procedure)
	   (expand-g=  ::obj ::procedure)
	   (expand-g<  ::obj ::procedure)
	   (expand-g>  ::obj ::procedure)
	   (expand-g<= ::obj ::procedure)
	   (expand-g>= ::obj ::procedure)))

;*---------------------------------------------------------------------*/
;*    expand-g+ ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-g+ x e)
   (match-case x
      ((?-)
       0)
      ((?- . (?x . ()))
       (e x e))
      ((?- ?x . (?y . ()))
       (cond
	  ((and (number? x) (number? y))
	   (+ x y))
	  (else
	   (e `(2+ ,x ,y) e))))
      ((?- ?x . ?y)
       (e `(2+ ,x (+ ,@y)) e)))) 
      
;*---------------------------------------------------------------------*/
;*    expand-g- ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-g- x e)
   (match-case x
      ((?- . (?x . ()))
       (cond
	  ((integer? x)
	   (negfx x))
	  ((real? x)
	   (negfl x))
	  (else
	   `(- ,(e x e)))))
      ((?- ?x . (?y . ()))
       (cond
	  ((and (number? x) (number? y))
	   (- x y))
	  (else
	   (e `(2- ,x ,y) e))))
      ((?- ?x . ?y)
       (e `(2- ,x (+ ,@y)) e))))
       
;*---------------------------------------------------------------------*/
;*    expand-g* ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-g* x e)
   (match-case x
      ((?-)
       1)
      ((?- . (?x . ()))
       (e x e))
      ((?- ?x . (?y . ()))
       (cond
	  ((and (number? x) (number? y))
	   (* x y))
	  (else
	   (e `(2* ,x ,y) e))))
      ((?- ?x . ?y)
       (e `(2* ,x (* ,@y)) e)))) 
      
;*---------------------------------------------------------------------*/
;*    expand-g/ ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-g/ x e)
   (match-case x
      ((?- . (?x . ()))
       `(2/ 1 ,(e x e)))
      ((?- ?x . (?y . ()))
       (cond
	  ((and (number? x) (number? y))
	   (/ x y))
	  (else
	   (e `(2/ ,x ,y) e))))
      ((?- ?x . ?y)
       (e `(2/ ,x (* ,@y)) e))))
      
;*---------------------------------------------------------------------*/
;*    expand-g= ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-g= x e)
   (match-case x
      ((?- ?x . (?y . ()))
       (cond
	  ((and (number? x) (number? y))
	   (= x y))
	  (else
	   (e `(2= ,x ,y) e))))
      ((?- ?-)
       (error "=" "Illegal form" x))
      ((?- ?x . ?y)
       (e `(and (2= ,x ,(car y)) (= ,@y)) e))))

;*---------------------------------------------------------------------*/
;*    expand-g< ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-g< x e)
   (match-case x
      ((?- ?x . (?y . ()))
       (cond
	  ((and (number? x) (number? y))
	   (< x y))
	  (else
	   (e `(2< ,x ,y) e))))
      ((?- ?-)
       (error "<" "Illegal form" x))
      ((?- ?x . ?y)
       (e `(and (2< ,x ,(car y)) (< ,@y)) e))))

;*---------------------------------------------------------------------*/
;*    expand-g> ...                                                    */
;*---------------------------------------------------------------------*/
(define (expand-g> x e)
    (match-case x
      ((?- ?x . (?y . ()))
       (cond
	  ((and (number? x) (number? y))
	   (> x y))
	  (else
	   (e `(2> ,x ,y) e))))
      ((?- ?-)
       (error ">" "Illegal form" x))
      ((?- ?x . ?y)
       (e `(and (2> ,x ,(car y)) (> ,@y)) e))))
     
;*---------------------------------------------------------------------*/
;*    expand-g<= ...                                                   */
;*---------------------------------------------------------------------*/
(define (expand-g<= x e)
   (match-case x
      ((?- ?x . (?y . ()))
       (cond
	  ((and (number? x) (number? y))
	   (<= x y))
	  (else
	   (e `(2<= ,x ,y) e))))
      ((?- ?-)
       (error "<=" "Illegal form" x))
      ((?- ?x . ?y)
       (e `(and (2<= ,x ,(car y)) (<= ,@y)) e))))
      
;*---------------------------------------------------------------------*/
;*    expand-g>= ...                                                   */
;*---------------------------------------------------------------------*/
(define (expand-g>= x e)
    (match-case x
      ((?- ?x . (?y . ()))
       (cond
	  ((and (number? x) (number? y))
	   (>= x y))
	  (else
	   (e `(2>= ,x ,y) e))))
      ((?- ?-)
       (error ">=" "Illegal form" x))
      ((?- ?x . ?y)
       (e `(and (2>= ,x ,(car y)) (>= ,@y)) e))))

