;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Cc/ld.scm                   */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jul 17 09:37:55 1992                          */
;*    Last change :  Fri Nov 30 14:34:48 2001 (serrano)                */
;*    Copyright   :  1992-2001 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The (system) link.                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cc_ld
   (export  (ld name ::bool))
   (import  tools_speek
	    tools_error
	    cc_exec
	    engine_param
	    engine_configure))

;*---------------------------------------------------------------------*/
;*    list-of-string->string ...                                       */
;*---------------------------------------------------------------------*/
(define (list-of-string->string l)
   (let loop ((l (reverse l))
	      (r ""))
      (if (null? l)
	  r
	  (loop (cdr l)
		(string-append (car l) " " r)))))

;*---------------------------------------------------------------------*/
;*    ld ...                                                           */
;*---------------------------------------------------------------------*/
(define (ld name need-to-return)
   (cond
      ((string=? (os-class) "unix")
       (unix-ld name need-to-return))
      (else
       (user-error "ld" "Unknow os" (os-class)))))

;*---------------------------------------------------------------------*/
;*    lib+suffix ...                                                   */
;*---------------------------------------------------------------------*/
(define (lib+suffix lib static? force?)
   (if (or (and force? static?)
	   (and (not force?)
		(or static?
		    *static-bigloo?*
		    (not bgl-configure-shared-library-available?))))
       (make-static-library-name lib)
       (make-shared-library-name lib)))

;*---------------------------------------------------------------------*/
;*    make-lib-name ...                                                */
;*---------------------------------------------------------------------*/
(define (make-lib-name lib-name rep-name static? force?)
   (if (and *ld-relative* (not (or static? *static-bigloo?*)))
       (string-append "-l" lib-name)
       (let* ((libname (string-append "lib" lib-name))
	      (fname (lib+suffix libname static? force?))
	      (name (find-file/path fname *lib-dir*)))
	  (if (string? name)
	      name
	      (if static?
		  (begin
		     (warning "make-lib-name"
			      "Can't find library `" lib-name "' -- "
			      "try shared library for `" lib-name "'")
		     (make-lib-name lib-name rep-name #f #t))
		  (if (string? rep-name)
		      (begin
			 (warning "make-lib-name"
				  "Can't find library `" lib-name "' -- "
				  "try replacement library `" rep-name "'")
			 (make-lib-name rep-name #f #t #t))
		      (error fname "Can't find library" *lib-dir*)))))))

;*---------------------------------------------------------------------*/
;*    select-library ...                                               */
;*---------------------------------------------------------------------*/
(define (select-library lib-name)
   (cond
      (*profile-library*
       (string-append lib-name "_p"))
      ((>fx *bdb-debug* 1)
       (string-append lib-name "_d"))
      (*unsafe-library*
       (string-append lib-name "_u"))
      (else
       lib-name)))
   
;*---------------------------------------------------------------------*/
;*    select-replacement-library ...                                   */
;*---------------------------------------------------------------------*/
(define (select-replacement-library lib-name)
   (cond
      (*profile-library*
       (string-append lib-name ""))
      ((>fx *bdb-debug* 1)
       (string-append lib-name "_d"))
      (*unsafe-library*
       (string-append lib-name ""))
      (else
       lib-name)))
   
;*---------------------------------------------------------------------*/
;*    select-profile-debug-library ...                                 */
;*---------------------------------------------------------------------*/
(define (select-profile-debug-library lib-name)
   (cond
      (*profile-library*
       (string-append lib-name "_p"))
      ((>fx *bdb-debug* 1)
       (string-append lib-name "_d"))
      (else
       lib-name)))
   
;*---------------------------------------------------------------------*/
;*    select-replacement-profile-debug-library ...                     */
;*---------------------------------------------------------------------*/
(define (select-replacement-profile-debug-library lib-name)
   (cond
      (*profile-library*
       (string-append lib-name ""))
      ((>fx *bdb-debug* 1)
       (string-append lib-name "_d"))
      (else
       lib-name)))
   
;*---------------------------------------------------------------------*/
;*    ld ...                                                           */
;*    -------------------------------------------------------------    */
;*    Le link se fait avec plusieurs fichiers:                         */
;*       1- Le fichier .o resultat de la compilation courrante         */
;*       2- Tous les .o qui ont ete passes en argument                 */
;*       3- Tous les .o qui correspondent aux fichiers de presents     */
;*          dans les clauses `with' du main.                           */
;*---------------------------------------------------------------------*/
(define (unix-ld name need-to-return)
   (verbose 1 "   . ld (" *cc* ")" #\Newline)
   ;; we add additional, machine specific, link options.
   (let ((static? (string-case *ld-options*
		     ((: (* all) "-static")
		      #t)
		     (else
		      #f))))
      (if static?
	  (set! *ld-options* (string-append bgl-configure-static-link-option
					    " " *ld-options*))
	  (set! *ld-options* (string-append bgl-configure-shared-link-option
					    " " *ld-options*)))
      (let* ((dest        (if (string? *dest*)
			      *dest*
			      bgl-configure-a.out))
	     ;; the standard bigloo library
	     (lib-name    (select-library *bigloo-lib*))
	     (rep-name    (select-replacement-library *bigloo-lib*))
	     (bigloo-lib  (make-lib-name lib-name rep-name static? #f))
	     ;; the garbarge collector libary
	     (gclib-name  (select-profile-debug-library *gc-lib*))
	     (gc-lib      (make-lib-name gclib-name
					 #f
					 (or *profile-library* static?)
					 #f))
	     ;; the debugger library
	     (bdb-lib     (cond
			     ((>fx *bdb-debug* 1)
			      (make-lib-name "bdb_d" #f #t #f))
			     ((>fx *bdb-debug* 0)
			      (make-lib-name "bdb_u" #f #t #f))
			     (else
			      "")))
	     ;; the extra bigloo libraries
	     (add-libs    (let loop ((lib *additional-bigloo-libraries*)
				     (res  ""))
			     (if (null? lib)
				 res
				 (loop (cdr lib)
				       (string-append
					(make-lib-name
					 (select-library (car lib))
					 (select-replacement-library (car lib))
					 static?
					 #f)
					" "
					res)))))
	     ;; the extra user C libraries
	     (other-libs  (let loop ((lib (reverse *bigloo-user-lib*))
				     (res ""))
			     (if (null? lib)
				 res
				 (loop (cdr lib)
				       (string-append (car lib)
						      " " res)))))
	     (ld-args     (string-append
			   ;; object file name
			   name ".o" " "
			   ;; to be linked with files
			   (list-of-string->string *with-files*)
			   ;; other object files
			   (list-of-string->string *o-files*)
			   ;; the executable name
			   " -o " dest
			   ;; cc options
			   " "  *cc-options*
			   ;; optional debug option
			   (if (or *c-debug* (>fx *bdb-debug* 0))
			       (string-append " " *c-debug-option*)
			       "")
			   ;; optional executable stripping
			   (if *strip*
			       (string-append " " bgl-configure-c-strip-flag)
			       "")
			   ;; user ld otions
			   " " *ld-options*
			   ;; the library path
			   (let loop ((path *lib-dir*))
			      (if (null? path)
				  ""
				  (string-append "-L"
						 (car path)
						 " "
						 (loop (cdr path)))))
			   ;; the bdb library
			   " " bdb-lib
			   ;; additional Bigloo libaries
			   " " add-libs
			   ;; standard bigloo library
			   " " bigloo-lib
			   ;; standard GC library
			   " " gc-lib
			   ;; dloptn library
			   " " bgl-configure-dlopen-lib
			   ;; user libraries
			   " " other-libs
			   ;; then we insert a second time the additional libs
			   " " (if *double-ld-libs?* add-libs "")))
	     (cmd/ld      (string-append *cc* " " ld-args))
	     (cmd         cmd/ld))
	 (verbose 2 "      ["  cmd/ld #\] #\Newline)
	 (exec cmd need-to-return "ld"))))
