;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/cee/cee-toolbar.el             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jun  5 21:03:27 1998                          */
;*    Last change :  Wed Aug  2 09:29:15 2000 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The Ude C toolbar system.                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'cee-toolbar)
(require 'cee-autoload)
(require 'ude-icon)
(require 'ude-toolbar)
(require 'ude-autoload)
(require 'dbg-autoload)

;*---------------------------------------------------------------------*/
;*    Various compile toolbar button                                   */
;*---------------------------------------------------------------------*/
(defvar cee-tag-button
  (toolbar-make-button-list ude-tag-icon))
(defvar cee-indent-button
  (toolbar-make-button-list ude-indent-icon))
(defvar cee-compile-button
  (toolbar-make-button-list ude-compile-icon))
(defvar cee-root-button
  (toolbar-make-button-list ude-root-icon))
(defvar cee-make-ude-button
  (toolbar-make-button-list ude-make-make-icon))
(defvar cee-make-entry-button
  (toolbar-make-button-list ude-make-entry-icon))
(defvar cee-gdb-button
  (toolbar-make-button-list ude-dbg-icon))
(defvar cee-connect-button
  (toolbar-make-button-list ude-dbg-connect-icon))
(defvar cee-profile-button
  (toolbar-make-button-list ude-profile-icon))
(defvar cee-help-button
  (toolbar-make-button-list ude-help-icon))
(defvar cee-info-button
  (toolbar-make-button-list ude-info-icon))

;*---------------------------------------------------------------------*/
;*    c opened toolbar ...                                             */
;*---------------------------------------------------------------------*/
(defvar cee-opened-toolbar
  '(;;close button
    [ude-close-toolbar-button cee-close-toolbar t "c toolbar"]
			      
    [:style 2d :size 2]
    ;; the tag button
    [cee-tag-button cee-tags-find t "Find definition"]

    [:style 2d :size 2]
    ;; the indent button
    [cee-indent-button cee-external-indent t "Indent whole buffer"]
    [:style 2d :size 2]

    ;; the compile button
    [cee-compile-button ude-mode-compile-from-menu t "Compile"]
    ;; the root button
    [cee-root-button ude-user-set-root-directory t "Set new C root directory"]
    ;; the make ude button
    [cee-make-ude-button ude-make-ude t "Generate/update Ude Makefile entries"]
    [:style 2d :size 2]

    ;; the profiler
    [cee-profile-button cee-profiler-start t "Profiling"]
    [:style 2d :size 2]

    ;; the gdb button
    [cee-gdb-button cee-kbdb-start t "Debugging"]
    ;; the gdb connect button
    [cee-connect-button dbg-toggle-connect-buffer t "Debugger connection"]
    [:style 2d :size 2]

    nil
    ;; the help button
    [:style 2d :size 2]
    [cee-help-button describe-mode t "Cc mode help"]
    ;; the info button
    [cee-info-button cee-docline t
    "The online documentation for C"]))

;*---------------------------------------------------------------------*/
;*    cee-closed-toolbar ...                                           */
;*---------------------------------------------------------------------*/
(defvar cee-closed-toolbar
  '([ude-open-toolbar-button cee-open-cee-toolbar t "Open toolbar"]))

;*---------------------------------------------------------------------*/
;*    Opening/closing the C toolbar ...                                */
;*---------------------------------------------------------------------*/
(defun cee-close-toolbar ()
  (ude-open-close-toolbar cee-closed-toolbar))

(defun cee-open-cee-toolbar ()
  (ude-open-close-toolbar cee-opened-toolbar))

;*---------------------------------------------------------------------*/
;*    cee-toolbar-init ...                                             */
;*---------------------------------------------------------------------*/
(defun cee-toolbar-init ()
  (set-specifier default-toolbar-visible-p t (current-buffer))
  (set-specifier default-toolbar cee-opened-toolbar (current-buffer)))


