;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/bee/bee-begoo.el               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Aug 19 10:20:37 1999                          */
;*    Last change :  Thu Aug 19 10:56:37 1999 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The Begoo connection.                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'bee-begoo)

;*---------------------------------------------------------------------*/
;*    bee-begoo-ready-p ...                                            */
;*---------------------------------------------------------------------*/
(defun bee-begoo-ready-p ()
  (and (stringp bee-begoo)
       (file-exists-p bee-begoo)
       (file-executable-p bee-begoo)))

;*---------------------------------------------------------------------*/
;*    bee-begoo-start ...                                              */
;*---------------------------------------------------------------------*/
(defun bee-begoo-start ()
  (interactive)
  ;; we enforce a connection that makes use of pipes instead of ptys
  (message "Waiting for BeGoo ...")
  (let* ((bmg-name (ude-fetch-makefile-one-entry bee-begoo-getbmg-entry))
	 (bmg      (if (stringp bmg-name)
		       (concat ude-root-directory "/" bmg-name)
		     nil))
	 (opt      (if (stringp bmg)
		       (cons bmg bee-begoo-bee-options)
		     bee-begoo-bee-options)))
    (condition-case err
	(make-plugin bee-begoo
		     opt
		     (function bee-begoo-callback)
		     nil
		     ude-root-directory)
      (error
       (if (stringp (car (cdr err)))
	   (ude-error (car (cdr err)))
	 (ude-error "Can't start Begoo"))))))

;*---------------------------------------------------------------------*/
;*    bee-begoo-callback ...                                           */
;*---------------------------------------------------------------------*/
(defun bee-begoo-callback (proc string)
  (cond
   ((not (consp string))
    '())
   ((eq (car string) 'LOAD)
    (let* ((name (car (cdr string)))
	   (buffer (substring name (match-beginning 1) (match-end 1))))
      (message "Loading %S." buffer)
      (begoo-find-file buffer 0)
      'ok))
   ((eq (car string) 'CLOSE)
    (let* ((name (car (cdr string)))
	   (buffer (substring name (match-beginning 1) (match-end 1))))
      (message "Closing %S." buffer)
      (begoo-close-file buffer)
      'ok))
   ((eq (car string) 'GOTOLINE)
    (let* ((name (car (cdr string)))
	   (pos  (string-to-number (car (cdr (cdr string))))))
      (begoo-find-file buffer (string-to-number pos))
      'ok))
   (t
    '())))

;*---------------------------------------------------------------------*/
;*    begoo-find-file ...                                              */
;*---------------------------------------------------------------------*/
(defun begoo-find-file (fname pos)
  (if (and (not (equal 'nil fname)) (file-readable-p fname))
      (let* ((fnamebuf (find-file-noselect (file-installed-p fname exec-path)))
	     (fnamefrml (frames-of-buffer fnamebuf))
	     (currentframe (selected-frame)))
	(if (equal 'nil fnamefrml)
	    (progn
	      (switch-to-buffer-other-frame fnamebuf)
	      (setq fnamefrml (frames-of-buffer fnamebuf))))
	(raise-frame (car fnamefrml))
	(select-frame (car fnamefrml))
	(with-current-buffer fnamebuf
	  (goto-line pos))
	(select-frame currentframe))
    (message (format "Cannot open file %S\n" fname))))

;*---------------------------------------------------------------------*/
;*    begoo-close-file ...                                             */
;*---------------------------------------------------------------------*/
(defun begoo-close-file (fname)
  ;; We open a file to close it !!
  ;; 'cause (get-buffer ..) don't work i has expected ... so .. trick :)
  (let ((fnamebuf (find-buffer-visiting fname)))
    (if (not (equal 'nil fnamebuf))
	(let ((fnamefrml (frames-of-buffer fnamebuf)))
	  (delete-windows-on fnamebuf)
	  (kill-buffer fnamebuf)
	  (if (not (equal 'nil fnamefrml))
	      (delete-frame (car fnamefrml)))))))
  
  
