/** 
 * @namespace   biewlib
 * @file        biewlib/sysdep/ia16/_inlines.h
 * @brief       This file includes 16-bit Intel architecture little inline functions.
 * @version     -
 * @remark      this source file is part of Binary vIEW project (BIEW).
 *              The Binary vIEW (BIEW) is copyright (C) 1995 Nick Kurshev.
 *              All rights reserved. This software is redistributable under the
 *              licence given in the file "Licence.en" ("Licence.ru" in russian
 *              translation) distributed in the BIEW archive.
 * @note        Requires POSIX compatible development system
 *
 * @author      Nick Kurshev
 * @since       2000
 * @note        Development, fixes and improvements
**/
#ifndef __TSC__
#include "biewlib/sysdep/generic/_inlines.h"
#else
#ifndef ___INLINES_H
#define ___INLINES_H 1

#define __NEAR__  near           /**< Modifier of near call and data */
#define __FAR__   far            /**< Modifier of far call and data */
#define __HUGE__  huge           /**< Modifier of huge pointer */
#define __INTERRUPT__ interrupt  /**< Modifier of interrupt call */

/* TopSpeed's calling conventions are already "fast".
    Hence, the definition is not required. */

#define __FASTCALL__             /**< Modifier of fast call */
#define __NORETURN__             /**< Modifier of function that never return control */
#define __CONSTFUNC__            /**< Modifier of contant function */

#ifdef __clpusplus
extern "C" {
#endif

                   /** Copies given number of bytes from one huge memory block to other.
                     * @return                pointer to destinition block.
                     * @param _dest           destinition huge memory block
                     * @param _source         source huge memory block
                     * @param n               indicates number of bytes to be copied
                     * @depricated            We need for own version of function hmemcpy because in some 16-bits libraries (like TopSpeed) last argument defined as unsigned instead long.
                    **/
extern void __HUGE__ * __FASTCALL__ HMemCpy(void __HUGE__ *_dest, const void __HUGE__ *_source, unsigned long n);

#pragma save, call(inline=>on,reg_param=>(ax,bx),reg_return=>(ax,bx))
                /** Changes byte order in 16-bit number */
static unsigned short __FASTCALL__ ByteSwapS(unsigned short val) =
{
    0x86, 0xC4  /* xchg al, ah */
};

                /** Changes byte order in 32-bit number */
static unsigned long __FASTCALL__ ByteSwapL(unsigned long  val) =
{
    0x86, 0xC7,  /* xchg al, bh */
    0x86, 0xDC   /* xchg bl, ah */
};
#pragma restore

                /** Translates byte via table lookup 
                  * @return         byte readed from table \e t at offset \e i
                  * @param t        pointer to 256-byte memory block from which will be readed byte
                  * @param i        index of memory block where byte is to be readed
                **/
#define __Xlat__(t,i) (t[i])

#ifdef __cplusplus
}
#endif

#endif
#endif



