//
// bidwatcher
// copyright (c) 1999, 2000, 2001, 2002
// Trent McNair (trent@rmci.net)
// Tom McNair  (tmcnair@cyberhighway.net)
// Wayne Schlitt (wayne@midwestcs.com)
// Ben Byer (bushing@users.sourceforge.net)
// Kevin Dwyer (kevin@pheared.net)
// 
// use of this code is restricted to the terms
// of the GNU GPL, which should have been included in this
// distribution. If not, see www.gnu.org/copyleft/gpl.html.
// Here is the short version:
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
#include <unistd.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <ctype.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <stdlib.h>
#include <stdio.h>
#include <netdb.h>
#include <fstream.h>
#include <strstream.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>

#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include "bidwatcher.h"
#include "config.h"

#include "pixmaps/user.xpm"
#include "pixmaps/clock.xpm"
#include "pixmaps/exit.xpm"
#include "pixmaps/help.xpm"
#include "pixmaps/update.xpm"
#include "pixmaps/stop.xpm"
#include "pixmaps/plus.xpm"
#include "pixmaps/redled.xpm"
#include "pixmaps/blueled.xpm"
#include "pixmaps/blackled.xpm"
#include "pixmaps/greenled.xpm"
#include "pixmaps/arrow.xpm"
#include "pixmaps/bidwatch.xpm"

using namespace std;

char * banner1 = "bidwatcher " VERSION " is GPL'd and has NO WARRANTY; "
                 "press the ABOUT button for details";
char * banner2 = "help us: please report ALL bugs at "
                 "http://sourceforge.net/projects/bidwatcher";

const char * const bw_subdir = ".bidwatcher";

unsigned int * ParseList2(char *);
void WriteAucFile2(void);
void ReadAucFile2(void);

#define DEBUG_NETWORK
bool configOpen=FALSE;
bool addOpen=FALSE;
bool helpOpen=FALSE;
bool passOpen=FALSE;

URL *proxyurl,*timesyncurl;
GdkFont *fixed_font;
GdkFont *clean14;

int numbids;
char authID[76];
char authPASS[76];
struct auctioninfo  * auction[MAXAUCS+1];

enum { TARGET_URL };
static GtkTargetEntry target_table[] = {
{ "STRING",     0, TARGET_URL },
{ "text/plain", 0, TARGET_URL },
{ "text/uri-list", 0, TARGET_URL }
};
static guint n_targets = sizeof(target_table) / sizeof(target_table[0]);

int GetUserBids2(void);

/* Used to mark which button was pressed while changing colors */
static GtkWidget *button_pressed;

GdkColor cyan={0,0,100*256,65535},red={0,200*256,0,0},blue={0,0,0,200*256},
         green={0,0,240*256,0},black={0,0,0,0},yellow={0,200*256,200*256,0}, 
         white={0,255,255,255}, peach={0,60000,60000,50000}, 
         lightblue={0,59000,59000,60000};

GdkColor color_near={0,200*256,0,0}, color_far={0,0,0,0}, 
         color_gone={0,0,100*256,65535}, color_win={0,0,0,0}, 
         color_willwin={0,0,100*256,65535}, color_lose={0,200*256,0,0},
         color_back1={0,59000,59000,60000}, color_back2={0,60000,60000,50000};

#define NUMCOLORS 8
GdkColor *colors[NUMCOLORS] = {&color_far, &color_near, &color_gone, 
			       &color_win, &color_willwin, &color_lose, 
			       &color_back1, &color_back2};

GtkStyle *greenstyle,*redstyle,*yellowstyle,*clean14style;
GtkStyle *wgreenstyle,*wredstyle,*wyellowstyle;
GtkStyle *win_style, *willwin_style, *lose_style;
GtkStyle *win_style2, *willwin_style2, *lose_style2;

GtkTooltips *tooltips;

GtkWidget *aucList,*timelabel, *statuswindow;
int currentauc;
GtkWidget      *window,* userconfigMenu,*statuslabel,*statusbox;
GtkWidget *userPMW,*plusPMW,*clockPMW,*updatePMW,*helpPMW,*exitPMW,*stopPMW,
  *userBut,*plusBut,*clockBut,*updateBut,*helpBut,*exitBut,*stopBut,
  *redled,*blueled,*greenled,*blackled, *errorbox, *errorstat, *bidstat, *addentry;
GdkPixmap *redledPM,*redledmask,*blueledPM,*blueledmask,
  *greenledPM,*greenledmask,*blackledPM,*blackledmask,*arrowPM,*arrowmask;

int             aucIdx;
volatile bool            updateInProgress;
bool            firstRun;
bool            checkForSnipe;
int             Timer1Idx;
int             Timer2Idx;
int             timeDiff;
int             snipeDelay; 
char            proxystring[200];
char            browserPATH[200];
char            emailPATH[200];
bool            trackListings;
bool            trackBids;
bool            autoDelete;
bool            doStartup;
bool            soundOn;
bool            clockIsSet;
int             security;

guint errorcontext,bidcontext;
ConfigWindow *confwindow; 
PopupMenu *popupmenu;

gint errorstat_timeout;

void DoEmail(char * name, char * auctionid);
static void deleteitem_handler(GtkMenuItem *MenuItem,gpointer data);
static void flush_handler(GtkMenuItem *MenuItem,gpointer data);
static void updateitem_handler(GtkMenuItem *MenuItem,gpointer data);
GtkWidget* makeicon(GtkWidget* toplevel, char** xpm);

void die() {
  printf("You've found a bug in bidwatcher!  Please fill out a bug\n"
	 "report, attaching the above output, at\n"
	 "http://sourceforge.net/projects/bidwatcher\n");
  exit(0);
}

GdkColor *get_style(struct auctioninfo *auc) {
  /* This code needed to be in one spot, and correct. ;) -kdwyer */

  /* bid column color: (These will be configurable.)
   * green - I have bid and am the high bidder
     yellow - I will snipe and (afaik) will be the high bidder 
     red - I have bid or will snipe, but am not / will not be the high bidder 
  */

  if (auc->myBidQuantity!=0) {
    if (!strcmp(auc->HighBidder, authID)) 
      return &color_win;

    else if ((auc->isSnipe && auc->myBidAmount > auc->CurrentBid) ||
	     (auc->isSnipe && auc->BidCount == 0 &&
	      auc->myBidAmount >= auc->CurrentBid))
      return &color_willwin;

    else 
      return &color_lose;
  } else return &color_lose;
    
}

void checkaucs(int line) {
  int i;
  for(i=0;i<aucIdx;i++) {
    if(auction[i]==NULL) {
      printf("auction[%i] was null at %d\n",i,line);
      die();
    }
    /*    if(auction[i]->infourl==NULL) {
      printf("auction[%i]->infourl was invalid at %d\n",i,line);
      die();
      } */
    if(auction[i]->magic!=12345) {
      printf("auction[%i]->magic was %d at %d\n",i,auction[i]->magic,line);
      die();
    }
  }
}

#define CHECK checkaucs(__LINE__)
// Thanks to Bob Beaty

gint statustimer_callback(void *) {
  gtk_statusbar_push(GTK_STATUSBAR(errorstat), errorcontext, "");
  return FALSE;
}

 /////////////////////////////////////////////////////////////////////////////
 // showError
 //   this presents the error message in 'arg' to the user in one of the
 //   available locations for it's presentation. This is based on the 
 //   availability of the dual-status bar or single-status bar design and
 //   has fall-backs for all designs.
 /////////////////////////////////////////////////////////////////////////////
 void showError(char *arg) {
       if (errorstat != NULL) {
               gtk_statusbar_push(GTK_STATUSBAR(errorstat), errorcontext, arg);
       } else if (bidstat != NULL) {
               gtk_statusbar_push(GTK_STATUSBAR(bidstat), bidcontext, arg);
       } else {
               // I can always show it on the upper status line
               showStatus(arg);
       }
       errorstat_timeout=gtk_timeout_add(4000,statustimer_callback, NULL);

 }
 
 /////////////////////////////////////////////////////////////////////////////
 // showBidStatus
 //   this presents the bid status message in 'arg' to the user in one of the
 //   available locations for it's presentation. This is based on the 
 //   availability of the dual-status bar or single-status bar design and
 //   has fall-backs for all designs.
 /////////////////////////////////////////////////////////////////////////////
 void showBidStatus(char *arg) {
       if (bidstat != NULL) {
               gtk_statusbar_push(GTK_STATUSBAR(bidstat), bidcontext, arg);
       } else if (errorstat != NULL) {
               gtk_statusbar_push(GTK_STATUSBAR(errorstat), errorcontext, arg);
       } else {
               // I can always show it on the upper status line
               showStatus(arg);
       }
 }
 
 /////////////////////////////////////////////////////////////////////////////
 // showStatus
 //   this presents the status message in 'arg' to the user in one of the
 //   available locations for it's presentation. This is based on the 
 //   availability of the dual-status bar or single-status bar design and
 //   has fall-backs for all designs.
 /////////////////////////////////////////////////////////////////////////////
 void showStatus(char *arg) {
       // add a space on the front, if it's possible
       char *t = g_strdup_printf(" %s", arg);
       if (t == NULL) {
               gtk_label_set_text(GTK_LABEL(statuslabel), arg);
       } else {
               gtk_label_set_text(GTK_LABEL(statuslabel), t);
               g_free( t );
       }
 }

void delete_event( GtkWidget *widget,
		   GdkEvent  *event,
		   gpointer   data )
{
  gtk_main_quit();
  exit(0);
}

void destroy_event( GtkWidget *widget,
	      gpointer   data )
{
  gtk_main_quit();
  exit(0);
}

void greenLED(void) {
    gtk_pixmap_set(GTK_PIXMAP(blackled),greenledPM,greenledmask);
}

void blackLED(void) {
    gtk_pixmap_set(GTK_PIXMAP(blackled),blackledPM,blackledmask);
}


void timesync_callback(GtkWidget *widget,gpointer data)
{
  if (updateInProgress ) return;
  updateInProgress = TRUE;
  TimeSync();
  updateInProgress = FALSE;
}

void cancel_callback(GtkWidget *widget,gpointer data) {
  cancelPressed=TRUE;
}

void exit_callback(GtkWidget *widget,gpointer data)
{
  if (updateInProgress == TRUE ) return;
  gtk_main_quit();
}

void update_callback(GtkWidget *widget,gpointer data)
{
  if (updateInProgress ) return;
  updateInProgress = TRUE;
  int retval;

  if(strlen(authID)>1) switch(retval=GetUserBids2()) {
  case GUA_SUCCESS:
    GetUserListings();
    UpdateList();
    break;
  case 2:
      showError("Update failed: Invalid username");
    break;
  default:
    showError("Update failed: Network error");
    printf("getuserbids2 returned %d\n",retval);
  }
  
  if ( aucIdx != 0 ) UpdateAll(FALSE);
  updateInProgress = FALSE;
}

static void detailsclose_callback(GtkWidget *widget, gpointer data) {
  DetailsWindow * obj=((DetailsWindow *) data);
  gtk_widget_destroy(obj->window);
}

static void detailsdestroy_callback(GtkWidget *widget, gpointer data) {
  DetailsWindow * obj=((DetailsWindow *) data);
  delete obj;
}

static void bidclose_callback(GtkWidget *widget, gpointer data) {
  BidWindow * obj=((BidWindow *) data);
  gtk_widget_destroy(obj->window);
}

static void biddestroy_callback(GtkWidget *widget, gpointer data) {
  BidWindow * obj=((BidWindow *) data);
  delete obj;
}

static void aboutclose_callback(GtkWidget *widget, gpointer data) {
  AboutWindow * obj=((AboutWindow *) data);
  gtk_widget_destroy(obj->window);
}

static void aboutdestroy_callback(GtkWidget *widget, gpointer data) {
  AboutWindow * obj=((AboutWindow *) data);
  delete obj;
}

static void endedclose_callback(GtkWidget *widget, gpointer data) {
  EndedWindow * obj=((EndedWindow *) data);
  delete obj;
}

static void endedmonth_callback(GtkWidget *widget, gpointer data) {
  EndedWindow * obj=((EndedWindow *) data);
  obj->iscurrent=!obj->iscurrent;
  obj->update();
}

static void configclose_callback(GtkWidget *widget, gpointer data) {
  ConfigWindow * obj=((ConfigWindow *) data);
  gtk_widget_destroy(obj->window);
}

static void configdestroy_callback(GtkWidget *widget, gpointer data) {
  ConfigWindow * obj=((ConfigWindow *) data);
  delete obj;
}

static void color_dlg_cancel (GtkWidget *button, gpointer data)
{
  gtk_widget_destroy(GTK_WIDGET(data));
}

static void color_dlg_ok (GtkWidget *button, GtkWidget *color_dlg) 
{
	GdkColor *color;
	gdouble new_color[3];
	GtkStyle *style;

	if (!GTK_IS_WIDGET (button_pressed)) {
		gtk_widget_destroy (color_dlg);
		return;
	}

	color = (GdkColor *) gtk_object_get_user_data (GTK_OBJECT (button_pressed));

	gtk_color_selection_get_color ((GtkColorSelection *)
				       ((GtkColorSelectionDialog *) 
					color_dlg)->colorsel, new_color);

	gdk_colormap_free_colors (gtk_widget_get_colormap (button_pressed), color, 1);

	color->red = (guint16) (new_color[0] * 65535.0);
	color->green = (guint16) (new_color[1] * 65535.0);
	color->blue = (guint16) (new_color[2] * 65535.0);

	color->pixel = (gulong) ((color->red & 0xff00) * 256 +
				 (color->green & 0xff00) +
				 (color->blue & 0xff00) / 256);

	gdk_color_alloc (gtk_widget_get_colormap (button), color);
	style = gtk_style_new();
	style->bg[0] = *color;
	gtk_widget_set_style (button_pressed, style);
	gtk_style_unref (style);
	gtk_widget_destroy (color_dlg);
}

static void color_edit(GtkWidget *button, GdkColor *color)
{
	GtkWidget *dialog;
	gdouble new_color[3];

	new_color[0] = color->red / 65535.0;
	new_color[1] = color->green / 65535.0;
	new_color[2] = color->blue / 65535.0;

	dialog = gtk_color_selection_dialog_new ("Select color");
	gtk_widget_hide (GTK_COLOR_SELECTION_DIALOG (dialog)->help_button);
	gtk_signal_connect (GTK_OBJECT
			    (((GtkColorSelectionDialog *) dialog)->ok_button),
			    "clicked", GTK_SIGNAL_FUNC (color_dlg_ok),
			    dialog);
	gtk_signal_connect (GTK_OBJECT
			    (((GtkColorSelectionDialog *) 
			      dialog)->cancel_button),
			    "clicked", GTK_SIGNAL_FUNC (color_dlg_cancel), 
			    dialog);

	gtk_widget_set_sensitive (((GtkColorSelectionDialog *) dialog)->help_button, FALSE);
	gtk_color_selection_set_color ((GtkColorSelection *)
				       ((GtkColorSelectionDialog *) dialog)->colorsel, new_color);
	gtk_widget_show (dialog);
	button_pressed = button;

}

static void errorclose_callback(GtkWidget *widget, gpointer data) {
  ErrorWindow * obj=((ErrorWindow *) data);
  delete obj;
}

static void confirmclose_callback(GtkWidget *widget, gpointer data) {
  ConfirmWindow * obj=((ConfirmWindow *) data);
  delete obj;
}

static void confirmok_callback(GtkWidget *widget, gpointer data) {
  flush();
  ConfirmWindow * obj=((ConfirmWindow *) data);
  delete obj;
}


void auctioninfo::getkey(float bid,int quantity) {
  char *Buff;
  snipeAmount=bid;
  snipeQty=quantity;
  myBidAmount=bid;
  myBidQuantity=quantity;
  //printf("myBidAmount set to %f\n",bid);
  bidurl=new URL(g_strdup_printf("http://cgi.ebay.com/aw-cgi/eBayISAPI.dll?"
				  "MakeBid&item=%lu&maxbid=%.2f&quant=%d",
				  ItemNumber,bid,quantity),proxyurl);
  int returnVal = fetchURL(bidurl, &Buff, TIMEOUT);
  if ( returnVal != 1 )
    {
      if ( returnVal == 2)
	showError("Could not obtain bid key: a network error occurred.");

      else if ( returnVal == 4)
	showError("Network timeout error");
      return;
    }
  char lineBuff[1024];
  returnVal = ProcessBidSubmission(Buff, lineBuff);

  switch(returnVal) {
  case PBS_BIDTOOLOW:
    sprintf(lineBuff,"Pre-bid on %lu for %.2f FAILED: bid below asking price",
	    ItemNumber,snipeAmount);
    showBidStatus(lineBuff);
    free(Buff);
    break;
  case PBS_BADQUANTITY:
    sprintf(lineBuff,"Pre-bid on %lu FAILED: Bad quantity '%d'",
	    ItemNumber,snipeQty);
    showBidStatus(lineBuff);
    free(Buff);
    break;
  case PBS_AUCTIONOVER:
    sprintf(lineBuff,"Pre-bid on %lu FAILED: Auction already ended",ItemNumber);
    showBidStatus(lineBuff);
    free(Buff);
    break;
  case PBS_SUCCESS: 
  // ok, eBay liked our bid submission so we can go ahead and make the bid
    char * scratch;
    scratch = strtok(lineBuff, "\"");
    scratch = strtok(0,"\"");
    //    printf("Snipe key is %s\n",scratch);
    strcpy(snipeKey, scratch);
    sprintf(lineBuff,"Pre-bid on %lu SUCCEEDED: %d at %.2f",
	    ItemNumber,snipeQty, snipeAmount);
    showBidStatus(lineBuff);
    free(Buff);
    break;
  default:
    sprintf(lineBuff,"Pre-bid on %lu FAILED: Unknown error %d",
	    ItemNumber,returnVal);
    showBidStatus(lineBuff);
  }
  
}
  
int auctioninfo::bid(bool windows) {
  char *Buff;
  char lineBuff[1024];
  int returnVal,retval;
  char *url=g_strdup(bidurl->url);
  char *end=strstr(url,"?");
  end[1]='\0';
  
  sprintf(bidurl->url,"%sAcceptBid&item=%lu&key=%s"
	  "&userid=%s&pass=%s&maxbid=%.2f&quant=%d",url,
	  ItemNumber,snipeKey,authID,authPASS,snipeAmount,
	  snipeQty);
  //  printf("%s\n",bidurl->url);
  free(url);
  
  retval = fetchURL(bidurl, &Buff, TIMEOUT);
  
  if(retval!=NET_SUCCESS) {
    sprintf(lineBuff,"Bid on %lu FAILED: Error %d connecting to eBay",
	    ItemNumber, retval);
    showBidStatus(lineBuff);
    return NET_NETERROR;
  }    
  returnVal = ProcessBid( Buff );
  if(windows && retval==PBS_SUCCESS) {
    switch(returnVal) {
    case PB_HIGHBID: 
      sprintf(lineBuff,"Bid on %lu SUCCEEDED: You are the high bidder",
	      ItemNumber);
      showBidStatus(lineBuff);
      break;
    case PB_OUTBID:
      sprintf(lineBuff,"Bid on %lu LOST: Someone has outbid you",
	      ItemNumber);
      showBidStatus(lineBuff);
      break;
    case PB_BIDTOOLOW:
      sprintf(lineBuff,"Bid on %lu FAILED: Bid below current asking price",
	      ItemNumber);
      showBidStatus(lineBuff);
      break;
    case PB_BADQUANTITY: 
      sprintf(lineBuff,"Bid on %lu FAILED: Bad quantity '%d'",
	      ItemNumber,snipeQty);
      showBidStatus(lineBuff);
      break;
    case PB_AUCTIONOVER:
      sprintf(lineBuff,"Bid on %lu FAILED: Auction already ended",
	      ItemNumber);
      showBidStatus(lineBuff);
      break;
    case PB_BADUSER:
      sprintf(lineBuff,"Bid on %lu FAILED: Invalid username or password!",
	      ItemNumber);
      showBidStatus(lineBuff);
      break;
    default:
      sprintf(lineBuff,"Pre-bid on %lu FAILED: Unknown error %d",
	      ItemNumber,returnVal);
      showBidStatus(lineBuff);
      if(returnVal>6 || returnVal<1) {
 	FILE *erfile=fopen(g_strdup_printf("%s/%s/error-%li",
 					   getenv("HOME"),bw_subdir,ItemNumber),
			   "w");
        //FILE *erfile=fopen(g_strdup_printf("%s/.bidwatcher/error-%lu",
	//	             getenv("HOME"),ItemNumber),"w");

	fprintf(erfile,"Error: could not parse answer.\n%s\n",bidurl->url);
	fprintf(erfile,"%s",Buff);
	fclose(erfile);
      }
    }
    bidstatus=returnVal;
    free(Buff);
    return retval;
  } 
  return ERROR;
}

void bidengine(BidWindow *obj,bool doSnipe)
{
  int returnVal;

  gtk_widget_set_sensitive(obj->okbutton,FALSE);
  gtk_widget_set_sensitive(obj->cancelbutton,FALSE);
  gtk_label_set_text(GTK_LABEL(obj->currentbidlabel),"Obtaining key...");
  obj->myauc->getkey(atof(gtk_entry_get_text(GTK_ENTRY(obj->bidtext))),
		       atoi(gtk_entry_get_text(GTK_ENTRY(obj->quantitytext))));
  gtk_widget_set_sensitive(obj->okbutton,TRUE);
  gtk_widget_set_sensitive(obj->cancelbutton,TRUE);
  gtk_label_set_text(GTK_LABEL(obj->currentbidlabel),"");


  if ( doSnipe )
    {
      obj->myauc->snipeAmount=atof(gtk_entry_get_text(GTK_ENTRY(obj->bidtext)));
      obj->myauc->snipeQty=atoi(gtk_entry_get_text(GTK_ENTRY(obj->quantitytext)));
      obj->myauc->isSnipe = TRUE;
      gtk_widget_set_sensitive(obj->okbutton,TRUE);
      gtk_widget_set_sensitive(obj->cancelbutton,TRUE);
      gtk_label_set_text(GTK_LABEL(obj->currentbidlabel),"");
      setupSnipe(obj->myauc, currentauc);
      return;
    }
  else
    {
      gtk_label_set_text(GTK_LABEL(obj->currentbidlabel),"Submitting bid...");
      // now, finalize bid with the key obtained.
      char WebPage[255];
      returnVal=obj->myauc->bid(true);
      switch(returnVal) {
      case NET_NETERROR:
	showError("Could not obtain key: a network error occurred.");
	break;
      case NET_TIMEOUT:
	showError("Could not obtain key: Network timeout error");
	break;
      case NET_SUCCESS:
      default: // *shrug*
	sprintf(WebPage, "Current Bid : %.2f",obj->myauc->CurrentBid);
	switch(obj->myauc->reserveMet) {
	case 'y': strcat(WebPage, " - reserve met"); break;
	case 'n': strcat(WebPage, " - reserve not met"); break;
	case 'x': strcat(WebPage, " - no reserve");
	}
	gtk_label_set_text(GTK_LABEL(obj->currentbidlabel),WebPage);
	return;
      }

      gtk_widget_set_sensitive(obj->okbutton,TRUE);
      gtk_widget_set_sensitive(obj->cancelbutton,TRUE);
      gtk_label_set_text(GTK_LABEL(obj->currentbidlabel),"");
      updateitem_handler(NULL,NULL);
      return;
    }
}

void bidnow_callback(GtkWidget *widget,gpointer data)
{
  BidWindow *obj=(BidWindow *)data;

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(obj->radio_bid))) {
	  /* Make sure we have a password ready */
	  if (authPASS[0] == '\0') {
		  if (!passOpen) new GetPass();
	  } else {
		  /* Bid Now */
		  bidengine(obj,FALSE);
		  updateitem(obj->myauc->ItemNumber);
		  gtk_widget_destroy(obj->window);
	  }  
  } else {
	  if (security != SEC_HIGH) {
		  if (authPASS[0] == '\0') {
			  if (!passOpen) new GetPass();
		  } else {
			  /* Snipe */
			  bidengine(obj,TRUE);
			  gtk_widget_destroy(obj->window);
		  }
	  } else {
		  showError("Cannot snipe with security set on High.  Choose Medium or Low.");
		  gtk_widget_destroy(obj->window); 
	  }
  }

  /* Forget the user/password for High security */
  if (security == SEC_HIGH) {
	  memset(authID, 0, sizeof(authID));
	  memset(authPASS, 0, sizeof(authPASS));
  }
  
}

gint detailstimer_callback(gpointer data)
{
  DetailsWindow *obj=(DetailsWindow *)data;
  obj->update();
  return TRUE;
}
/*
static void detailsbidder_callback(GtkWidget *widget, gpointer data) {
  DetailsWindow * obj=((DetailsWindow *) data);
  DoEmail(obj->myauc->HighBidder,obj->myauc->ItemNumber);
  delete obj;
}

static void detailsseller_callback(GtkWidget *widget, gpointer data) {
  DetailsWindow * obj=((DetailsWindow *) data);
  DoEmail(obj->myauc->Seller,obj->myauc->ItemNumber);
  delete obj;
}

void DoEmail(char * name, char * auctionid)
{
  if ( strlen(name) < 2 )
    {
      showError("No name to look up");
      return;
    }
  else if ( (strlen(authID) < 2) || (strlen(authPASS) < 2) ) 
    {
      showError("Username or password is required but missing");
      return;
    }
  else if ( name[0] == '-' ) return;
  else if ( strcmp("Dutch Auction", name) == 0 ) return;
  else if ( strstr(name,"@") != NULL )
    {
      CmEmail(name);
      return;
    }
  else
    {
      // if we made it here, we need to call up ebay and get 
      // the email address.
      char *Buff;
      char *Buff2;
      char WebPage[250];
      sprintf(WebPage,"http://contact.ebay.com/aw-cgi/eBayISAPI.dll?"
	      "ReturnUserEmail&requested=%s&userid=%s&pass=%s&iid=%s",
	      name,authID,authPASS,auctionid);
      URL * emailurl=new URL(WebPage,proxyurl);
      int err = fetchURL(emailurl,&Buff,TIMEOUT);
      delete(emailurl);
      if ( (err == 2) || (err == 4) || ( strlen(Buff) < 1000 ) )
	{
	  showError("Could not get email address: Network error" );
	  return;
	}
      Buff2=StripHtmlTags(Buff);
      int returnVal = ParseEmailAddress(Buff2, name);
      free(Buff);
      free(Buff2);
      switch(returnVal) {
      case PEA_SUCCESS: CmEmail(name); break;
      case PEA_BADUSER: 
	showError("Could not get email address: bad password"); 
	    break;
      default:
	showError("Could not get email address: Unknown error"); 
	    break;
      }
    }
}
*/

void toggle_button_callback (GtkWidget *widget, gpointer data) {
  *((bool *)data)=GTK_TOGGLE_BUTTON (widget)->active;
}

void getpassok_callback (GtkWidget *widget, gpointer data) {
	GetPass * obj=((GetPass *) data);

	strcpy(authID, gtk_entry_get_text(GTK_ENTRY(obj->useridentry)));

	char encpassword[76];
	
	encode_password(encpassword,
			gtk_entry_get_text(GTK_ENTRY(obj->passentry)));
	strcpy(authPASS,encpassword);

	gtk_widget_destroy(obj->window);
}

void getpassclose_callback (GtkWidget *widget, gpointer data) {
	GetPass * obj=((GetPass *) data);
	gtk_widget_destroy(obj->window);
}

static void getpassdestroy_callback(GtkWidget *widget, gpointer data) {
	GetPass * obj=((GetPass *) data);
	delete obj;
}

void configok_callback (GtkWidget *widget, gpointer data) {
  snipeDelay=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON
						  (confwindow->
						   snipespin));

  strcpy(authID,
  	 gtk_entry_get_text(GTK_ENTRY(confwindow->useridtext)));

  char encpassword[76];

  encode_password(encpassword,gtk_entry_get_text(GTK_ENTRY(confwindow
							   ->passwordtext)));
  strcpy(authPASS,encpassword);
  strcpy(browserPATH,gtk_entry_get_text(GTK_ENTRY(confwindow
						      ->browsertext)));
  strcpy(emailPATH,gtk_entry_get_text(GTK_ENTRY(confwindow
						    ->mailclienttext)));
  strcpy(proxystring,gtk_entry_get_text(GTK_ENTRY(confwindow
						    ->proxytext)));

  trackListings=confwindow->listing;
  trackBids=confwindow->bid;
  doStartup=confwindow->startup;
  autoDelete=confwindow->del;

  if(proxyurl!=NULL) delete(proxyurl);
  if(strlen(proxystring)>2)
    proxyurl=new URL(g_strdup_printf("http://%s/",proxystring),NULL);
  else proxyurl=NULL;
  
  if(timesyncurl!=NULL) delete(timesyncurl);
  
  timesyncurl=new URL("http://cgi3.ebay.com/aw-cgi/eBayISAPI.dll?TimeShow",
		      proxyurl);

  /* Set security level */
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(confwindow->radio_sec_low)))
    security=SEC_LOW;

  else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(confwindow->radio_sec_medium)))
    security=SEC_MED;

  else {
    security=SEC_HIGH;
    /* Forget the user/password for High security */
    memset(authID, 0, sizeof(authID));
    memset(authPASS, 0, sizeof(authPASS));
  }

  WriteAucFile();
  gtk_widget_destroy(confwindow->window);
}

ConfigWindow::ConfigWindow() {
  window=gtk_dialog_new();
  notebook = gtk_notebook_new();
  bookbox[CONFIG_MAIN] = gtk_vbox_new(FALSE,0);
  bookbox[CONFIG_COLOR] = gtk_vbox_new(FALSE,0);

  gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook), TRUE);

  //  gtk_container_set_border_width(GTK_CONTAINER(window),10);

  /* CONFIG_MAIN */
  useridlabel=gtk_label_new("Enter user ID:");
  passwordlabel=gtk_label_new("Enter password:");
  browserlabel=gtk_label_new("Path to web browser:");
  mailclientlabel=gtk_label_new("Path to email client:");
  proxylabel=gtk_label_new("Proxy server: (ex: foo.bar.com:8080)");
  useridtext=gtk_entry_new();
  passwordtext=gtk_entry_new();
  gtk_entry_set_visibility(GTK_ENTRY(passwordtext), FALSE);
  browsertext=gtk_entry_new();
  mailclienttext=gtk_entry_new();
  proxytext=gtk_entry_new();
  
  listingcheck=gtk_check_button_new_with_label("Track my eBay listings");
  bidcheck=gtk_check_button_new_with_label("Track current bids");
  startupcheck=gtk_check_button_new_with_label("Check auctions on startup");
  deletecheck=gtk_check_button_new_with_label("Automatically delete ended "
					      "auctions");

  label_security = gtk_label_new("Security level:");
  radio_sec_low = gtk_radio_button_new_with_label(NULL, "Low");
  radio_sec_medium = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radio_sec_low)), "Medium");
  radio_sec_high = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radio_sec_low)), "High");
  
  snipeadj=gtk_adjustment_new(snipeDelay,5,1000,1,10,10);
  snipespin=gtk_spin_button_new(GTK_ADJUSTMENT(snipeadj),1.0,0);
  snipelabel=gtk_label_new("Snipe timer");
  
  snipebox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(snipebox),snipespin,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(snipebox),snipelabel,FALSE,FALSE,0);
  
  useridbox = gtk_hbox_new(FALSE,10);
  gtk_box_pack_start(GTK_BOX(useridbox),
		     useridlabel,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(useridbox),
		     useridtext,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(bookbox[CONFIG_MAIN]),
  		     useridbox,FALSE,FALSE,0);

  passwordbox = gtk_hbox_new(FALSE,10);
  gtk_box_pack_start(GTK_BOX(passwordbox),
		     passwordlabel,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(passwordbox),
		     passwordtext,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(bookbox[CONFIG_MAIN]),
  		     passwordbox,FALSE,FALSE,0);

  browserbox = gtk_hbox_new(FALSE,10);
  gtk_box_pack_start(GTK_BOX(browserbox),
		     browserlabel,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(browserbox),
		     browsertext,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(bookbox[CONFIG_MAIN]),
  		     browserbox,FALSE,FALSE,0);


  emailbox = gtk_hbox_new(FALSE,10);
  gtk_box_pack_start(GTK_BOX(emailbox),
		     mailclientlabel,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(emailbox),
		     mailclienttext,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(bookbox[CONFIG_MAIN]),
  		     emailbox,FALSE,FALSE,0);


  proxybox = gtk_hbox_new(FALSE,10);
  gtk_box_pack_start(GTK_BOX(proxybox),
		     proxylabel,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(proxybox),
		     proxytext,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(bookbox[CONFIG_MAIN]),
  		     proxybox,FALSE,FALSE,0);

  gtk_box_pack_start(GTK_BOX(bookbox[CONFIG_MAIN]),
		     listingcheck,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(bookbox[CONFIG_MAIN]),
		     bidcheck,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(bookbox[CONFIG_MAIN]),
		     startupcheck,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(bookbox[CONFIG_MAIN]),
		     deletecheck,FALSE,FALSE,0);

  security_box = gtk_hbox_new(FALSE,FALSE);
  //  gtk_box_pack_start(GTK_BOX(bookbox[CONFIG_MAIN]), label_security,
  //	     FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(security_box), label_security,
		     FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(security_box),
		     radio_sec_low,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(security_box),
		     radio_sec_medium,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(security_box),
  		     radio_sec_high,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(bookbox[CONFIG_MAIN]),
  		     security_box,FALSE,FALSE,0);


  gtk_box_pack_start(GTK_BOX(bookbox[CONFIG_MAIN]),
		     snipebox,FALSE,FALSE,0);


  configOpen=TRUE;

  char plainpassword[76];
  decode_password(plainpassword,authPASS);

  gtk_entry_set_text(GTK_ENTRY(useridtext),authID);
  gtk_entry_set_text(GTK_ENTRY(passwordtext),plainpassword);

  gtk_entry_set_text(GTK_ENTRY(browsertext),browserPATH);
  gtk_entry_set_text(GTK_ENTRY(mailclienttext),emailPATH);
  gtk_entry_set_text(GTK_ENTRY(proxytext),proxystring);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(listingcheck),
			       listing=trackListings);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(bidcheck),
			       bid=trackBids);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(startupcheck),
			       startup=doStartup);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(deletecheck),
			       del=autoDelete);

  /* Toggle the current security level */
  switch(security) {
  case SEC_LOW:
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_sec_low), TRUE);
	  break;
  case SEC_MED:
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_sec_medium),
				       TRUE);
	  break;
  case SEC_HIGH:
	  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_sec_high),
				       TRUE);
  }

  gtk_signal_connect (GTK_OBJECT (listingcheck), "toggled",
		      GTK_SIGNAL_FUNC (toggle_button_callback), 
		      (gpointer) &listing);
  gtk_signal_connect (GTK_OBJECT (bidcheck), "toggled",
		      GTK_SIGNAL_FUNC (toggle_button_callback), 
		      (gpointer) &bid);
  gtk_signal_connect (GTK_OBJECT (startupcheck), "toggled",
		      GTK_SIGNAL_FUNC (toggle_button_callback), 
		      (gpointer) &startup);
  gtk_signal_connect (GTK_OBJECT (deletecheck), "toggled",
		      GTK_SIGNAL_FUNC (toggle_button_callback), 
		      (gpointer) &del);

  tab_label[CONFIG_MAIN] = gtk_label_new("Main");
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
			   bookbox[CONFIG_MAIN], tab_label[CONFIG_MAIN]);


  /* CONFIG_COLOR */
  color_ended_box = gtk_vbox_new(FALSE, FALSE);

  for (int x = 0; x < NUMCOLORS; x++) {

    color_button_style = gtk_style_new ();
    color_button_style->bg[0] = *colors[x];
    switch (x) {
    case 0:
      color_button = gtk_button_new_with_label ("Color_far");
      break;
    case 1:
      color_button = gtk_button_new_with_label ("Color_near");
      break;
    case 2:
      color_button = gtk_button_new_with_label ("Color_gone");
      break;
    case 3:
      color_button = gtk_button_new_with_label ("Bid/Snipe: Color_win");
      break;
    case 4:
      color_button = gtk_button_new_with_label ("Bid/Snipe: Color_willwin");
      break;
    case 5:
      color_button = gtk_button_new_with_label ("Bid/Snipe: Color_lose");
      break;
    case 6:
      color_button = gtk_button_new_with_label ("Color_back1");
      break;
    case 7:
      color_button = gtk_button_new_with_label ("Color_back2");
      break;
    }
    gtk_object_set_user_data (GTK_OBJECT (color_button), colors[x]);
    gtk_container_add (GTK_CONTAINER (color_ended_box), color_button);
    gtk_signal_connect (GTK_OBJECT (color_button), "clicked",
			GTK_SIGNAL_FUNC (color_edit), colors[x]);
    gtk_widget_set_usize (color_button, 150, 0);
    gtk_widget_set_style (color_button, color_button_style);
    gtk_widget_show (color_button);
    gtk_style_unref (color_button_style);
  }

  gtk_box_pack_start(GTK_BOX(bookbox[CONFIG_COLOR]), color_ended_box,
		     FALSE, FALSE, 0);
 

  tab_label[CONFIG_COLOR] = gtk_label_new("Colors");
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
			   bookbox[CONFIG_COLOR], tab_label[CONFIG_COLOR]);


  /* Action area */
  okbutton=gtk_button_new_with_label("OK");
  cancelbutton=gtk_button_new_with_label("Cancel");
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area),
		     okbutton,FALSE,FALSE,0);
  gtk_box_pack_end(GTK_BOX(GTK_DIALOG(window)->action_area),
		   cancelbutton,FALSE,FALSE,0);


  gtk_signal_connect (GTK_OBJECT (cancelbutton), "clicked",
		      GTK_SIGNAL_FUNC (configclose_callback), 
		      (gpointer) this);
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (configok_callback), 
		      (gpointer) this);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
  		      GTK_SIGNAL_FUNC (configdestroy_callback), 
  		      (gpointer) this);


  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
		     notebook,FALSE,FALSE,0);

  gtk_widget_show_all(window);

}

ConfigWindow::~ConfigWindow() { 
  configOpen=FALSE; 
  if(GTK_IS_WIDGET(window)) gtk_widget_destroy(window);
}

AboutWindow::AboutWindow() {
  window=gtk_dialog_new();
  gtk_container_set_border_width(GTK_CONTAINER(window),10);
  aboutlabel=
    gtk_label_new(
		  "Bidwatcher [ v" VERSION " ]\n\n"
		  "Authors: \n"
		  "Trent McNair <trent@rmci.net>,\n"
		  "Tom McNair <tmcnair@cyberhighway.net>\n"
		  "\n"
		  "Maintainers:\n"
		  "Wayne Schlitt <wayne@midwestcs.com>\n"
		  "Larry Gilbert (dischead@users.sourceforge.net)\n"
		  "Ben Byer <bushing@users.sourceforge.net>\n"
		  "Kevin Dwyer <kevin@pheared.net>\n"
		  "\n"
		  "All copyrights under the GNU GPL 1998-2002.\n"
		  "See the enclosed file COPYING for more details, or\n"
		  "go to http://www.gnu.org/copyleft/gpl.html\n"
		  "\n"
		  "This software comes with ABSOLUTELY NO WARRANTY - \n"
		  "please see sections 11 and 12 in the GNU GPL for details\n"
		  "Submit all questions, bug reports, etc. "
		  "to the forums at\n"
		  "http://sourceforge.net/projects/bidwatcher\n"
		  "\n"
		  "For complete documentation, see the web pages that came\n"
		  "with Bidwatcher, or view them at: \n"
		  "http://bidwatcher.sourceforge.net"
		  );
  gtk_label_set_justify(GTK_LABEL(aboutlabel),GTK_JUSTIFY_LEFT);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
		     aboutlabel,FALSE,FALSE,0);
  
  okbutton=gtk_button_new_with_label("OK");
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area),
		     okbutton,FALSE,FALSE,0);
  gtk_widget_show(aboutlabel); gtk_widget_show(okbutton); 
  gtk_widget_show(window);
  
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (aboutclose_callback), 
		      (gpointer) this);

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
  		      GTK_SIGNAL_FUNC (aboutdestroy_callback), 
  		      (gpointer) this);
  helpOpen=TRUE;
  
}

AboutWindow::~AboutWindow() { 
  helpOpen=FALSE;
  if(GTK_IS_WIDGET(window)) gtk_widget_destroy(window);
}

GetPass::GetPass() {
  window=gtk_dialog_new();
  gtk_container_set_border_width(GTK_CONTAINER(window),10);

  missinglabel = gtk_label_new("Enter the missing information:");
  useridlabel = gtk_label_new("UserID:");
  passlabel = gtk_label_new("Password:");

  useridentry = gtk_entry_new();
  passentry = gtk_entry_new();
  gtk_entry_set_visibility(GTK_ENTRY(passentry), FALSE);

  gtk_entry_set_text(GTK_ENTRY(useridentry), authID);

  useridbox = gtk_hbox_new(FALSE, FALSE);
  passbox = gtk_hbox_new(FALSE, FALSE);

  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
		     missinglabel,FALSE,FALSE,0);

  gtk_box_pack_start(GTK_BOX(useridbox),
		     useridlabel,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(passbox),
		     passlabel,FALSE,FALSE,0);

  gtk_box_pack_start(GTK_BOX(useridbox),
		     useridentry,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(passbox),
		     passentry,FALSE,FALSE,0);

  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
		     useridbox,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
		     passbox,FALSE,FALSE,0);
  
  okbutton=gtk_button_new_with_label("OK");
  cancelbutton=gtk_button_new_with_label("Cancel");

  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area),
		     okbutton,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area),
		     cancelbutton,FALSE,FALSE,0);

  gtk_widget_show_all(window);
  
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (getpassok_callback), 
		      (gpointer) this);

  gtk_signal_connect (GTK_OBJECT (cancelbutton), "clicked",
		      GTK_SIGNAL_FUNC (getpassclose_callback), 
		      (gpointer) this);

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
  		      GTK_SIGNAL_FUNC (getpassdestroy_callback), 
  		      (gpointer) this);
  passOpen=TRUE;
  
}

GetPass::~GetPass() { 
  passOpen=FALSE;
  if(GTK_IS_WIDGET(window)) gtk_widget_destroy(window);
}


DetailsWindow::DetailsWindow(struct auctioninfo * auc) {
  window=gtk_dialog_new();
  gtk_container_set_border_width(GTK_CONTAINER(window),10);
  myauc=auc;
  
  currentbidlabel=gtk_label_new("");
  gtk_widget_show(currentbidlabel);

  categorylabel=gtk_label_new("");
  infolabel=gtk_label_new("");
  hbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(hbox),categorylabel,FALSE,FALSE,0);
  gtk_box_pack_end(GTK_BOX(hbox),infolabel,FALSE,FALSE,0);
  gtk_label_set_justify(GTK_LABEL(categorylabel),GTK_JUSTIFY_RIGHT);
  gtk_label_set_justify(GTK_LABEL(infolabel),GTK_JUSTIFY_LEFT);
  gtk_widget_show(categorylabel); gtk_widget_show(infolabel);
  gtk_widget_show(hbox);
    
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),currentbidlabel,
		     FALSE,FALSE,0);
  gtk_box_pack_end(GTK_BOX(GTK_DIALOG(window)->vbox),hbox,FALSE,FALSE,0);
  
  /*  sellerbutton=gtk_button_new_with_label("mail seller");
      bidderbutton=gtk_button_new_with_label("mail bidder"); */
  cancelbutton=gtk_button_new_with_label("Close");
  gtk_box_pack_end(GTK_BOX(GTK_DIALOG(window)->action_area),
		   cancelbutton,FALSE,FALSE,0);
		   /*  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area),
		     sellerbutton,FALSE,FALSE,0);
  gtk_box_pack_end(GTK_BOX(GTK_DIALOG(window)->action_area),
  bidderbutton,FALSE,FALSE,0); */
  //  gtk_widget_show(sellerbutton);   gtk_widget_show(bidderbutton); 
  gtk_widget_show(cancelbutton);
    
  gtk_widget_show(window);
  gtk_signal_connect (GTK_OBJECT (cancelbutton), "clicked",
		      GTK_SIGNAL_FUNC (detailsclose_callback), 
		      (gpointer) this);

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
  		      GTK_SIGNAL_FUNC (detailsdestroy_callback), 
  		      (gpointer) this);

  /*  gtk_signal_connect (GTK_OBJECT (bidderbutton), "clicked",
		      GTK_SIGNAL_FUNC (detailsbidder_callback), 
		      (gpointer) this);
  gtk_signal_connect (GTK_OBJECT (sellerbutton), "clicked",
		      GTK_SIGNAL_FUNC (detailsseller_callback), 
		      (gpointer) this); */
    
  fill();
}
  
void DetailsWindow::fill() {
  gtk_label_set_text(GTK_LABEL(categorylabel),
		     "\nSeller :\n"
		     "Location :\n"
		     "Ends :\n"
		     "Time Left :\n"
		     "Quantity :\n"
		     "Number of Bids :\n"
		     "High Bidder :\n"
		     "Minimum Bid :\n"
		     "First Bid :\n"
		     "Snipe Amount :\n"
		     "Snipe Key :\n");
  
  char info[600];
  int infoState = 1;
  // we have 3 states of information:
  // 1 - from aucFile
  // 2 - from ebay user/listings list
  // 3 - full information.
  if ( myauc->CurrentBid != 0 ) {
    if ( myauc ->TimeLeft[0] != 0 ) infoState = 3;
    else infoState = 2;
  }   

  sprintf(info, "Item Number : %lu",myauc->ItemNumber);
  gtk_window_set_title(GTK_WINDOW(window),info);  
  
  strcpy(info, "Current Bid : ");
  if ( infoState > 1 ) {
    strcat(info,myauc->currency);
    strcat(info, g_strdup_printf("%.2f",myauc->CurrentBid));
    if (infoState == 3) {
	  switch(myauc->reserveMet) {
	  case 'y': strcat(info, " - reserve met"); break;
	  case 'n': strcat(info, " - reserve not met"); break;
	  case 'x': strcat(info, " - no reserve");
	  }
    }
  }
  gtk_label_set_text(GTK_LABEL(currentbidlabel),info);
  update();
  timeouttag=gtk_timeout_add(1000,detailstimer_callback,this);
}
  
void DetailsWindow::update() {
  char info[600];
  char temp[20];
  char temp2[20];
  char unitstring[15];
  int infoState = 1;
  // we have 3 states of information:
  // 1 - from aucFile
  // 2 - from ebay user/listings list
  // 3 - full information.
  if ( myauc->CurrentBid != 0 ) {
    if ( myauc->TimeLeft[0] != 0 ) infoState = 3;
    else infoState = 2;
  }   
  strcpy(unitstring, " unit at ");	// DBS
  if(myauc->snipeQty >= 2)	// DBS
    strcpy(unitstring, " units at ");	// DBS

  if (myauc->BidCount == 0 && !TYPE_EBAYMOTORSCAR) 
    sprintf(temp, "%.2f",myauc->FirstBid);
  else {
    sprintf(temp,"%.2f",calculateBidIncrement(myauc->CurrentBid,myauc->currency));
  }
  if ( infoState == 3 )
    {
      strcpy(info," ");
      strcat(info,myauc->Seller);
      strcat(info,myauc->SellerRate);
      strcat(info,"\n ");
      strcat(info,myauc->Location);
      strcat(info,"\n ");
      strcat(info,myauc->Ends);
      strcat(info,"\n ");
      stringTimeLeft(myauc->EndsValue, timeDiff, temp2);
      strcat(info,temp2);
      strcat(info,"\n ");
      strcat(info,g_strdup_printf("%d",myauc->Quantity));
      strcat(info,"\n ");
      strcat(info,g_strdup_printf("%d",myauc->BidCount));
      strcat(info,"\n ");
      strcat(info,myauc->HighBidder);
      strcat(info,myauc->BidderRate);
      strcat(info,"\n ");  
      strcat(info,myauc->currency);
      strcat(info,temp);
      strcat(info,"\n ");
      strcat(info,myauc->currency);
      sprintf(temp, "%.2f",myauc->FirstBid);
      strcat(info,temp);
      strcat(info,"\n ");
      // deal with snipes and quantity	- // DBS
      if ( myauc->isSnipe && strcmp(myauc->HighBidder, "Dutch Auction") == 0) {
	char ts[100];
	sprintf(ts,"%d%s%s%.2f each\n ",myauc->snipeQty,unitstring,myauc->currency,
		myauc->snipeAmount);
	strcat(info, ts);
      }
      else
	{
	  if( myauc->isSnipe )
	    {
	      char ts[100];
	      sprintf(ts,"%s%.2f",myauc->currency,myauc->snipeAmount);
	      strcat(info, ts);
	    }
	  strcat(info,"\n ");
	}
      strcat(info,myauc->snipeKey);
    }
  else
    {
      if ( myauc->isSnipe ) {
	char ts[100];
	strcpy(info, "\n\n\n\n\n\n\n\n\n\n ");
	sprintf(ts,"%d%s%s%.2f each\n ",myauc->snipeQty,unitstring,myauc->currency,
		myauc->snipeAmount);
	strcat(info, myauc->snipeKey);
      }
      else strcpy(info,"");
    }

  /*  gtk_widget_set_sensitive(sellerbutton,myauc->stat=='2');
      gtk_widget_set_sensitive(bidderbutton,!strcasecmp(authID,myauc->Seller)); */
  gtk_label_set_text(GTK_LABEL(infolabel),info);
  /*  gtk_widget_set_sensitive(sellerbutton,FALSE);
      gtk_widget_set_sensitive(bidderbutton,FALSE); */

}

DetailsWindow::~DetailsWindow() {
  if(GTK_IS_WIDGET(window)) gtk_widget_destroy(window);
  gtk_timeout_remove(timeouttag);
}


BidWindow::BidWindow(struct auctioninfo * auc) {

	// if ((authID[0] == '\0') || (authPASS[0] == '\0')) {
    /* No UserID or pass.  don't allow this. */
	//    showError("Missing Username or Password.");
	//  return;
	// }

  updateitem_handler(NULL,NULL);
  myauc=auc;
  window=gtk_dialog_new();
  gtk_container_set_border_width(GTK_CONTAINER(window),10);
  char currentbid[80],chTemp[80];
  
  gtk_window_set_title(GTK_WINDOW(window),g_strdup_printf("Item Number : %lu",
							  myauc->ItemNumber));  
    sprintf(currentbid, "Current Bid : %s%.2f",myauc->currency,
	  myauc->CurrentBid);
  if ( myauc->reserveMet == 'y' ) strcat(currentbid, " - reserve met");
  else if ( myauc->reserveMet == 'n' ) 
    strcat(currentbid," - reserve not met");
  else if ( myauc->reserveMet == 'x' ) 
    strcat(currentbid, " - no reserve");
  
  currentbidlabel=gtk_label_new(currentbid);
  stringTimeLeft(myauc->EndsValue, timeDiff, chTemp);
  sprintf(currentbid, "Time Left : %s",chTemp);
  timeleftlabel=gtk_label_new(currentbid);
  
  gtk_widget_show(currentbidlabel);
  gtk_widget_show(timeleftlabel);
  
  chTemp[0]=0;
  //  int skipchars=strcspn(myauc->FirstBid,"0123456789");
  if ( myauc->BidCount == 0 ) sprintf(chTemp, "%.2f",myauc->FirstBid);
  else {
    sprintf(chTemp,"%.2f",calculateBidIncrement(myauc->CurrentBid,myauc->currency));
  }
  
  bidlabel=gtk_label_new("Your MAXIMUM bid");
  bidtext=gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(bidtext),chTemp);
  bidbox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(bidbox),bidtext,FALSE,FALSE,0);
  gtk_box_pack_end(GTK_BOX(bidbox),bidlabel,FALSE,FALSE,0);
  
  gtk_widget_show(bidlabel);gtk_widget_show(bidtext);
  gtk_widget_show(bidbox);
  
  quantitylabel=gtk_label_new("Dutch Auction Quantity");
  quantitytext=gtk_entry_new();
  quantitybox=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(quantitybox),quantitytext,FALSE,FALSE,0);
  gtk_box_pack_end(GTK_BOX(quantitybox),quantitylabel,FALSE,FALSE,0);
  
  gtk_entry_set_text(GTK_ENTRY(quantitytext),"1");
  gtk_widget_set_sensitive(quantitylabel,!strcmp(myauc->HighBidder,
						 "Dutch Auction"));
  gtk_widget_set_sensitive(quantitytext,!strcmp(myauc->HighBidder,
						"Dutch Auction"));
  
  gtk_widget_show(quantitylabel);gtk_widget_show(quantitytext);
  gtk_widget_show(quantitybox);
  
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),timeleftlabel,
		     FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),currentbidlabel,
		     FALSE,FALSE,0);
  gtk_box_pack_end(GTK_BOX(GTK_DIALOG(window)->vbox),bidbox,
		   FALSE,FALSE,0);
  gtk_box_pack_end(GTK_BOX(GTK_DIALOG(window)->vbox),quantitybox,
		   FALSE,FALSE,0);
  
  radio_snipe = gtk_radio_button_new_with_label(NULL, "Snipe");
  radio_bid = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radio_snipe)), "Bid");

  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area),
		     radio_bid,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area),
		     radio_snipe,FALSE,FALSE,0);

  gtk_widget_show(radio_bid);
  gtk_widget_show(radio_snipe);

  okbutton=gtk_button_new_with_label("OK");
  cancelbutton=gtk_button_new_with_label("Cancel");

  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area),
		     okbutton,FALSE,FALSE,0);
  gtk_box_pack_end(GTK_BOX(GTK_DIALOG(window)->action_area),
		   cancelbutton,FALSE,FALSE,0);
  
  gtk_widget_show(okbutton); gtk_widget_show(cancelbutton);
  
  gtk_widget_show(window);
  
  gtk_signal_connect (GTK_OBJECT (cancelbutton), "clicked",
		      GTK_SIGNAL_FUNC (bidclose_callback), 
		      (gpointer) this);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
  		      GTK_SIGNAL_FUNC (biddestroy_callback), 
  		      (gpointer) this);
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (bidnow_callback), 
		      (gpointer) this);
  
}

EndedWindow::EndedWindow(char snipes,char current) {
  issnipes=snipes;
  iscurrent=current;
  window=gtk_dialog_new();
  gtk_container_set_border_width(GTK_CONTAINER(window),10);
  gtk_widget_set_usize(window,500,300);
  
  hbox=gtk_hbox_new(FALSE,0);
  textbuffer=gtk_text_new(NULL,NULL);
  scrollbar=gtk_vscrollbar_new(GTK_TEXT(textbuffer)->vadj);
  gtk_text_set_editable(GTK_TEXT(textbuffer),FALSE);
  gtk_box_pack_start(GTK_BOX(hbox),textbuffer,TRUE,TRUE,0);
  gtk_box_pack_end(GTK_BOX(hbox),scrollbar,FALSE,FALSE,0);
  
  gtk_widget_show(textbuffer); gtk_widget_show(scrollbar);
  gtk_widget_show(hbox);
  
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),hbox,TRUE,TRUE,0);
  
  monthbutton=gtk_button_new();
  monthlabel=gtk_label_new("");
  gtk_container_add(GTK_CONTAINER(monthbutton),monthlabel);
  okbutton=gtk_button_new_with_label("OK");
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area),
		     monthbutton,FALSE,FALSE,0);
  gtk_box_pack_end(GTK_BOX(GTK_DIALOG(window)->action_area),
		   okbutton,FALSE,FALSE,0);
  
  gtk_widget_show(monthbutton);gtk_widget_show(monthlabel);
  gtk_widget_show(okbutton);
  
  gtk_widget_show(window);
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (endedclose_callback), 
		      (gpointer) this);

  //  gtk_signal_connect (GTK_OBJECT (window), "destroy",
  //		      GTK_SIGNAL_FUNC (endedclose_callback), 
  //		      (gpointer) this);

  gtk_signal_connect (GTK_OBJECT (monthbutton), "clicked",
		      GTK_SIGNAL_FUNC (endedmonth_callback), 
		      (gpointer) this);
  
  update();
}

void EndedWindow::update() {
  if(gtk_text_get_length(GTK_TEXT(textbuffer))>0) {
    gtk_text_set_point(GTK_TEXT(textbuffer),0);
    gtk_text_forward_delete(GTK_TEXT(textbuffer),
			    gtk_text_get_length(GTK_TEXT(textbuffer)));
  }
  char fileName[200];
  if(issnipes) {
    MakeFileName(g_strdup_printf("/%s/snipe", bw_subdir), fileName, iscurrent);
    gtk_window_set_title(GTK_WINDOW(window),iscurrent?"This month's snipes":
			 "Last month's snipes");
  } else {
    MakeFileName(g_strdup_printf("/%s/log", bw_subdir), fileName, iscurrent);
    gtk_window_set_title(GTK_WINDOW(window),iscurrent?
			 "This month's ended auctions":
			 "Last month's ended auctions");
  }
  gtk_label_set_text(GTK_LABEL(monthlabel),iscurrent?"view last month"
		     :"view this month"); 
    
  FILE *infile = fopen(fileName, "r");
    
  if (infile) {
    char buffer[1024];
    int nchars;
      
    while (1)
      {
	nchars = fread(buffer, 1, 1024, infile);
	gtk_text_insert (GTK_TEXT (textbuffer), fixed_font, NULL,
			 NULL, buffer, nchars);
	  
	if (nchars < 1024)
	  break;
      }
      
    fclose (infile);
  } 
}

EndedWindow::~EndedWindow() {
  if(GTK_IS_WIDGET(window)) gtk_widget_destroy(window);
}


static void details_handler(GtkMenuItem *menuitem,gpointer data) {
  if(currentauc>MAXAUCS) return;
  new DetailsWindow(auction[currentauc]);
}

void unbid_handler(GtkMenuItem *MenuItem,gpointer data) {
  if(currentauc>MAXAUCS) return;
  int indx = currentauc;
  ClearSnipe(indx);
}

static void bid_handler(GtkMenuItem *menuitem,gpointer data) {
  if(currentauc>MAXAUCS) return;
  new BidWindow(auction[currentauc]);
}

static void showauctions_handler(GtkMenuItem *menuitem,gpointer data) {
  new EndedWindow(FALSE,TRUE);
}

static void showsnipes_handler(GtkMenuItem *menuitem,gpointer data) {
  new EndedWindow(TRUE,TRUE);
}

static void loadauc_handler(GtkMenuItem *MenuItem,gpointer data)
{ 
  int choice = currentauc;
  launchBrowser( choice );
}

static void config_callback(GtkWidget *widget, gpointer data) {
  if(!configOpen) confwindow=new ConfigWindow();
}

static void add_callback(GtkWidget *widget, gpointer data) {
	if ( updateInProgress == TRUE ) {
		// Is this actually necessary?
		showError("Error: Can't add auction while updating auctions." );
	} else {
		addNewItem(atoi(gtk_entry_get_text(GTK_ENTRY(data))));
		gtk_entry_set_text(GTK_ENTRY(data), "");
	}
}

static void add_activate(GtkWidget *widget, gpointer data) {
	// Callback to catch the user hitting enter on the
	// addentry box.  phear the elite passthru to add_callback ;)
	add_callback(widget, data);
}

static void help_callback(GtkWidget *widget, gpointer data) {
  if(!helpOpen) new AboutWindow();
}


static GtkItemFactoryEntry popupmenu_items[]={
  { "/show item details",NULL,(GtkItemFactoryCallback)details_handler,0,NULL },
    { "/open browser to this auction",NULL,(GtkItemFactoryCallback)loadauc_handler,0,NULL },
      { "/update this auction",NULL,(GtkItemFactoryCallback)updateitem_handler,0,NULL },
	{ "/bid or set up snipe",NULL,(GtkItemFactoryCallback)bid_handler,0,NULL },
	  { "/cancel snipe",NULL,(GtkItemFactoryCallback)unbid_handler,0,NULL },
	    { "/delete this item",NULL,(GtkItemFactoryCallback)deleteitem_handler,0,NULL },
	      { "/delete ALL auctions",NULL,(GtkItemFactoryCallback)flush_handler,0,NULL },
		{ "/view completed snipes",NULL,(GtkItemFactoryCallback)showsnipes_handler,
		    0,NULL },
		  { "/view completed auctions",NULL,
		      (GtkItemFactoryCallback)showauctions_handler,0,NULL }};

static gint popupnum_items=sizeof(popupmenu_items)/sizeof(popupmenu_items[0]);

class PopupMenu {
public:
  GtkItemFactory *factory;
  GtkWidget *menu;
  PopupMenu() {
    factory=gtk_item_factory_new(GTK_TYPE_MENU,"<popup>",NULL);
    gtk_item_factory_create_items(factory,popupnum_items,
				  popupmenu_items,NULL);
    menu=gtk_item_factory_get_widget(factory,"<popup>");
  }
};

static gint select_row_handler(GtkWidget *widget,gint row,
			       gint col, GdkEventButton *event,
			       gpointer data) {
  if(event==NULL) return FALSE;
  currentauc=row;
  return FALSE; // not handled
}

static gint button_press_event_handler(GtkWidget *w,
				GdkEventButton *event, gpointer d) {
  gint row, col;

  if(w==NULL || event==NULL) {
    showError("Please select an auction first"); 
    return FALSE;
  }

  gtk_clist_get_selection_info(GTK_CLIST(w), (gint) event->x, (gint) event->y, &row, &col);

  currentauc=row;

  if (aucIdx != 0) {
	  if(event->type==GDK_2BUTTON_PRESS) {
		  loadauc_handler(NULL,NULL);
		  return TRUE;
	  }
	  if(event->button==3) {// right mouse button 
		  gtk_menu_popup(GTK_MENU(popupmenu->menu), NULL, NULL, NULL,
				 NULL, event->button, 1);
		  gtk_signal_emit_stop_by_name(GTK_OBJECT(w),
					       "button_press_event");
		  return TRUE;
	  }
  }
  return FALSE;
}

void drophandler(GtkWidget *w,
		 GdkDragContext *c,
		 gint x,
		 gint y,
		 GtkSelectionData *data,
		 guint inf,
		 guint time,
		 gpointer info) {
  char *item=strstr((char *)data->data,"item=");
  if(item==NULL) gtk_drag_finish (c,FALSE,FALSE,time);
  else {
    item+=strlen("item=");
    char itemnumbuf[20];
    strncpy(itemnumbuf,item,strspn(item,"0123456789"));
    itemnumbuf[strspn(item,"0123456789")]='\0';
    addNewItem(atoi(itemnumbuf));
    gtk_drag_finish (c,TRUE,FALSE,time);
  }
}

// Make a GtkPixmap out of the given xpm data; uses style of toplevel
// for transparent color of xpm
GtkWidget* makeicon(GtkWidget* toplevel, char** xpm)
{
  GdkBitmap* mask;

  GtkStyle* style = gtk_widget_get_style(toplevel);
  GdkPixmap* pixmap = gdk_pixmap_create_from_xpm_d(toplevel->window, &mask,
                                      &style->bg[GTK_STATE_NORMAL], xpm);
  GtkWidget* pixmapwid = gtk_pixmap_new(pixmap, mask);
  return pixmapwid;
}

    
void init()
{
  GdkPixmap *window_icon_PM;
  GdkBitmap *mask;

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (delete_event), NULL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (destroy_event), NULL);

  clockIsSet = FALSE;
  updateInProgress = FALSE;
  trackBids = trackListings = autoDelete = doStartup = TRUE;
  numbids = aucIdx = Timer1Idx = timeDiff = 0;   
  security = SEC_LOW;
  
  snipeDelay = 15;

#ifdef ONE_STATUS  
  gtk_widget_set_usize(window,640,120);
#else
  gtk_widget_set_usize(window,640,180);
#endif
  tooltips=gtk_tooltips_new();

  //strcpy(authID, "!");
  //strcpy(authPASS, "!");
  //strcpy(proxystring, "!");

  //authID[0] = '\0';
  //authPASS[0] = '\0';
  //proxystring[0] = '\0';

  memset(authID, 0, sizeof(authID));
  memset(authPASS, 0, sizeof(authPASS));
  memset(proxystring, 0, sizeof(proxystring));

  strcpy(browserPATH, "netscape");
  strcpy(emailPATH, "xterm -e pine");
  
  popupmenu=new PopupMenu(); 
  
  
  umask( 0077 );		// make sure files are private
  GtkStyle *style=gtk_widget_get_style(window);
  GtkWidget *vbox=gtk_vbox_new(FALSE,0);
  
  GdkPixmap *userPM,*plusPM,*clockPM,*updatePM,*helpPM,*exitPM,*stopPM,
    *usermask,*plusmask,*clockmask,*updatemask,*helpmask,*exitmask,*stopmask;
  
  gtk_widget_show(window);

  /* Set the window manager icon */
  window_icon_PM = gdk_pixmap_create_from_xpm_d(window->window, &mask, 
						&style->bg[GTK_STATE_NORMAL], 
						bidwatch_xpm);
  gdk_window_set_icon(window->window, NULL, window_icon_PM, mask);
  gdk_window_set_group(window->window, window->window);


  userPM=gdk_pixmap_create_from_xpm_d(window->window,&usermask,
				      &style->bg[GTK_STATE_NORMAL],
				      user_xpm);
  userPMW=gtk_pixmap_new(userPM,usermask);
   
  plusPM=gdk_pixmap_create_from_xpm_d(window->window,&plusmask,
				      &style->bg[GTK_STATE_NORMAL],
				      plus_xpm);
  plusPMW=gtk_pixmap_new(plusPM,plusmask);
   
  clockPM=gdk_pixmap_create_from_xpm_d(window->window,&clockmask,
				       &style->bg[GTK_STATE_NORMAL],
				       clock_xpm);
  clockPMW=gtk_pixmap_new(clockPM,clockmask);
   
  updatePM=gdk_pixmap_create_from_xpm_d(window->window,&updatemask,
					&style->bg[GTK_STATE_NORMAL],
					update_xpm);
  updatePMW=gtk_pixmap_new(updatePM,updatemask);
   
  helpPM=gdk_pixmap_create_from_xpm_d(window->window,&helpmask,
				      &style->bg[GTK_STATE_NORMAL],
				      help_xpm);
  helpPMW=gtk_pixmap_new(helpPM,helpmask);

  exitPM=gdk_pixmap_create_from_xpm_d(window->window,&exitmask,
				      &style->bg[GTK_STATE_NORMAL],
				      exit_xpm);
  exitPMW=gtk_pixmap_new(exitPM,exitmask);
   
  stopPM=gdk_pixmap_create_from_xpm_d(window->window,&stopmask,
				      &style->bg[GTK_STATE_NORMAL],
				      stop_xpm);
  stopPMW=gtk_pixmap_new(stopPM,stopmask);

  redledPM=gdk_pixmap_create_from_xpm_d(window->window,&redledmask,
					&style->bg[GTK_STATE_NORMAL],
					redled_xpm);

  blueledPM=gdk_pixmap_create_from_xpm_d(window->window,&blueledmask,
					 &style->bg[GTK_STATE_NORMAL],
					 blueled_xpm);

  greenledPM=gdk_pixmap_create_from_xpm_d(window->window,&greenledmask,
					  &style->bg[GTK_STATE_NORMAL],
					  greenled_xpm);

  blackledPM=gdk_pixmap_create_from_xpm_d(window->window,&blackledmask,
					  &style->bg[GTK_STATE_NORMAL],
					  blackled_xpm);
  blackled=gtk_pixmap_new(blackledPM,blackledmask);

  arrowPM=gdk_pixmap_create_from_xpm_d(window->window,&arrowmask,
				       &style->bg[GTK_STATE_NORMAL],
				       arrow_xpm);
   
  userBut=gtk_button_new();
  gtk_container_add(GTK_CONTAINER (userBut),userPMW);
   
  plusBut=gtk_button_new();
  gtk_container_add(GTK_CONTAINER (plusBut),plusPMW);
   
  clockBut=gtk_button_new();
  gtk_container_add(GTK_CONTAINER (clockBut),clockPMW);

  updateBut=gtk_button_new();
  gtk_container_add(GTK_CONTAINER (updateBut),updatePMW);

  helpBut=gtk_button_new();
  gtk_container_add(GTK_CONTAINER (helpBut),helpPMW);

  exitBut=gtk_button_new();
  gtk_container_add(GTK_CONTAINER (exitBut),exitPMW);

  stopBut=gtk_button_new();
  gtk_container_add(GTK_CONTAINER (stopBut),stopPMW);


  statusbox=gtk_hbox_new(FALSE,0);
  statuslabel=gtk_label_new("");
  showStatus("");
  gtk_label_set_justify(GTK_LABEL(statuslabel),GTK_JUSTIFY_LEFT);
  gtk_widget_set_usize(statuslabel,150,8);

  timelabel=gtk_label_new("");
  gtk_label_set_justify(GTK_LABEL(timelabel),GTK_JUSTIFY_RIGHT);
   
  gtk_box_pack_start(GTK_BOX(statusbox),statuslabel,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(statusbox),timelabel,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(statusbox),blackled,FALSE,FALSE,0);
   
  gtk_widget_show(blackled); gtk_widget_show(statusbox);

  errorbox=gtk_vbox_new(FALSE,0);
#ifdef ONE_STATUS
  errorstat=NULL;
  bidstat=NULL;
#else
  errorstat=gtk_statusbar_new();
  bidstat=gtk_statusbar_new();
  errorcontext=gtk_statusbar_get_context_id(GTK_STATUSBAR(errorstat),
					    "error status bar");
  bidcontext=gtk_statusbar_get_context_id(GTK_STATUSBAR(bidstat),
					  "bid status bar");
  gtk_box_pack_start(GTK_BOX(errorbox),bidstat,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(errorbox),errorstat,FALSE,FALSE,0);
#endif

  showError(banner2);
  showBidStatus(banner1);
  

  gtk_widget_show(errorstat);  gtk_widget_show(bidstat);
  gtk_widget_show(errorbox);
  GtkWidget *buttonbox=gtk_hbox_new(FALSE,0);

  gtk_button_set_relief(GTK_BUTTON(userBut),GTK_RELIEF_NONE);
  gtk_button_set_relief(GTK_BUTTON(plusBut),GTK_RELIEF_NONE);
  gtk_button_set_relief(GTK_BUTTON(clockBut),GTK_RELIEF_NONE);
  gtk_button_set_relief(GTK_BUTTON(updateBut),GTK_RELIEF_NONE);
  gtk_button_set_relief(GTK_BUTTON(helpBut),GTK_RELIEF_NONE);
  gtk_button_set_relief(GTK_BUTTON(exitBut),GTK_RELIEF_NONE);
  gtk_button_set_relief(GTK_BUTTON(stopBut),GTK_RELIEF_NONE);
   
  gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips),userBut,"preferences",NULL);
  gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips),plusBut,
		       "add auction by number",NULL);
  gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips),clockBut,"sync clock",NULL);
  gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips),updateBut,
		       "pull info from eBay NOW",NULL);
  gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips),helpBut,
		       "about bidwatcher",NULL);
  gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips),exitBut,"quit",NULL);
  gtk_tooltips_set_tip(GTK_TOOLTIPS(tooltips),stopBut,"stop",NULL);

  addentry = gtk_entry_new();

  gtk_signal_connect (GTK_OBJECT (userBut), "clicked",
		      GTK_SIGNAL_FUNC (config_callback), 
		      NULL);
  gtk_signal_connect (GTK_OBJECT (plusBut), "clicked",
		      GTK_SIGNAL_FUNC (add_callback), 
		      addentry);
  gtk_signal_connect (GTK_OBJECT (helpBut), "clicked",
		      GTK_SIGNAL_FUNC (help_callback), 
		      NULL);
  gtk_signal_connect (GTK_OBJECT (clockBut), "clicked",
		      GTK_SIGNAL_FUNC (timesync_callback), 
		      NULL);
  gtk_signal_connect (GTK_OBJECT (exitBut), "clicked",
		      GTK_SIGNAL_FUNC (exit_callback), 
		      NULL);
  gtk_signal_connect (GTK_OBJECT (updateBut), "clicked",
		      GTK_SIGNAL_FUNC (update_callback), 
		      NULL);
  gtk_signal_connect (GTK_OBJECT (stopBut), "clicked",
		      GTK_SIGNAL_FUNC (cancel_callback), 
		      NULL);

  // Catch user hitting enter
  gtk_signal_connect(GTK_OBJECT(addentry), "activate",
		     GTK_SIGNAL_FUNC(add_activate),
		     addentry);

  gtk_box_pack_start(GTK_BOX(buttonbox),userBut,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(buttonbox),clockBut,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(buttonbox),updateBut,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(buttonbox),helpBut,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(buttonbox),exitBut,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(buttonbox),plusBut,FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(buttonbox), addentry, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(buttonbox),stopBut,FALSE,FALSE,0);

  statuswindow=gtk_event_box_new();
  GtkWidget * outerwindow=gtk_event_box_new();
  gtk_widget_show(statuswindow); gtk_widget_show(outerwindow);

  gtk_container_add(GTK_CONTAINER(statuswindow),statusbox);
  gtk_container_add(GTK_CONTAINER(outerwindow),statuswindow);
  gtk_container_set_border_width(GTK_CONTAINER(outerwindow),5);
  gtk_box_pack_start(GTK_BOX(buttonbox),outerwindow,FALSE,FALSE,0);
  gtk_widget_set_style (statuswindow, greenstyle);
  gtk_widget_set_style (statuslabel, greenstyle);
  gtk_widget_set_style (timelabel, greenstyle);


  gtk_box_pack_start(GTK_BOX(vbox),buttonbox,FALSE,FALSE,0);
   
  gchar *titles[]={"Number","Current Bid","Time left","Bid","Description"};

  GtkWidget *scrolled_window=gtk_scrolled_window_new(NULL,NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),
  			 GTK_POLICY_AUTOMATIC,
  			 GTK_POLICY_AUTOMATIC);

  aucList=gtk_clist_new_with_titles( 5,titles);
  gtk_clist_column_titles_passive(GTK_CLIST(aucList));
  gtk_clist_set_column_width(GTK_CLIST(aucList),0,100);
  gtk_clist_set_column_width(GTK_CLIST(aucList),1,100);
  gtk_clist_set_column_width(GTK_CLIST(aucList),2,110);
  gtk_clist_set_column_width(GTK_CLIST(aucList),3,60);
  gtk_clist_set_selection_mode(GTK_CLIST(aucList),
			       GTK_SELECTION_SINGLE);
  gtk_clist_set_shadow_type(GTK_CLIST(aucList),
			    GTK_SHADOW_NONE);
  //gtk_clist_set_background(GTK_CLIST(aucList),1,&black);
  // make right button select, too
  //  gtk_clist_set_button_actions(GTK_CLIST(aucList),1,GTK_BUTTON_SELECTS);
  //  gtk_clist_set_button_actions(GTK_CLIST(aucList),2,GTK_BUTTON_SELECTS);
  //  gtk_clist_set_button_actions(GTK_CLIST(aucList),3,GTK_BUTTON_SELECTS);

  gtk_signal_connect(GTK_OBJECT(aucList),"select_row",
		     GTK_SIGNAL_FUNC(select_row_handler),NULL);
  gtk_signal_connect(GTK_OBJECT(aucList),"unselect_row",
		     GTK_SIGNAL_FUNC(select_row_handler),NULL);
  gtk_signal_connect(GTK_OBJECT(aucList),"button_press_event",
		     GTK_SIGNAL_FUNC(button_press_event_handler),NULL);
   
  gtk_drag_dest_set(aucList,GTK_DEST_DEFAULT_ALL,target_table,
		    n_targets,GDK_ACTION_DEFAULT);
  gtk_signal_connect(GTK_OBJECT(aucList), "drag_data_received",
		     GTK_SIGNAL_FUNC(drophandler),NULL);
  
  scrolled_window = gtk_scrolled_window_new(NULL,NULL);
  gtk_container_add(GTK_CONTAINER(scrolled_window),aucList);

  gtk_box_pack_start(GTK_BOX(vbox),scrolled_window,TRUE,TRUE,0);
  gtk_box_pack_start(GTK_BOX(vbox),errorbox,FALSE,FALSE,0);

  gtk_widget_set_style(aucList,clean14style);
  
  gtk_container_add(GTK_CONTAINER (window),vbox);

  gtk_widget_show_all(window);

  char fileName[200];
  char * homeDir = getenv("HOME");
  strcpy(fileName, homeDir);
  strcat(fileName, "/");
  strcat(fileName, bw_subdir);
  mkdir(fileName, 0700);

  ReadAucFile();

  if ( strlen(authID) > 1 )
    {
      char capt[150];
      strcpy(capt, "bidwatcher - ");
      strcat(capt, authID);
      gtk_window_set_title(GTK_WINDOW(window),capt);
    }
  else gtk_window_set_title(GTK_WINDOW(window),"bidwatcher");

  //  getAdultCookie(authID,authPASS);
  timer1Up();
  gtk_timeout_add(1000,secondticker_callback,NULL);
  gtk_timeout_add(BIGDELAY,bigdelay_callback,NULL);
  gtk_timeout_add(30*1000,updatelist_callback,NULL);
  // until we know better, don't waste bandwidth
} // end constructor

/////////////////////////////////////////////////////////////////////////////
// WriteAucFile
//   writes the configuration file
/////////////////////////////////////////////////////////////////////////////
void WriteAucFile() 
{
  WriteAucFile2();
  ofstream outFile;
  int rows = 5;
  char fileName[200];
  char * homeDir = getenv("HOME");
  strcpy(fileName, homeDir);
  strcat(fileName, "/");
  strcat(fileName, bw_subdir);
  strcat(fileName, "/bw.cfg");
  outFile.open(fileName);
  if ( outFile )
    {
      outFile << "1 " << rows << " " << soundOn << " " << trackListings << " " << trackBids << " " << autoDelete << " " << doStartup <<
	" " << snipeDelay << " " << clockIsSet << " " << timeDiff << endl;
      outFile << "2 " << authID << endl;
      outFile << "3 " << authPASS << endl;
      outFile << "4 " << browserPATH << endl;
      outFile << "8 " << emailPATH << endl;
      for ( int i=0; i < aucIdx; i++ )
	{
	  outFile << "5 " << auction[i]->ItemNumber << "\t" << auction[i]->Description << endl;
	  outFile << "6 " << auction[i]->stat << " " <<  auction[i]->EndsValue 
		  << " " << auction[i]->isSnipe << endl;;
	  if ( auction[i]->isSnipe )
	    {
	      outFile << "7 " << auction[i]->snipeQty << "\t" << auction[i]->snipeAmount << "\t";
	      outFile << auction[i]->snipeKey << endl;
	    }
	}
      outFile << "9 " << proxystring << endl;
    }
  outFile.close();
}

void WriteAucFile2() 
{
  FILE *file;
  char fileName[200];
  sprintf(fileName,"%s/%s/bw2.cfg",getenv("HOME"),bw_subdir);
  file=fopen(fileName,"w");
  if(file==NULL) {
    printf("Error opening configuration file %s!\n",fileName);
    return;
  }
  
  fprintf(file,"option tracklistings %s\n", trackListings?"yes":"no");
  fprintf(file,"option trackbids %s\n", trackBids?"yes":"no");
  fprintf(file,"option updateonstartup %s\n", doStartup?"yes":"no");
  fprintf(file,"option autodelete %s\n", autoDelete?"yes":"no");
  fprintf(file,"option snipedelay %i\n", snipeDelay);
  fprintf(file, "option security %i\n", security);
  if(clockIsSet) fprintf(file,"option timediff %d\n",timeDiff);

  if (security != SEC_HIGH) {
	  if (authID[0]!='\0')
		  fprintf(file, "user %s ", authID);
	  if ((authPASS[0]!='\0') && (security != SEC_MED))
		  fprintf(file, "%s\n", authPASS);
	  else
		  fprintf(file, "nopass\n");
  }

  if (browserPATH[0]!='\0')
    fprintf(file, "option browser %s\n",browserPATH);
  if (emailPATH[0]!='\0')
    fprintf(file, "option emailclient %s\n",emailPATH);
  if (proxystring[0]!='\0')
     fprintf(file, "option proxy %s\n",proxystring);

  /* Save our color configuration from the array */
  for (int i=0; i<NUMCOLORS; i++) {
    fprintf(file, "option color%i %i %i %i\n", i, colors[i]->red, 
	    colors[i]->green, colors[i]->blue);
  }

  for ( int i=0; i < aucIdx; i++ ) {
    fprintf(file,"auction %lu\n",auction[i]->ItemNumber);
    fprintf(file, " desc %s\n",auction[i]->Description);
    fprintf(file, " ends %ld\n",auction[i]->EndsValue);
    fprintf(file, " mybid %.2f %d\n",auction[i]->myBidAmount, auction[i]->myBidQuantity); 
#ifdef DEBUGCONFIG
    printf(" writing: mybid %.2f %d\n",auction[i]->myBidAmount, auction[i]->myBidQuantity); 
#endif
    if(auction[i]->isSnipe) 
      fprintf(file, " snipe %.2f %d\n",auction[i]->snipeAmount, auction[i]->snipeQty);
    fprintf(file," endauction\n");
  }
  fclose(file); 
}

BidWindow::~BidWindow() {
  if(GTK_IS_WIDGET(window)) gtk_widget_destroy(window);
  WriteAucFile();
}




/////////////////////////////////////////////////////////////////////////////////
// CmWeb
//   Launches a web browser session for the selected myauc->
/////////////////////////////////////////////////////////////////////////////////

void launchBrowser( int choice )
{
  char commandLine[500];
  if ( strlen(browserPATH) < 2 )
    {
      showError("No Web Browser configured!");
      return;
    }
  char homePath[200];
  //check if netscape is running:
  char lockBuffer[200];
  strcpy(homePath,getenv("HOME"));
  strcat(homePath, "/.netscape/lock");
  int err = readlink(homePath, lockBuffer, 199);
  bool hit = TRUE;
  if ( err < 0 ) hit = FALSE;
  if ( (choice < 0) || (choice > aucIdx) ) return;
  
  else if ( (strstr(browserPATH, "scape") != NULL) && hit )
    {
      sprintf(commandLine, "exec %s -remote \"openURL(http://cgi.ebay.com/ws/eBayISAPI.dll?ViewItem&item=%lu,new-window)\"",browserPATH,auction[choice]->ItemNumber);
      system(commandLine);
    }
  else
    {
      sprintf(commandLine, "exec %s \"http://cgi.ebay.com/ws/eBayISAPI.dll?ViewItem&item=%lu\" &",browserPATH,auction[choice]->ItemNumber);
      system(commandLine);
    } 
}
/*
//////////////////////////////////////////////////////////////////////////////
// CmEmail
//    send email to person specified in char * recip
//////////////////////////////////////////////////////////////////////////////
void CmEmail(char * recip)
{
  int err; 
  char commandLine[500];
  char command[500];
  if ( strstr(emailPATH,"%s") == NULL )
    {
      strcat(emailPATH, " %s");
    }
  err = sprintf(command, emailPATH, recip);
  strcpy(commandLine, "exec ");
  strcat(commandLine, command);
  strcat(commandLine, " ");
  strcat(commandLine, " &");
  system(commandLine);
}
*/ 
//////////////////////////////////////////////////////////////////////////////
// CmBid
//////////////////////////////////////////////////////////////////////////////
void CmBid()
{
  struct auctioninfo * newAuction;
  int choice = currentauc;
  newAuction = auction[choice];
  if ( strlen(newAuction->TimeLeft) < 3 )
    {
      showStatus(" updating auction...");
      int returnVal = newAuction->getinfo();
      if ( returnVal != 1 )
	{
	  showError("Can't update auction, network problems.");
	  showStatus("");
	    return;
	}
      UpdateListItem(choice);
    }
  showStatus("");
  new BidWindow(newAuction);
}
//////////////////////////////////////////////////////////////////////////
// ClearSnipe
//////////////////////////////////////////////////////////////////////////
void ClearSnipe(int choice)
{
  auction[choice]->isSnipe = FALSE;
  strcpy(auction[choice]->snipeKey, "");
  auction[choice]->snipeAmount=0;
  auction[choice]->snipeQty=0;
  auction[choice]->myBidAmount=0;
  auction[choice]->myBidQuantity=0;
  UpdateListItem(choice);

  WriteAucFile();
}
/////////////////////////////////////////////////////////////////////////////
//  UpdateItem
//      responds to update this auction popup menu selection
/////////////////////////////////////////////////////////////////////////////
static void updateitem_handler(GtkMenuItem *MenuItem,gpointer data)
{
  int clickIndex = currentauc;
  
  if ( updateInProgress == TRUE ) return;
  updateInProgress = TRUE;
  struct auctioninfo * NewAuction;
  showStatus(" updating auction...");
  NewAuction = auction[clickIndex];
  int returnVal = NewAuction->getinfo();
  
  switch(returnVal) {
  case 3:
    showError("Invalid auction number. (uih)");
    break;
  case 4:
    showError("Timeout.");
    break;
  case 5:
    showError("CGI server down.");
    break;
  case 2:
    showError("Can't connect to server.");
    break;
  case 10:
    /* ? */
    break;
  default:
    UpdateListItem(clickIndex);
  }
  
  showStatus("");
  updateInProgress = FALSE;
}

static void deleteitem_handler(GtkMenuItem *MenuItem,gpointer data)
{
  if ( updateInProgress == TRUE ) return;
  updateInProgress = TRUE;
  int choice = currentauc;
  if ( choice < 0 )
    { 
      updateInProgress = FALSE;
      return;  // no item selected
    }
  DeleteAuction(choice);
  gtk_clist_remove(GTK_CLIST(aucList),choice);
  updateInProgress = FALSE;
  if ( choice == (aucIdx) )
    gtk_clist_moveto(GTK_CLIST(aucList),choice-1,0,0.5,0.5);
  else
    gtk_clist_moveto(GTK_CLIST(aucList),choice-1,0,0.5,0.5);
  WriteAucFile();
}

static void flush_handler(GtkMenuItem *MenuItem,gpointer data)
{
  new ConfirmWindow("Are you sure you want to delete all auctions?");
}


//////////////////////////////////////////////////////////////////////////////
// flush:
//      all bets off, clears all the structs and emptys the .audFile
// calls:
//      DeleteAuction(), UpdateList()
//////////////////////////////////////////////////////////////////////////////
void flush()
{ 
  int totalAucs = aucIdx;
  int i;
  
  if ( updateInProgress == TRUE )
    return;
  
  if( totalAucs <= 0 )
    return;
  
  updateInProgress = TRUE;
  
  for (i = 0; i < totalAucs; i++)
    {
      ClearBidMakeUp(auction[i]);
    }
  aucIdx = 0;
  numbids = 0;
  gtk_window_set_title(GTK_WINDOW(window),"bidwatcher");
  UpdateList();
  updateInProgress = FALSE;
  WriteAucFile();
}
//////////////////////////////////////////////////////////////////////////////
// UpdateLatest
//      updates auctions with less than mins minutes remaining
///////////////////////////////////////////////////////////////////////////////
void UpdateLatest(int mins)
{ 
  // cancelButton->show();
  gtk_widget_show(stopBut);
  cancelPressed = FALSE;
  int returnVal = 0;
  int intTimeLeft;
  int minTimeLeft;
  char numerator[4];
  char denominator[4];
  char message[20];
  int err;
  
  int prev_selected = currentauc;
  
  for ( int i = 0; i < aucIdx; i++ ) 
    {
      if ( cancelPressed == TRUE )
	break;
      
      minTimeLeft = timeToNextEnd() - (int)((avg_load_time + 500)/1000);
      
      if( minTimeLeft > -2 && minTimeLeft < snipeDelay + 2 )	// don't interfere with the snipe
	break;
      
      strcpy(message, " updating ");
      err = sprintf(denominator, "%d", aucIdx);
      err = sprintf(numerator, "%d", (i + 1));
      strcat(message, numerator);
      strcat(message, "/");
      strcat(message, denominator);
      showStatus(message);
      
      gtk_main_iteration_do(FALSE);

      intTimeLeft = CalcTimeLeft(auction[i]->EndsValue, timeDiff);
      if ( (intTimeLeft < AUTODEL)
	   && (auction[i]->TimeLeft[0] != 0) && (autoDelete) )
	{
	  DeleteAuction(i);
	  gtk_clist_remove(GTK_CLIST(aucList),i);
	  i--;
	}
      else if ( (auction[i]->TimeLeft[0] == 0)
		|| (intTimeLeft > -60 && intTimeLeft < mins*60) )
	{
	  returnVal = auction[i]->getinfo();
	  if ( returnVal == 1 )
	    {
	      UpdateListItem(i);
	    }
	  
	}
      else 
	{
	  UpdateListItem(i);
	}
    }

  gtk_clist_moveto(GTK_CLIST(aucList),prev_selected,0,0.5,0.5);
  showStatus("");
  gtk_widget_hide(stopBut);
  cancelPressed = FALSE;
  return;
}
//////////////////////////////////////////////////////////////////////////////
// timeToNextEnd
//      Calculate the time until the next auction ends, in seconds
//////////////////////////////////////////////////////////////////////////////
int timeToNextEnd()
{
  int intTimeLeft;
  int minTimeLeft = 9999999;
  for ( int i = 0; i < aucIdx; i++ ) 
    {
      intTimeLeft = CalcTimeLeft(auction[i]->EndsValue, timeDiff);
      if( intTimeLeft > -30 && intTimeLeft < minTimeLeft )
	minTimeLeft = intTimeLeft;
    }
  return minTimeLeft;
}

//////////////////////////////////////////////////////////////////////////////
// UpdateAll:
//       updates all the auction in AucNumList, clycles throuh the list,
//      updates auctions or removes them if they are ended.  This 
//      is called by the long-cycle update timer.
// calls:
//      CmCancelClicked(), UpdateAuction(), DeleteAuction(), UpdateList()
//////////////////////////////////////////////////////////////////////////////
bool UpdateAll(bool firstRun)
{
  int returnVal;
  int idx;
  char numerator[4];
  char denominator[4];
  char message[20];
  WriteAucFile();
  gtk_widget_show(stopBut);
  cancelPressed = FALSE;
  
  int prev_selected = currentauc;
  
  // loop through each auction, updating it as we hit it.
  for (idx=0;idx<aucIdx;idx++)
    {
      // make sure we don't interfere with a snipe...
      if( !firstRun && timeToNextEnd() < 5*60 )
	{
	  cancelPressed = FALSE;
	  gtk_widget_hide(stopBut);
	  return TRUE;
	}
      
      strcpy(message, " updating ");
      sprintf(denominator, "%d", aucIdx);
      sprintf(numerator, "%d", (idx + 1));
      strcat(message, numerator);
      strcat(message, "/");
      strcat(message, denominator);
      showStatus(message);
      
      // if user pressed the cancel button, end the 
      // update right here.
      if ( cancelPressed == TRUE )
	{
	  showStatus("");
	  cancelPressed = FALSE;
	  gtk_widget_hide(stopBut);
	  return FALSE;
	}
      // if the auction is over, we will delete it here, unless this is the
      // first run through.
      if ( (CalcTimeLeft(auction[idx]->EndsValue, timeDiff) < AUTODEL) &&
	   (auction[0]->TimeLeft[0] != 0) && (autoDelete) )
	{   
	  DeleteAuction(idx);
	  gtk_clist_remove(GTK_CLIST(aucList),idx);
	  idx--;
	}
      else if(firstRun || CalcTimeLeft(auction[idx]->EndsValue, timeDiff)>0)
	{
	  returnVal = auction[idx]->getinfo();
	  if ( returnVal != 1 )
	    {   
	      showStatus("");
	      cancelPressed = FALSE;
	      //	   cancelButton->hide();
	      gtk_widget_hide(stopBut);
	      return FALSE;
	    }
	  else
	    {
	      UpdateListItem(idx);
	    }
	}
    }
  gtk_clist_moveto(GTK_CLIST(aucList),prev_selected,0,0.5,0.5);
  showStatus("");
  cancelPressed = FALSE;
  gtk_widget_hide(stopBut);
  return FALSE;
}

int updateitem(unsigned int inumber)
{
  int returnVal;
  int idx;
  char numerator[4];
  char denominator[4];
  char message[20];
  WriteAucFile();
  gtk_widget_show(stopBut);
  cancelPressed = FALSE;
  
  for (idx=0;idx<aucIdx;idx++) {
    if (auction[idx]->ItemNumber == inumber) {
      strcpy(message, " Updating ");
      sprintf(denominator, "%d", aucIdx);
      sprintf(numerator, "%d", (idx + 1));
      strcat(message, numerator);
      strcat(message, "/");
      strcat(message, denominator);
      showStatus(message);
      
      // if user pressed the cancel button, end the 
      // update right here.
      if ( cancelPressed == TRUE ) {
	  showStatus("");
	  cancelPressed = FALSE;
	  gtk_widget_hide(stopBut);
	  return FALSE;
	}

      returnVal = auction[idx]->getinfo();
      if ( returnVal != 1 ) {   
	  showStatus("");
	  cancelPressed = FALSE;
	  gtk_widget_hide(stopBut);
	  return FALSE;
	}
      else
	  UpdateListItem(idx);
    }
  }
  showStatus("");
  cancelPressed = FALSE;
  gtk_widget_hide(stopBut);
  return FALSE;
  
}

//////////////////////////////////////////////////////////////////////////////
// addNewItem:
//      called when user enters a number via numberEdit, does some error
//      checking on the supplied auction number, and if it looks valid, 
//      is submitted to the auction site for verification.
//   calls:
//      UpdateAuction(), DeleteAuction(), UpdateList()
//////////////////////////////////////////////////////////////////////////////
void addNewItem(unsigned int newNumber)
{
    updateInProgress = TRUE;
    int    i;      // for counting
    int returnVal;
  
  if ( aucIdx >= MAXAUCS )
    {
      // over the limit on auctions already
      showError("You already have the maximum allowed auctions." );
	updateInProgress = FALSE;
	return;
    }

  // scan current list, make sure this isn't a dup
  for ( i=0; i < aucIdx; i++)
    {
      if (newNumber==auction[i]->ItemNumber)
	{
	  showError("Auction is already on list." );
	  updateInProgress = FALSE;
	  return;
	}
    }
  // now we're reasonably sure that this is an ebay auction - add it to AucNumList, and submit to
  // UpdateAuction.  If it is a mistype or otherwise not valid, it will be caught there and deleted,
  // we will notify user.
  showStatus(" adding auction...");
  auction[aucIdx]=new auctioninfo();
  struct auctioninfo * NewAuction=auction[aucIdx];
  NewAuction->ItemNumber=newNumber;
  returnVal = NewAuction->getinfo();
  if ( returnVal == INFO_SUCCESS )
    {
      NewAuction->EndsValue = CalcEndsValue(NewAuction->Ends);
      aucIdx++;
      showStatus("");
      UpdateList();
      updateInProgress = FALSE;
      updatelist_callback(NULL);
      WriteAucFile();
      return;
    }
  else if ( returnVal == INFO_BADAUCTION)
    showError("Invalid auction number. (ani3)" );
  
  else if ( returnVal == INFO_TIMEOUT)
    showError("Connection time-out");
  
  else  showError("Can't connect to server.");
  
  updateInProgress = FALSE;
  showStatus("");
}
//////////////////////////////////////////////////////////////////////////////
// timer1Up:
//      
// calls:
//      UpdateAuction()
//////////////////////////////////////////////////////////////////////////////
void timer1Up()
{
  // this timer runs once on startup.
  updateInProgress = TRUE;
  TimeSync();
  if ( doStartup )
    {
      if ( strlen(authID)>2 && GetUserBids2() == 1 )
	{
	  GetUserListings();
	  UpdateList();
	}
      UpdateAll(TRUE);
    }
  UpdateList();
  updateInProgress = FALSE;
}

gint secondticker_callback(gpointer data)  // second ticker
{
  static volatile int	checking_snipes = FALSE;
  
  if ( clockIsSet )
    {
      int timeLeft; 
      char newTime[10];
      int alarm_level = 0;
#ifdef DEBUG_NETWORK
      static int prev_snipe_delay = 0;
#endif
      
      
      int cur_snipe_delay = snipeDelay;
      int snipe_adj = (int)((avg_load_time - NORMAL_LOAD_TIME + 500)/1000);
      
      if( snipe_adj > 0 )
	{
	  cur_snipe_delay += snipe_adj;
	  
#ifdef DEBUG_NETWORK
	  if( prev_snipe_delay != cur_snipe_delay )
	    {
	      fprintf( stderr, "poor network response:  "
		       "Adjusting snipe delay from %d to %d\n",
		       snipeDelay, cur_snipe_delay );
	      
	      prev_snipe_delay = cur_snipe_delay;
	    }
#endif
	}
#ifdef DEBUG_NETWORK
      else
	{
	  prev_snipe_delay = 0;
	}
#endif
      
      
      for ( int i=0; i < aucIdx; i++ ) {
	
	if ( auction[i]->isSnipe ) {
	  timeLeft = CalcTimeLeft(auction[i]->EndsValue, timeDiff);
	  
	  if ( !checking_snipes )
	    {
	      checking_snipes = TRUE;
	      
	      if ( timeLeft < cur_snipe_delay ) {
		auction[i]->isSnipe = FALSE;
		DoSnipe(i);
	      }
	      
	      checking_snipes = FALSE;
	    }
	  
	  if ( timeLeft > -5 )
	    {
	      if ( timeLeft < 120 )
		alarm_level = 2;
	      
	      else if ( timeLeft < 1800 )
		{
		  if ( alarm_level < 1 )
		    alarm_level = 1;
		}
	    }
	}
      }
      
      if ( alarm_level == 0 ) {
	gtk_widget_set_style (timelabel, greenstyle);
      }
      else if ( alarm_level == 1 ) {
	gtk_widget_set_style (timelabel, yellowstyle);
      }
      else if ( alarm_level == 2 ) {
	gtk_widget_set_style (timelabel, redstyle);
      }

      MakeClockTime(timeDiff, newTime);
      gtk_label_set_text(GTK_LABEL(timelabel),newTime);
      
    }
  else
    gtk_label_set_text(GTK_LABEL(timelabel),"no sync");
  return TRUE;
}
//////////////////////////////////////////////////////////////////////////////
// bigUpdate
//      triggers an UpdateAll every BIGDELAY mSeconds. if there is an
//      update in progress, tries again in 2 minutes
//////////////////////////////////////////////////////////////////////////////
bool bigUpdate()
{
  if(updateInProgress) return TRUE;
  
  if ( timeToNextEnd() < 5*60)
    return TRUE;
  
  TimeSync();
  if( timeToNextEnd() < 5*60 )
    return TRUE;
  updateInProgress=TRUE;

  if ( GetUserBids2() == 1 )
    {
      updateInProgress=FALSE;
      if( timeToNextEnd() < 5*60 )
	return TRUE;
      
      GetUserListings();
      if( timeToNextEnd() < 5*60 )
	return TRUE;
      
      UpdateList();
      if( timeToNextEnd() < 5*60 )
	return TRUE;
      
      if( UpdateAll(FALSE) )
	return TRUE;
    }
  updateInProgress=FALSE;
  return FALSE;
}
//////////////////////////////////////////////////////////////////////////////
// timer3up:
//      triggers an UpdateAll every BIGDELEY mSeconds. if there is an
//      update in progress, tries again in 2 minutes
//////////////////////////////////////////////////////////////////////////////
gint bigdelay_callback(gpointer data)
{
  if ( updateInProgress == TRUE )
    {
      gtk_timeout_add(2*60*1000,bigdelay_callback,NULL);
      return FALSE;
    }

  updateInProgress = TRUE;
  if( bigUpdate() )
    {
      // update failed, try again soon      
      gtk_timeout_add(5*60*1000,bigdelay_callback,NULL);
    }
  else
    {
      gtk_timeout_add(BIGDELAY,bigdelay_callback,NULL);
    }
  updateInProgress = FALSE;
  return FALSE;
}
//////////////////////////////////////////////////////////////////////////////
// timer4Up - schedules the next update of the list of auctions
//////////////////////////////////////////////////////////////////////////////
gint updatelist_callback(gpointer data)
{

  int minTimeLeft;
  int time_to_next_update;
  int max_update;
  
  if ( aucIdx == 0 )
    {
      gtk_timeout_add(30*60*1000,updatelist_callback,NULL);
      return FALSE;
    }

  minTimeLeft = timeToNextEnd() - (int)((avg_load_time + 500)/1000);
   
  if( minTimeLeft > -2 && minTimeLeft < snipeDelay + 2 )	// don't interfere with the snipe
    {
      gtk_timeout_add((minTimeLeft + 3) *1000,updatelist_callback,NULL);
      return FALSE;
    }

  if ( updateInProgress )
    {
      gtk_timeout_add(30*1000,updatelist_callback,NULL);
      return FALSE;
    }
  updateInProgress = TRUE;
  if(minTimeLeft<10*60) 
    UpdateLatest(5);  /* If less than 10 minutes left, only update auctions 
			 with 5 mins left */
  else
    UpdateLatest(4*60);

  updateInProgress = FALSE;

  minTimeLeft = timeToNextEnd() - (int)((avg_load_time + 500)/1000);
   
  if( minTimeLeft > 0 && minTimeLeft < snipeDelay + 2 )	// don't interfere with the snipe
    time_to_next_update = (minTimeLeft + 3) * 1000;
  else if( minTimeLeft < 3*60 )		// watch it even closer
    time_to_next_update = 10*1000;
  else if( minTimeLeft < 15*60 )		// watch it closely
    time_to_next_update = 60*1000;
  else if( minTimeLeft < 2*60*60 )		// no sense in wasting bandwidth...
    time_to_next_update = 5*60*1000;
  else						// *yawn*
    time_to_next_update = 15*60*1000;
   
  max_update = (int)(avg_load_time * 2);
  if( time_to_next_update < max_update )
    {
#ifdef DEBUG_NETWORK
      fprintf( stderr, "poor network response:  "
	       "Adjusting update time from %d to %d\n",
	       time_to_next_update, max_update );
#endif
      time_to_next_update = max_update;
    }
   
  gtk_timeout_add(time_to_next_update,updatelist_callback,NULL);
  return FALSE;
}
//////////////////////////////////////////////////////////////////////////////
// ReadAucFile:
//      called once at startup, reads the username and stored auctions from
//      .aucFile
// calls:
//////////////////////////////////////////////////////////////////////////////
void ReadAucFile()
{
  int rows;
  int dataID;
  char holder[200];
  char fileName[200];
  char * scratch;
  ifstream inFile;

  sprintf(fileName,"%s/%s/bw2.cfg",getenv("HOME"),bw_subdir);
  FILE *file=fopen(fileName,"r");
  if(file) {
    fclose(file);
    ReadAucFile2();
    return;
  }
  sprintf(fileName,"%s/%s/bw.cfg",getenv("HOME"),bw_subdir);
  inFile.open(fileName, ios::in);
  if ( inFile )
    {
      inFile >> dataID;
      while ( inFile )
	{
	  switch (dataID)
	    {
            case 1: 
	      inFile >> rows; // not used in linux version as of yet
	      inFile >> soundOn;
	      inFile >> trackListings;
	      inFile >> trackBids;
	      inFile >> autoDelete;
	      inFile >> doStartup;
	      inFile >> snipeDelay;
	      inFile >> clockIsSet;
	      if ( clockIsSet ) inFile >> timeDiff;
	      inFile.ignore(200,'\n');
	      break;
            
	    case 2:
	      inFile.ignore();
	      inFile.getline(authID, 76, '\n');
	      break;
              
	    case 3:
	      inFile.ignore();
	      inFile.getline(authPASS, 76, '\n');
	      break;
             
            case 4:
	      inFile.ignore();
	      inFile.getline(browserPATH, 200, '\n');
	      break;
            case 8:
	      inFile.ignore();
	      inFile.getline(emailPATH, 200, '\n'); 
	      break;
	    case 9:
	      inFile.ignore();
	      inFile.getline(proxystring,200,'\n');
	      break;
	    case 5:
	      if ( aucIdx < MAXAUCS )
		{
                  //ClearBidMakeUp(auction[aucIdx]);
		  auction[aucIdx]=new auctioninfo();
                  inFile.ignore();
                  inFile.getline(holder, 200, '\n');
                  scratch = strtok(holder, "\t");
                  if (scratch) auction[aucIdx]->ItemNumber=atoi(scratch);
                  scratch = strtok(0, "\n");
                  if (scratch) strcpy(auction[aucIdx]->Description, scratch);
                  //
                  inFile >> dataID;
                  inFile >> auction[aucIdx]->stat;
                  inFile >> auction[aucIdx]->EndsValue;
                  inFile >> auction[aucIdx]->isSnipe;
                  if ( auction[aucIdx]->isSnipe )
		    {
		      inFile >> dataID;
		      inFile.ignore(); 
		      inFile.getline(holder,200, '\n');
		      scratch = strtok(holder, "\t");
		      if (scratch) auction[aucIdx]->snipeQty=atoi(scratch);
		      scratch = strtok(0,"\t");
		      if ( scratch ) auction[aucIdx]->snipeAmount=atof(scratch);
		      scratch = strtok(0,"\n");
		      // key from bw.cfg is now ignored :(
		      if ( scratch ) strcpy(auction[aucIdx]->snipeKey, scratch);
		      auction[aucIdx]->getkey(auction[aucIdx]->snipeAmount,
					      auction[aucIdx]->snipeQty);
		    }
                  aucIdx++;
		}  
	      break;
           
	    default:
              inFile.close();
	      break;
	    }
	  inFile >> dataID;
	}
    }
  inFile.close();

  if(proxyurl!=NULL) delete(proxyurl);
  if(strlen(proxystring)>2)
    proxyurl=new URL(g_strdup_printf("http://%s/",proxystring),NULL);
  else proxyurl=NULL;
  
  if(timesyncurl!=NULL) delete(timesyncurl);
  
  timesyncurl=new URL("http://cgi3.ebay.com/aw-cgi/eBayISAPI.dll?TimeShow",
		      proxyurl);
  
  
  return;
}

void ReadAucFile2()
{
  FILE *file;
  char fileName[200];
  sprintf(fileName,"%s/%s/bw2.cfg",getenv("HOME"),bw_subdir);
  file=fopen(fileName,"r");
  if(file==NULL) {
    printf("Error opening configuration file %s!\n",fileName);
    return;
  }

  while(!feof(file)) {
    char keyword[20];
    fscanf(file,"%19s",keyword);
    if(feof(file)) break;
    if(!strcasecmp(keyword,"option")) {
      char which[20];
      char recognized=0;
      fscanf(file,"%19s",which);
      if(!strcasecmp(which,"tracklistings")) {
	fscanf(file,"%19s",which);
	if(which[0]=='y'||which[0]=='Y') trackListings=1; else trackListings=0;
	recognized=1;
      }

      if(!strcasecmp(which,"trackbids")) {
	fscanf(file,"%19s",which);
	if(which[0]=='y'||which[0]=='Y') trackBids=1; else trackBids=0;
	recognized=1;
      }

      if(!strcasecmp(which,"updateonstartup")) {
	fscanf(file,"%19s",which);
	if(which[0]=='y'||which[0]=='Y') doStartup=1; else doStartup=0;
	recognized=1;
      }

      if(!strcasecmp(which,"autodelete")) {
	fscanf(file,"%19s",which);
	if(which[0]=='y'||which[0]=='Y') autoDelete=1; else autoDelete=0;
	recognized=1;
      }

      if(!strcasecmp(which,"snipedelay")) {
	fscanf(file,"%i",&snipeDelay);
	recognized=1;
      }

      if(!strcasecmp(which,"security")) {
	fscanf(file,"%i",&security);
	recognized=1;
      }

      if(!strcasecmp(which,"timediff")) {
	fscanf(file,"%d",&timeDiff);
	clockIsSet=1;
	recognized=1;
      }
      
      if(!strcasecmp(which,"browser")) {
	fscanf(file," %[^\n]%*c",browserPATH);
	recognized=1;
      }

      if(!strcasecmp(which,"emailclient")) {
	fscanf(file," %199[^\n]",emailPATH);
	recognized=1;
      }

      if(!strcasecmp(which,"proxy")) {
	fscanf(file,"%199s[^\n]",proxystring);
	recognized=1;
	if(strspn(proxystring," ")==strlen(proxystring)) proxystring[0]='\0';
      }

      if(!strncasecmp(which,"color", 5)) {
	int x=0;

	// Get the number of the color.
 	x = atoi(which+5);
#ifdef DEBUGCONFIG
	printf("x == %i (%s)\n", x, which+5);
#endif
	fscanf(file," %hi %hi %hi[^\n]", &colors[x]->red, &colors[x]->green, 
	       &colors[x]->blue);

	recognized=1;
      }

      if(!recognized) printf("Unrecognized option %s\n",which);
    } 
    else if(!strcasecmp(keyword,"user")) {
      fscanf(file,"%s %s",authID,authPASS);
      if (strcmp(authPASS, "nopass") == 0) 
	memset(authPASS, 0, sizeof(authPASS));
    }
    else if(!strcasecmp(keyword,"auction")) {
      char which[20];
      auction[aucIdx]=new auctioninfo();
      fscanf(file,"%lu",&auction[aucIdx]->ItemNumber);

      while(!feof(file)) {
	fscanf(file,"%19s",which);
	if(!strcasecmp(which,"desc")) fscanf(file,"%120[^\n]",auction[aucIdx]->Description);
	if(!strcasecmp(which,"ends")) fscanf(file,"%ld",&auction[aucIdx]->EndsValue);
	if(!strcasecmp(which,"mybid")) {
	  fscanf(file,"%f %d",&auction[aucIdx]->myBidAmount,
		 &auction[aucIdx]->myBidQuantity);
#ifdef DEBUGCONFIG
	  printf("read mybid %f\n",auction[aucIdx]->myBidAmount);
#endif
	}
	if(!strcasecmp(which,"snipe")) {
	  fscanf(file,"%f %d",&(auction[aucIdx]->snipeAmount),
		 &(auction[aucIdx]->snipeQty));
#ifdef DEBUGCONFIG
	  printf("read %.2f %d\n",auction[aucIdx]->snipeAmount,auction[aucIdx]->snipeQty);
#endif
	  auction[aucIdx]->isSnipe=1;
	  auction[aucIdx]->getkey(auction[aucIdx]->snipeAmount,
				  auction[aucIdx]->snipeQty);
	  
	}
	if(!strcasecmp(which,"endauction")) break;
      }
      aucIdx++;
    }
  }
  fclose(file);
  if(proxyurl!=NULL) delete(proxyurl);
  if(strlen(proxystring)>2)
    proxyurl=new URL(g_strdup_printf("http://%s/",proxystring),NULL);
  else proxyurl=NULL;
  
  if(timesyncurl!=NULL) delete(timesyncurl);
  
  timesyncurl=new URL("http://cgi3.ebay.com/aw-cgi/eBayISAPI.dll?TimeShow",
		      proxyurl);
}
//////////////////////////////////////////////////////////////////////////////
// UpdateListItem:
//      replaces the item in the index position with current information.
//////////////////////////////////////////////////////////////////////////////
void UpdateListItem(int i)
{
  char chTemp[20];
  int intTimeLeft = stringTimeLeft( auction[i]->EndsValue, timeDiff, chTemp);
  GdkColor *theColor;
  GdkColor *textcolor;
  GtkStyle *bid_style;
  
  if ( intTimeLeft < -30 )
    theColor = &color_gone;
  else if ( intTimeLeft < 14400 )
    theColor = &color_near;
  else theColor = &color_far;

  // we have 3 possible states:
  // 1. info from saved file
  // 2. info from an auction list grab
  // 3. all info
  int infoState = 1;
  if ( auction[i]->CurrentBid != 0 ) {
    if ( auction[i]->TimeLeft[0] != 0 ) infoState = 3;
    else infoState = 2;
  }   
  char price[40];
  char mybid[40];
  switch(infoState) {
  case 1:
    strcpy(price," -");
    break;
  case 2: 
    sprintf(price,"%.2f",auction[i]->CurrentBid);
    break;
  default:
    char flags[3]; flags[0]=0;
    if( auction[i]->reserveMet == 'n' ) strcat(flags, "R" );
    if ( strcmp(auction[i]->HighBidder, "Dutch Auction") == 0)
      strcat(flags, "D" );
    sprintf(price,"%s%.2f(%d%s)",auction[i]->currency,
	    auction[i]->CurrentBid,auction[i]->BidCount,
	    flags);
  }
  if(auction[i]->myBidQuantity>0) {
    sprintf(mybid,"%s%.2f",auction[i]->currency,auction[i]->myBidAmount);
  } else strcpy(mybid,"");

  gchar *item[]={g_strdup_printf("%lu",auction[i]->ItemNumber),price,chTemp,mybid,
		   auction[i]->Description};
  int j;for(j=0;j<5;j++) 
    gtk_clist_set_text(GTK_CLIST(aucList),i,j,item[j]);
  if(auction[i]->isSnipe) { 
    gtk_clist_set_pixtext(GTK_CLIST(aucList),i,0,item[0],5,
			  arrowPM,arrowmask);
  }
  else switch(auction[i]->stat) {
  case '1':
    gtk_clist_set_pixtext(GTK_CLIST(aucList),i,0,item[0],5,
			  redledPM,redledmask);
    break;
  case '2':
    gtk_clist_set_pixtext(GTK_CLIST(aucList),i,0,item[0],5,
			  greenledPM,greenledmask);
    break;
  case '3':
    gtk_clist_set_pixtext(GTK_CLIST(aucList),i,0,item[0],5,
			  blueledPM,blueledmask);
    break;
  default:
    gtk_clist_set_pixtext(GTK_CLIST(aucList),i,0,item[0],5,
			  blackledPM,blackledmask);
    break;
  }
   
  gtk_clist_set_foreground(GTK_CLIST(aucList),i,theColor);

  gtk_clist_set_background(GTK_CLIST(aucList),i,(i%2)?&color_back2:&color_back1);


  textcolor = get_style(auction[i]);
  bid_style = gtk_style_copy (gtk_widget_get_default_style());
  bid_style->fg[0] = *textcolor;
  bid_style->text[0] = *textcolor;
  bid_style->base[0] = (i%2)?color_back2:color_back1;
  bid_style->font=fixed_font;

  gtk_clist_set_cell_style(GTK_CLIST(aucList),i,3,bid_style);

}
      
   
//////////////////////////////////////////////////////////////////////////////
// DeleteAuction:
//      deletes the auction at position index, adjust both the AucNumList[]
//      and auction[] to fill the gap created.
// calls:
//      Clearauction()
//////////////////////////////////////////////////////////////////////////////   
void DeleteAuction(int index )
{
  CHECK;
  int idx; 
  if ( index >= aucIdx ) return;  // we are out of range
  // Loop through AucNumList, moving list up to fill the gap
  // where choice will be removed, this should be a linked list.  
  WriteLog(index); 
  delete auction[index];

  for(idx = index ; idx < (aucIdx - 1 ); idx++) 
    {
      auction[idx] = auction[idx+1];
    }
  auction[aucIdx-1]=NULL;
  aucIdx--; 
  CHECK;
}
//////////////////////////////////////////////////////////////////////////////
//
// GetUserAuctions - grabs users auctions from ebay and adds them to
//    aucNum list if they aren't already there.
//   return -2 if userID is not recognized by ebay
//  return -1 if grab otherwise fails (lost connection, etc)
//   return -5 if the cgi server is down
//  return -4 on timeout
//  retunrn 1 on success
//////////////////////////////////////////////////////////////////////////////
int GetUserBids()
{
  CHECK;
  bool flagMatch;
  struct auctioninfo * TempList[MAXAUCS + 1]; 
  int listCount = 0;
  int idx, cnt;
  char *Buff, *Buff2;
  char WebPage[200];
  int returnVal;
  
  if ( strlen(authID) < 2 ) return -1;
  if ( strlen(authID) > 64 ) return -2;
  
  showStatus(" getting bids");
  greenLED();
  sprintf(WebPage,"http://cgi.ebay.com/ws/eBayISAPI.dll?"
	  "MfcISAPICommand=ViewBidItems&userid=%s&completed=0&all=1&rows=200",
	  authID);
  URL *bidsurl=new URL(WebPage,proxyurl);
  returnVal = fetchURL(bidsurl, &Buff,TIMEOUT);
  delete(bidsurl);
  blackLED();
  showStatus("");
  if ( (returnVal != NET_SUCCESS) ) return ERROR;
  if ( strstr(Buff, "invalid") != NULL) {
    free(Buff);
    return GUA_BADUSER;
  }
  CHECK;
  Buff2=parseRows(Buff);
  free(Buff);
  Buff=StripAndTab(Buff2);
  free(Buff2);
  listCount = ParseList( TempList, Buff );
  free(Buff);
  if ( listCount < 0 ) return ERROR;
  // copy TempList to bidlist and set the number of user bids
  // that we have on store from ebay
  /*  for ( cnt=0; cnt < listCount; cnt++ )
    {
      strcpy(auctionlist[cnt], TempList[cnt]->ItemNumber);
    }
    numbids = listCount; */

  if ( !trackBids ) return GUA_SUCCESS;
  // now, compare each auction to the current auction list,
  // if there are no matches, insert it into auction.
  // also check for matches that are not flagged as owned by
  // user (this could happen if the auction was entered manually
  // before the user bid on the auction ).
  CHECK;
  for ( cnt=0; cnt < listCount; cnt++)
    {
      if ( aucIdx >= MAXAUCS ) return GUA_SUCCESS;
      flagMatch = FALSE;
      for ( idx=0; idx < aucIdx; idx++ )
	{
	  if (auction[idx]->ItemNumber==TempList[cnt]->ItemNumber)
	    {
	      /*	      strcpy(auction[idx]->CurrentBid, TempList[cnt]->CurrentBid);
			      strip_commas( auction[idx]->myBid ); */
	      flagMatch = TRUE;
	    }
	  CHECK;
	}
      if ( flagMatch == FALSE )
	{
	  translate_date( TempList[cnt]->Ends );
	  auction[aucIdx]=TempList[cnt];
	  //	  strip_commas( auction[idx]->CurrentBid );
	  auction[aucIdx]->EndsValue = CalcEndsValue(TempList[cnt]->Ends);
	  auction[aucIdx]->stat = '3';
	  aucIdx++;
	}
      CHECK;
    } 
  CHECK;
  return GUA_SUCCESS;
} // end GetUserAuctions.
//////////////////////////////////////////////////////////////////////////////
//
// GetUserAuctions - grabs users auctions from ebay and adds them to
//    aucNum list if they aren't already there.
//   return -2 if userID is not recognized by ebay
//  return -1 if grab otherwise fails (lost connection, etc)
//   return -5 if the cgi server is down
//  return -4 on timeout
//  retunrn 1 on success
//////////////////////////////////////////////////////////////////////////////
int GetUserBids2()
{
  CHECK;
  bool flagMatch;
  int idx, cnt;
  char *Buff, *Buff2;
  char WebPage[200];
  int returnVal;
  unsigned int * ids;

  if ( !trackBids ) return GUA_SUCCESS;
  /* XXX FIXME remove when we fix this subroutine */
  return GUA_SUCCESS;
  if ( strlen(authID) < 2 ) return GUA_BADUSER;
  if ( strlen(authID) > 64 ) return GUA_BADUSER;
  
  showStatus(" getting bids");
  greenLED();
  sprintf(WebPage,"http://cgi.ebay.com/ws/eBayISAPI.dll?"
	  "MfcISAPICommand=ViewBidItems&userid=%s&completed=0&all=1&rows=200",
	  authID);
  URL *bidsurl=new URL(WebPage,proxyurl);
  returnVal = fetchURL(bidsurl, &Buff,TIMEOUT);
  delete(bidsurl);
  blackLED();
  showStatus("");
  if ( (returnVal != NET_SUCCESS) ) return ERROR;
  if ( strstr(Buff, "invalid") != NULL) {
    free(Buff);
    return GUA_BADUSER;
  }
  CHECK;
  Buff2=parseRows(Buff);
  free(Buff);
  Buff=StripAndTab(Buff2);
  free(Buff2);
  ids = ParseList2(Buff);
  free(Buff);
  if (ids[0]==0 ) return ERROR;

  CHECK;
  for ( cnt=0; ids[cnt]!=0; cnt++)
    {
      if ( aucIdx >= MAXAUCS ) return GUA_SUCCESS;
      flagMatch = FALSE;
      for ( idx=0; idx < aucIdx; idx++ ) 	{
	  if (auction[idx]->ItemNumber == ids[cnt] ) flagMatch = TRUE;
      }
      if (!flagMatch)  addNewItem(ids[cnt]);
      CHECK;
    } 
  CHECK;
  return GUA_SUCCESS;
} // end GetUserAuctions.
/////////////////////////////////////////////////////////////////////////////
// GetUserListings
/////////////////////////////////////////////////////////////////////////////
int GetUserListings()
{  
  CHECK;
  if ( !trackListings ) return GUA_SUCCESS;
  bool flagMatch;
  struct auctioninfo * TempList[MAXAUCS + 1];
  int listCount = 0;
  int idx, cnt;
  char *Buff, *Buff2;
  char WebPage[200];
  int returnVal;

  if ( strlen(authID) < 2 ) return -1;
  if ( strlen(authID) > 64 ) return -2;
  showStatus(" getting listings");
  greenLED();
  sprintf(WebPage,"http://cgi6.ebay.com/aw-cgi/eBayISAPI.dll?"
	  "ViewListedItems&userid=%s&completed=0&sort=3&since=-1",authID);
  URL * listingurl=new URL(WebPage,proxyurl);
  returnVal = fetchURL(listingurl, &Buff,TIMEOUT);
  delete listingurl;
  blackLED();
  showStatus("");
  if (returnVal!=NET_SUCCESS) return ERROR;
  if ( strstr(Buff, "invalid") != NULL ) return GUA_BADUSER;
  Buff2=parseRows(Buff);
  free(Buff);
  Buff=StripAndTab(Buff2);
  listCount = ParseList( TempList, Buff );
  free(Buff2);
  free(Buff);
  if ( listCount < 0 ) return ERROR; 
  // now, compare each auction to the current auction list,
  // if there are no matches, insert it into AucNumList
  // if we are over the limit of auctions, return;
  for ( cnt=0; cnt < listCount; cnt++)
    {
      if ( aucIdx >= MAXAUCS ) return 1;
      flagMatch = FALSE;
      for ( idx=0; idx < aucIdx; idx++ )
	{
	  if (auction[idx]->ItemNumber==TempList[cnt]->ItemNumber) {
            auction[idx]->CurrentBid=TempList[cnt]->CurrentBid;
            flagMatch = TRUE;
          }
	}
      if ( flagMatch == FALSE )
	{
	  auction[aucIdx]=new auctioninfo();
	  ClearBidMakeUp(auction[aucIdx]);
	  translate_date( TempList[cnt]->Ends );
	  strcpy(auction[aucIdx]->Ends, TempList[cnt]->Ends);
	  auction[aucIdx]->CurrentBid=TempList[cnt]->CurrentBid;
	  //	  strip_commas( auction[aucIdx]->CurrentBid );
	  auction[aucIdx]->EndsValue = CalcEndsValue(TempList[cnt]->Ends);
	  auction[aucIdx]->ItemNumber=TempList[cnt]->ItemNumber;
	  strcpy(auction[aucIdx]->Description, TempList[cnt]->Description);
	  auction[aucIdx]->stat = '1';
	  aucIdx++;
	}
    } 
  CHECK;
  return GUA_SUCCESS;
}
///////////////////////////////////////////////////////////////////
///////////------------------- UpdateList -------------////////////
///////////////////////////////////////////////////////////////////
void UpdateList()
{
  CHECK;
  char chTemp[20];
  ArrangeList();
  int intTimeLeft=0;
  int infoState;

  GdkColor *theColor;
  GdkColor *textcolor;
  GtkStyle *bid_style;

  showError("Getting watched auctions");

  gtk_clist_freeze(GTK_CLIST(aucList));
  gtk_clist_clear(GTK_CLIST(aucList));
  for( int i = 0; i < aucIdx; i++ )
    {
      infoState = 1;
      intTimeLeft = stringTimeLeft( auction[i]->EndsValue, timeDiff, chTemp);
      if ( intTimeLeft < -30 )
	theColor = &color_gone;
      else if ( intTimeLeft < 14400 )
	theColor = &color_near;
      else theColor = &color_far;

      if ( auction[i]->CurrentBid != 0 ) {
	if ( auction[i]->TimeLeft[0] != 0 ) infoState = 3;
	else infoState = 2;
      }   

      char price[40];
      switch(infoState) {
      case 1:
	strcpy(price," -");
	break;
      case 2: 
	sprintf(price,"%.2f",auction[i]->CurrentBid);
	break;
      default:
	char flags[3]; flags[0]=0;
	if( auction[i]->reserveMet == 'n' ) strcat(flags, "R" );
	if ( strcmp(auction[i]->HighBidder, "Dutch Auction") == 0)
	  strcat(flags, "D" );
	sprintf(price,"%s%.2f(%d%s)",auction[i]->currency,
		auction[i]->CurrentBid,auction[i]->BidCount,
		flags);
      }
      char mybid[40];

  if(auction[i]->myBidQuantity>0) {
    sprintf(mybid,"%s%.2f",auction[i]->currency,auction[i]->myBidAmount);
  } else strcpy(mybid,"");
  
  gchar *item[]={g_strdup_printf("%lu",auction[i]->ItemNumber),price,chTemp,mybid,
		       auction[i]->Description};
      gtk_clist_insert(GTK_CLIST(aucList),i,item);
      if(auction[i]->isSnipe) { 
	gtk_clist_set_pixtext(GTK_CLIST(aucList),i,0,item[0],5,
			      arrowPM,arrowmask);
      }
      else switch(auction[i]->stat) {
      case '1':
	gtk_clist_set_pixtext(GTK_CLIST(aucList),i,0,item[0],5,
			      redledPM,redledmask);
	break;
      case '2':
	gtk_clist_set_pixtext(GTK_CLIST(aucList),i,0,item[0],5,
			      greenledPM,greenledmask);
	break;
      case '3':
	gtk_clist_set_pixtext(GTK_CLIST(aucList),i,0,item[0],5,
			      blueledPM,blueledmask);
	break;
      default:
	gtk_clist_set_pixtext(GTK_CLIST(aucList),i,0,item[0],5,
			      blackledPM,blackledmask);
	break;
      }

      gtk_clist_set_foreground(GTK_CLIST(aucList),i,theColor);

      gtk_clist_set_background(GTK_CLIST(aucList),i,(i%2)?&color_back2:&color_back1);

      textcolor = get_style(auction[i]);
      bid_style = gtk_style_copy (gtk_widget_get_default_style());
      bid_style->fg[0] = *textcolor;
      bid_style->text[0] = *textcolor;
      bid_style->base[0] = (i%2)?color_back2:color_back1;
      bid_style->font=fixed_font;

      gtk_clist_set_cell_style(GTK_CLIST(aucList),i,3,bid_style);

    }
  gtk_clist_thaw(GTK_CLIST(aucList));
  CHECK;
  gtk_statusbar_pop(GTK_STATUSBAR(errorstat),errorcontext);


  return;
}   
//////////////////////////////////////////////////////////////////////////////
// ArrangeList
//
// arrange the list in order of auction ending time.
//////////////////////////////////////////////////////////////////////////////
void ArrangeList()
{
  CHECK;
  struct auctioninfo * Scratch;
  int cnt = 0;
  bool swapflag = TRUE;
  
  while ( swapflag ) {
    swapflag = FALSE;
    for (cnt=0; cnt < (aucIdx - 1); cnt++) {
      if ( auction[cnt]->EndsValue > auction[cnt + 1]->EndsValue )  {
	Scratch = auction[cnt];
	auction[cnt] = auction[cnt + 1];
	auction[cnt + 1] = Scratch;
	swapflag = TRUE;
      }
    }
  } 
  CHECK;
}      
//////////////////////////////////////////////////////////////////////////////
// Updates the auction information for the AucListNum of the
// index number passed.
//      Returns 1 success
//      Returns 2 connection problem
//      Returns 3 invalid auction (was deleted)
//      Returns 4 timeout
//      Returns 5 ebay cgi is down
//      Returns 6 itemNumber is out of bounds.
//      Returns 10 if the update was user-cancelled
//////////////////////////////////////////////////////////////////////////////
int auctioninfo::getinfo()
{
  CHECK;
  int returnVal;
  char *HtmlBuff;
  if(infourl==NULL) 
    infourl=new URL(g_strdup_printf("http://cgi.ebay.com/ws/eBayISAPI.dll"
				    "?ViewItem&item=%lu",ItemNumber),
		    proxyurl);
  greenLED();
  returnVal = fetchURL(infourl,&HtmlBuff,TIMEOUT);
  //  puts(HtmlBuff);
  if(returnVal==NET_NETERROR || returnVal==NET_TIMEOUT) { // maybe proxy settings changed
    infourl=new URL(g_strdup_printf("http://cgi.ebay.com/ws/eBayISAPI.dll"
				    "?ViewItem&item=%lu",ItemNumber),
		    proxyurl);
    returnVal = fetchURL(infourl,&HtmlBuff, TIMEOUT);
  }
  
  blackLED();

  // This looks majorly hacky to me, but lets at least free the memory
  // Thanks to kochc for pointing it out.
  if(returnVal!=NET_SUCCESS) return returnVal;
  else if ( strlen(HtmlBuff) < 1000 ) {
    free(HtmlBuff);
    return INFO_CGIDOWN;
  } else if ( strlen(HtmlBuff) < 5000 ) {
    free(HtmlBuff);
    return INFO_BADAUCTION;
  }

  // ok, html grab was a success - now process the html
  char *Buff;
  Buff=StripHtmlTags(HtmlBuff);
  free(HtmlBuff);
  if ( parseaucinfo(Buff) ) {
    // if the grab was a success, check to see if it is a user 
    // called auction.
    if (strcmp(Seller, authID) == 0 ) {
      stat = '1';
    }
    else {
      if (strcmp(HighBidder, authID) == 0 ) {
	stat = '2';
      }
      else {
	for (int i=0; i < numbids; i++ ) {
	  /* if ( strcmp(ItemNumber, auctionlist[i]) == 0 ) {
	     stat = '3';
	     } */
	}
      }
    }
    free(Buff);
    return INFO_SUCCESS;
  }
  free(Buff);
  return INFO_BADAUCTION;
}   
///////////////////////////////////////////////////////////////////////////////
//  TimeSync
///////////////////////////////////////////////////////////////////////////////
void TimeSync()
{
  CHECK;
  showStatus(" syncing clock");
  int returnVal, i, tDiff;
  char *HtmlBuff;
  int		new_timeDiff = -24*60*60;
  struct timeval tm_start, tm_end;
  double	t1;
  
  
  
  // try getting the time several times and pick the minimum time
  // difference.  This should reduce the variable network delay.  
  
  int num_good = 0;
  
  for( i = 0; i < 10 && num_good < 3; i++ )
    {
      greenLED();
      gettimeofday( &tm_start, NULL );
      
      returnVal = fetchURL(timesyncurl, &HtmlBuff, TIMEOUT);

      gettimeofday( &tm_end, NULL );
      t1 = (tm_end.tv_sec + 0.000001 * tm_end.tv_usec)
	- (tm_start.tv_sec + 0.000001 * tm_start.tv_usec);
      blackLED();
      
      
      if ( returnVal != 1 )
	{
#ifdef DEBUG_NETWORK
	  fprintf( stderr, "Error (%d) fetching ebay's time web page, retrying... (%d)\n", returnVal, i );
#endif
	  continue;
	}

      if( t1 > 6 )
	{
#ifdef DEBUG_NETWORK
	  fprintf( stderr, "Took too long (%.2f sec) to fetch ebay's time web page, retrying... (%d)\n", t1, i );
#endif
	  continue;
	}
      
      if ( strlen(HtmlBuff) < 1000 )
	{
#ifdef DEBUG_NETWORK
	  fprintf( stderr, "Short web page (%d bytes) from ebay's time web page, retrying... (%d)\n", strlen( HtmlBuff ), i );
#endif
	  continue;
	}
       
      tDiff = calcTimeDiff(HtmlBuff);
      free(HtmlBuff);

      // Network delays can cause the time returned by ebay to be
      // off, so we try to correct for this error by removing half the
      // total packet time.  The time returned by ebay is (most likely)
      // truncated to the nearest second.  We try to correct for this by
      // adding in a half second to "round" it correctly.
#ifdef DEBUG_NETWORK
      fprintf( stderr, "Adjusting tDiff from %d by %.2f\n",
	       tDiff, t1/2 + .5 );
#endif
      tDiff += (int)(t1/2 + .5);
       
      // is the time difference total garbage?
      if( tDiff < -24*60*60 || tDiff > 24*60*60 )
	{
#ifdef DEBUG_NETWORK
	  fprintf( stderr, "Bogus tDiff (%d) from ebay's time web page, retrying... (%d)\n", tDiff, i );
#endif
	  continue;
	}
       
      if( tDiff > new_timeDiff )
	new_timeDiff = tDiff;
      
      num_good++;
    }
  

#ifdef DEBUG_NETWORK
  if( num_good != i )
    fprintf( stderr,
	     "Failed to get a good sync %d out of %d times\n",
	     i - num_good, i );
#endif
  
  time_t time_now = time(0);
  int	gmt_time;
  int		local_timeDiff;
  
#if defined(HAVE_GMTIME)
  gmt_time = time_now - mktime(gmtime(&time_now));
#elif defined(HAVE_TM_ZONE)
  struct tm * timeStruct = localtime(&time_now);
  gmt_time = timeStruct->tm_gmtoff;
  if( timeStruct->tm_isdst )
    gmt_time -= 60*60;	// correct for daylight savings time
#elif defined(HAVE_TZNAME)  // this may not work...
  struct tm * timeStruct = localtime(&time_now);	// just to set timezone global variable
  gmt_time = -timezone;
#else
#error "Don't know how to get current timezone!"
#endif
  
  // ebay is GMT+8hrs
  local_timeDiff = -8*60*60 - gmt_time;  // get real diff

  showStatus("");
  
  if ( num_good < 2 ) {
    clockIsSet = TRUE;
    timeDiff = local_timeDiff;
    
    // ebay is GMT+8hrs, but add a 5 minute fudge so that we bid
    // early to be safe
    
    timeDiff += 5*60;
    
    showError("WARNING: Couldn't reach eBay, using local clock."
	      " Do not depend on times or sniping.");
    return;
  }
  
  static bool warned_timeDiff = FALSE;
  if(abs( local_timeDiff - new_timeDiff ) > 15*60 )  // 15 minutes
    {
      char	msg[512];

      sprintf(msg,
	      "ERROR: System clock seems to differ from eBay's by"
	      " %d minutes. Check system clock and timezone.",
	      (local_timeDiff - new_timeDiff)/60);

      showError(msg);
      if(!warned_timeDiff) {
	sprintf(msg,
		"Using the local clock and timezone information to calculate\n"
		"eBay's time is %d minutes different than the time returned\n"
		"from eBay's web site.  This may be a problem. Please\n"
		"double-check your system time and timezone.",
		(local_timeDiff - new_timeDiff)/60 );
	
	new ErrorWindow(msg);
	warned_timeDiff = TRUE;
      }
      return;
    }
  
#ifdef DEBUG_NETWORK
  if( clockIsSet && abs( new_timeDiff - timeDiff ) > 2 )
    fprintf( stderr, "Unusually large time change:  %d - %d = %d\n",
	     new_timeDiff, timeDiff, new_timeDiff - timeDiff );
#endif
  
  clockIsSet = TRUE;
  timeDiff = new_timeDiff;
  
#ifdef DEBUG_NETWORK
  fprintf( stderr, "TimeSync()  time diff=%d   local time diff=%d\n",
	   timeDiff, local_timeDiff );
#endif
  }

/////////////////////////////////////////////////////////////////////////////
// setupSnipe
/////////////////////////////////////////////////////////////////////////////
void setupSnipe(struct auctioninfo * snipeAuction, int idx)
{
  auction[idx] = snipeAuction;
  UpdateListItem(idx);
  WriteAucFile();
}
/////////////////////////////////////////////////////////////////////////////
// WriteLog - append auction[index] to the completed auction log.
/////////////////////////////////////////////////////////////////////////////
void WriteLog( int index )
{
  if ((auction[index]->TimeLeft[0] != '0') && 
      (CalcTimeLeft(auction[index]->EndsValue, timeDiff) < 0) )
    {
      ofstream reportOut;
      char fileName[200];
      MakeFileName(g_strdup_printf("/%s/log", bw_subdir), fileName, TRUE);
      reportOut.open(fileName, ios::app);
      char truncDesc[300];
      sprintf(truncDesc,"%lu - %s\nHigh Bidder: %s\n High Bid: %.2f",
	      auction[index]->ItemNumber,auction[index]->Description,
	      auction[index]->HighBidder,auction[index]->CurrentBid);
      strcat( truncDesc, "\n-----------------------------------------------------\n");
      reportOut << truncDesc;
      reportOut.close();
      ClearSnipe(index);
    }
}
///////////////////////////////////////////////////////////////////////////////////
///// DoSnipe()
///////////////////////////////////////////////////////////////////////////////////
void DoSnipe(int index)
{
  char startTime[10];
  char finishTime[10];
  
  printf("Trying to snipe with idx %i key %s amount %.2f quantity %d\n",
	 index,auction[index]->snipeKey,auction[index]->snipeAmount,
	 auction[index]->snipeQty);

  // now, submit the bid, then check the resulting buffer
  // for a message indicating it was successful:
  MakeClockTime(timeDiff, startTime);
  ofstream reportOut;
  char fileName[200];
  MakeFileName(g_strdup_printf("/%s/snipe", bw_subdir), fileName, TRUE);
  reportOut.open(fileName, ios::app);
  char truncDesc[1024];
  sprintf( truncDesc, "%lu %s%.2f %s",
	   auction[index]->ItemNumber,auction[index]->currency,
	   auction[index]->snipeAmount,
	   auction[index]->Description );
  
  greenLED();
  int returnVal = auction[index]->bid(FALSE);
  blackLED();

  if( returnVal != NET_SUCCESS )
    {
      reportOut << "Bid processing failed:  error" << returnVal << "\n";
      
      // Try once more 
      greenLED();
      returnVal = auction[index]->bid(FALSE);
      blackLED();
    }
  
  MakeClockTime(timeDiff, finishTime);
  strcat(truncDesc, "\nSnipe start: " );
  strcat(truncDesc, startTime );
  strcat(truncDesc, "   finish: " );
  strcat(truncDesc, finishTime );
  strcat(truncDesc, "   auction ends: " );
  strcat(truncDesc, auction[index]->Ends );
  
  auction[index]->stat = '3';
  
  switch(auction[index]->bidstatus) {
  case PB_HIGHBID:
    strcat(truncDesc, "\nSnipe completed: you are the high bidder!");
    strcat(truncDesc, "\n---------------------------------------------------\n");
    /*    strcpy(auctionlist[numbids], auction[index]->ItemNumber);
	  auction[index]->stat = '2'; */
    numbids++;
    break;
  case PB_OUTBID:
    strcat(truncDesc, "\nSnipe completed: but you were outbid");
    strcat(truncDesc, "\n---------------------------------------------------\n");
    break;
  case PB_BIDTOOLOW:
    strcat(truncDesc, "\nSnipe failed: bid under the current asking price");
    strcat(truncDesc, "\n---------------------------------------------------\n");
    break;
  case PB_BADQUANTITY:
    strcat(truncDesc, "\nSnipe failed: problem with bid quantity");
    strcat(truncDesc, "\n---------------------------------------------------\n");
    break;
  case PB_AUCTIONOVER:
    strcat(truncDesc, "\nSnipe failed: auction ended before bid placed");
    strcat(truncDesc, "\n---------------------------------------------------\n");
    break;
 case PB_BADUSER:
   strcat(truncDesc, "\nSnipe failed: invalid username or password");
   strcat(truncDesc, "\n---------------------------------------------------\n");
   break;
  default:
    strcat(truncDesc, "\nSnipe failed: unknown reason");
    strcat(truncDesc, "\n---------------------------------------------------\n");
  }
#ifdef DEBUG_NETWORK
    ofstream outFile;
    sprintf( fileName, "%s/%s/snipe_fail_%lu",
	     getenv("HOME"), bw_subdir, auction[index]->ItemNumber );

    outFile.open(fileName);
    outFile.close();
#endif
    
  reportOut << truncDesc;
  reportOut.close();
  ClearSnipe(index);
  WriteAucFile();
  return;
}

ErrorWindow::ErrorWindow(char *message) {
  window=gtk_dialog_new();
  gtk_container_set_border_width(GTK_CONTAINER(window),10);
  gtk_window_set_title(GTK_WINDOW(window),"Error");  
  messagelabel=gtk_label_new(message);
  gtk_widget_show(messagelabel);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),messagelabel,
		     FALSE,FALSE,0);
  
  okbutton=gtk_button_new_with_label("OK");
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (errorclose_callback), 
		      (gpointer) this);
  gtk_widget_show(okbutton);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area),okbutton,
		     FALSE,FALSE,0);
  
  gtk_widget_show(window);
}

ErrorWindow::~ErrorWindow() {
  if(GTK_IS_WIDGET(window)) gtk_widget_destroy(window);
}

ConfirmWindow::ConfirmWindow(char *message) {
  window=gtk_dialog_new();  
  gtk_container_set_border_width(GTK_CONTAINER(window),10);
  gtk_window_set_title(GTK_WINDOW(window),"Confirm");  
  messagelabel=gtk_label_new(message);
  gtk_widget_show(messagelabel);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),messagelabel,
		     FALSE,FALSE,0);
  
  okbutton=gtk_button_new_with_label("OK");
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
		      GTK_SIGNAL_FUNC (confirmok_callback), 
		      (gpointer) this);
  gtk_widget_show(okbutton);
  cancelbutton=gtk_button_new_with_label("Cancel");
  gtk_signal_connect (GTK_OBJECT (cancelbutton), "clicked",
		      GTK_SIGNAL_FUNC (confirmclose_callback), 
		      (gpointer) this);
  gtk_widget_show(cancelbutton);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area),okbutton,
		     FALSE,FALSE,0);
  gtk_box_pack_end(GTK_BOX(GTK_DIALOG(window)->action_area),cancelbutton,
		   FALSE,FALSE,0);
  
  gtk_widget_show(window);
}

ConfirmWindow::~ConfirmWindow() {
  if(GTK_IS_WIDGET(window)) gtk_widget_destroy(window);
}

  
int main( int argc, char ** argv )
{
  gtk_init(&argc,&argv); 
  int i;
  fixed_font = gdk_font_load ("-*-clean-medium-r-normal-*-*-120-*-*-c-*-*-*");
  clean14 = gdk_font_load ("-*-clean-medium-r-normal-*-*-140-*-*-c-*-*-*");

  greenstyle = gtk_style_copy (gtk_widget_get_default_style());
  for(i=0;i<5;i++) {
    greenstyle->fg[i] = green;
    greenstyle->text[i] = green;
    greenstyle->bg[i] = black;
    greenstyle->base[i] = black;
  }
  greenstyle->font=fixed_font;

  yellowstyle = gtk_style_copy (gtk_widget_get_default_style());
  for(i=0;i<5;i++) {
    yellowstyle->fg[i] = yellow;
    yellowstyle->text[i] = yellow;
    yellowstyle->bg[i] = black;
    yellowstyle->base[i] = black;
  }
  yellowstyle->font=fixed_font;

  redstyle = gtk_style_copy (gtk_widget_get_default_style());
  for(i=0;i<5;i++) {
    redstyle->fg[i] = red;
    redstyle->text[i] = red;
    redstyle->bg[i] = black;
    redstyle->base[i] = black;
  }
  redstyle->font=fixed_font;

  wgreenstyle = gtk_style_copy (gtk_widget_get_default_style());
  for(i=0;i<5;i++) {
    wgreenstyle->fg[i] = green;
    wgreenstyle->text[i] = green;
  }
  wgreenstyle->font=fixed_font;

  wyellowstyle = gtk_style_copy (gtk_widget_get_default_style());
  for(i=0;i<5;i++) {
    wyellowstyle->fg[i] = yellow;
    wyellowstyle->text[i] = yellow;
  }
  wyellowstyle->font=fixed_font;

  wredstyle = gtk_style_copy (gtk_widget_get_default_style());
  for(i=0;i<5;i++) {
    wredstyle->fg[i] = red;
    wredstyle->text[i] = red;
  }
  wredstyle->font=fixed_font;

  clean14style = gtk_style_copy (gtk_widget_get_default_style());
  clean14style->font=clean14;

  win_style = gtk_style_copy (gtk_widget_get_default_style());
  for(i=0;i<5;i++) {
    win_style->fg[i] = black;
    win_style->text[i] = black;
  }
  win_style->font=fixed_font;

  willwin_style = gtk_style_copy (gtk_widget_get_default_style());
  for(i=0;i<5;i++) {
    willwin_style->fg[i] = yellow;
    willwin_style->text[i] = yellow;
  }
  willwin_style->font=fixed_font;

  lose_style = gtk_style_copy (gtk_widget_get_default_style());
  for(i=0;i<5;i++) {
    lose_style->fg[i] = red;
    lose_style->text[i] = red;
  }
  lose_style->font=fixed_font;

  init();

  gtk_main ();
  
  return 0;
}

auctioninfo::auctioninfo() {
  memset(this,0,sizeof(auctioninfo));
  magic=12345;
}

auctioninfo::~auctioninfo() {
  magic=789;
}
