/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_SESSION_H
#define INCLUDED_SESSION_H


#include "libraries.h"
#include <gtk/gtk.h>
#include "types.h"
#include "sqlite3.h"


class Session
// Stores settings valid only during one session. If the program stops, this
// information is lost - and that is what is wanted.
{
public:
  Session (int dummy);
  ~Session ();
  // Search / Replace
  ustring searchword();
  void searchword (const ustring& value);
  ustring replaceword ();
  void replaceword (const ustring& value);
  bool search_case_sensitive ();
  void search_case_sensitive (bool value);
  bool search_current_book ();
  void search_current_book (bool value);
  bool search_current_chapter ();
  void search_current_chapter (bool value);
  bool search_globbing ();
  void search_globbing (bool value);
  bool search_start_word_match ();
  void search_start_word_match (bool value);
  bool search_end_word_match ();
  void search_end_word_match (bool value);
  SearchResultsType searchresultstype ();
  void searchresultstype (SearchResultsType value);
  int search_page ();
  void search_page (int value);
  SearchBibleTimeType searchbibletimetype ();
  void searchbibletimetype (SearchBibleTimeType value);
  ustring search_bibletime_bible ();
  void search_bibletime_bible (const ustring& value);
  ustring search_bibletime_commentary ();
  void search_bibletime_commentary (const ustring& value);
  // Book selection.
  set<unsigned int> selected_books ();
  void selected_books (const set<unsigned int>& value);
  // References highlighting.
  void highlights_clear ();
  void highlights_add (const ustring& word, 
                       bool casesensitive, bool globbing, 
                       bool matchbegin, bool matchend,
                       AreaType areatype,
                       bool id, bool intro, bool heading, bool chapter, 
                       bool study, bool notes, bool xref, bool verse);
  vector<ustring> highlight_words ();
  void highlight_words (const vector<ustring>& value);
  vector<bool> highlight_casesensitives ();
  void highlight_casesensitives (const vector<bool>& value);
  vector<bool> highlight_globbings ();
  void highlight_globbings (const vector<bool>& value);
  vector<bool> highlight_matchbegins ();
  void highlight_matchbegins (const vector<bool>& value);
  vector<bool> highlight_matchends ();
  void highlight_matchends (const vector<bool>& value);
  vector<AreaType> highlight_area_type ();
  void highlight_area_type (const vector<AreaType>& value);
  vector<bool> highlight_area_id ();
  void highlight_area_id (const vector<bool>& value);
  vector<bool> highlight_area_intro ();
  void highlight_area_intro (const vector<bool>& value);
  vector<bool> highlight_area_heading ();
  void highlight_area_heading (const vector<bool>& value);
  vector<bool> highlight_area_chapter ();
  void highlight_area_chapter (const vector<bool>& value);
  vector<bool> highlight_area_study ();
  void highlight_area_study (const vector<bool>& value);
  vector<bool> highlight_area_notes ();
  void highlight_area_notes (const vector<bool>& value);
  vector<bool> highlight_area_xref ();
  void highlight_area_xref (const vector<bool>& value);
  vector<bool> highlight_area_verse ();
  void highlight_area_verse (const vector<bool>& value);
  // Import.
  vector <ustring> import_references_searchwords ();
  void import_references_searchwords (const vector <ustring>& value);
  // Export
  ustring export_usfm_location ();
  void export_usfm_location (const ustring& value);
  // Entry completion.
  vector<ustring> completion_search ();
  void completion_search (const vector<ustring>& value);
  vector<ustring> completion_replace ();
  void completion_replace (const vector<ustring>& value);
  vector<ustring> completion_goto ();
  void completion_goto (const vector<ustring>& value);
  // Checks.
  CheckSortType checksorttype ();
  void checksorttype (CheckSortType value);
  // Area selection.
  AreaType area_type ();
  void area_type (AreaType value);
  bool area_id ();
  void area_id (bool value);
  bool area_intro ();
  void area_intro (bool value);
  bool area_heading ();
  void area_heading (bool value);
  bool area_chapter ();
  void area_chapter (bool value);
  bool area_study ();
  void area_study (bool value);
  bool area_notes ();
  void area_notes (bool value);
  bool area_xref ();
  void area_xref (bool value);
  bool area_verse ();
  void area_verse (bool value);
  // Printing
  vector<ustring> additional_printing_projects ();
  void additional_printing_projects (const vector<ustring>& value);
  // Tools
  int line_cutter_for_hebrew_text_characters ();
  void line_cutter_for_hebrew_text_characters (int value);
  // State
  bool debug ();
  void debug (bool value);
  bool window_initialized ();
  void window_initialized (bool value);
private:
  sqlite3 *db;
  int rc;
  char *error;
  void create (const ustring& filename);
  ustring string_get (gchar * key);
  void string_set (gchar * key, const ustring& value);
  bool boolean_get (gchar * key);
  void boolean_set (gchar * key, bool value);
  int integer_get (gchar * key);
  void integer_set (gchar * key, int value);
  vector<ustring> stringlist_get (gchar * key);
  void stringlist_set (gchar * key, const vector<ustring>& value);
  vector<int> integerlist_get (gchar * key);
  void integerlist_set (gchar * key, const vector<int>& value);
  vector<bool> booleanlist_get (gchar * key);
  void booleanlist_set (gchar * key, const vector<bool>& value);
};


void session_create ();


#endif
