/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_SCRIPTURECHECKS_H
#define INCLUDED_SCRIPTURECHECKS_H


#include "libraries.h"
#include <glib.h>
#include <gtk/gtk.h>
#include "checks.h"


void scripture_checks_count_usfms (bool gui);
void scripture_checks_validate_usfms (GtkListStore * liststore, GtkWidget * treeview, GtkTreeViewColumn * treecolumn, CollectCheckingResults * results);
void scripture_checks_compare_usfms (GtkListStore * liststore, GtkWidget * treeview, GtkTreeViewColumn * treecolumn, CollectCheckingResults * results);
void scripture_checks_chapters_verses (GtkListStore * liststore, GtkWidget * treeview, GtkTreeViewColumn * treecolumn, CollectCheckingResults * results);
void scripture_checks_count_characters (bool gui);
void scripture_checks_unwanted_patterns (GtkListStore * liststore, GtkWidget * treeview, GtkTreeViewColumn * treecolumn, CollectCheckingResults * results);
void scripture_checks_capitalization (GtkListStore * liststore, GtkWidget * treeview, GtkTreeViewColumn * treecolumn, CollectCheckingResults * results);
void scripture_checks_repetition (GtkListStore * liststore, GtkWidget * treeview, GtkTreeViewColumn * treecolumn, CollectCheckingResults * results);
void scripture_checks_matching_pairs (GtkListStore * liststore, GtkWidget * treeview, GtkTreeViewColumn * treecolumn, CollectCheckingResults * results);
void scripture_checks_unwanted_words (GtkListStore * liststore, GtkWidget * treeview, GtkTreeViewColumn * treecolumn, CollectCheckingResults * results);
void scripture_checks_word_inventory (bool gui);
void scripture_checks_usfm_spacing (GtkListStore * liststore, GtkWidget * treeview, GtkTreeViewColumn * treecolumn, CollectCheckingResults * results);
ustring checks_abbreviations_get_filename (const ustring& project);
ustring checks_uncapitalized_prefixes_get_filename (const ustring& project);
ustring checks_capitalized_suffixes_get_filename (const ustring& project);
ustring checks_repetition_show_only_get_filename (const ustring& project);
ustring checks_repetition_ignore_get_filename (const ustring& project);
ustring checks_unwanted_patterns_get_filename (const ustring& project);
ustring checks_unwanted_words_get_filename (const ustring& project);


#endif
