/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_DIALOGSYNCHRONIZE_H
#define INCLUDED_DIALOGSYNCHRONIZE_H


#include <gtk/gtk.h>
#include "ustring.h"
#include "synchronize.h"


class SynchronizeDialog
{
public:
  SynchronizeDialog (int dummy);
  ~SynchronizeDialog ();
  int run ();
protected:
  GtkWidget *synchronizedialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox1;
  GtkWidget *scrolledwindow1;
  GtkWidget *treeview1;
  GtkWidget *hbox3;
  GtkWidget *button_differences;
  GtkWidget *alignment2;
  GtkWidget *hbox4;
  GtkWidget *image2;
  GtkWidget *label4;
  GtkWidget *button_import;
  GtkWidget *alignment3;
  GtkWidget *hbox5;
  GtkWidget *image3;
  GtkWidget *label5;
  GtkWidget *button_export;
  GtkWidget *alignment4;
  GtkWidget *hbox6;
  GtkWidget *image4;
  GtkWidget *label6;
  GtkWidget *dialog_action_area1;
  GtkWidget *cancelbutton1;
  GtkWidget *okbutton1;
private:
  GtkListStore *store1;
  GtkTreeViewColumn *column1;
  GtkTreeSelection *select1;
  vector<ustring> problem_projects;
  vector<ustring> problem_books;
  vector<SynchronizeBookResult> problem_results;
  ustring problem_project;
  ustring problem_book;
  ustring problem_file;
  ustring bibleditproject;
  ustring fileproject;
  ustring differencesproject;
  static void on_treeview1_row_activated (GtkTreeView *treeview, GtkTreePath *path, GtkTreeViewColumn *column, gpointer user_data);
  static gboolean on_treeview1_move_cursor (GtkTreeView *treeview, GtkMovementStep step, gint count, gpointer user_data);
  static void on_treeview1_cursor_changed (GtkTreeView *treeview, gpointer user_data);
  void on_treeview ();
  static void on_button_differences_clicked (GtkButton *button, gpointer user_data);
  void on_button_differences ();
  static void on_button_import_clicked (GtkButton *button, gpointer user_data);
  void on_button_import ();
  static void on_button_export_clicked (GtkButton *button,  gpointer user_data);
  void on_button_export ();
  void buttons_sensitive (bool sensitive);
  void sync ();
  void finalize ();
};


#endif
