/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_BIBLETIME_H
#define INCLUDED_BIBLETIME_H


#include "libraries.h"
#include <glib.h>
#include <gtk/gtk.h>
#include "reference.h"


class BibleTime
{
public:
  BibleTime (bool dummy);
  ~BibleTime ();
  void sendreference (const Reference& reference);
  bool getreference (Reference& reference);
  bool connected;
  vector<ustring> getbibles ();
  vector<ustring> getcommentaries ();
  vector<ustring> search_in_default_bible (const ustring& searchtext);
  vector<ustring> search_in_open_modules (const ustring& searchtext);
  vector<ustring> search_in_module (const ustring& modulename, const ustring& searchtext);
  void reloadmodules ();
private:
  int stage;
  ustring bibledit_dcop_name;
  void log (const ustring & message);
  ustring previous_message;
  static void thread_start (gpointer data);
  void thread_main ();
  bool thread_run;
  bool thread_running;
  void sendreference_internal ();
  bool getreference_internal ();
  unsigned int send_book, send_chapter;
  ustring send_verse;
  bool send_now;
  unsigned int bibletime_book, bibletime_chapter;
  ustring bibletime_verse, bibletime_reply;
  bool bibletime_got_reference;
  bool update_modules;
  void get_modules ();
  vector<ustring> bibles;
  vector<ustring> commentaries;
  ustring dcop_command ();
  vector<ustring> search (const ustring& modulename, const ustring& searchtext, int selector);
  void search_internal ();
  bool search_now;
  ustring search_command;
  vector<ustring> search_results;
  void check_exit (bool spawned, int exitstatus);
  bool reloadmodules_now;
  void reloadmodules_internal ();
};


#endif
