/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "usfm.h"
#include "utilities.h"
#include "config.h"
#include "directories.h"
#include "style.h"
#include "stylesheetutils.h"


Usfm::Usfm (const ustring& stylesheet)
{
  stylesheet_get_styles (stylesheet, styles);
}


Usfm::~Usfm ()
{
}


bool Usfm::is_identifier (const ustring& usfm)
{
  get_style_pointer (usfm);
  if (last_style_pointer < 0)
    return false;
  return (styles[last_style_pointer].type == stIdentifier);
}


bool Usfm::is_comment (const ustring& usfm)
{
  get_style_pointer (usfm);
  if (last_style_pointer < 0)
    return false;
  return (styles[last_style_pointer].type == stComment);
}


bool Usfm::is_running_header (const ustring& usfm)
{
  get_style_pointer (usfm);
  if (last_style_pointer < 0)
    return false;
  return (styles[last_style_pointer].type == stRunningHeader);
}


bool Usfm::is_starting_paragraph (const ustring& usfm)
{
  get_style_pointer (usfm);
  if (last_style_pointer < 0)
    return false;
  return (styles[last_style_pointer].type == stStartsParagraph);
}


ParagraphType Usfm::paragraph_get_subtype (const ustring& usfm)
{
  get_style_pointer (usfm);
  if (last_style_pointer < 0)
    return ptNormalParagraph;
  return (ParagraphType) styles[last_style_pointer].subtype;
}


bool Usfm::is_inline_text (const ustring& usfm)
{
  get_style_pointer (usfm);
  if (last_style_pointer < 0)
    return false;
  return (styles[last_style_pointer].type == stInlineText);
}


bool Usfm::is_chapter_number (const ustring& usfm)
{
  get_style_pointer (usfm);
  if (last_style_pointer < 0)
    return false;
  return (styles[last_style_pointer].type == stChapterNumber);
}


bool Usfm::is_verse_number (const ustring& usfm)
{
  get_style_pointer (usfm);
  if (last_style_pointer < 0)
    return false;
  return (styles[last_style_pointer].type == stVerseNumber);
}


double Usfm::fontsize ()
{
  return styles[last_style_pointer].fontsize;
}


int Usfm::fontpercentage ()
{
  return styles[last_style_pointer].fontpercentage;
}


ustring Usfm::italic ()
{
  return styles[last_style_pointer].italic;
}


ustring Usfm::bold ()
{
  return styles[last_style_pointer].bold;
}


ustring Usfm::underline ()
{
  return styles[last_style_pointer].underline;
}


ustring Usfm::smallcaps ()
{
  return styles[last_style_pointer].smallcaps;
}


bool Usfm::superscript ()
{
  return styles[last_style_pointer].superscript;
}


ustring Usfm::justification ()
{
  return styles[last_style_pointer].justification;
}


double Usfm::spacebefore ()
{
  return styles[last_style_pointer].spacebefore;
}


double Usfm::spaceafter ()
{
  return styles[last_style_pointer].spaceafter;
}


double Usfm::leftmargin ()
{
  return styles[last_style_pointer].leftmargin;
}


double Usfm::rightmargin ()
{
  return styles[last_style_pointer].rightmargin;
}


double Usfm::firstlineindent ()
{
  return styles[last_style_pointer].firstlineindent;
}


bool Usfm::spancolumns ()
{
  return styles[last_style_pointer].spancolumns;
}


int Usfm::get_style_pointer (const ustring& usfm)
// Returns a pointer to the style relevant for "usfm", or -1 is the style is not found.
{
  // Optimization to speed up finding the pointer: if found before, reuse the result.
  if (usfm != last_marker) {
    last_style_pointer = stylesheet_style_get_pointer (styles, usfm);
    last_marker = usfm;
  }
  return last_style_pointer;
}


bool usfm_is_id (const ustring& marker)
{
  return (marker == "id");
}


bool usfm_is_chapter (const ustring& marker)
{
  return (marker == "c");
}


bool usfm_is_verse (const ustring& marker)
{
  return (marker == "v");
}
