/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_TRACK_H
#define INCLUDED_TRACK_H

#include "libraries.h"


class Track
{
public:
  Track (unsigned int dummy);
  ~Track ();
  void tick (const ustring & book, const ustring & chapter, const ustring & verse);
  void get_next_reference (ustring & book, ustring & chapter, ustring & verse);
  void get_previous_reference (ustring & book, ustring & chapter, ustring & verse);
  bool next_reference_available ();
  bool previous_reference_available ();
  void clear ();
private:
  unsigned int time_elapsed;
  ustring previous_reference;
  vector <ustring> recorded_references;
  int reference_pointer;
  bool we_went_back;
  bool we_went_forward;
  ustring reference (const ustring & book, const ustring & chapter, const ustring & verse);
  void store_reference (const ustring& reference);
  // IMPORTANT When adding new variables, get them cleared in function clear()
};


#endif
