/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "oldproject.h"
#include "utilities.h"
#include "config.h"
#include <glib.h>
#include "directories.h"
#include "stylesheetutils.h"
#include "constants.h"
#include "gwrappers.h"
#include "bible.h"
#include "projectutils.h"
#include "books.h"
#include "generalconfig.h"


OldProject::OldProject (const ustring& project)
{
  projectname = project;
  project_load ();
}


void OldProject::project_load ()
{
  // Read the project file, if there is any. Add the bits that are missing.
  GeneralConfiguration genconfig (0);
  filename = gw_build_filename (directories_get_projects(), projectname, "projectsettings");
  ReadText rc (filename, true);
  for (unsigned int i = 0; i <= 1000; i++) {
    switch (i) {
      case 2:
      {
        if (i < rc.lines.size ()) {
          editor_font = rc.lines[i];
        }
        else {
          editor_font = genconfig.editor_font_name();
        }
        break;
      }
      case 3:
      {
        if (i < rc.lines.size ()) {
          stylesheet = rc.lines[i];
        }
        else
        {
          stylesheet = "Standard";
        }
        break;
      }
      case 4:
      {
        if (i < rc.lines.size ()) {
          versification = rc.lines[i];
        }
        else
        {
          versification = "English";
        }
        break;
      }
      case 5:
      {
        if (i < rc.lines.size ())
          sword_description = rc.lines[i];
        else 
        {
          sword_description = " Bibledit project";
        }
        break;
      }
      case 6:
      {
        if (i < rc.lines.size ())
          sword_about = rc.lines[i];
        else
          sword_about = sword_description;
        break;
      }
      case 7:
      {
        if (i < rc.lines.size ())
          sword_lcsh = rc.lines[i];
        else
          sword_lcsh = "Bible--Translation";
        break;
      }
      case 8:
      {
        if (i < rc.lines.size ())
          sword_license = rc.lines[i];
        else
          sword_license = "GNU General Public License";
        break;
      }
      case 9:
      {
        if (i < rc.lines.size ())
          sword_version = rc.lines[i];
        else
          sword_version = "1.0";
        break;
      }
      case 10:
      {
        if (i < rc.lines.size ())
          sword_language = rc.lines[i];
        else
          sword_language = "English";
        break;
      }
      case 11:
      {
        if (i < rc.lines.size ())
          sword_name = rc.lines[i];
        else
          sword_name.clear();
        break;
      }

    }
  }
  // Read the printing fonts.
  ReadText rc2 (printing_fonts_filename(), true);
  printing_fonts.assign (rc2.lines.begin(), rc2.lines.end());
}


ustring OldProject::printing_fonts_filename ()
{
  return gw_build_filename (directories_get_projects(), projectname, "printing-fonts");
}


ustring OldProject::books_reordering_filename ()
{
  return gw_build_filename (directories_get_projects(), projectname, "books-reordering");
}


void OldProject::reordering_read ()
{
  ReadText rc3 (books_reordering_filename(), true);
  for (unsigned int i = 2; i < rc3.lines.size(); i += 3) {
    reordered_books.push_back (rc3.lines[i - 2]);
    reordered_includes.push_back (convert_to_bool (rc3.lines[i - 1]));
    reordered_portions.push_back (rc3.lines[i]);    
  }
}
