/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_GENERALCONFIGURATION_H
#define INCLUDED_GENERALCONFIGURATION_H


#include "libraries.h"
#include "constants.h"
#include "sqlite3.h"


void configuration_vacuum ();
ustring configuration_filename ();
void upgrade_configuration ();


class GeneralConfiguration
// Manages program settings.
{
public:
  GeneralConfiguration (int dummy);
  ~GeneralConfiguration ();
  ustring value_get (const ustring& key, const ustring& standard);
  void value_set (const ustring& key, const ustring& value);
  vector<ustring> valuelist_get (const ustring& key);
  void valuelist_set (const ustring& key, const vector<ustring>& value);
private:
  ustring synchronize_project_on_open_key ();
public:
  bool synchronize_project_on_open ();
  void synchronize_project_on_open_set (bool value);
private:
  ustring synchronize_project_on_close_key ();
public:
  bool synchronize_project_on_close ();
  void synchronize_project_on_close_set (bool value);
private:
  ustring synchronize_project_regularly_key ();
public:
  bool synchronize_project_regularly ();
  void synchronize_project_regularly_set (bool value);
private:
  ustring synchronize_project_minutes_key ();
public:
  int synchronize_project_minutes ();
  void synchronize_project_minutes_set (int value);
private:
  ustring synchronize_on_startup_key ();
public:
  bool synchronize_on_startup ();
  void synchronize_on_startup_set (bool value);
private:
  ustring synchronize_on_shutdown_key ();
public:
  bool synchronize_on_shutdown ();
  void synchronize_on_shutdown_set (bool value);
private:
  ustring startup_time_key ();
public:
  int startup_time ();
  void startup_time_set (int value);
private:
  ustring screen_width_key ();
public:
  int screen_width ();
  void screen_width_set (int value);
private:
  ustring screen_height_key ();
public:
  int screen_height ();
  void screen_height_set (int value);
private:
  ustring window_width_key ();
public:
  int window_width ();
  void window_width_set (int value);
private:
  ustring window_height_key ();
public:
  int window_height ();
  void window_height_set (int value);
private:
  ustring window_x_position_key ();
public:
  int window_x_position ();
  void window_x_position_set (int value);
private:
  ustring window_y_position_key ();
public:
  int window_y_position ();
  void window_y_position_set (int value);
private:
  ustring hpane_position_key ();
public:
  int hpane_position ();
  void hpane_position_set (int value);
private:
  ustring vpane_editor_position_key ();
public:
  int vpane_editor_position ();
  void vpane_editor_position_set (int value);
private:
  ustring vpane_biblenotes_position_key ();
public:
  int vpane_biblenotes_position ();
  void vpane_biblenotes_position_set (int value);
private:
  ustring vpane_quick_references_position_key ();
public:
  int vpane_quick_references_position ();
  void vpane_quick_references_position_set (int value);
private:
  ustring tools_area_left_key ();
public:
  bool tools_area_left ();
  void tools_area_left_set (bool value);
private:
  ustring edit_note_standard_text_one_key ();
public:
  ustring edit_note_standard_text_one ();
  void edit_note_standard_text_one_set (ustring value);
private:
  ustring edit_note_standard_text_two_key ();
public:
  ustring edit_note_standard_text_two ();
  void edit_note_standard_text_two_set (ustring value);
private:
  ustring edit_note_standard_text_three_key ();
public:
  ustring edit_note_standard_text_three ();
  void edit_note_standard_text_three_set (ustring value);
private:
  ustring edit_note_standard_text_four_key ();
public:
  ustring edit_note_standard_text_four ();
  void edit_note_standard_text_four_set (ustring value);
private:
  ustring project_key ();
public:
  ustring project ();
  void project_set (ustring value);
private:
  ustring book_key ();
public:
  ustring book ();
  void book_set (ustring value);
private:
  ustring chapter_key ();
public:
  ustring chapter ();
  void chapter_set (ustring value);
private:
  ustring verse_key ();
public:
  ustring verse ();
  void verse_set (ustring value);
private:
  ustring stylesheet_key ();
public:
  ustring stylesheet ();
  void stylesheet_set (ustring value);
private:
  ustring references_file_key ();
public:
  ustring references_file ();
  void references_file_set (ustring value);
private:
  ustring export_to_bibleworks_filename_key ();
public:
  ustring export_to_bibleworks_filename ();
  void export_to_bibleworks_filename_set (ustring value);
private:
  ustring export_to_sword_module_path_key ();
public:
  ustring export_to_sword_module_path ();
  void export_to_sword_module_path_set (ustring value);
private:
  ustring export_to_sword_install_path_key ();
public:
  ustring export_to_sword_install_path ();
  void export_to_sword_install_path_set (ustring value);
private:
  ustring editor_font_name_key ();
public:
  ustring editor_font_name ();
  void editor_font_name_set (ustring value);
private:
  ustring paper_format_key ();
public:
  ustring paper_format ();
  void paper_format_set (ustring value);
private:
  ustring paper_width_key ();
public:
  double paper_width ();
  void paper_width_set (double value);
private:
  ustring paper_height_key ();
public:
  double paper_height ();
  void paper_height_set (double value);
private:
  ustring paper_left_margin_key ();
public:
  double paper_left_margin ();
  void paper_left_margin_set (double value);
private:
  ustring paper_right_margin_key ();
public:
  double paper_right_margin ();
  void paper_right_margin_set (double value);
private:
  ustring paper_top_margin_key ();
public:
  double paper_top_margin ();
  void paper_top_margin_set (double value);
private:
  ustring paper_bottom_margin_key ();
public:
  double paper_bottom_margin ();
  void paper_bottom_margin_set (double value);
private:
  ustring notes_print_full_page_width_key ();
public:
  bool notes_print_full_page_width ();
  void notes_print_full_page_width_set (bool value);
private:
  ustring java_binary_key ();
public:
  ustring java_binary ();
  void java_binary_set (ustring value);
private:
  ustring xep_home_key ();
public:
  ustring xep_home ();
  void xep_home_set (ustring value);
private:
  ustring printcoverpage_key ();
public:
  bool printcoverpage ();
  void printcoverpage_set (bool value);
private:
  ustring printdate_key ();
public:
  bool printdate ();
  void printdate_set (bool value);
private:
  ustring print_changes_only_key ();
public:
  bool print_changes_only ();
  void print_changes_only_set (bool value);
private:
  ustring project_to_compare_with_key ();
public:
  ustring project_to_compare_with ();
  void project_to_compare_with_set (ustring value);
private:
  ustring show_notes_selector_key ();
public:
  int show_notes_selector ();
  void show_notes_selector_set (int value);
private:
  ustring show_notes_for_current_project_only_key ();
public:
  bool show_notes_for_current_project_only ();
  void show_notes_for_current_project_only_set (bool value);
private:
  ustring notes_show_project_key ();
public:
  bool notes_show_project ();
  void notes_show_project_set (bool value);
private:
  ustring show_notes_category_key ();
public:
  ustring show_notes_category ();
  void show_notes_category_set (ustring value);
private:
  ustring show_notes_date_range_from_key ();
public:
  int show_notes_date_range_from ();
  void show_notes_date_range_from_set (int value);
private:
  ustring show_notes_date_range_to_key ();
public:
  int show_notes_date_range_to ();
  void show_notes_date_range_to_set (int value);
private:
  ustring bibleworks_executable_key ();
public:
  ustring bibleworks_executable ();
  void bibleworks_executable_set (ustring value);
private:
  ustring reference_exchange_send_to_bibleworks_key ();
public:
  bool reference_exchange_send_to_bibleworks ();
  void reference_exchange_send_to_bibleworks_set (bool value);
private:
  ustring reference_exchange_receive_from_bibleworks_key ();
public:
  bool reference_exchange_receive_from_bibleworks ();
  void reference_exchange_receive_from_bibleworks_set (bool value);
private:
  ustring reference_exchange_send_to_bibletime_key ();
public:
  bool reference_exchange_send_to_bibletime ();
  void reference_exchange_send_to_bibletime_set (bool value);
private:
  ustring reference_exchange_receive_from_bibletime_key ();
public:
  bool reference_exchange_receive_from_bibletime ();
  void reference_exchange_receive_from_bibletime_set (bool value);
private:
  ustring reference_exchange_send_to_santafefocus_key ();
public:
  bool reference_exchange_send_to_santafefocus ();
  void reference_exchange_send_to_santafefocus_set (bool value);
private:
  ustring reference_exchange_receive_from_santafefocus_key ();
public:
  bool reference_exchange_receive_from_santafefocus ();
  void reference_exchange_receive_from_santafefocus_set (bool value);
private:
  ustring check_markers_compare_project_key ();
public:
  ustring check_markers_compare_project ();
  void check_markers_compare_project_set (ustring value);
private:
  ustring check_markers_compare_all_markers_key ();
public:
  bool check_markers_compare_all_markers ();
  void check_markers_compare_all_markers_set (bool value);
private:
  ustring check_markers_compare_include_only_key ();
public:
  ustring check_markers_compare_include_only ();
  void check_markers_compare_include_only_set (ustring value);
private:
  ustring check_markers_compare_ignore_key ();
public:
  ustring check_markers_compare_ignore ();
  void check_markers_compare_ignore_set (ustring value);
private:
  ustring check_markers_compare_ignore_verse_zero_key ();
public:
  bool check_markers_compare_ignore_verse_zero ();
  void check_markers_compare_ignore_verse_zero_set (bool value);
private:
  ustring check_capitalization_punctuation_key ();
public:
  ustring check_capitalization_punctuation ();
  void check_capitalization_punctuation_set (ustring value);
private:
  ustring check_capitalization_ignore_key ();
public:
  ustring check_capitalization_ignore ();
  void check_capitalization_ignore_set (ustring value);
private:
  ustring check_capitalization_allow_any_prefixes_key ();
public:
  bool check_capitalization_allow_any_prefixes ();
  void check_capitalization_allow_any_prefixes_set (bool value);
private:
  ustring check_repetition_ignore_case_key ();
public:
  bool check_repetition_ignore_case ();
  void check_repetition_ignore_case_set (bool value);
private:
  ustring check_repetition_show_only_these_key ();
public:
  bool check_repetition_show_only_these ();
  void check_repetition_show_only_these_set (bool value);
private:
  ustring check_repetition_ignore_these_key ();
public:
  bool check_repetition_ignore_these ();
  void check_repetition_ignore_these_set (bool value);
private:
  ustring check_matching_pairs_ignore_key ();
public:
  ustring check_matching_pairs_ignore ();
  void check_matching_pairs_ignore_set (ustring value);
private:
  ustring check_words_inventory_not_include_words_count_key ();
public:
  int check_words_inventory_not_include_words_count ();
  void check_words_inventory_not_include_words_count_set (int value);
private:
  ustring check_words_inventory_word_forming_characters_key ();
public:
  ustring check_words_inventory_word_forming_characters ();
  void check_words_inventory_word_forming_characters_set (ustring value);
private:
  ustring tools_area_page_number_key ();
public:
  int tools_area_page_number ();
  void tools_area_page_number_set (int value);
private:
  ustring styles_category_expanded_key ();
public:
  vector<bool> styles_category_expanded ();
  void styles_category_expanded_set (vector<bool> value);
private:
  ustring insert_footnote_template_key ();
public:
  ustring insert_footnote_template ();
  void insert_footnote_template_set (ustring value);
private:
  ustring insert_endnote_template_key ();
public:
  ustring insert_endnote_template ();
  void insert_endnote_template_set (ustring value);
private:
  ustring insert_xref_template_key ();
public:
  ustring insert_xref_template ();
  void insert_xref_template_set (ustring value);
private:
  ustring parallel_bible_keep_verses_together_key ();
public:
  bool parallel_bible_keep_verses_together ();
  void parallel_bible_keep_verses_together_set (bool value);
private:
  ustring parallel_bible_chapters_verses_key ();
public:
  ustring parallel_bible_chapters_verses ();
  void parallel_bible_chapters_verses_set (ustring value);
private:
  ustring parallel_bible_include_verse_zero_key ();
public:
  bool parallel_bible_include_verse_zero ();
  void parallel_bible_include_verse_zero_set (bool value);
private:
  ustring printing_fonts_key ();
public:
  vector<ustring> printing_fonts ();
  void printing_fonts_set (vector<ustring> value);
private:
  ustring parallel_bible_projects_key ();
public:
  vector<ustring> parallel_bible_projects ();
  void parallel_bible_projects_set (vector<ustring> value);
private:
  sqlite3 *db;
  int rc;
  char *error;
  void create (const ustring& filename);
  bool bool_get (const ustring& id, bool standard);
  void bool_set (const ustring& id, bool value);
  int int_get (const ustring& id, int standard);
  void int_set (const ustring& id, int value);
  ustring string_get (const ustring& id, const ustring& standard);
  void string_set (const ustring& id, const ustring& value);
  double double_get (const ustring& id, double standard);
  void double_set (const ustring& id, double value);
  vector<bool> vector_bool_get (const ustring& id);
  void vector_bool_set (const ustring& id, const vector<bool>& value);
  vector<ustring> vector_string_get (const ustring& id);
  void vector_string_set (const ustring& id, const vector<ustring>& value);
};


#endif
