/* ****************************************************************************

 * eID Middleware Project.
 * Copyright (C) 2008-2009 FedICT.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version
 * 3.0 as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, see
 * http://www.gnu.org/licenses/.

**************************************************************************** */
#include "UnitTest++/src/UnitTest++.h"
#include "../eidlib/eidlib.h"
#include "../common/eidErrors.h"
#include "../eidlib/eidlibException.h"
#include <iostream>

using namespace eIDMW;

static unsigned char _photo0[] = {
		0xff,0xd8,0xff,0xe0,0x00,0x10,0x4a,0x46,0x49,0x46,0x00,0x01,0x02,0x01,0x01,0x2c,
		0x01,0x2c,0x00,0x00,0xff,0xdb,0x00,0x43,0x00,0x1c,0x13,0x15,0x18,0x15,0x11,0x1c,
		0x18,0x16,0x18,0x1f,0x1d,0x1c,0x21,0x29,0x45,0x2d,0x29,0x26,0x26,0x29,0x54,0x3c,
		0x40,0x32,0x45,0x64,0x58,0x69,0x67,0x62,0x58,0x60,0x5f,0x6e,0x7c,0x9e,0x86,0x6e,
		0x75,0x96,0x77,0x5f,0x60,0x8a,0xbb,0x8b,0x96,0xa3,0xa9,0xb1,0xb3,0xb1,0x6b,0x84,
		0xc2,0xd0,0xc1,0xac,0xce,0x9e,0xae,0xb1,0xaa,0xff,0xc0,0x00,0x0b,0x08,0x00,0xc8,
		0x00,0x8c,0x01,0x01,0x11,0x00,0xff,0xc4,0x00,0xd2,0x00,0x00,0x01,0x05,0x01,0x01,
		0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x03,0x04,
		0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x10,0x00,0x02,0x01,0x03,0x03,0x02,0x04,0x03,
		0x05,0x05,0x04,0x04,0x00,0x00,0x01,0x7d,0x01,0x02,0x03,0x00,0x04,0x11,0x05,0x12,
		0x21,0x31,0x41,0x06,0x13,0x51,0x61,0x07,0x22,0x71,0x14,0x32,0x81,0x91,0xa1,0x08,
		0x23,0x42,0xb1,0xc1,0x15,0x52,0xd1,0xf0,0x24,0x33,0x62,0x72,0x82,0x09,0x0a,0x16,
		0x17,0x18,0x19,0x1a,0x25,0x26,0x27,0x28,0x29,0x2a,0x34,0x35,0x36,0x37,0x38,0x39,
		0x3a,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
		0x5a,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x73,0x74,0x75,0x76,0x77,0x78,0x79,
		0x7a,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x92,0x93,0x94,0x95,0x96,0x97,0x98,
		0x99,0x9a,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xb2,0xb3,0xb4,0xb5,0xb6,
		0xb7,0xb8,0xb9,0xba,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xd2,0xd3,0xd4,
		0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,
		0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xff,0xda,0x00,0x08,0x01,0x01,
		0x00,0x00,0x3f,0x00,0xdf,0xc9,0xf5,0x34,0x64,0xfa,0x9a,0x32,0x7d,0x4d,0x19,0x3e,
		0xa6,0x8c,0x9f,0x53,0x46,0x4f,0xa9,0xa3,0x27,0xd4,0xd2,0x16,0xc0,0xc9,0x6c,0x7e,
		0x35,0x1f,0xda,0xa1,0x1d,0x67,0x4f,0xfb,0xec,0x53,0xd6,0x55,0x7f,0xb9,0x20,0x6f,
		0xa1,0xcd,0x3b,0x27,0xd4,0xd1,0x93,0xea,0x68,0xc9,0xf5,0x34,0x64,0xfa,0x9a,0x32,
		0x7d,0x4d,0x19,0x3e,0xa6,0x8c,0x9f,0x53,0x46,0x4f,0xa9,0xa4,0xa2,0x8a,0x28,0xaa,
		0x73,0x6a,0x31,0x46,0xfb,0x57,0xe6,0xc1,0xe4,0xe7,0x8a,0xab,0x73,0xa9,0x3b,0x8f,
		0xdc,0xfc,0xab,0x8c,0x93,0x9e,0x6b,0x2a,0x4b,0xd2,0xe7,0x25,0x99,0x88,0xee,0xd9,
		0x26,0xa3,0x17,0x32,0x72,0x36,0x82,0x3d,0x0a,0xff,0x00,0xf5,0xaa,0x58,0xe7,0x72,
		0x7e,0x50,0x8c,0x7b,0x00,0x7f,0xc9,0xab,0xd0,0xea,0x32,0x21,0xc1,0xde,0x87,0xb8,
		0x3f,0x30,0xfd,0x6b,0x52,0x0b,0xc8,0xe6,0xc0,0xe8,0x4f,0xa7,0x23,0xff,0x00,0xad,
		0xf8,0xd5,0x8a,0x28,0xa2,0x8a,0x28,0xa2,0x8a,0x46,0x65,0x45,0x2c,0xc4,0x05,0x51,
		0x92,0x4f,0x40,0x2b,0x9b,0xd4,0x35,0x69,0x2e,0x58,0xa4,0x04,0xac,0x59,0xe0,0x63,
		0xaf,0xb9,0xac,0xf5,0xf9,0x9c,0xf9,0xb2,0x1c,0x0e,0xde,0xb4,0x34,0xd6,0xd9,0xc7,
		0x97,0x9c,0x0e,0xb9,0x34,0x79,0xf0,0x63,0xfd,0x58,0xfc,0xa9,0x37,0xc2,0xdd,0x13,
		0x6f,0xb8,0x6c,0x7f,0x3a,0x9d,0x77,0x60,0x79,0x6e,0x19,0x4f,0x69,0x3f,0xc4,0x54,
		0xc9,0x37,0x96,0x42,0x48,0x0c,0x64,0xf4,0x0f,0x82,0xbf,0x81,0xab,0x03,0x83,0xc8,
		0x1c,0x76,0x35,0xa9,0xa7,0xcf,0xbd,0x7c,0xb2,0x78,0x51,0xf2,0x83,0xd4,0x7b,0x55,
		0xda,0x28,0xa2,0x8a,0x28,0xa2,0xb1,0xb5,0xcb,0x96,0x91,0x96,0xce,0x16,0xc7,0xf1,
		0x4a,0x47,0x61,0xd8,0x7f,0x5f,0xca,0xb2,0x7e,0x44,0x52,0xa9,0x8f,0x73,0x55,0x27,
		0xdb,0x9f,0x94,0xf3,0xf5,0xa8,0x83,0x7f,0x7b,0x9a,0x4c,0x7a,0x52,0xab,0x76,0x65,
		0xc8,0xa9,0x51,0x33,0xcc,0x2c,0x43,0x7a,0x67,0x07,0xf3,0xa9,0x96,0xea,0x44,0x1b,
		0x26,0x40,0xeb,0xdd,0x58,0x55,0x88,0x64,0x08,0x99,0xb7,0x6d,0xf1,0x8e,0xa8,0x7a,
		0xaf,0xd3,0xfc,0x2a,0xe4,0x32,0x2b,0x61,0xd4,0xed,0xc1,0xe1,0x87,0x05,0x4d,0x6c,
		0xda,0xdc,0x79,0xf1,0xfc,0xd8,0x12,0x0f,0xbc,0xa3,0xf9,0xd4,0xf4,0x51,0x45,0x14,
		0x53,0x26,0x90,0x43,0x0b,0xca,0xc3,0x21,0x14,0xb6,0x07,0x7c,0x76,0xae,0x62,0xea,
		0x46,0x3b,0x9d,0x8e,0x19,0xdb,0x73,0x9f,0xe8,0x2b,0x36,0x49,0x4b,0x70,0x0e,0x05,
		0x0a,0x85,0xce,0x31,0x9a,0x9d,0x2c,0x9d,0x97,0x27,0x8a,0x63,0x5b,0xb2,0x9f,0xeb,
		0x48,0x21,0xdc,0xa7,0xa0,0x61,0xda,0x98,0x51,0x94,0xf4,0x23,0x15,0x34,0x72,0xab,
		0x0d,0xb3,0x82,0x47,0xf7,0x87,0x51,0x4a,0x55,0xed,0xc8,0x92,0x32,0x1b,0xdc,0x74,
		0x61,0xe8,0x45,0x59,0x86,0x65,0x90,0x87,0x8f,0xe4,0x27,0x86,0x52,0x7a,0xff,0x00,
		0xf5,0xfd,0x3d,0x6b,0x4e,0xd6,0x53,0x1b,0x2c,0x89,0x93,0xb7,0x82,0xbe,0xde,0x95,
		0xb0,0x08,0x20,0x10,0x72,0x0f,0x20,0xd2,0xd1,0x45,0x14,0x55,0x0d,0x5e,0x60,0x96,
		0xeb,0x19,0x07,0x0e,0x77,0x13,0x8e,0x81,0x70,0x7f,0x9e,0x3f,0x5a,0xe5,0xae,0x65,
		0x2e,0xdc,0xfa,0xd3,0x60,0x84,0xca,0xe0,0x0a,0xdc,0xb4,0xb0,0x0a,0x01,0x22,0xb4,
		0x05,0xaa,0xec,0xe9,0xda,0xaa,0x5c,0xd8,0xe3,0x90,0x2b,0x32,0x68,0xb6,0x7b,0x1e,
		0xc7,0xd2,0xab,0x82,0xa3,0x83,0xf4,0xe3,0xb1,0xa8,0xa5,0x5e,0xeb,0x4d,0x8e,0x52,
		0xbc,0x75,0x0d,0xd4,0x52,0x9f,0x91,0xb7,0xaf,0xdd,0x61,0x86,0xad,0x7b,0x09,0xcb,
		0x27,0x27,0x2e,0xbc,0x30,0xfe,0x55,0xb9,0x68,0x73,0x16,0xdc,0xe4,0x0e,0x9f,0x4a,
		0x9e,0x8a,0x28,0xa2,0xb0,0xf5,0xf9,0x71,0x26,0xcd,0xd9,0x01,0x00,0x23,0xd0,0xf2,
		0x4f,0xfe,0xcb,0x5c,0xf0,0xcb,0x35,0x6d,0x69,0x76,0xe0,0x28,0x62,0x3a,0xfb,0x56,
		0xd2,0x2f,0x4e,0x95,0x30,0xe9,0x41,0x00,0x8e,0x6a,0x9d,0xdd,0x92,0xcc,0x84,0xa8,
		0xc3,0x7f,0x3a,0xe7,0x2f,0x2d,0xde,0x19,0x09,0xda,0x45,0x55,0x0e,0x7a,0x1e,0x94,
		0xd7,0x03,0x39,0x1d,0xe9,0xc8,0xdf,0xc3,0xd8,0x8f,0xce,0xac,0xd8,0xc9,0xe5,0x4e,
		0x37,0x74,0xe8,0x7e,0x95,0xd2,0xd8,0xb9,0x0d,0xb0,0x9e,0x6a,0xf5,0x14,0x51,0x45,
		0x72,0x7a,0xa4,0xbe,0x65,0xc5,0xce,0x58,0x13,0xe6,0x1f,0xc8,0x1c,0x0f,0xd0,0x0a,
		0xcf,0x8c,0x66,0x45,0x1e,0xa7,0x15,0xd2,0xd9,0xae,0xd8,0xc0,0x1c,0x55,0xf5,0xcf,
		0xa5,0x4a,0x29,0xd8,0xa3,0x15,0x4e,0xf6,0xc5,0x6e,0x54,0xe3,0x01,0xbd,0x7d,0x6b,
		0x9a,0xbd,0xb1,0x92,0xd9,0xce,0x54,0xe2,0xaa,0x88,0xcb,0x02,0x54,0xfe,0x14,0xcc,
		0x11,0xd7,0x8a,0x9e,0x32,0x37,0x29,0x3d,0x09,0xda,0x6b,0xa1,0xb3,0x90,0xe6,0x16,
		0x63,0xce,0x02,0xb1,0xf7,0xad,0x7a,0x28,0xa2,0x82,0xc1,0x41,0x66,0x38,0x50,0x32,
		0x7e,0x95,0xc2,0x33,0x92,0xe4,0xb1,0xc9,0x27,0x9f,0x7a,0x7d,0xa2,0xef,0xb9,0x41,
		0xfe,0xd6,0x6b,0xa7,0x84,0x04,0x51,0xb8,0x81,0xc7,0x7a,0x9c,0x4f,0x1a,0xf5,0x3c,
		0x7a,0xd4,0xab,0x2c,0x6d,0xf7,0x5d,0x4f,0xe3,0x52,0x02,0x28,0xcd,0x04,0x81,0xd6,
		0xa1,0x9e,0x38,0xe5,0x8c,0x89,0x30,0x47,0xbd,0x61,0xdd,0xe9,0x91,0x07,0x0d,0x6f,
		0x28,0x27,0xfb,0xbd,0x6a,0x85,0xcd,0xac,0x85,0x0b,0x18,0xc6,0x57,0xba,0x90,0x73,
		0xf8,0x55,0x64,0xf9,0xb3,0x9e,0xe3,0x15,0xb9,0x6e,0xe3,0x64,0x64,0x7f,0x7f,0xfa,
		0x56,0xf2,0x1d,0xc8,0xa7,0xd4,0x66,0x96,0x8a,0x2a,0xa6,0xaa,0xfb,0x34,0xd9,0x88,
		0xea,0x46,0xde,0xb8,0xea,0x70,0x7f,0x4c,0xd7,0x35,0x6d,0xb6,0x58,0x96,0x29,0x23,
		0x4d,0xac,0xa4,0x86,0x1f,0x7b,0x3e,0xb4,0xba,0x4c,0x3b,0xae,0x86,0x46,0x71,0xde,
		0xb6,0xe5,0x75,0x56,0xcd,0x40,0xfa,0x84,0x2a,0x30,0xcb,0xc1,0xef,0xc6,0x2a,0xb9,
		0xbc,0x80,0xb8,0xf2,0x98,0xe4,0xfa,0x73,0x57,0xac,0xef,0x43,0x10,0x37,0x86,0x07,
		0x8c,0xe6,0xb4,0x41,0xc8,0xcd,0x55,0xba,0xb8,0xf2,0xc1,0x19,0x22,0xb2,0xe5,0xba,
		0xe7,0xe6,0x66,0x23,0xbf,0xa0,0xa9,0x12,0xee,0xdd,0x40,0xda,0xd1,0xb1,0xf4,0xde,
		0x09,0xa7,0x49,0x24,0x53,0x29,0xf9,0x70,0x7d,0xeb,0x04,0xaf,0x97,0x3b,0x27,0xa1,
		0xad,0x2b,0x39,0x0f,0x93,0xc9,0xfb,0xae,0x31,0xfe,0x7f,0x1a,0xe9,0x2d,0x8e,0x6d,
		0xd0,0xfe,0x15,0x25,0x14,0x56,0x57,0x88,0xa4,0xd9,0x62,0xab,0xdd,0x9b,0x3f,0x80,
		0x18,0xfe,0xa2,0xb2,0x2c,0x88,0x7b,0x55,0x66,0x1f,0xea,0x8b,0x28,0xfe,0x7f,0xd6,
		0xae,0xe9,0x4a,0x3c,0xc7,0x60,0x31,0x56,0xee,0x2d,0xcc,0x8b,0x90,0x71,0x59,0x46,
		0xc0,0x2b,0xc8,0x25,0x52,0xe1,0xc6,0x03,0x77,0x43,0xf4,0xf4,0xa5,0xb2,0xb4,0x95,
		0xa4,0x41,0x74,0x77,0xc5,0x16,0x4a,0x20,0xf5,0x20,0x0f,0xcb,0x81,0x57,0x52,0xcb,
		0x6b,0x96,0x04,0xf2,0x78,0xc9,0xe7,0xf1,0xad,0x78,0x87,0xee,0x86,0x7a,0xe2,0xa8,
		0xdd,0x41,0xe6,0xcb,0x82,0x71,0x59,0xf2,0xe9,0xa8,0xc8,0xe8,0xea,0xdb,0xf1,0xf2,
		0x3a,0x9e,0x14,0xfd,0x2a,0xbc,0x16,0x52,0x64,0x9b,0xa4,0x32,0x32,0xae,0xc4,0x50,
		0x46,0x31,0xef,0x56,0xac,0x6c,0x1e,0x25,0xc3,0x1e,0x3d,0x3d,0x3e,0x95,0x9f,0xaa,
		0x43,0xe4,0x5e,0x86,0x1f,0x75,0xd7,0xfc,0xff,0x00,0x4a,0x4b,0x47,0xca,0x14,0xf7,
		0x26,0xba,0x6d,0x35,0xf7,0x5b,0x0e,0xb5,0x6e,0x8a,0x2b,0x03,0xc4,0x8d,0xf3,0x80,
		0x1b,0x8d,0xa0,0x63,0xd0,0xe4,0x9f,0xf0,0xaa,0x1a,0x4b,0x06,0x12,0xc0,0xcd,0x8c,
		0xe0,0x8c,0x7e,0xbf,0xd2,0xb5,0x6c,0xd0,0xc7,0x3b,0x29,0xe9,0x8e,0x0f,0xad,0x68,
		0x22,0xe7,0xad,0x23,0xc0,0x0f,0x6a,0x44,0xb7,0x51,0xfc,0x38,0xa7,0xf9,0x63,0x77,
		0xa6,0x2a,0x55,0xe0,0x53,0x08,0xc9,0xc1,0xa4,0x68,0x43,0x0f,0x7f,0x5a,0x6f,0xd9,
		0xc6,0x73,0x4e,0x29,0xb5,0x6b,0x0f,0x5f,0x50,0x22,0x88,0xf1,0x9d,0xdf,0xd2,0xb2,
		0xed,0x9b,0x13,0x2e,0x7b,0x9c,0x57,0x4b,0xa3,0xb6,0x63,0x2b,0xd8,0x7e,0x95,0xa5,
		0x45,0x15,0xcd,0x78,0x83,0x22,0x79,0x33,0xd0,0xba,0xe3,0xfe,0xf9,0x15,0x99,0x04,
		0xa2,0x0b,0x84,0x98,0x03,0x81,0x8c,0x8f,0x62,0x39,0xad,0xc8,0xe5,0x5f,0xb4,0x23,
		0x2b,0x82,0x8c,0x7e,0x52,0x0d,0x69,0x23,0x7c,0xc4,0x54,0xe2,0x8e,0x2a,0x17,0x62,
		0xcc,0x42,0xf4,0x15,0x3a,0xf2,0x2a,0x27,0x38,0x3f,0x2f,0x24,0x53,0xe3,0x70,0xeb,
		0x91,0xf9,0x53,0xce,0x2a,0x29,0x5b,0x0b,0x5c,0xce,0xb7,0x36,0xfb,0x94,0x41,0xd1,
		0x41,0x3f,0xe7,0xf2,0xac,0xf8,0xdb,0x0c,0xa7,0xd0,0xd6,0xfe,0x87,0x3f,0xef,0xca,
		0x9f,0xe2,0x18,0xad,0xda,0x28,0xae,0x6b,0xc4,0x21,0x85,0xc4,0x99,0x3c,0x16,0x52,
		0x07,0xb6,0xd0,0x3f,0xa1,0xac,0x86,0xc1,0x40,0x79,0xe9,0x49,0x0b,0x88,0xe7,0x47,
		0x27,0x85,0x60,0xc7,0xf3,0xae,0xb1,0x5c,0x70,0xd5,0x65,0x1f,0x8a,0x79,0xf9,0x85,
		0x52,0xba,0x8a,0xe5,0x43,0x79,0x2d,0x8c,0xf7,0xe0,0xff,0x00,0x3a,0x8a,0x3b,0xa9,
		0x91,0x42,0x30,0xcb,0x1e,0x0e,0x05,0x3a,0x34,0xbb,0x33,0xee,0xdf,0xf2,0x9e,0xab,
		0xc6,0x3f,0xc6,0xae,0xa2,0x95,0x39,0x14,0xad,0x20,0x15,0x5a,0xe6,0x5f,0x93,0xad,
		0x72,0xd7,0xcf,0xbe,0xee,0x43,0x9c,0xe0,0xe2,0xa2,0x5c,0x71,0xf5,0xe6,0xaf,0xe9,
		0xd2,0x94,0x99,0x48,0x38,0x65,0x39,0x15,0xd7,0xfd,0x3a,0x51,0x45,0x61,0x78,0x96,
		0x03,0xfb,0xb9,0xf9,0x2a,0x46,0xc3,0xec,0x46,0x48,0xfe,0x67,0xf2,0xac,0x40,0x84,
		0xdb,0x67,0xd0,0xd4,0x1d,0xfe,0xb5,0xbf,0xa7,0xdc,0x19,0xad,0x14,0xb1,0xc9,0x1c,
		0x1f,0xad,0x68,0x44,0x4f,0x63,0x53,0x89,0x31,0x4b,0x24,0xd1,0xa2,0xe5,0xdc,0x28,
		0xf7,0x35,0x02,0xdc,0xda,0xb9,0xe2,0x64,0xe3,0xf0,0x34,0xe5,0xbc,0xb5,0xdd,0x81,
		0x32,0xe7,0xdf,0x8a,0x90,0xb8,0x61,0x90,0x47,0xb1,0x1c,0xd4,0x72,0x9f,0x6a,0xce,
		0xbb,0x90,0x24,0x6c,0xc4,0xf0,0xa3,0x35,0xce,0x9c,0x93,0x93,0xde,0x95,0x4e,0x08,
		0xab,0x16,0xe7,0x0e,0xac,0xa7,0x90,0x6b,0xb2,0xb5,0x7f,0x32,0xda,0x36,0xff,0x00,
		0x64,0x0a,0x96,0x8a,0xa3,0xac,0xc5,0xe6,0xe9,0xb2,0x71,0x92,0xa4,0x30,0xfc,0xff,
		0x00,0xc0,0x9a,0xe7,0xfc,0xb0,0x96,0x59,0x3d,0x73,0x59,0xec,0x30,0xc7,0xd8,0xd5,
		0xcd,0x2e,0x63,0x1c,0xcd,0x19,0x3f,0x2b,0x0c,0xfe,0x35,0xb9,0x0c,0x82,0x9f,0x26,
		0x5f,0xa3,0x11,0x54,0xe6,0xb1,0x0c,0xfb,0xdd,0xde,0x5f,0x66,0x34,0x82,0xd6,0xd0,
		0xf5,0x49,0x01,0xf6,0x63,0x4e,0x36,0x56,0xee,0x30,0x91,0x91,0xee,0xc4,0xe6,0xac,
		0x41,0x6c,0x96,0xe0,0x08,0xcb,0x63,0xd3,0x71,0x34,0xf9,0xa4,0x01,0x71,0x58,0x9a,
		0xa4,0xe0,0x81,0x12,0x9e,0x4f,0x2d,0xcd,0x67,0x01,0x4b,0x8c,0xb0,0xa9,0xa1,0x8d,
		0x98,0xe5,0x06,0x70,0x09,0x3f,0x4a,0xec,0x2c,0x10,0x25,0xa2,0x61,0x98,0x86,0x19,
		0xc1,0xe8,0x0f,0x7c,0x55,0x8a,0x29,0x0a,0x86,0x52,0xac,0x32,0x08,0xc1,0x1e,0xa2,
		0xb9,0x8d,0x48,0xa8,0x41,0x1a,0x0e,0x17,0x82,0x7d,0xeb,0x2d,0x86,0x5b,0xeb,0x8a,
		0x20,0x6d,0x92,0xa9,0x15,0xb3,0x1c,0x98,0xe0,0xfe,0x75,0x7a,0x12,0x1d,0x78,0x3c,
		0xd4,0xeb,0x06,0xe1,0x8c,0x8a,0x43,0x69,0x4e,0xfb,0x38,0x41,0x51,0xc8,0xc2,0x31,
		0xcf,0x4a,0xce,0xba,0xb8,0xda,0xa7,0x1c,0x91,0x58,0x45,0x8b,0xbe,0xe6,0xe4,0x93,
		0x4e,0xcf,0x24,0xf6,0xa1,0x3a,0x56,0xae,0x8f,0x0b,0xc8,0xec,0x14,0x91,0xbd,0x76,
		0x9c,0x77,0x04,0xf3,0xfc,0xab,0xa7,0x55,0x0a,0xa1,0x47,0x40,0x31,0x4b,0x45,0x55,
		0xbd,0xb9,0xf2,0xe3,0x28,0x8d,0x87,0xc7,0x27,0xd0,0x57,0x39,0x70,0xdb,0x99,0xff,
		0x00,0x31,0x54,0xdb,0xa2,0x9c,0x7b,0x54,0x47,0x82,0x78,0xad,0x68,0xce,0xe8,0x55,
		0x87,0x71,0x4e,0x8e,0xe1,0xa1,0x39,0x3d,0x2b,0x46,0x1b,0xf8,0xd8,0x73,0x80,0x6a,
		0x71,0x76,0x84,0x75,0x1f,0x9d,0x47,0x25,0xec,0x60,0x7d,0xe1,0xf9,0xd6,0x74,0xd7,
		0x2f,0x70,0xd8,0x40,0x70,0x7b,0xd4,0x53,0xc7,0xb2,0xdd,0x8e,0x0e,0x48,0xac,0x71,
		0x4a,0x4f,0x18,0xa7,0xa9,0xc2,0xf4,0xae,0x83,0xc3,0xd2,0xc6,0xa8,0xc1,0x8e,0x19,
		0xb0,0x01,0xf6,0xff,0x00,0xf5,0xd6,0xe5,0x15,0x4a,0x5b,0x8d,0x89,0x9b,0x83,0xb5,
		0xba,0x84,0x15,0x97,0x35,0xc1,0x6d,0xc4,0x93,0x8e,0xb8,0x3f,0xce,0xb3,0x2e,0x1b,
		0x18,0x3d,0x7a,0xe6,0xa2,0x5f,0x98,0x91,0x9e,0xf9,0xa8,0xd8,0x10,0x2b,0x42,0xc5,
		0xb7,0x43,0xb4,0xf6,0x35,0x2b,0xaf,0x04,0x54,0x0f,0x1f,0xa7,0x5a,0x66,0xd9,0xfa,
		0x29,0xfd,0x6a,0x68,0xad,0x89,0x20,0xbf,0x35,0x76,0x28,0x80,0xc6,0x05,0x45,0x78,
		0x7f,0x74,0xc0,0x7a,0x56,0x29,0x5c,0x73,0x48,0x54,0x83,0x46,0xe2,0x48,0x1e,0xf5,
		0x3c,0x57,0x32,0xc5,0xb5,0x91,0xc8,0x60,0x30,0x3b,0xf1,0xe9,0x5a,0x56,0xda,0xdc,
		0xf1,0x80,0xb2,0x63,0x6f,0xa8,0x15,0xb2,0x97,0x37,0x45,0x41,0x30,0x02,0x0f,0x20,
		0x8e,0x84,0x57,0x3e,0xad,0x31,0x3f,0x3c,0x81,0x7f,0x53,0x51,0x4d,0x2e,0x1f,0xcb,
		0x53,0xc7,0x73,0xea,0x6a,0xac,0xaf,0xbd,0xcf,0xa0,0xa6,0x2b,0xe1,0xf3,0xda,0xa4,
		0x73,0xb9,0x73,0xde,0xac,0x58,0x3e,0x19,0x97,0xd7,0x15,0xa1,0xd4,0x50,0x17,0x3d,
		0x45,0x48,0xb1,0x8e,0xf4,0xed,0xa0,0x70,0x3a,0xd3,0x88,0xc0,0xcd,0x57,0x9f,0x95,
		0xc5,0x65,0xc8,0x98,0x72,0xb8,0xc7,0x26,0xa4,0xb5,0x84,0x4d,0x87,0x73,0x80,0x2a,
		0x9b,0x10,0x64,0x24,0x70,0xb9,0xe3,0xe9,0x46,0x79,0xa3,0x71,0xe2,0xa6,0x4b,0x99,
		0x95,0x40,0x59,0x5c,0x01,0xd8,0x31,0xa5,0x33,0x9c,0x1d,0xbd,0x4f,0x15,0x13,0x1d,
		0xa0,0x8c,0xfc,0xc7,0xaf,0xb5,0x47,0x40,0x1c,0xd3,0xc1,0x3b,0x6a,0x6b,0x73,0xb6,
		0x40,0x7d,0xeb,0x52,0x36,0xe3,0x1e,0xd5,0x20,0xf5,0xa5,0xc9,0xa7,0x03,0x4a,0x49,
		0x35,0x11,0x5c,0xf6,0xaa,0x97,0x10,0xe0,0x87,0xc7,0x43,0x93,0x55,0x25,0x76,0x84,
		0x3c,0x4a,0x4e,0x09,0xcd,0x56,0xef,0x41,0xe2,0x90,0x52,0xe7,0x14,0xed,0xea,0x83,
		0xe5,0x19,0x3e,0xa6,0x98,0x49,0x34,0x0a,0x72,0x7d,0xef,0xa5,0x03,0xbd,0x5a,0xb7,
		0x4c,0xb6,0x71,0xe9,0x5a,0x08,0x3d,0xbb,0x54,0xa0,0x0c,0xf1,0x4b,0x4f,0x00,0xd3,
		0xd6,0x33,0xdc,0x53,0xd2,0x1c,0x9a,0x65,0xd4,0x4b,0x1c,0x6c,0xcf,0xc0,0x03,0x9a,
		0xe7,0x70,0x25,0xde,0xc4,0x90,0xdc,0x6d,0x18,0xce,0x7b,0x53,0x18,0x15,0x7d,0xa7,
		0xa8,0x38,0x34,0xc3,0x9c,0xd2,0xd1,0x49,0x45,0x14,0xbf,0x4f,0xc6,0x9c,0x80,0xb1,
		0x00,0x75,0x35,0xb3,0x69,0x6d,0xfb,0xbc,0x8e,0xe7,0xf4,0xab,0x9f,0x67,0x38,0xfa,
		0x0a,0x55,0x87,0x27,0x9a,0x77,0x91,0xcd,0x38,0x42,0x41,0xe9,0x53,0xa4,0x27,0xd2,
		0xa5,0x54,0x0a,0x39,0x15,0x8b,0xe2,0x0b,0x9d,0xa1,0x60,0x46,0xe5,0x8e,0x5b,0x07,
		0xb5,0x61,0x06,0x65,0x39,0x04,0x83,0xea,0x0d,0x27,0x42,0x3e,0xb4,0x1e,0xb4,0x51,
		0x9a,0x4a,0x01,0xc1,0xcd,0x2e,0x68,0x03,0xbd,0x28,0x24,0x74,0x35,0xd3,0xe9,0x92,
		0x25,0xc5,0xb2,0xc8,0xa3,0x04,0x7c,0xac,0x3d,0x0d,0x5f,0x08,0x29,0x42,0x73,0x9e,
		0xb4,0xbe,0x58,0xa5,0x08,0x01,0xa7,0xd4,0x53,0xca,0xb1,0x44,0xce,0xc4,0x00,0x06,
		0x49,0x35,0xc7,0x5d,0xdc,0x1b,0x8b,0x87,0x94,0xe7,0xe6,0x3c,0x67,0xb0,0xed,0x50,
		0x0a,0x3b,0x8a,0x28,0xa5,0x15,0x3f,0xf6,0x75,0xf7,0xfc,0xf9,0xdc,0x7f,0xdf,0xa6,
		0xff,0x00,0x0a,0x4f,0xec,0xeb,0xef,0xf9,0xf3,0xb8,0xff,0x00,0xbf,0x4d,0xfe,0x14,
		0xa3,0x4f,0xbd,0xff,0x00,0x9f,0x3b,0x8f,0xfb,0xf4,0xdf,0xe1,0x4b,0xfd,0x9f,0x7d,
		0xff,0x00,0x3e,0x77,0x1f,0xf7,0xe9,0xbf,0xc2,0x81,0xa7,0xdf,0x7f,0xcf,0x9d,0xc7,
		0xfd,0xfa,0x6f,0xf0,0xad,0x2d,0x16,0x2b,0xcb,0x6b,0x83,0x1c,0x96,0xb3,0x88,0xe4,
		0xee,0x63,0x38,0x04,0x56,0xf8,0x46,0xc7,0xdc,0x6f,0xca,0x9c,0x11,0xbf,0xba,0xdf,
		0x95,0x3b,0x6b,0x63,0xee,0x9f,0xca,0x82,0xad,0xfd,0xd3,0xf9,0x53,0x08,0x7e,0x7e,
		0x46,0xfc,0xab,0x27,0x5a,0x17,0x4f,0x00,0x8a,0x08,0x26,0x6d,0xe7,0xe6,0x2a,0x84,
		0xe0,0x56,0x4a,0x68,0xf7,0xb2,0x23,0xb7,0x90,0xea,0x55,0x37,0xe1,0x90,0x8c,0xfb,
		0x0f,0x7f,0x6a,0x87,0xfb,0x3a,0xf7,0xfe,0x7c,0xee,0x3f,0xef,0xdb,0x7f,0x85,0x27,
		0xf6,0x75,0xee,0x7f,0xe3,0xce,0xe3,0xfe,0xfd,0x37,0xf8,0x51,0xfd,0x9d,0x7d,0xff,
		0x00,0x3e,0x77,0x1f,0xf7,0xe9,0xbf,0xc2,0x8f,0xec,0xfb,0xef,0xf9,0xf3,0xb8,0xff,
		0x00,0xbf,0x4d,0xfe,0x14,0xbf,0xd9,0xf7,0xbf,0xf3,0xe7,0x71,0xff,0x00,0x7e,0x9b,
		0xfc,0x2b,0xff,0xd9,
};

static unsigned char _photo2[] = {
        0xff,0xd8,0xff,0xe0,0x00,0x10,0x4a,0x46,0x49,0x46,0x00,0x01,0x02,0x01,0x01,0x2c,
        0x01,0x2c,0x00,0x00,0xff,0xdb,0x00,0x43,0x00,0x0f,0x0a,0x0b,0x0d,0x0b,0x09,0x0f,
        0x0d,0x0c,0x0d,0x11,0x10,0x0f,0x11,0x16,0x25,0x18,0x16,0x14,0x14,0x16,0x2d,0x20,
        0x22,0x1b,0x25,0x35,0x2f,0x38,0x37,0x34,0x2f,0x34,0x33,0x3b,0x42,0x55,0x48,0x3b,
        0x3f,0x50,0x3f,0x33,0x34,0x4a,0x64,0x4b,0x50,0x57,0x5a,0x5f,0x60,0x5f,0x39,0x47,
        0x68,0x6f,0x67,0x5c,0x6e,0x55,0x5d,0x5f,0x5b,0xff,0xc0,0x00,0x0b,0x08,0x00,0xc8,
        0x00,0x8c,0x01,0x01,0x11,0x00,0xff,0xc4,0x00,0xd2,0x00,0x00,0x01,0x05,0x01,0x01,
        0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x03,0x04,
        0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x10,0x00,0x02,0x01,0x03,0x03,0x02,0x04,0x03,
        0x05,0x05,0x04,0x04,0x00,0x00,0x01,0x7d,0x01,0x02,0x03,0x00,0x04,0x11,0x05,0x12,
        0x21,0x31,0x41,0x06,0x13,0x51,0x61,0x07,0x22,0x71,0x14,0x32,0x81,0x91,0xa1,0x08,
        0x23,0x42,0xb1,0xc1,0x15,0x52,0xd1,0xf0,0x24,0x33,0x62,0x72,0x82,0x09,0x0a,0x16,
        0x17,0x18,0x19,0x1a,0x25,0x26,0x27,0x28,0x29,0x2a,0x34,0x35,0x36,0x37,0x38,0x39,
        0x3a,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
        0x5a,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x73,0x74,0x75,0x76,0x77,0x78,0x79,
        0x7a,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x92,0x93,0x94,0x95,0x96,0x97,0x98,
        0x99,0x9a,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xb2,0xb3,0xb4,0xb5,0xb6,
        0xb7,0xb8,0xb9,0xba,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xd2,0xd3,0xd4,
        0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,
        0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xff,0xda,0x00,0x08,0x01,0x01,
        0x00,0x00,0x3f,0x00,0xef,0xb7,0x1f,0x53,0x40,0x27,0x1d,0x4d,0x21,0x63,0xea,0x68,
        0xdc,0x7d,0x4d,0x1b,0x8e,0x3a,0x9f,0xce,0x97,0x27,0xd4,0xd1,0x96,0x1d,0xcd,0x1b,
        0x8f,0xf7,0x8f,0xe7,0x4d,0x33,0x28,0x20,0x17,0xe4,0xf4,0xe7,0xad,0x29,0x93,0x03,
        0x3b,0xbf,0x5a,0x6a,0x4e,0xaf,0xc2,0x3e,0x48,0xeb,0xcd,0x3b,0x71,0xf5,0x34,0x9b,
        0x9b,0xd4,0xfe,0x74,0x6e,0x6f,0xef,0x1f,0xce,0x93,0x73,0x7f,0x78,0xfe,0x74,0xbb,
        0x9b,0xfb,0xc7,0xf3,0xa3,0x73,0x7a,0x9f,0xce,0x8d,0xcd,0xea,0x7f,0x3a,0x5c,0x52,
        0xd2,0x1c,0x51,0x49,0x50,0x5e,0x5e,0xc1,0x65,0x03,0x4d,0x71,0x22,0xa2,0x0e,0xe4,
        0xf5,0xae,0x43,0x53,0xf1,0xb3,0x07,0x2b,0x64,0x17,0x68,0xfe,0x22,0xbc,0xd6,0x63,
        0xf8,0xc2,0x69,0xa1,0x6f,0x38,0xb3,0x48,0x3e,0xee,0x0e,0xd5,0x3f,0x50,0x2b,0x22,
        0x2d,0x4d,0x9a,0xe9,0x66,0x9a,0x67,0xce,0x79,0x24,0x9e,0x05,0x5e,0xff,0x00,0x84,
        0xa2,0xee,0x30,0xf1,0x45,0x71,0x21,0x4c,0xf0,0x5b,0xe6,0xc0,0xfc,0x6a,0xb4,0x7a,
        0xe5,0xdc,0x13,0x89,0xa1,0xb8,0x90,0x3f,0x76,0xdd,0x9c,0xfd,0x6b,0x66,0xc3,0xc6,
        0xf7,0xb1,0x95,0xfb,0x4a,0x24,0xeb,0xf4,0xda,0x7f,0x4a,0xea,0xec,0x7c,0x43,0x65,
        0x79,0x66,0x6e,0x43,0x98,0xd5,0x78,0x60,0xdd,0x45,0x69,0xc7,0x22,0x4a,0x81,0xd1,
        0x83,0x2b,0x0c,0x82,0x3a,0x53,0xbb,0xd2,0xd1,0x45,0x3e,0x90,0xd1,0x4c,0x92,0x44,
        0x89,0x0b,0xc8,0xc1,0x54,0x72,0x49,0x38,0x02,0xb9,0x6d,0x73,0xc6,0x50,0x5a,0x86,
        0x8f,0x4f,0x2b,0x34,0x9f,0xdf,0x3f,0x74,0x7f,0x8d,0x70,0xfa,0x86,0xb3,0x79,0xa8,
        0x49,0xbe,0xe6,0x56,0x90,0xe3,0x8c,0xf1,0x8f,0xa0,0xaa,0x04,0x92,0x73,0xed,0xd6,
        0x98,0x84,0x9c,0x82,0x08,0xfa,0x8a,0x52,0x0e,0xdf,0x9b,0x39,0xc7,0x6a,0x01,0xc1,
        0xc1,0xa5,0xc7,0x39,0xa7,0x27,0xde,0x1c,0xfe,0x35,0x37,0x99,0x22,0x70,0x84,0xf2,
        0x7a,0x7a,0xd7,0x55,0xe1,0xcf,0x13,0xfd,0x8a,0x18,0xed,0xee,0x81,0x68,0x87,0x1b,
        0x81,0xc9,0x1c,0xd7,0x77,0x0c,0xa9,0x34,0x6b,0x24,0x6c,0x19,0x18,0x64,0x11,0xdc,
        0x54,0x94,0xb4,0x53,0xe9,0x0d,0x35,0x98,0x2a,0x92,0x48,0x00,0x57,0x0d,0xe2,0xcf,
        0x11,0x8b,0x82,0xd6,0x76,0x8d,0xfb,0xb5,0xce,0xe7,0xcf,0xde,0xfa,0x57,0x10,0xec,
        0x4b,0x1f,0x9b,0x23,0xb6,0x6a,0x12,0xc7,0xa8,0xe0,0x91,0xf9,0xd3,0xfe,0xf0,0xf6,
        0xef,0x49,0xef,0x9c,0x67,0x81,0x4e,0xed,0x9e,0xde,0xd4,0x80,0xe4,0xe7,0x1f,0x86,
        0x29,0x73,0xf3,0x01,0xc9,0xfa,0x53,0xd4,0xed,0x56,0x1d,0x0d,0x2a,0xc8,0x3a,0xb0,
        0xfd,0x29,0xe0,0xb0,0x60,0x41,0xf9,0x4d,0x77,0x9e,0x0e,0xd7,0x61,0x92,0x04,0xb0,
        0x95,0xb6,0xc8,0xbc,0x26,0x7f,0x88,0x7a,0x57,0x5a,0x29,0x45,0x2d,0x3e,0x83,0xd2,
        0xb9,0xdf,0x17,0xea,0xa2,0xc2,0xc7,0xca,0x5e,0x64,0x94,0x10,0x3d,0x87,0x15,0xe6,
        0x13,0xca,0x64,0x6c,0xf3,0x51,0x06,0xcf,0xe1,0x48,0xab,0xf7,0x48,0xcf,0x4a,0x7e,
        0xd2,0x07,0x20,0xfb,0x71,0x46,0xd3,0xd7,0x69,0xfc,0x05,0x4d,0x15,0xb3,0xbf,0x62,
        0x2a,0xd2,0xe9,0x72,0x75,0xd8,0xde,0xb4,0xf8,0xb4,0x79,0x09,0x04,0xa9,0xab,0xd1,
        0xe8,0x99,0x18,0x7c,0xe3,0xda,0xa9,0x5f,0x68,0xb2,0x43,0x97,0x8c,0x31,0x51,0xc9,
        0xac,0xe4,0xc2,0xfc,0xaf,0x91,0x83,0xc8,0x3d,0x2a,0xdd,0xb4,0xa6,0x0b,0x88,0xe4,
        0x8c,0x72,0x8c,0x18,0x57,0xaa,0x68,0xf7,0xdf,0xda,0x1a,0x7c,0x77,0x18,0x0a,0x5b,
        0xa8,0x07,0x38,0x35,0x7e,0x83,0x4f,0x34,0x86,0xbc,0xe3,0xc7,0x77,0x7e,0x6e,0xaa,
        0x63,0xce,0x44,0x48,0x17,0x19,0xee,0x79,0xff,0x00,0x0a,0xe4,0x58,0x74,0x1e,0xbd,
        0xea,0x6b,0x3b,0x63,0x2b,0xe4,0xfd,0xd1,0x5a,0x49,0x6a,0xbd,0x00,0xab,0x09,0x64,
        0x8f,0x8c,0x8a,0xb3,0x1d,0x8c,0x4b,0xc6,0xd1,0xcd,0x5d,0x86,0xd2,0x15,0x1c,0x20,
        0xab,0xab,0x12,0x6d,0xe1,0x45,0x3b,0xcb,0x52,0x06,0x45,0x28,0x40,0x3a,0x52,0x94,
        0x5c,0x1c,0x8e,0xbe,0xd5,0xcb,0xf8,0x8b,0x4e,0x11,0x11,0x3c,0x6b,0x85,0x6e,0x08,
        0xf4,0x35,0x8e,0x8d,0xb4,0x6d,0x39,0x1c,0xf7,0xae,0xdb,0xc0,0x97,0xa5,0x7c,0xcb,
        0x3c,0x65,0x4b,0x6f,0x07,0xd3,0x80,0x3f,0xa5,0x76,0xa0,0xd2,0xe6,0x9e,0x45,0x43,
        0x77,0x3a,0x5b,0x5b,0x49,0x34,0x87,0x0a,0x8a,0x58,0xd7,0x8f,0xea,0xf7,0x4f,0x7f,
        0x7d,0x2d,0xc3,0x8e,0x59,0x8b,0x7d,0x2a,0x8e,0x32,0x45,0x6d,0xda,0x5b,0x88,0x2d,
        0x97,0xfb,0xc7,0xad,0x4a,0x0f,0x39,0xab,0x90,0x01,0xe9,0x56,0xd1,0x01,0xc7,0x15,
        0x32,0x29,0xcf,0xd6,0xac,0x01,0x81,0x40,0xcd,0x4b,0x1a,0x9c,0x50,0xca,0x73,0xd2,
        0xaa,0xde,0xdb,0x8b,0x8b,0x77,0x8d,0x86,0x43,0x0c,0x57,0x13,0x2c,0x5e,0x59,0x78,
        0xd8,0x1f,0x94,0x91,0x5b,0x7e,0x11,0x9f,0xca,0xd6,0xe1,0xeb,0x87,0xca,0xf1,0xf4,
        0xaf,0x4b,0x5e,0x94,0xb5,0x2d,0x64,0x78,0xa0,0xb8,0xd0,0xae,0x76,0x0c,0x9d,0xbd,
        0xbe,0xb5,0xe4,0x93,0xb9,0x32,0x1e,0xb4,0xfb,0x38,0xfc,0xc9,0xd7,0x3e,0xb5,0xbd,
        0x20,0xc4,0x6b,0x51,0x01,0xf3,0x55,0xc8,0x3a,0x8a,0xbc,0x8c,0x05,0x4e,0x87,0x8e,
        0x95,0x20,0xa9,0x11,0x38,0xe6,0xad,0x46,0xa0,0x20,0xe2,0x99,0x22,0xe4,0xe4,0x54,
        0x12,0x8c,0x57,0x27,0xaf,0x40,0x12,0xe9,0x9c,0x0e,0x1f,0x9a,0xbb,0xe0,0xcb,0x65,
        0x9f,0x54,0x0d,0x92,0x0c,0x5f,0x30,0xc5,0x7a,0x3a,0xf4,0x14,0xa6,0xa4,0x35,0x5e,
        0xf6,0x05,0xb8,0xb3,0x96,0x17,0xfb,0xae,0x85,0x4f,0xe3,0x5e,0x33,0x79,0x16,0xcb,
        0x86,0x5c,0xfd,0xd2,0x47,0x27,0xd2,0xac,0xe9,0x89,0x99,0x46,0x79,0xad,0x67,0xfe,
        0x55,0x08,0x38,0x3c,0x55,0x98,0x4e,0x0e,0x4f,0x5a,0xb6,0x8f,0x93,0xc1,0xab,0x50,
        0xb5,0x4e,0x32,0x79,0xa9,0xd0,0x00,0xa3,0x26,0xa7,0x0c,0x36,0x8e,0x45,0x34,0xbf,
        0x18,0xa8,0x66,0xae,0x6b,0x5e,0x4c,0x9c,0x9f,0xc2,0xac,0xf8,0x11,0x5b,0xfb,0x56,
        0x5e,0x3e,0x51,0x1f,0x27,0xdf,0x35,0xe8,0x42,0x97,0xf0,0xa9,0x31,0x4d,0x71,0x95,
        0x22,0xbc,0x77,0x56,0xb6,0x31,0xea,0x33,0xc4,0xeb,0x82,0x92,0x15,0xc7,0xe3,0x52,
        0x69,0xaa,0x03,0xf4,0xe6,0xb4,0x25,0x1c,0x1c,0x55,0x60,0xd9,0x38,0xc5,0x4f,0x19,
        0x27,0x8e,0x6a,0xe4,0x23,0x91,0x57,0x61,0x4e,0x2a,0xc2,0x8e,0xd5,0x2c,0x63,0x24,
        0x62,0xac,0xf9,0x5c,0x53,0x19,0x48,0x15,0x13,0xf3,0xda,0xb0,0x75,0xe8,0xb3,0x16,
        0xf1,0xd0,0x75,0xab,0x5e,0x03,0x1f,0xe9,0x37,0x27,0x1d,0x94,0x7f,0x3a,0xee,0x96,
        0x9d,0x8a,0x92,0x90,0xf4,0xae,0x07,0xc7,0xb6,0x2b,0x0d,0xec,0x57,0x51,0xae,0x3c,
        0xe0,0x43,0x9f,0x71,0x8f,0xe9,0xfc,0xab,0x03,0x4d,0x19,0x63,0xed,0x57,0x66,0xe1,
        0x32,0x6a,0xbe,0x40,0x1c,0xd2,0xad,0xc2,0x8c,0x62,0xaf,0x5b,0x4c,0xad,0x5a,0x30,
        0x38,0x3f,0x95,0x58,0x89,0xb3,0xd7,0xbd,0x3a,0x39,0x02,0x0c,0x93,0xd2,0x89,0x75,
        0x58,0x61,0xe1,0xe4,0x51,0x55,0x1b,0x5d,0x80,0x92,0x00,0x63,0xee,0x2a,0x44,0xd4,
        0xa1,0x94,0x60,0xe5,0x73,0xdc,0xd5,0x7d,0x4a,0x35,0x96,0xce,0x50,0x39,0x18,0xaa,
        0xfe,0x0f,0x96,0x5b,0x79,0x27,0x75,0x00,0xa1,0x20,0x1c,0xd7,0xa0,0x2f,0x23,0x34,
        0xec,0x54,0x94,0xd6,0x38,0x04,0xfa,0x57,0x9f,0xf8,0x87,0x52,0x9a,0xfd,0x19,0x1b,
        0x63,0x44,0xa4,0x95,0xda,0x39,0x15,0x8b,0xa6,0x8c,0x33,0xd4,0xd7,0x72,0xec,0x4c,
        0x01,0x96,0xac,0xc1,0xe6,0x39,0x07,0x9f,0xc2,0xac,0x08,0x26,0xd9,0xbf,0x63,0x74,
        0xa8,0x16,0xe6,0x68,0x9b,0x90,0x54,0xe7,0xb5,0x69,0x5a,0x6a,0x7c,0x61,0xf8,0x35,
        0xb3,0x63,0x2f,0xda,0x53,0xe5,0xea,0x47,0x14,0xcb,0x85,0x96,0x33,0xc8,0x38,0xf5,
        0xac,0x1b,0xa5,0x8c,0xca,0xde,0x6d,0xc0,0x5e,0x79,0xef,0x53,0xdb,0x43,0x60,0x40,
        0x26,0xe8,0xe0,0xf7,0xce,0x2b,0x5a,0x2b,0x4b,0x79,0x50,0x18,0xa5,0xdc,0x31,0xc7,
        0x39,0xab,0x09,0x01,0x5b,0x73,0x1e,0x73,0xc6,0x39,0xa8,0xf4,0x88,0x19,0x2c,0x94,
        0x01,0x8c,0xcb,0xd2,0xbb,0x78,0xc7,0xca,0x29,0xe6,0xa4,0x34,0xd6,0x19,0x04,0x57,
        0x9d,0x6a,0x16,0x8d,0x65,0x79,0x3c,0x2c,0x38,0x56,0xe3,0x3d,0xc7,0x6a,0xa3,0x6d,
        0x0f,0x96,0xae,0xff,0x00,0xde,0x3c,0x55,0x79,0xce,0x5b,0x9a,0xaa,0xf3,0x49,0xbb,
        0x10,0x8c,0x7b,0xe2,0x89,0x92,0xee,0x52,0x82,0x39,0x1c,0x8e,0xe3,0x9a,0x8b,0x50,
        0xb6,0xf2,0x82,0xb0,0x0d,0x90,0x3e,0x62,0xde,0xb4,0xdb,0x30,0xe4,0x8c,0xf3,0x9a,
        0xeb,0xf4,0x80,0x23,0x55,0xc5,0x68,0xde,0x45,0xbd,0x36,0x8e,0xe2,0xb9,0xd9,0xb4,
        0xa6,0x69,0x18,0x6c,0x1f,0x37,0xb5,0x5b,0xd3,0x74,0x6f,0xb3,0x02,0x40,0x4c,0xbf,
        0x04,0x91,0xc8,0x1e,0xd5,0xa1,0x0e,0x8f,0x0c,0x27,0x74,0x43,0x61,0xf6,0xe2,0xa7,
        0x75,0x0a,0x98,0x1d,0xaa,0x7d,0x38,0x89,0x24,0x54,0xc0,0xe1,0x85,0x74,0x6a,0x38,
        0xa5,0xa9,0x29,0x2b,0x95,0xf1,0xad,0xb1,0x10,0x25,0xd2,0x0e,0x9f,0x2b,0x1f,0xe5,
        0x5c,0xb5,0xa2,0xb0,0xb6,0xc9,0xe7,0x24,0x9a,0x86,0x54,0x25,0xaa,0x5b,0x7b,0x75,
        0x3d,0x45,0x5d,0xd9,0xe5,0xa7,0x1c,0x56,0x56,0xa0,0x9b,0x8e,0xe2,0x6a,0x2b,0x64,
        0x0a,0x33,0xc5,0x6f,0x69,0x6c,0x4e,0x0d,0x6c,0x06,0x27,0x19,0xa7,0xaa,0x2b,0x8e,
        0x45,0x38,0x7c,0x84,0x00,0x72,0x2a,0x6d,0xc0,0xa9,0xe9,0x54,0xe6,0x04,0x66,0xa5,
        0xd2,0x57,0x17,0x41,0xbd,0x5a,0xba,0x31,0xd2,0x96,0xa4,0xa2,0xa8,0x6b,0x36,0xa2,
        0xef,0x4d,0x9a,0x22,0x32,0x4a,0xe4,0x7d,0x47,0x35,0xc2,0x34,0x5e,0x48,0x28,0x01,
        0xf9,0x6a,0x9c,0xa7,0x9a,0x92,0x27,0xc7,0x41,0x56,0x0b,0x65,0x79,0x15,0x99,0xa8,
        0x49,0x8e,0x05,0x45,0x6c,0x0b,0x46,0x0e,0x38,0x35,0xbb,0xa5,0x83,0xc7,0x6a,0xda,
        0xda,0xc0,0x00,0x47,0x38,0xa6,0x24,0x85,0x58,0xa9,0xa9,0x43,0x67,0x1c,0x54,0x84,
        0x9c,0x55,0x79,0x8e,0x41,0xab,0x3a,0x52,0xfe,0xf6,0x3f,0xa9,0xad,0xf1,0xd2,0x96,
        0xa4,0xa2,0x9a,0xe3,0x2b,0x5c,0x1e,0xa7,0x6e,0xf6,0xf7,0xb3,0x46,0xe3,0xa1,0xc8,
        0x3e,0xa2,0xb2,0x26,0xe0,0xe2,0x92,0x16,0x19,0xe4,0x54,0xcf,0x26,0x13,0xde,0xb1,
        0xae,0xdc,0xb4,0x84,0x9e,0xb4,0xf8,0x2e,0x56,0x28,0xb6,0xbf,0x51,0xd3,0x15,0xab,
        0xa6,0x5f,0x8c,0x81,0xd3,0xd8,0xd6,0xc4,0x77,0xce,0xf2,0xaa,0x24,0x4c,0xcb,0x8e,
        0x5b,0x3d,0x2a,0xcc,0x88,0x4e,0x1d,0x7a,0x8e,0xa2,0x9f,0x1b,0x03,0x8c,0xd4,0xdb,
        0xb2,0x3d,0xaa,0x07,0xe8,0x7d,0xeb,0x67,0x4d,0xb2,0x68,0x40,0x79,0x46,0x1b,0xa0,
        0x1e,0x95,0xa3,0x45,0x49,0x45,0x21,0xe9,0x59,0xfa,0xd5,0x94,0x77,0x36,0x32,0x12,
        0x80,0xc8,0x8a,0x4a,0xb6,0x39,0xe3,0x9a,0xf3,0xcb,0xd4,0xfd,0xe1,0xf4,0xcd,0x45,
        0x08,0xc3,0x63,0x35,0x63,0x03,0x93,0xda,0xb3,0xae,0x10,0x34,0x99,0xc5,0x42,0xd0,
        0x16,0xfb,0xa3,0x35,0xa0,0x60,0xf2,0xad,0xad,0x9b,0x67,0xcd,0xbf,0x9a,0xdf,0x80,
        0x1f,0x2c,0x3e,0x31,0x9a,0xb0,0x92,0x76,0xcf,0x34,0xe2,0x0e,0xef,0x6a,0x7a,0xb7,
        0x6a,0x58,0xb0,0xf7,0x31,0x2f,0x62,0xe3,0xf9,0xd7,0x4c,0x29,0x68,0xa9,0x28,0xa2,
        0x91,0x86,0x54,0x83,0x5e,0x71,0xac,0xc1,0xe4,0x5d,0x48,0x98,0xfb,0xac,0x46,0x6b,
        0x35,0x0e,0xd6,0xfa,0x55,0x98,0x81,0x94,0x63,0xa5,0x50,0xbf,0x63,0x0c,0x81,0x23,
        0x5c,0x9c,0x75,0x27,0x8a,0x2d,0x3c,0xd7,0x61,0xf3,0x28,0x1e,0xc3,0x35,0xad,0x14,
        0x72,0x91,0x83,0x20,0x23,0xd0,0x8a,0xbb,0x6f,0x14,0xac,0xbc,0x4d,0x8f,0x6c,0x54,
        0xa6,0xd6,0x70,0xa4,0xf9,0xab,0x9e,0xdc,0x53,0x2d,0xee,0x25,0x2d,0xe5,0xcc,0x9b,
        0x58,0x1c,0x67,0xb5,0x5c,0x1c,0x55,0xad,0x2d,0x0c,0xba,0x82,0x7a,0x20,0xdc,0x6b,
        0xa1,0xc5,0x18,0xa5,0xc5,0x3e,0x8a,0x28,0xae,0x17,0xc4,0x80,0x7f,0x6a,0x4e,0x98,
        0xf4,0x23,0xf2,0xae,0x6e,0x53,0xb5,0xbd,0xe9,0xf0,0xdc,0x79,0x6a,0x79,0xa8,0x1e,
        0x60,0xec,0x4b,0x0a,0xb5,0x14,0x71,0x85,0xdd,0xd2,0x9f,0x1c,0x25,0xe4,0x3e,0x59,
        0x20,0x7a,0xe6,0xb4,0xec,0x2d,0xda,0x2e,0xa4,0x90,0x4d,0x69,0x6f,0x00,0x73,0x50,
        0x4a,0xeb,0xb8,0x71,0x4f,0x57,0x3b,0x79,0xad,0xfd,0x12,0xdc,0xc7,0x6f,0xe6,0xb8,
        0xc3,0x4b,0xc8,0xfa,0x76,0xad,0x2a,0x29,0x4d,0x3a,0x8a,0x28,0xae,0x13,0xc5,0x87,
        0x6e,0xad,0x2f,0xd0,0x7f,0x21,0x5c,0xe4,0xc3,0x77,0x3d,0xea,0xb4,0x84,0x80,0x00,
        0xe2,0xa3,0x1c,0x74,0xab,0x91,0xc8,0x4a,0x81,0xd8,0xd6,0x9d,0x9a,0xf1,0x5a,0xd1,
        0xa9,0x28,0x0f,0xa5,0x2b,0x70,0x2a,0xbc,0xd2,0x63,0xfc,0x6a,0xe6,0x93,0x00,0xbd,
        0xbc,0x58,0xcf,0xdc,0x03,0x73,0x7b,0x8f,0x4a,0xeb,0x40,0x00,0x01,0x4b,0x4b,0x8a,
        0x52,0x29,0x68,0xa2,0xa8,0xdf,0xeb,0x16,0x36,0x1c,0x4f,0x3a,0x87,0xec,0x8b,0xcb,
        0x7e,0x55,0xc3,0xeb,0xf7,0xa9,0x7d,0x7c,0xf3,0xc6,0x0a,0xab,0x63,0x01,0xba,0xf1,
        0x58,0x8e,0xc7,0xad,0x46,0xdf,0x31,0xeb,0x8a,0x61,0x4e,0xc3,0xb5,0x3e,0x16,0x28,
        0x70,0xdd,0xab,0x5e,0xde,0x55,0x2a,0x0a,0xd5,0xd8,0xef,0x55,0x17,0x19,0xc7,0xd6,
        0xa3,0x6b,0xe5,0x3c,0x2b,0x64,0xf6,0x02,0x9d,0x14,0x0f,0x33,0x6e,0x90,0x91,0xed,
        0x5d,0x17,0x87,0xa2,0x0b,0x3c,0x8c,0x06,0x36,0xa8,0x1f,0x9f,0xff,0x00,0xaa,0xb7,
        0xf1,0x46,0x3f,0x9d,0x2d,0x2d,0x14,0xc9,0x65,0x8e,0x18,0xcb,0xca,0xe1,0x54,0x75,
        0x24,0xd7,0x27,0xe2,0x5f,0x14,0x14,0x8c,0xc1,0x60,0xc4,0x6e,0x1c,0xc9,0xd0,0xfe,
        0x15,0xc8,0x09,0x18,0xb6,0xf7,0x25,0x9d,0xba,0x92,0x6a,0x47,0x62,0xc3,0xf0,0xaa,
        0xce,0x0d,0x46,0x43,0x02,0x09,0xa5,0x0d,0x83,0xeb,0x4b,0x8d,0xdd,0x6a,0x68,0x97,
        0x8e,0x37,0x7b,0x55,0x88,0xe0,0x2e,0xc3,0x20,0xe3,0xeb,0x5a,0x56,0xd6,0xea,0x84,
        0x10,0x2a,0xfc,0x49,0xc5,0x58,0xb5,0xd5,0x93,0x4e,0xbd,0x10,0x90,0x09,0x98,0x64,
        0x03,0xed,0x5d,0x05,0xb6,0xa7,0x04,0xf8,0xc9,0xd8,0x7d,0x1a,0xad,0x87,0x56,0xfb,
        0xa4,0x1f,0xa5,0x28,0x34,0xb5,0x85,0x7d,0xe2,0x35,0x50,0x56,0xcd,0x37,0x7f,0xb6,
        0xdd,0x3f,0x01,0x5c,0xe6,0xa1,0x7b,0x3d,0xd7,0x32,0x3b,0x31,0x1e,0xa6,0xb1,0xef,
        0x54,0xc8,0xa1,0xfa,0xe3,0xad,0x54,0x1d,0x45,0x4a,0x32,0x47,0xad,0x28,0x8c,0xb0,
        0xe4,0x54,0x9f,0x66,0x27,0xb5,0x35,0xad,0x18,0x1e,0x99,0xa7,0x25,0xb1,0xc8,0xc8,
        0xab,0x91,0x41,0xc7,0xdd,0xab,0x31,0xc4,0x46,0x30,0x2a,0xe4,0x30,0xb1,0x23,0x3d,
        0x2a,0xd8,0x8f,0x0b,0x59,0x1a,0xcc,0x67,0x02,0x74,0x1f,0x3c,0x3c,0xfd,0x47,0x7a,
        0xd5,0xb7,0x93,0x7c,0x28,0xeb,0xfc,0x40,0x11,0x53,0xa4,0xa5,0x94,0x8c,0x91,0xcf,
        0x23,0x35,0xa1,0x6f,0xaa,0xb2,0x00,0x25,0x5d,0xc0,0x77,0xcf,0x35,0x75,0x75,0x1b,
        0x72,0xb9,0xdc,0x47,0xb1,0x15,0xca,0x3a,0x0e,0x40,0xe4,0x8f,0x4a,0xab,0x02,0x79,
        0x83,0x9e,0xf5,0x11,0xb6,0x01,0xd9,0x18,0x7c,0xad,0x54,0xa7,0xb0,0xdb,0xd0,0x73,
        0x55,0x52,0x22,0x1b,0x04,0x74,0xab,0x70,0xa5,0x5b,0x11,0xf1,0xd2,0x9f,0xe4,0x64,
        0x76,0xa7,0xac,0x38,0xea,0x2a,0xc4,0x51,0xae,0x2a,0xca,0x44,0xbe,0x95,0x3a,0xa7,
        0x1d,0x30,0x28,0x71,0xc1,0xaa,0x57,0x11,0x79,0x8a,0xea,0x47,0xde,0x52,0x29,0x34,
        0xd3,0xbb,0x4d,0x84,0xfa,0x0c,0x7f,0x4a,0xb0,0x4e,0xd9,0x33,0xd9,0xa9,0x09,0x23,
        0xe9,0x4f,0x59,0x06,0x28,0x8e,0xce,0xeb,0x39,0x36,0xd2,0x8c,0xff,0x00,0xb0,0x6a,
        0xbd,0xbd,0x85,0xdc,0x73,0x3a,0xfd,0x96,0x6d,0xb9,0xe0,0xf9,0x67,0x15,0x3c,0xba,
        0x7d,0xcb,0x0c,0x8b,0x69,0x73,0xfe,0xe1,0xa8,0xdf,0x4d,0xb9,0x74,0xff,0x00,0x8f,
        0x69,0x41,0xff,0x00,0xae,0x66,0xa8,0x49,0xa3,0xde,0x6f,0xc8,0xb4,0x9c,0xff,0x00,
        0xdb,0x33,0xfe,0x14,0xab,0xa5,0xde,0x81,0xff,0x00,0x1e,0x93,0xff,0x00,0xdf,0xb3,
        0xfe,0x15,0x3c,0x7a,0x7d,0xe6,0x39,0xb4,0x9c,0x7f,0xdb,0x33,0xfe,0x15,0x38,0xb0,
        0xba,0xc7,0xfc,0x7a,0xcd,0x9f,0xfa,0xe6,0x69,0xe2,0xc6,0xe7,0xbd,0xb4,0xdf,0xf7,
        0xc1,0xa9,0xa3,0xb2,0x9c,0x75,0xb6,0x93,0xfe,0xf8,0x35,0x38,0xb5,0x98,0x63,0xf7,
        0x12,0x7f,0xdf,0x06,0x94,0xdb,0x5c,0x7f,0xcf,0x19,0x3f,0xef,0x93,0x4d,0x6b,0x6b,
        0x83,0xff,0x00,0x2c,0x24,0xff,0x00,0xbe,0x0d,0x31,0xec,0xa7,0x11,0xb1,0x10,0x48,
        0x4e,0x0f,0x1b,0x0d,0x51,0xd2,0xec,0x6f,0x23,0xd3,0x15,0x1e,0xd6,0x65,0x61,0x9e,
        0x0c,0x64,0x1e,0xbf,0x4a,0xb6,0xd6,0x77,0x25,0x07,0xee,0x25,0xcf,0xfb,0x86,0x81,
        0x69,0x72,0xcb,0xcd,0xbc,0xbf,0xf7,0xc1,0xa8,0x8d,0x95,0xd0,0x24,0x7d,0x9a,0x53,
        0xff,0x00,0x00,0x35,0xff,0xd9,
};

static unsigned char _photo3[] = {
		0xff,0xd8,0xff,0xe0,0x00,0x10,0x4a,0x46,0x49,0x46,0x00,0x01,0x02,0x01,0x01,0x2c,
		0x01,0x2c,0x00,0x00,0xff,0xdb,0x00,0x43,0x00,0x1c,0x13,0x15,0x18,0x15,0x11,0x1c,
		0x18,0x16,0x18,0x1f,0x1d,0x1c,0x21,0x29,0x45,0x2d,0x29,0x26,0x26,0x29,0x54,0x3c,
		0x40,0x32,0x45,0x64,0x58,0x69,0x67,0x62,0x58,0x60,0x5f,0x6e,0x7c,0x9e,0x86,0x6e,
		0x75,0x96,0x77,0x5f,0x60,0x8a,0xbb,0x8b,0x96,0xa3,0xa9,0xb1,0xb3,0xb1,0x6b,0x84,
		0xc2,0xd0,0xc1,0xac,0xce,0x9e,0xae,0xb1,0xaa,0xff,0xc0,0x00,0x0b,0x08,0x00,0xc8,
		0x00,0x8c,0x01,0x01,0x11,0x00,0xff,0xc4,0x00,0xd2,0x00,0x00,0x01,0x05,0x01,0x01,
		0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x03,0x04,
		0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x10,0x00,0x02,0x01,0x03,0x03,0x02,0x04,0x03,
		0x05,0x05,0x04,0x04,0x00,0x00,0x01,0x7d,0x01,0x02,0x03,0x00,0x04,0x11,0x05,0x12,
		0x21,0x31,0x41,0x06,0x13,0x51,0x61,0x07,0x22,0x71,0x14,0x32,0x81,0x91,0xa1,0x08,
		0x23,0x42,0xb1,0xc1,0x15,0x52,0xd1,0xf0,0x24,0x33,0x62,0x72,0x82,0x09,0x0a,0x16,
		0x17,0x18,0x19,0x1a,0x25,0x26,0x27,0x28,0x29,0x2a,0x34,0x35,0x36,0x37,0x38,0x39,
		0x3a,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
		0x5a,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x73,0x74,0x75,0x76,0x77,0x78,0x79,
		0x7a,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x92,0x93,0x94,0x95,0x96,0x97,0x98,
		0x99,0x9a,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xb2,0xb3,0xb4,0xb5,0xb6,
		0xb7,0xb8,0xb9,0xba,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xd2,0xd3,0xd4,
		0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,
		0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xff,0xda,0x00,0x08,0x01,0x01,
		0x00,0x00,0x3f,0x00,0xdf,0xc9,0xf5,0x34,0x64,0xfa,0x9a,0x32,0x7d,0x4d,0x19,0x3e,
		0xa6,0x8c,0x9f,0x53,0x46,0x4f,0xa9,0xa3,0x27,0xd4,0xd2,0x16,0xc0,0xc9,0x6c,0x7e,
		0x35,0x1f,0xda,0xa1,0x1d,0x67,0x4f,0xfb,0xec,0x53,0xd6,0x55,0x7f,0xb9,0x20,0x6f,
		0xa1,0xcd,0x3b,0x27,0xd4,0xd1,0x93,0xea,0x68,0xc9,0xf5,0x34,0x64,0xfa,0x9a,0x32,
		0x7d,0x4d,0x19,0x3e,0xa6,0x8c,0x9f,0x53,0x46,0x4f,0xa9,0xa4,0xa2,0x8a,0x28,0xaa,
		0x73,0x6a,0x31,0x46,0xfb,0x57,0xe6,0xc1,0xe4,0xe7,0x8a,0xab,0x73,0xa9,0x3b,0x8f,
		0xdc,0xfc,0xab,0x8c,0x93,0x9e,0x6b,0x2a,0x4b,0xd2,0xe7,0x25,0x99,0x88,0xee,0xd9,
		0x26,0xa3,0x17,0x32,0x72,0x36,0x82,0x3d,0x0a,0xff,0x00,0xf5,0xaa,0x58,0xe7,0x72,
		0x7e,0x50,0x8c,0x7b,0x00,0x7f,0xc9,0xab,0xd0,0xea,0x32,0x21,0xc1,0xde,0x87,0xb8,
		0x3f,0x30,0xfd,0x6b,0x52,0x0b,0xc8,0xe6,0xc0,0xe8,0x4f,0xa7,0x23,0xff,0x00,0xad,
		0xf8,0xd5,0x8a,0x28,0xa2,0x8a,0x28,0xa2,0x8a,0x46,0x65,0x45,0x2c,0xc4,0x05,0x51,
		0x92,0x4f,0x40,0x2b,0x9b,0xd4,0x35,0x69,0x2e,0x58,0xa4,0x04,0xac,0x59,0xe0,0x63,
		0xaf,0xb9,0xac,0xf5,0xf9,0x9c,0xf9,0xb2,0x1c,0x0e,0xde,0xb4,0x34,0xd6,0xd9,0xc7,
		0x97,0x9c,0x0e,0xb9,0x34,0x79,0xf0,0x63,0xfd,0x58,0xfc,0xa9,0x37,0xc2,0xdd,0x13,
		0x6f,0xb8,0x6c,0x7f,0x3a,0x9d,0x77,0x60,0x79,0x6e,0x19,0x4f,0x69,0x3f,0xc4,0x54,
		0xc9,0x37,0x96,0x42,0x48,0x0c,0x64,0xf4,0x0f,0x82,0xbf,0x81,0xab,0x03,0x83,0xc8,
		0x1c,0x76,0x35,0xa9,0xa7,0xcf,0xbd,0x7c,0xb2,0x78,0x51,0xf2,0x83,0xd4,0x7b,0x55,
		0xda,0x28,0xa2,0x8a,0x28,0xa2,0xb1,0xb5,0xcb,0x96,0x91,0x96,0xce,0x16,0xc7,0xf1,
		0x4a,0x47,0x61,0xd8,0x7f,0x5f,0xca,0xb2,0x7e,0x44,0x52,0xa9,0x8f,0x73,0x55,0x27,
		0xdb,0x9f,0x94,0xf3,0xf5,0xa8,0x83,0x7f,0x7b,0x9a,0x4c,0x7a,0x52,0xab,0x76,0x65,
		0xc8,0xa9,0x51,0x33,0xcc,0x2c,0x43,0x7a,0x67,0x07,0xf3,0xa9,0x96,0xea,0x44,0x1b,
		0x26,0x40,0xeb,0xdd,0x58,0x55,0x88,0x64,0x08,0x99,0xb7,0x6d,0xf1,0x8e,0xa8,0x7a,
		0xaf,0xd3,0xfc,0x2a,0xe4,0x32,0x2b,0x61,0xd4,0xed,0xc1,0xe1,0x87,0x05,0x4d,0x6c,
		0xda,0xdc,0x79,0xf1,0xfc,0xd8,0x12,0x0f,0xbc,0xa3,0xf9,0xd4,0xf4,0x51,0x45,0x14,
		0x53,0x26,0x90,0x43,0x0b,0xca,0xc3,0x21,0x14,0xb6,0x07,0x7c,0x76,0xae,0x62,0xea,
		0x46,0x3b,0x9d,0x8e,0x19,0xdb,0x73,0x9f,0xe8,0x2b,0x36,0x49,0x4b,0x70,0x0e,0x05,
		0x0a,0x85,0xce,0x31,0x9a,0x9d,0x2c,0x9d,0x97,0x27,0x8a,0x63,0x5b,0xb2,0x9f,0xeb,
		0x48,0x21,0xdc,0xa7,0xa0,0x61,0xda,0x98,0x51,0x94,0xf4,0x23,0x15,0x34,0x72,0xab,
		0x0d,0xb3,0x82,0x47,0xf7,0x87,0x51,0x4a,0x55,0xed,0xc8,0x92,0x32,0x1b,0xdc,0x74,
		0x61,0xe8,0x45,0x59,0x86,0x65,0x90,0x87,0x8f,0xe4,0x27,0x86,0x52,0x7a,0xff,0x00,
		0xf5,0xfd,0x3d,0x6b,0x4e,0xd6,0x53,0x1b,0x2c,0x89,0x93,0xb7,0x82,0xbe,0xde,0x95,
		0xb0,0x08,0x20,0x10,0x72,0x0f,0x20,0xd2,0xd1,0x45,0x14,0x55,0x0d,0x5e,0x60,0x96,
		0xeb,0x19,0x07,0x0e,0x77,0x13,0x8e,0x81,0x70,0x7f,0x9e,0x3f,0x5a,0xe5,0xae,0x65,
		0x2e,0xdc,0xfa,0xd3,0x60,0x84,0xca,0xe0,0x0a,0xdc,0xb4,0xb0,0x0a,0x01,0x22,0xb4,
		0x05,0xaa,0xec,0xe9,0xda,0xaa,0x5c,0xd8,0xe3,0x90,0x2b,0x32,0x68,0xb6,0x7b,0x1e,
		0xc7,0xd2,0xab,0x82,0xa3,0x83,0xf4,0xe3,0xb1,0xa8,0xa5,0x5e,0xeb,0x4d,0x8e,0x52,
		0xbc,0x75,0x0d,0xd4,0x52,0x9f,0x91,0xb7,0xaf,0xdd,0x61,0x86,0xad,0x7b,0x09,0xcb,
		0x27,0x27,0x2e,0xbc,0x30,0xfe,0x55,0xb9,0x68,0x73,0x16,0xdc,0xe4,0x0e,0x9f,0x4a,
		0x9e,0x8a,0x28,0xa2,0xb0,0xf5,0xf9,0x71,0x26,0xcd,0xd9,0x01,0x00,0x23,0xd0,0xf2,
		0x4f,0xfe,0xcb,0x5c,0xf0,0xcb,0x35,0x6d,0x69,0x76,0xe0,0x28,0x62,0x3a,0xfb,0x56,
		0xd2,0x2f,0x4e,0x95,0x30,0xe9,0x41,0x00,0x8e,0x6a,0x9d,0xdd,0x92,0xcc,0x84,0xa8,
		0xc3,0x7f,0x3a,0xe7,0x2f,0x2d,0xde,0x19,0x09,0xda,0x45,0x55,0x0e,0x7a,0x1e,0x94,
		0xd7,0x03,0x39,0x1d,0xe9,0xc8,0xdf,0xc3,0xd8,0x8f,0xce,0xac,0xd8,0xc9,0xe5,0x4e,
		0x37,0x74,0xe8,0x7e,0x95,0xd2,0xd8,0xb9,0x0d,0xb0,0x9e,0x6a,0xf5,0x14,0x51,0x45,
		0x72,0x7a,0xa4,0xbe,0x65,0xc5,0xce,0x58,0x13,0xe6,0x1f,0xc8,0x1c,0x0f,0xd0,0x0a,
		0xcf,0x8c,0x66,0x45,0x1e,0xa7,0x15,0xd2,0xd9,0xae,0xd8,0xc0,0x1c,0x55,0xf5,0xcf,
		0xa5,0x4a,0x29,0xd8,0xa3,0x15,0x4e,0xf6,0xc5,0x6e,0x54,0xe3,0x01,0xbd,0x7d,0x6b,
		0x9a,0xbd,0xb1,0x92,0xd9,0xce,0x54,0xe2,0xaa,0x88,0xcb,0x02,0x54,0xfe,0x14,0xcc,
		0x11,0xd7,0x8a,0x9e,0x32,0x37,0x29,0x3d,0x09,0xda,0x6b,0xa1,0xb3,0x90,0xe6,0x16,
		0x63,0xce,0x02,0xb1,0xf7,0xad,0x7a,0x28,0xa2,0x82,0xc1,0x41,0x66,0x38,0x50,0x32,
		0x7e,0x95,0xc2,0x33,0x92,0xe4,0xb1,0xc9,0x27,0x9f,0x7a,0x7d,0xa2,0xef,0xb9,0x41,
		0xfe,0xd6,0x6b,0xa7,0x84,0x04,0x51,0xb8,0x81,0xc7,0x7a,0x9c,0x4f,0x1a,0xf5,0x3c,
		0x7a,0xd4,0xab,0x2c,0x6d,0xf7,0x5d,0x4f,0xe3,0x52,0x02,0x28,0xcd,0x04,0x81,0xd6,
		0xa1,0x9e,0x38,0xe5,0x8c,0x89,0x30,0x47,0xbd,0x61,0xdd,0xe9,0x91,0x07,0x0d,0x6f,
		0x28,0x27,0xfb,0xbd,0x6a,0x85,0xcd,0xac,0x85,0x0b,0x18,0xc6,0x57,0xba,0x90,0x73,
		0xf8,0x55,0x64,0xf9,0xb3,0x9e,0xe3,0x15,0xb9,0x6e,0xe3,0x64,0x64,0x7f,0x7f,0xfa,
		0x56,0xf2,0x1d,0xc8,0xa7,0xd4,0x66,0x96,0x8a,0x2a,0xa6,0xaa,0xfb,0x34,0xd9,0x88,
		0xea,0x46,0xde,0xb8,0xea,0x70,0x7f,0x4c,0xd7,0x35,0x6d,0xb6,0x58,0x96,0x29,0x23,
		0x4d,0xac,0xa4,0x86,0x1f,0x7b,0x3e,0xb4,0xba,0x4c,0x3b,0xae,0x86,0x46,0x71,0xde,
		0xb6,0xe5,0x75,0x56,0xcd,0x40,0xfa,0x84,0x2a,0x30,0xcb,0xc1,0xef,0xc6,0x2a,0xb9,
		0xbc,0x80,0xb8,0xf2,0x98,0xe4,0xfa,0x73,0x57,0xac,0xef,0x43,0x10,0x37,0x86,0x07,
		0x8c,0xe6,0xb4,0x41,0xc8,0xcd,0x55,0xba,0xb8,0xf2,0xc1,0x19,0x22,0xb2,0xe5,0xba,
		0xe7,0xe6,0x66,0x23,0xbf,0xa0,0xa9,0x12,0xee,0xdd,0x40,0xda,0xd1,0xb1,0xf4,0xde,
		0x09,0xa7,0x49,0x24,0x53,0x29,0xf9,0x70,0x7d,0xeb,0x04,0xaf,0x97,0x3b,0x27,0xa1,
		0xad,0x2b,0x39,0x0f,0x93,0xc9,0xfb,0xae,0x31,0xfe,0x7f,0x1a,0xe9,0x2d,0x8e,0x6d,
		0xd0,0xfe,0x15,0x25,0x14,0x56,0x57,0x88,0xa4,0xd9,0x62,0xab,0xdd,0x9b,0x3f,0x80,
		0x18,0xfe,0xa2,0xb2,0x2c,0x88,0x7b,0x55,0x66,0x1f,0xea,0x8b,0x28,0xfe,0x7f,0xd6,
		0xae,0xe9,0x4a,0x3c,0xc7,0x60,0x31,0x56,0xee,0x2d,0xcc,0x8b,0x90,0x71,0x59,0x46,
		0xc0,0x2b,0xc8,0x25,0x52,0xe1,0xc6,0x03,0x77,0x43,0xf4,0xf4,0xa5,0xb2,0xb4,0x95,
		0xa4,0x41,0x74,0x77,0xc5,0x16,0x4a,0x20,0xf5,0x20,0x0f,0xcb,0x81,0x57,0x52,0xcb,
		0x6b,0x96,0x04,0xf2,0x78,0xc9,0xe7,0xf1,0xad,0x78,0x87,0xee,0x86,0x7a,0xe2,0xa8,
		0xdd,0x41,0xe6,0xcb,0x82,0x71,0x59,0xf2,0xe9,0xa8,0xc8,0xe8,0xea,0xdb,0xf1,0xf2,
		0x3a,0x9e,0x14,0xfd,0x2a,0xbc,0x16,0x52,0x64,0x9b,0xa4,0x32,0x32,0xae,0xc4,0x50,
		0x46,0x31,0xef,0x56,0xac,0x6c,0x1e,0x25,0xc3,0x1e,0x3d,0x3d,0x3e,0x95,0x9f,0xaa,
		0x43,0xe4,0x5e,0x86,0x1f,0x75,0xd7,0xfc,0xff,0x00,0x4a,0x4b,0x47,0xca,0x14,0xf7,
		0x26,0xba,0x6d,0x35,0xf7,0x5b,0x0e,0xb5,0x6e,0x8a,0x2b,0x03,0xc4,0x8d,0xf3,0x80,
		0x1b,0x8d,0xa0,0x63,0xd0,0xe4,0x9f,0xf0,0xaa,0x1a,0x4b,0x06,0x12,0xc0,0xcd,0x8c,
		0xe0,0x8c,0x7e,0xbf,0xd2,0xb5,0x6c,0xd0,0xc7,0x3b,0x29,0xe9,0x8e,0x0f,0xad,0x68,
		0x22,0xe7,0xad,0x23,0xc0,0x0f,0x6a,0x44,0xb7,0x51,0xfc,0x38,0xa7,0xf9,0x63,0x77,
		0xa6,0x2a,0x55,0xe0,0x53,0x08,0xc9,0xc1,0xa4,0x68,0x43,0x0f,0x7f,0x5a,0x6f,0xd9,
		0xc6,0x73,0x4e,0x29,0xb5,0x6b,0x0f,0x5f,0x50,0x22,0x88,0xf1,0x9d,0xdf,0xd2,0xb2,
		0xed,0x9b,0x13,0x2e,0x7b,0x9c,0x57,0x4b,0xa3,0xb6,0x63,0x2b,0xd8,0x7e,0x95,0xa5,
		0x45,0x15,0xcd,0x78,0x83,0x22,0x79,0x33,0xd0,0xba,0xe3,0xfe,0xf9,0x15,0x99,0x04,
		0xa2,0x0b,0x84,0x98,0x03,0x81,0x8c,0x8f,0x62,0x39,0xad,0xc8,0xe5,0x5f,0xb4,0x23,
		0x2b,0x82,0x8c,0x7e,0x52,0x0d,0x69,0x23,0x7c,0xc4,0x54,0xe2,0x8e,0x2a,0x17,0x62,
		0xcc,0x42,0xf4,0x15,0x3a,0xf2,0x2a,0x27,0x38,0x3f,0x2f,0x24,0x53,0xe3,0x70,0xeb,
		0x91,0xf9,0x53,0xce,0x2a,0x29,0x5b,0x0b,0x5c,0xce,0xb7,0x36,0xfb,0x94,0x41,0xd1,
		0x41,0x3f,0xe7,0xf2,0xac,0xf8,0xdb,0x0c,0xa7,0xd0,0xd6,0xfe,0x87,0x3f,0xef,0xca,
		0x9f,0xe2,0x18,0xad,0xda,0x28,0xae,0x6b,0xc4,0x21,0x85,0xc4,0x99,0x3c,0x16,0x52,
		0x07,0xb6,0xd0,0x3f,0xa1,0xac,0x86,0xc1,0x40,0x79,0xe9,0x49,0x0b,0x88,0xe7,0x47,
		0x27,0x85,0x60,0xc7,0xf3,0xae,0xb1,0x5c,0x70,0xd5,0x65,0x1f,0x8a,0x79,0xf9,0x85,
		0x52,0xba,0x8a,0xe5,0x43,0x79,0x2d,0x8c,0xf7,0xe0,0xff,0x00,0x3a,0x8a,0x3b,0xa9,
		0x91,0x42,0x30,0xcb,0x1e,0x0e,0x05,0x3a,0x34,0xbb,0x33,0xee,0xdf,0xf2,0x9e,0xab,
		0xc6,0x3f,0xc6,0xae,0xa2,0x95,0x39,0x14,0xad,0x20,0x15,0x5a,0xe6,0x5f,0x93,0xad,
		0x72,0xd7,0xcf,0xbe,0xee,0x43,0x9c,0xe0,0xe2,0xa2,0x5c,0x71,0xf5,0xe6,0xaf,0xe9,
		0xd2,0x94,0x99,0x48,0x38,0x65,0x39,0x15,0xd7,0xfd,0x3a,0x51,0x45,0x61,0x78,0x96,
		0x03,0xfb,0xb9,0xf9,0x2a,0x46,0xc3,0xec,0x46,0x48,0xfe,0x67,0xf2,0xac,0x40,0x84,
		0xdb,0x67,0xd0,0xd4,0x1d,0xfe,0xb5,0xbf,0xa7,0xdc,0x19,0xad,0x14,0xb1,0xc9,0x1c,
		0x1f,0xad,0x68,0x44,0x4f,0x63,0x53,0x89,0x31,0x4b,0x24,0xd1,0xa2,0xe5,0xdc,0x28,
		0xf7,0x35,0x02,0xdc,0xda,0xb9,0xe2,0x64,0xe3,0xf0,0x34,0xe5,0xbc,0xb5,0xdd,0x81,
		0x32,0xe7,0xdf,0x8a,0x90,0xb8,0x61,0x90,0x47,0xb1,0x1c,0xd4,0x72,0x9f,0x6a,0xce,
		0xbb,0x90,0x24,0x6c,0xc4,0xf0,0xa3,0x35,0xce,0x9c,0x93,0x93,0xde,0x95,0x4e,0x08,
		0xab,0x16,0xe7,0x0e,0xac,0xa7,0x90,0x6b,0xb2,0xb5,0x7f,0x32,0xda,0x36,0xff,0x00,
		0x64,0x0a,0x96,0x8a,0xa3,0xac,0xc5,0xe6,0xe9,0xb2,0x71,0x92,0xa4,0x30,0xfc,0xff,
		0x00,0xc0,0x9a,0xe7,0xfc,0xb0,0x96,0x59,0x3d,0x73,0x59,0xec,0x30,0xc7,0xd8,0xd5,
		0xcd,0x2e,0x63,0x1c,0xcd,0x19,0x3f,0x2b,0x0c,0xfe,0x35,0xb9,0x0c,0x82,0x9f,0x26,
		0x5f,0xa3,0x11,0x54,0xe6,0xb1,0x0c,0xfb,0xdd,0xde,0x5f,0x66,0x34,0x82,0xd6,0xd0,
		0xf5,0x49,0x01,0xf6,0x63,0x4e,0x36,0x56,0xee,0x30,0x91,0x91,0xee,0xc4,0xe6,0xac,
		0x41,0x6c,0x96,0xe0,0x08,0xcb,0x63,0xd3,0x71,0x34,0xf9,0xa4,0x01,0x71,0x58,0x9a,
		0xa4,0xe0,0x81,0x12,0x9e,0x4f,0x2d,0xcd,0x67,0x01,0x4b,0x8c,0xb0,0xa9,0xa1,0x8d,
		0x98,0xe5,0x06,0x70,0x09,0x3f,0x4a,0xec,0x2c,0x10,0x25,0xa2,0x61,0x98,0x86,0x19,
		0xc1,0xe8,0x0f,0x7c,0x55,0x8a,0x29,0x0a,0x86,0x52,0xac,0x32,0x08,0xc1,0x1e,0xa2,
		0xb9,0x8d,0x48,0xa8,0x41,0x1a,0x0e,0x17,0x82,0x7d,0xeb,0x2d,0x86,0x5b,0xeb,0x8a,
		0x20,0x6d,0x92,0xa9,0x15,0xb3,0x1c,0x98,0xe0,0xfe,0x75,0x7a,0x12,0x1d,0x78,0x3c,
		0xd4,0xeb,0x06,0xe1,0x8c,0x8a,0x43,0x69,0x4e,0xfb,0x38,0x41,0x51,0xc8,0xc2,0x31,
		0xcf,0x4a,0xce,0xba,0xb8,0xda,0xa7,0x1c,0x91,0x58,0x45,0x8b,0xbe,0xe6,0xe4,0x93,
		0x4e,0xcf,0x24,0xf6,0xa1,0x3a,0x56,0xae,0x8f,0x0b,0xc8,0xec,0x14,0x91,0xbd,0x76,
		0x9c,0x77,0x04,0xf3,0xfc,0xab,0xa7,0x55,0x0a,0xa1,0x47,0x40,0x31,0x4b,0x45,0x55,
		0xbd,0xb9,0xf2,0xe3,0x28,0x8d,0x87,0xc7,0x27,0xd0,0x57,0x39,0x70,0xdb,0x99,0xff,
		0x00,0x31,0x54,0xdb,0xa2,0x9c,0x7b,0x54,0x47,0x82,0x78,0xad,0x68,0xce,0xe8,0x55,
		0x87,0x71,0x4e,0x8e,0xe1,0xa1,0x39,0x3d,0x2b,0x46,0x1b,0xf8,0xd8,0x73,0x80,0x6a,
		0x71,0x76,0x84,0x75,0x1f,0x9d,0x47,0x25,0xec,0x60,0x7d,0xe1,0xf9,0xd6,0x74,0xd7,
		0x2f,0x70,0xd8,0x40,0x70,0x7b,0xd4,0x53,0xc7,0xb2,0xdd,0x8e,0x0e,0x48,0xac,0x71,
		0x4a,0x4f,0x18,0xa7,0xa9,0xc2,0xf4,0xae,0x83,0xc3,0xd2,0xc6,0xa8,0xc1,0x8e,0x19,
		0xb0,0x01,0xf6,0xff,0x00,0xf5,0xd6,0xe5,0x15,0x4a,0x5b,0x8d,0x89,0x9b,0x83,0xb5,
		0xba,0x84,0x15,0x97,0x35,0xc1,0x6d,0xc4,0x93,0x8e,0xb8,0x3f,0xce,0xb3,0x2e,0x1b,
		0x18,0x3d,0x7a,0xe6,0xa2,0x5f,0x98,0x91,0x9e,0xf9,0xa8,0xd8,0x10,0x2b,0x42,0xc5,
		0xb7,0x43,0xb4,0xf6,0x35,0x2b,0xaf,0x04,0x54,0x0f,0x1f,0xa7,0x5a,0x66,0xd9,0xfa,
		0x29,0xfd,0x6a,0x68,0xad,0x89,0x20,0xbf,0x35,0x76,0x28,0x80,0xc6,0x05,0x45,0x78,
		0x7f,0x74,0xc0,0x7a,0x56,0x29,0x5c,0x73,0x48,0x54,0x83,0x46,0xe2,0x48,0x1e,0xf5,
		0x3c,0x57,0x32,0xc5,0xb5,0x91,0xc8,0x60,0x30,0x3b,0xf1,0xe9,0x5a,0x56,0xda,0xdc,
		0xf1,0x80,0xb2,0x63,0x6f,0xa8,0x15,0xb2,0x97,0x37,0x45,0x41,0x30,0x02,0x0f,0x20,
		0x8e,0x84,0x57,0x3e,0xad,0x31,0x3f,0x3c,0x81,0x7f,0x53,0x51,0x4d,0x2e,0x1f,0xcb,
		0x53,0xc7,0x73,0xea,0x6a,0xac,0xaf,0xbd,0xcf,0xa0,0xa6,0x2b,0xe1,0xf3,0xda,0xa4,
		0x73,0xb9,0x73,0xde,0xac,0x58,0x3e,0x19,0x97,0xd7,0x15,0xa1,0xd4,0x50,0x17,0x3d,
		0x45,0x48,0xb1,0x8e,0xf4,0xed,0xa0,0x70,0x3a,0xd3,0x88,0xc0,0xcd,0x57,0x9f,0x95,
		0xc5,0x65,0xc8,0x98,0x72,0xb8,0xc7,0x26,0xa4,0xb5,0x84,0x4d,0x87,0x73,0x80,0x2a,
		0x9b,0x10,0x64,0x24,0x70,0xb9,0xe3,0xe9,0x46,0x79,0xa3,0x71,0xe2,0xa6,0x4b,0x99,
		0x95,0x40,0x59,0x5c,0x01,0xd8,0x31,0xa5,0x33,0x9c,0x1d,0xbd,0x4f,0x15,0x13,0x1d,
		0xa0,0x8c,0xfc,0xc7,0xaf,0xb5,0x47,0x40,0x1c,0xd3,0xc1,0x3b,0x6a,0x6b,0x73,0xb6,
		0x40,0x7d,0xeb,0x52,0x36,0xe3,0x1e,0xd5,0x20,0xf5,0xa5,0xc9,0xa7,0x03,0x4a,0x49,
		0x35,0x11,0x5c,0xf6,0xaa,0x97,0x10,0xe0,0x87,0xc7,0x43,0x93,0x55,0x25,0x76,0x84,
		0x3c,0x4a,0x4e,0x09,0xcd,0x56,0xef,0x41,0xe2,0x90,0x52,0xe7,0x14,0xed,0xea,0x83,
		0xe5,0x19,0x3e,0xa6,0x98,0x49,0x34,0x0a,0x72,0x7d,0xef,0xa5,0x03,0xbd,0x5a,0xb7,
		0x4c,0xb6,0x71,0xe9,0x5a,0x08,0x3d,0xbb,0x54,0xa0,0x0c,0xf1,0x4b,0x4f,0x00,0xd3,
		0xd6,0x33,0xdc,0x53,0xd2,0x1c,0x9a,0x65,0xd4,0x4b,0x1c,0x6c,0xcf,0xc0,0x03,0x9a,
		0xe7,0x70,0x25,0xde,0xc4,0x90,0xdc,0x6d,0x18,0xce,0x7b,0x53,0x18,0x15,0x7d,0xa7,
		0xa8,0x38,0x34,0xc3,0x9c,0xd2,0xd1,0x49,0x45,0x14,0xbf,0x4f,0xc6,0x9c,0x80,0xb1,
		0x00,0x75,0x35,0xb3,0x69,0x6d,0xfb,0xbc,0x8e,0xe7,0xf4,0xab,0x9f,0x67,0x38,0xfa,
		0x0a,0x55,0x87,0x27,0x9a,0x77,0x91,0xcd,0x38,0x42,0x41,0xe9,0x53,0xa4,0x27,0xd2,
		0xa5,0x54,0x0a,0x39,0x15,0x8b,0xe2,0x0b,0x9d,0xa1,0x60,0x46,0xe5,0x8e,0x5b,0x07,
		0xb5,0x61,0x06,0x65,0x39,0x04,0x83,0xea,0x0d,0x27,0x42,0x3e,0xb4,0x1e,0xb4,0x51,
		0x9a,0x4a,0x01,0xc1,0xcd,0x2e,0x68,0x03,0xbd,0x28,0x24,0x74,0x35,0xd3,0xe9,0x92,
		0x25,0xc5,0xb2,0xc8,0xa3,0x04,0x7c,0xac,0x3d,0x0d,0x5f,0x08,0x29,0x42,0x73,0x9e,
		0xb4,0xbe,0x58,0xa5,0x08,0x01,0xa7,0xd4,0x53,0xca,0xb1,0x44,0xce,0xc4,0x00,0x06,
		0x49,0x35,0xc7,0x5d,0xdc,0x1b,0x8b,0x87,0x94,0xe7,0xe6,0x3c,0x67,0xb0,0xed,0x50,
		0x0a,0x3b,0x8a,0x28,0xa5,0x15,0x3f,0xf6,0x75,0xf7,0xfc,0xf9,0xdc,0x7f,0xdf,0xa6,
		0xff,0x00,0x0a,0x4f,0xec,0xeb,0xef,0xf9,0xf3,0xb8,0xff,0x00,0xbf,0x4d,0xfe,0x14,
		0xa3,0x4f,0xbd,0xff,0x00,0x9f,0x3b,0x8f,0xfb,0xf4,0xdf,0xe1,0x4b,0xfd,0x9f,0x7d,
		0xff,0x00,0x3e,0x77,0x1f,0xf7,0xe9,0xbf,0xc2,0x81,0xa7,0xdf,0x7f,0xcf,0x9d,0xc7,
		0xfd,0xfa,0x6f,0xf0,0xad,0x2d,0x16,0x2b,0xcb,0x6b,0x83,0x1c,0x96,0xb3,0x88,0xe4,
		0xee,0x63,0x38,0x04,0x56,0xf8,0x46,0xc7,0xdc,0x6f,0xca,0x9c,0x11,0xbf,0xba,0xdf,
		0x95,0x3b,0x6b,0x63,0xee,0x9f,0xca,0x82,0xad,0xfd,0xd3,0xf9,0x53,0x08,0x7e,0x7e,
		0x46,0xfc,0xab,0x27,0x5a,0x17,0x4f,0x00,0x8a,0x08,0x26,0x6d,0xe7,0xe6,0x2a,0x84,
		0xe0,0x56,0x4a,0x68,0xf7,0xb2,0x23,0xb7,0x90,0xea,0x55,0x37,0xe1,0x90,0x8c,0xfb,
		0x0f,0x7f,0x6a,0x87,0xfb,0x3a,0xf7,0xfe,0x7c,0xee,0x3f,0xef,0xdb,0x7f,0x85,0x27,
		0xf6,0x75,0xee,0x7f,0xe3,0xce,0xe3,0xfe,0xfd,0x37,0xf8,0x51,0xfd,0x9d,0x7d,0xff,
		0x00,0x3e,0x77,0x1f,0xf7,0xe9,0xbf,0xc2,0x8f,0xec,0xfb,0xef,0xf9,0xf3,0xb8,0xff,
		0x00,0xbf,0x4d,0xfe,0x14,0xbf,0xd9,0xf7,0xbf,0xf3,0xe7,0x71,0xff,0x00,0x7e,0x9b,
		0xfc,0x2b,0xff,0xd9,
};

static unsigned char _pref0[] = {
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,
 };

static unsigned char _prefChange[] = {
        0x5b,0x54,0x65,0x73,0x74,0x5d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,
 };

TEST(GetName)
{
	BEID_ReaderContext &reader0=ReaderSet.getReaderByNum(0);	
	BEID_EIDCard &card0=reader0.getEIDCard();	
	BEID_EId *doc0=&card0.getID();
	card0.setAllowTestCard(false);
	CHECK_EQUAL("",doc0->getSurname());
	card0.setAllowTestCard(true);
	CHECK_EQUAL("name0",doc0->getSurname());

	BEID_ReaderContext &reader2=ReaderSet.getReaderByNum(2);	
	BEID_EIDCard &card2=reader2.getEIDCard();				
	BEID_EId &doc2=card2.getID();
	CHECK_EQUAL("Hoeben",doc2.getSurname());

	BEID_ReaderContext &reader3=ReaderSet.getReaderByNum(3);	
	BEID_EIDCard &card3=reader3.getEIDCard();				
	BEID_EId *doc3=&card3.getID();
	card3.setAllowTestCard(false);
	CHECK_EQUAL("",doc3->getSurname());
	card3.setAllowTestCard(true);
	CHECK_EQUAL("name1",doc3->getSurname());
}

TEST(GetAddress)
{
	BEID_ReaderContext &reader0=ReaderSet.getReaderByNum(0);	
	BEID_EIDCard &card0=reader0.getEIDCard();	
	BEID_EId &doc0=card0.getID();
	card0.setAllowTestCard(true);
	CHECK_EQUAL("Ruisbroek",doc0.getMunicipality());

	BEID_ReaderContext &reader2=ReaderSet.getReaderByNum(2);	
	BEID_EIDCard &card2=reader2.getEIDCard();				
	BEID_EId &doc2=card2.getID();
	CHECK_EQUAL("Holsbeek",doc2.getMunicipality());

	BEID_ReaderContext &reader3=ReaderSet.getReaderByNum(3);	
	BEID_EIDCard &card3=reader3.getEIDCard();				
	BEID_EId &doc3=card3.getID();
	card3.setAllowTestCard(true);
	CHECK_EQUAL("Ruisbroek",doc3.getMunicipality());
}

TEST(GetPhoto)
{
	BEID_ReaderContext &reader0=ReaderSet.getReaderByNum(0);	
	BEID_EIDCard &card0=reader0.getEIDCard();	
	BEID_Picture &photo0=card0.getPicture();
	card0.setAllowTestCard(true);
	CHECK_EQUAL(sizeof(_photo0),photo0.getData().Size());
	if(photo0.getData().Size()==sizeof(_photo0))
		CHECK(memcmp(_photo0,photo0.getData().GetBytes(),sizeof(_photo0))==0);

	BEID_ReaderContext &reader2=ReaderSet.getReaderByNum(2);	
	BEID_EIDCard &card2=reader2.getEIDCard();				
	BEID_Picture &photo2=card2.getPicture();
	CHECK_EQUAL(sizeof(_photo2),photo2.getData().Size());
	if(photo2.getData().Size()==sizeof(_photo2))
		CHECK(memcmp(_photo2,photo2.getData().GetBytes(),sizeof(_photo2))==0);

	BEID_ReaderContext &reader3=ReaderSet.getReaderByNum(3);	
	BEID_EIDCard &card3=reader3.getEIDCard();				
	BEID_Picture &photo3=card3.getPicture();
	card3.setAllowTestCard(true);
	CHECK_EQUAL(sizeof(_photo3),photo3.getData().Size());
	if(photo3.getData().Size()==sizeof(_photo3))
		CHECK(memcmp(_photo3,photo3.getData().GetBytes(),sizeof(_photo3))==0);
}

TEST(GetDocument)
{
	BEID_ReaderContext &reader0=ReaderSet.getReaderByNum(0);	
	BEID_EIDCard &card0=reader0.getEIDCard();	
	card0.setAllowTestCard(true);
	BEID_XMLDoc &doc0a=card0.getDocument(BEID_DOCTYPE_ID);
	CHECK(&doc0a);
	BEID_XMLDoc &doc0b=card0.getDocument(BEID_DOCTYPE_PICTURE);
	CHECK(&doc0b);


	BEID_ReaderContext &reader4=ReaderSet.getReaderByNum(4);	
	BEID_SISCard &card4=reader4.getSISCard();				
	BEID_XMLDoc &doc4a=card4.getDocument(BEID_DOCTYPE_ID);
	CHECK(&doc4a);

	try
	{
		BEID_XMLDoc &doc4b=card4.getDocument(BEID_DOCTYPE_PICTURE); //Must go to the catch
		CHECK(0);					//No picture on Sis card
	}
	catch(BEID_ExDocTypeUnknown e)
	{
		CHECK(1);					//No picture on Sis card
	}
	catch(...)
	{
		CHECK(0);					//Unknown Exception
		throw;
	}
}

TEST(ReadWriteFile)
{
	BEID_ReaderContext &reader0=ReaderSet.getReaderByNum(0);	
	BEID_EIDCard &card0=reader0.getEIDCard();	
	card0.setAllowTestCard(true);
	//First get the photo
	BEID_ByteArray photoBefore;
	card0.readFile("3F00DF014035",photoBefore);

	CHECK_EQUAL(sizeof(_photo0),photoBefore.Size());
	if(photoBefore.Size()==sizeof(_photo0))
		CHECK(memcmp(_photo0,photoBefore.GetBytes(),sizeof(_photo0))==0);

	//Replace the photo
	BEID_ByteArray photoChange(_photo2,sizeof(_photo2));
	try
	{
		card0.writeFile("3F00DF014035",photoChange);
		CHECK(0);					//Write not allowed
	}
	catch(BEID_ExCmdNotAllowed e)
	{
		CHECK(1);					//Write not allowed
	}
	catch(...)
	{
		CHECK(0);					//Unknown Exception
	}

	//First get the pref
	BEID_ByteArray prefBefore;
	card0.readFile("3F00DF014039",prefBefore);

	CHECK_EQUAL(sizeof(_pref0),prefBefore.Size());
	if(prefBefore.Size()==sizeof(_pref0))
		CHECK(memcmp(_pref0,prefBefore.GetBytes(),sizeof(_pref0))==0);

	//Replace the pref
	BEID_ByteArray prefChange(_prefChange,sizeof(_prefChange));
	card0.writeFile("3F00DF014039",prefChange);

	//Get the pref again
	BEID_ByteArray prefAfter;
	card0.readFile("3F00DF014039",prefAfter);

	CHECK_EQUAL(prefChange.Size(),prefAfter.Size());
	if(prefAfter.Size()==prefChange.Size())
		CHECK(memcmp(prefChange.GetBytes(),prefAfter.GetBytes(),prefChange.Size())==0);

	//Change the pref again
	card0.writeFile("3F00DF014039",prefBefore);

}

TEST(SIS_ID)
{
	BEID_ReaderContext &reader=ReaderSet.getReaderByNum(4);	
	BEID_SISCard &card=reader.getSISCard();				
	BEID_SisId &doc=card.getID();

	CHECK_EQUAL("HOEBEN",doc.getSurname());
	CHECK_EQUAL("STEFAN",doc.getName());
	CHECK_EQUAL("",doc.getInitials());
	CHECK_EQUAL("1",doc.getGender());
	CHECK_EQUAL("01/04/1973",doc.getDateOfBirth());
	CHECK_EQUAL("730401 027 49",doc.getSocialSecurityNumber());
	CHECK_EQUAL("737033783",doc.getLogicalNumber());
	CHECK_EQUAL("05/01/2004",doc.getDateOfIssue());
	CHECK_EQUAL("02/01/2004",doc.getValidityBeginDate());
	CHECK_EQUAL("31/01/2014",doc.getValidityEndDate());
}

TEST(VersionInfo)
{
	BEID_ReaderContext &reader=ReaderSet.getReaderByNum(0);	
	BEID_EIDCard &card=reader.getEIDCard();	
	BEID_CardVersionInfo &doc=card.getVersionInfo();

	CHECK_EQUAL("534C494E336600296CFF2623000000E1",doc.getSerialNumber());
	CHECK_EQUAL("A5",doc.getComponentCode());
	CHECK_EQUAL("03",doc.getOsNumber());
	CHECK_EQUAL("01",doc.getOsVersion());
	CHECK_EQUAL("01",doc.getSoftmaskNumber());
	CHECK_EQUAL("01",doc.getSoftmaskVersion());
	CHECK_EQUAL("1.1",doc.getAppletVersion());
	CHECK_EQUAL("0002",doc.getGlobalOsVersion());
	CHECK_EQUAL("00",doc.getAppletInterfaceVersion());
	CHECK_EQUAL("01",doc.getPKCS1Support());
	CHECK_EQUAL("01",doc.getKeyExchangeVersion());
	CHECK_EQUAL("0F",doc.getAppletLifeCycle());
	CHECK_EQUAL("04",doc.getGraphicalPersonalisation());
	CHECK_EQUAL("02",doc.getElectricalPersonalisation());
	CHECK_EQUAL("00",doc.getElectricalPersonalisationInterface());
}

TEST(SIS_XML)
{
	BEID_ReaderContext &reader=ReaderSet.getReaderByNum(4);	
	BEID_SISCard &card=reader.getSISCard();				
	BEID_XMLDoc &doc=card.getID();

	//std::cout << doc.getXML();
	doc.writeXmlToFile("sis.xml");
	CHECK_EQUAL(1077,doc.getXML().Size());
}

TEST(EID_XML)
{
	BEID_ReaderContext &reader=ReaderSet.getReaderByNum(0);	
	BEID_EIDCard &card=reader.getEIDCard();	

	{
		BEID_XMLDoc &doc=card.getID();
		//std::cout << doc.getXML();
		CHECK_EQUAL(1862,doc.getXML().Size());
		CHECK(doc.writeXmlToFile("eid.xml"));
	}

	{
		BEID_XMLDoc &doc=card.getPicture();
		//std::cout << doc.getXML();
		CHECK_EQUAL(4322,doc.getXML().Size());
		CHECK(doc.writeXmlToFile("picture.xml"));
	}

	{
		BEID_XMLDoc &doc=card.getVersionInfo();
		//std::cout << doc.getXML();
		CHECK_EQUAL(883,doc.getXML().Size());
		CHECK(doc.writeXmlToFile("info.xml"));
	}

	{
		BEID_XMLDoc &doc=card.getDocument(BEID_DOCTYPE_PINS);
		//std::cout << doc.getXML();
		CHECK_EQUAL(328,doc.getXML().Size());
		CHECK(doc.writeXmlToFile("pins.xml"));
	}

	{
		BEID_XMLDoc &doc=card.getDocument(BEID_DOCTYPE_CERTIFICATES);
		//std::cout << doc.getXML();
		CHECK_EQUAL(6407,doc.getXML().Size());
		CHECK(doc.writeXmlToFile("certs.xml"));
	}
}
