/* ****************************************************************************

 * eID Middleware Project.
 * Copyright (C) 2008-2009 FedICT.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version
 * 3.0 as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, see
 * http://www.gnu.org/licenses/.

**************************************************************************** */
#ifndef __CSPUTIL_H__
#define __CSPUTIL_H__

#include <windows.h>
#include "Cspdk.h"

#include "../common/Hash.h"
#include "../common/MWException.h"
#include "../common/eidErrors.h"
#include "../cardlayer/CardLayerConst.h"

namespace eIDMW
{

BOOL FillProvParam(LPBYTE pbData, LPDWORD pcbDataLen,
	  const void *dataIn, size_t dataLen);

/** CryptoAPI's ALG_ID -> middleware's tHashAlgo */
tHashAlgo GetHashAlgo(ALG_ID Algid);

/** CryptoAPI's ALG_ID -> middleware's signature algo */
unsigned long GetSignAlgo(ALG_ID Algid);

/** swap first and last byte, swap 2nd and 2nd last byte, etc. */
void ReverseByteOrder (BYTE *pByte, DWORD dwLen);

/** Make a copy of CERT_PUBLIC_KEY_INFO, with memory allocated for the pointers */
BOOL DuplicatePubKeyInfo(CERT_PUBLIC_KEY_INFO *pDest, const CERT_PUBLIC_KEY_INFO *pSrc);

/** Free the CERT_PUBLIC_KEY_INFO that was generated by DuplicatePubKeyInfo() */
void FreePubKeyInfo(CERT_PUBLIC_KEY_INFO *pPubKeyInfo);

}

#endif
