
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsedatapocket.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsedatapocket.h>


#line 24 "bsedatapocket.proc"


/* --- create-entry --- */
static void
create_entry_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 26 "bsedatapocket.proc"
 {
#line 29 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", NULL,
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 33 "bsedatapocket.proc"
}  }
static BseErrorType
#line 33 "bsedatapocket.proc"
create_entry_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 36 "bsedatapocket.proc"
{
#line 37 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id;
  
#line 41 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 45 "bsedatapocket.proc"
  
  id = _bse_data_pocket_create_entry (pocket);
  
#line 48 "bsedatapocket.proc"
  
  sfi_value_set_int (out_values++, id);
  
  return BSE_ERROR_NONE;
}

/* --- delete-entry --- */
static void
delete_entry_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 54 "bsedatapocket.proc"
 {
#line 56 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", NULL,
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
#line 63 "bsedatapocket.proc"
}  }
static BseErrorType
#line 63 "bsedatapocket.proc"
delete_entry_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 66 "bsedatapocket.proc"
{
#line 67 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gboolean fail = TRUE;
  
#line 72 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 76 "bsedatapocket.proc"
  
  if (id)
    fail = _bse_data_pocket_delete_entry (pocket, id);
  
#line 80 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, fail ? BSE_ERROR_NO_ENTRY : BSE_ERROR_NONE);
  
  return BSE_ERROR_NONE;
}

/* --- get-n-entries --- */
static void
get_n_entries_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 86 "bsedatapocket.proc"
 {
#line 88 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_int ("n_entries", "N Entries", "The number of entries in use",
			 1, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 92 "bsedatapocket.proc"
}  }
static BseErrorType
#line 92 "bsedatapocket.proc"
get_n_entries_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 95 "bsedatapocket.proc"
{
#line 96 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  
#line 99 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 103 "bsedatapocket.proc"
  
  sfi_value_set_int (out_values++, pocket->n_entries);
  
  return BSE_ERROR_NONE;
}

/* --- get-nth-entry-id --- */
static void
get_nth_entry_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 109 "bsedatapocket.proc"
 {
#line 111 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_index", "Entry Index", "index into number of entries present",
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID (or 0 if there's no such entry)",
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 117 "bsedatapocket.proc"
}  }
static BseErrorType
#line 117 "bsedatapocket.proc"
get_nth_entry_id_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 120 "bsedatapocket.proc"
{
#line 121 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint index           = sfi_value_get_int (in_values++);
  
#line 125 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 129 "bsedatapocket.proc"
  
  sfi_value_set_int (out_values++, index < pocket->n_entries ? pocket->entries[index].id : 0);
  
  return BSE_ERROR_NONE;
}

/* --- set-float --- */
static void
set_float_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 135 "bsedatapocket.proc"
 {
#line 139 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("number", "Number", "The value to store in the data pocket entry",
			  0, -G_MAXDOUBLE, G_MAXDOUBLE, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
#line 150 "bsedatapocket.proc"
}  }
static BseErrorType
#line 150 "bsedatapocket.proc"
set_float_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 153 "bsedatapocket.proc"
{
#line 154 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  gfloat v_float        = sfi_value_get_real (in_values++);
  BseDataPocketValue value;
  gboolean success = FALSE;
  
#line 162 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 166 "bsedatapocket.proc"
  
  value.v_float = v_float;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_FLOAT, value);
  
#line 171 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_ENTRY);
  
  return BSE_ERROR_NONE;
}

/* --- set-int --- */
static void
set_int_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 177 "bsedatapocket.proc"
 {
#line 181 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("number", "Number", "The value to store in the data pocket entry",
			 0, G_MININT, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
#line 192 "bsedatapocket.proc"
}  }
static BseErrorType
#line 192 "bsedatapocket.proc"
set_int_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 195 "bsedatapocket.proc"
{
#line 196 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  guint v_uint          = sfi_value_get_int (in_values++);
  BseDataPocketValue value;
  gboolean success = FALSE;
  
#line 204 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 208 "bsedatapocket.proc"
  
  value.v_int = v_uint;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_INT, value);
  
#line 213 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_ENTRY);
  
  return BSE_ERROR_NONE;
}

/* --- set-object --- */
static void
set_object_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 219 "bsedatapocket.proc"
 {
#line 223 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", "The value to store in the data pocket entry",
				 BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
#line 234 "bsedatapocket.proc"
}  }
static BseErrorType
#line 234 "bsedatapocket.proc"
set_object_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 237 "bsedatapocket.proc"
{
#line 238 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  BseItem *v_object     = bse_value_get_object (in_values++);
  BseDataPocketValue value;
  gboolean success = FALSE;
  
#line 246 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket) ||
      (v_object && !bse_item_common_ancestor ((BseItem*) pocket, v_object)))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 251 "bsedatapocket.proc"
  
  value.v_object = v_object;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_OBJECT, value);
  
#line 256 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_ENTRY);
  
  return BSE_ERROR_NONE;
}

/* --- set-string --- */
static void
set_string_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 262 "bsedatapocket.proc"
 {
#line 264 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("string", "String", "The value to store in the data pocket entry",
			    0, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
#line 275 "bsedatapocket.proc"
}  }
static BseErrorType
#line 275 "bsedatapocket.proc"
set_string_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 278 "bsedatapocket.proc"
{
#line 279 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  gchar *v_string       = sfi_value_get_string (in_values++);
  BseDataPocketValue value;
  gboolean success = FALSE;
  
#line 287 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 291 "bsedatapocket.proc"
  
  value.v_string = v_string;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_STRING, value);
  
#line 296 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_ENTRY);
  
  return BSE_ERROR_NONE;
}

/* --- get-float --- */
static void
get_float_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 302 "bsedatapocket.proc"
 {
#line 304 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_real ("number", "Number", "The value stored in the data pocket entry",
			  0, -G_MAXDOUBLE, G_MAXDOUBLE, 1, SFI_PARAM_STANDARD);
#line 312 "bsedatapocket.proc"
}  }
static BseErrorType
#line 312 "bsedatapocket.proc"
get_float_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 315 "bsedatapocket.proc"
{
#line 316 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;
  
#line 323 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 327 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);
  
#line 330 "bsedatapocket.proc"
  
  sfi_value_set_real (out_values++, type == BSE_DATA_POCKET_FLOAT ? value.v_float : 0);
  
  return BSE_ERROR_NONE;
}

/* --- get-int --- */
static void
get_int_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 336 "bsedatapocket.proc"
 {
#line 338 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_int ("number", "Number", "The value stored in the data pocket entry",
			 0, G_MININT, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 346 "bsedatapocket.proc"
}  }
static BseErrorType
#line 346 "bsedatapocket.proc"
get_int_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 349 "bsedatapocket.proc"
{
#line 350 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;
  
#line 357 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 361 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);
  
#line 364 "bsedatapocket.proc"
  
  sfi_value_set_int (out_values++, type == BSE_DATA_POCKET_INT ? value.v_int : 0);
  
  return BSE_ERROR_NONE;
}

/* --- get-object --- */
static void
get_object_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 370 "bsedatapocket.proc"
 {
#line 372 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("item", "Item", "The value stored in the data pocket entry",
				 BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
#line 380 "bsedatapocket.proc"
}  }
static BseErrorType
#line 380 "bsedatapocket.proc"
get_object_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 383 "bsedatapocket.proc"
{
#line 384 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;
  
#line 391 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 395 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);
  
#line 398 "bsedatapocket.proc"
  
  bse_value_set_object (out_values++, type == BSE_DATA_POCKET_OBJECT ? value.v_object : 0);
  
  return BSE_ERROR_NONE;
}

/* --- get-string --- */
static void
get_string_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 404 "bsedatapocket.proc"
 {
#line 406 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("string", "String", "The value stored in the data pocket entry",
			    0, SFI_PARAM_STANDARD);
#line 414 "bsedatapocket.proc"
}  }
static BseErrorType
#line 414 "bsedatapocket.proc"
get_string_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 417 "bsedatapocket.proc"
{
#line 418 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;
  
#line 425 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 429 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);
  
#line 432 "bsedatapocket.proc"
  
  sfi_value_set_string (out_values++, type == BSE_DATA_POCKET_STRING ? value.v_string : 0);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_create_entry__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Create a new entry in a data pocket. "
	   "Entries have a unique ID which is required to set values in a data pocket.");
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 27;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_entry = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+create-entry", 
    NULL,
    "/Methods/BseDataPocket/General/Create Entry",
    NULL,
    __enode_create_entry__fill_strings,
  },
  0, create_entry_setup, create_entry_exec, 
};
static void
__enode_delete_entry__fill_strings (BseExportStrings *es)
{
  es->blurb = "Delete an existing entry from a data pocket";
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 55;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_delete_entry = {
  { (BseExportNode*) &__enode_create_entry, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+delete-entry", 
    NULL,
    "/Methods/BseDataPocket/General/Delete Entry",
    NULL,
    __enode_delete_entry__fill_strings,
  },
  0, delete_entry_setup, delete_entry_exec, 
};
static void
__enode_get_n_entries__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the number of entries created in a data pocket.";
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 87;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_n_entries = {
  { (BseExportNode*) &__enode_delete_entry, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-n-entries", 
    NULL,
    "/Methods/BseDataPocket/General/Get N Entries",
    NULL,
    __enode_get_n_entries__fill_strings,
  },
  0, get_n_entries_setup, get_n_entries_exec, 
};
static void
__enode_get_nth_entry_id__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the ID of an entry in the data pocket by sequential index.";
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 110;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_nth_entry_id = {
  { (BseExportNode*) &__enode_get_n_entries, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-nth-entry-id", 
    NULL,
    "/Methods/BseDataPocket/General/Get Nth Entry Id",
    NULL,
    __enode_get_nth_entry_id__fill_strings,
  },
  0, get_nth_entry_id_setup, get_nth_entry_id_exec, 
};
static void
__enode_set_float__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Set a named floating point value in a data pocket entry. "
	   "Names are required to distinguish different values from each other "
	   "when accessing values in a data pocket.");
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 136;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_float = {
  { (BseExportNode*) &__enode_get_nth_entry_id, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+set-float", 
    NULL,
    "/Methods/BseDataPocket/General/Set Float",
    NULL,
    __enode_set_float__fill_strings,
  },
  0, set_float_setup, set_float_exec, 
};
static void
__enode_set_int__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Set a named integer value in a data pocket entry. "
	   "Names are required to distinguish different values from each other "
	   "when accessing values in a data pocket.");
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 178;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_int = {
  { (BseExportNode*) &__enode_set_float, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+set-int", 
    NULL,
    "/Methods/BseDataPocket/General/Set Int",
    NULL,
    __enode_set_int__fill_strings,
  },
  0, set_int_setup, set_int_exec, 
};
static void
__enode_set_object__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Set a named object reference in a data pocket entry. "
	   "Object references stored in a data pocket must exist within the "
	   "same project that the data pocket belongs to");
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 220;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_object = {
  { (BseExportNode*) &__enode_set_int, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+set-object", 
    NULL,
    "/Methods/BseDataPocket/General/Set Object",
    NULL,
    __enode_set_object__fill_strings,
  },
  0, set_object_setup, set_object_exec, 
};
static void
__enode_set_string__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Set a named string in a data pocket entry.");
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 263;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_string = {
  { (BseExportNode*) &__enode_set_object, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+set-string", 
    NULL,
    "/Methods/BseDataPocket/General/Set String",
    NULL,
    __enode_set_string__fill_strings,
  },
  0, set_string_setup, set_string_exec, 
};
static void
__enode_get_float__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve a previously set floating point value from a data pocket entry.";
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 303;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_float = {
  { (BseExportNode*) &__enode_set_string, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-float", 
    NULL,
    "/Methods/BseDataPocket/General/Get Float",
    NULL,
    __enode_get_float__fill_strings,
  },
  0, get_float_setup, get_float_exec, 
};
static void
__enode_get_int__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve a previously set integer value from a data pocket entry.";
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 337;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_int = {
  { (BseExportNode*) &__enode_get_float, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-int", 
    NULL,
    "/Methods/BseDataPocket/General/Get Int",
    NULL,
    __enode_get_int__fill_strings,
  },
  0, get_int_setup, get_int_exec, 
};
static void
__enode_get_object__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve a previously set object reference from a data pocket entry.";
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 371;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_object = {
  { (BseExportNode*) &__enode_get_int, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-object", 
    NULL,
    "/Methods/BseDataPocket/General/Get Object",
    NULL,
    __enode_get_object__fill_strings,
  },
  0, get_object_setup, get_object_exec, 
};
static void
__enode_get_string__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve a previously set string from a data pocket entry.";
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 405;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_string = {
  { (BseExportNode*) &__enode_get_object, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-string", 
    NULL,
    "/Methods/BseDataPocket/General/Get String",
    NULL,
    __enode_get_string__fill_strings,
  },
  0, get_string_setup, get_string_exec, 
};
BseExportNode* bse__builtin_init_bsedatapocket_genprc_c (void);
BseExportNode* bse__builtin_init_bsedatapocket_genprc_c (void)
{
  return (BseExportNode*) &__enode_get_string;
}

/*
 * Generated data ends here
 */
