/* patch.h:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005 Canonical Limited
 * 	Authors: Robert Collins <robert.collins@canonical.com>
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__PATCH_H
#define INCLUDE__LIBARCH__PATCH_H

#include "libarch/patch-id.h"

/**
 * A patch - i.e. foo@example.com/foo--bar--0--base-0
 * with metadata, contents, 
 * and memory mgmt
 */
typedef struct arch_patch_ 
{
    arch_patch_id patch_id;
    t_uchar *creator;
    
} arch_patch_t;

extern void arch_patch_init (arch_patch_t *patch, t_uchar const *patch_id);
extern void arch_patch_finalise (arch_patch_t *patch);
extern arch_patch_t * arch_patch_new (t_uchar const *patch_id);
extern void arch_patch_delete (arch_patch_t **patch);
extern arch_patch_t * arch_patch_copy (arch_patch_t *patch);
/* should be const ! */
extern t_uchar * arch_patch_creator (arch_patch_t *patch);
extern void arch_patch_creator_set (arch_patch_t *patch, t_uchar const *creator);
extern arch_patch_id * arch_patch_patch_id (arch_patch_t *patch);
  
#endif /* INCLUDE__LIBARCH__PATCH_H */
