/* inv.h: file inventories
 *
 ****************************************************************
 * Copyright (C) 2002, 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__FILE_UTILS__INV_H
#define INCLUDE__FILE_UTILS__INV_H

#include "hackerlab/os/sys/stat.h"
#include "hackerlab/machine/types.h"
#include "hackerlab/rx-posix/regex.h"
#include "libawk/relational.h"


struct arch_inventory_options;
typedef struct invent_callback_data_ invent_callback_data_t;
typedef void (*inv_callback) (void * closure, invent_callback_data_t const * const data);

#include "libarch/inv-ids.h"

struct arch_inventory_regexps
{
  regex_t excludes_pattern;
  regex_t junk_pattern;
  regex_t backup_pattern;
  regex_t precious_pattern;
  regex_t unrecognized_pattern;
  regex_t source_pattern;
};

struct arch_inventory_options
{
  t_uint categories;                    /* set of enum inv_category */

  int want_ids;                        /* go to the expense of computing file ids? */
  int treat_unrecognized_source_as_source;                 /* report source-named files that are missing ids? */
  enum arch_id_tagging_method method;      /* id tagging method */
  enum arch_inventory_category untagged_source_category; /* what are untagged files matching source? */

  int nested;                           /* search in nested trees? */
  int include_excluded;                 /* ignore the `excludes_pattern'? */
  int override_method;	              /* override tree's id tagging methods? */
  int no_recursion;

  struct arch_inventory_regexps regexps;
};

struct invent_callback_data_ {
  t_uchar * path;
  struct stat stat_buf;
  enum arch_inventory_category category;
  t_uchar * id;
  int has_source_name;
};

AR_TYPEDEF (invent_callback_data_t *, invent_cb);

/* talloc managed, talloc_free to release */
typedef struct {
  struct arch_inventory_options options;
  ar_invent_cb inventory;
} cached_changeset_inventory_t;


/* automatically generated __STDC__ prototypes */
extern rel_table arch_source_inventory (arch_project_tree_t * tree, int include_ctl, int include_precious, int include_nested);
extern rel_table arch_source_files_inventory (arch_project_tree_t * tree, int include_ctl, int include_precious);
extern t_uchar * arch_default_naming_conventions_regexp (enum arch_inventory_category cat);
extern t_uchar * arch_ancient_default_naming_conventions_regexp (enum arch_inventory_category cat);
extern t_uchar * arch_null_default_naming_conventions_regexp (enum arch_inventory_category cat);
extern void arch_get_inventory_naming_conventions (struct arch_inventory_options * options,
                                                   arch_project_tree_t * tree);
extern void arch_free_inventory_naming_conventions (struct arch_inventory_options * options);
extern void arch_inventory_traversal (struct arch_inventory_options * options,
                                      arch_project_tree_t * tree,
                                      inv_callback callback,
                                      void * closure);
extern void arch_inventory_traversal_path (struct arch_inventory_options * options,
                                      arch_project_tree_t * tree,
				      t_uchar const * const path, 
                                      inv_callback callback,
                                      void * closure);
extern int arch_is_control_file (char * rel_file, char * filename);
extern rel_table pick_non_control (rel_table table);
extern rel_table arch_inventory_included (rel_table an_inventory, rel_table filter_paths);
extern void cached_changeset_inventory_traveral (struct arch_inventory_options * options, arch_project_tree_t * tree, inv_callback callback, void * closure, cached_changeset_inventory_t ** cache);
#endif  /* INCLUDE__FILE_UTILS__INV_H */


/* tag: Tom Lord Wed May 14 11:10:28 2003 (invent.h)
 */
