/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.analyser.BMPReader;
import org.apache.fop.image.analyser.EMFReader;
import org.apache.fop.image.analyser.EPSReader;
import org.apache.fop.image.analyser.GIFReader;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.image.analyser.JPEGReader;
import org.apache.fop.image.analyser.PNGReader;
import org.apache.fop.image.analyser.SVGReader;
import org.apache.fop.image.analyser.TIFFReader;
import org.apache.fop.image.analyser.XMLReader;

public class ImageReaderFactory {
    private static ArrayList formats = new ArrayList();
    protected static Log log = LogFactory.getLog(class$org$apache$fop$image$analyser$ImageReaderFactory == null ? (class$org$apache$fop$image$analyser$ImageReaderFactory = ImageReaderFactory.class$("org.apache.fop.image.analyser.ImageReaderFactory")) : class$org$apache$fop$image$analyser$ImageReaderFactory);
    static /* synthetic */ Class class$org$apache$fop$image$analyser$ImageReaderFactory;

    public static void registerFormat(ImageReader reader) {
        formats.add(reader);
    }

    public static FopImage.ImageInfo make(String uri, InputStream in, FOUserAgent ua) {
        try {
            int count = 0;
            while (count < formats.size()) {
                ImageReader reader = (ImageReader)formats.get(count);
                FopImage.ImageInfo info = reader.verifySignature(uri, in, ua);
                if (info != null) {
                    return info;
                }
                ++count;
            }
            log.warn("No ImageReader found for " + uri);
            in.close();
        }
        catch (IOException ex) {
            log.error("Error while recovering Image Informations (" + uri + ")", ex);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ImageReaderFactory.registerFormat(new JPEGReader());
        ImageReaderFactory.registerFormat(new BMPReader());
        ImageReaderFactory.registerFormat(new GIFReader());
        ImageReaderFactory.registerFormat(new PNGReader());
        ImageReaderFactory.registerFormat(new TIFFReader());
        ImageReaderFactory.registerFormat(new EPSReader());
        ImageReaderFactory.registerFormat(new EMFReader());
        ImageReaderFactory.registerFormat(new SVGReader());
        ImageReaderFactory.registerFormat(new XMLReader());
    }
}

