<?php
/*
+-------------------------------------------------------------------+
| BasiliX - Copyright (C) 2000 Murat Arslan <arslanm@cyberdude.com> |
+-------------------------------------------------------------------+
*/

require("$BSX_LIBDIR/lang.class");

// Load the desired language msg files
// ------------------------------------------------------------------

function lang_init($lang) {
    global $lng;
    return $lng->init($lang);
}

function lang_load($section) {
    global $lng;
    $lng->load($section);
}

function lang_start($lang) {
    global $RequestID;

    $charset = lang_init($lang);

    // find the suitable language msg
    if($RequestID == "") $tmp = "DUMMY";
    else $tmp = $RequestID;
    switch($tmp) {
        case LOGIN:
	case CHUSER:
        case DUMMY:
	    $section = "login";
	    break;
        case FOLDERS:
	case CRTFOL:
	case DELFOL:
	case RENFOL:
	case EMPTFOL:
	    $section = "folders";
	    break;
	case ABOOK:
	    $section = "addrbook";
	    break;
	case SETTINGS:
	    $section = "settings";
	    break;
	case LOGOUT:
	    $section = "logout";
	    break;
	case READMSG:
	case SHOWHDR:
	case DELMSG:
	case PRINTMSG:
	    $section = "msgs";
	    break;
	case REPMSG:
	case REPAMSG:
	case FORWMSG:
	case CMPSNEW:
	case CMPSABOOK:
	case CMPSATCH:
	case CMPSSEND:
	    $section = "compose";
	    break;
	case MBOXLST:
	case MBOXACT:
	    $section = "mboxlst";
	    break;
	case FINDMSG:
	    $section = "findmsg";
	    break;
    }
    lang_load($section);
    return $charset;
}

// --
if(empty($BSX_Lang)) {
	$tmp_langarr = explode(",", $HTTP_ACCEPT_LANGUAGE);
	$BSX_Lang = strtolower($tmp_langarr[0]);
}
$charset = lang_start($BSX_Lang);
// --
?>
