/*
 * Copyright 2000 Murray Cumming
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef BAKERY_APP_WITHDOC_GTK_H
#define BAKERY_APP_WITHDOC_GTK_H

#include <bakery/App/App_WithDoc.h>
#include <bakery/App/App_Gtk.h>
#include <bakery/Document/Document.h>

namespace Bakery
{

/** This class implements Bakery::App_WithDoc using gtkmm.
 *
 */
class App_WithDoc_Gtk
    //These are virtual base classes, with shared shared App and SigC::Object base classes:
  : public App_WithDoc, 
    public App_Gtk
{
public:
  ///Don't forget to call init() too.
  App_WithDoc_Gtk(const Glib::ustring& appname);
  virtual ~App_WithDoc_Gtk();

  virtual void init(); //Unique final overrider.

protected:
  virtual void init_menus_file(); //overridden to add open/save/save as.
  virtual void init_toolbars(); //overridden to add open/save

  virtual void update_window_title();
  virtual void show_document_history(); //override

  virtual void ui_warning(const Glib::ustring& text);
  virtual Glib::ustring ui_file_select_open();
  virtual Glib::ustring ui_file_select_save(const Glib::ustring& old_filepath);
  virtual void ui_show_modification_status();
  virtual enumSaveChanges ui_offer_to_save_changes();
  virtual bool ui_ask_overwrite(const std::string& filepath);
  
  //Menu stuff:
  Gtk::Menu m_SubMenu_RecentFiles;
  Gtk::Widget* m_pMenuItem_File_Save;
  Gtk::Widget* m_pToolbarItem_Save;
};

} //namespace

#endif //BAKERY_APP_WITHDOC_GTK_H
