/*
 * Copyright 2000 Murray Cumming
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <bakery/App/App_Gtk.h>
#include <gtkmm/stock.h>
#include <gtkmm/messagedialog.h>
#include <libintl.h>
#include <algorithm>

namespace Bakery
{

//Initialize static member data:


Gtk::Window* App_Gtk::m_pAbout = 0;

App_Gtk::App_Gtk(const Glib::ustring& appname)
{
  init_app_name(appname);  
  
  init_layout();                                                      
}

App_Gtk::~App_Gtk()
{
  //If this was the last instance:
  if(m_AppInstanceManager.get_app_count() == 0)
  {
    //Delete shared static widgets if this was the last instance:
    if(m_pAbout)
    {
      delete m_pAbout;
      m_pAbout = 0;
    }
  }
}

void App_Gtk::on_hide()
{
  ui_signal_hide().emit();
}

void App_Gtk::ui_hide()
{
  hide();  
}

void App_Gtk::ui_bring_to_front()
{
  get_window()->raise();
}
  
void App_Gtk::init_layout()
{
  set_resizable(); //resizable
  set_default_size(640, 400); //A sensible default.

  Gtk::Window::add(m_VBox);

  //Add menu bar at the top:
  m_VBox.pack_start(m_MenuBar, Gtk::PACK_SHRINK);
  m_MenuBar.show();
  
  m_HandleBox_Toolbar.add(m_Toolbar);
  m_Toolbar.show();
  m_VBox.pack_start(m_HandleBox_Toolbar, Gtk::PACK_SHRINK);
  m_HandleBox_Toolbar.show();
  
  //Add placeholder, to be used by add():
  m_VBox.pack_start(m_VBox_PlaceHolder);
  m_VBox_PlaceHolder.show();
  
  m_VBox.show(); //Show it last so the child widgtets all show at once.
}

void App_Gtk::init()
{
  App::init();
  show();
}

void App_Gtk::init_menus()
{
  //Override this to add more menus
  init_menus_file();
  init_menus_edit();
  init_menus_help();
}

void App_Gtk::add(Gtk::Widget& child)
{
  m_VBox_PlaceHolder.pack_start(child);
}


void App_Gtk::init_toolbars()
{
  m_Toolbar.tools().push_back( Gtk::Toolbar_Helpers::StockElem(Gtk::Stock::NEW, SigC::slot(*this, &App::on_menu_file_new)) );
}


bool App_Gtk::on_delete_event(GdkEventAny* e)
{
  //Clicking on the [x] in the title bar should be like choosing File|New
  on_menu_file_close();

  return true; // true = don't hide, don't destroy
}

void App_Gtk::init_menus_file()
{
  // File menu

  //Build menu:
  m_Menu_File.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::NEW, SigC::slot(*this, &App::on_menu_file_new)));
  m_Menu_File.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::CLOSE, SigC::slot(*this, &App::on_menu_file_close)));
  m_Menu_File.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::QUIT, SigC::slot(*this, &App::on_menu_file_exit)));

  //Add menu:
  m_MenuBar.items().push_back(Gtk::Menu_Helpers::MenuElem(gettext("_File"), m_Menu_File));
}

void App_Gtk::init_menus_edit()
{
  //Edit menu
  
  //Build menu:
  m_Menu_Edit.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::CUT, SigC::slot(*this, &App::on_menu_edit_cut)));
  m_Menu_Edit.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::COPY, SigC::slot(*this, &App::on_menu_edit_copy)));
  m_Menu_Edit.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::PASTE, SigC::slot(*this, &App::on_menu_edit_paste)));
  m_Menu_Edit.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::CLEAR, SigC::slot(*this, &App::on_menu_edit_clear)));

  //Add menu:
  m_MenuBar.items().push_back(Gtk::Menu_Helpers::MenuElem(gettext("_Edit"), m_Menu_Edit));
}

void App_Gtk::init_menus_help()
{
  //Help menu

  //Build menu:
  m_Menu_Help.items().push_back(Gtk::Menu_Helpers::MenuElem(gettext("_About"), SigC::slot(*this, &App::on_menu_help_about)));

  //Add menu:
 
  m_MenuBar.items().push_back(Gtk::Menu_Helpers::StockMenuElem(Gtk::Stock::HELP, m_Menu_Help));
}


void App_Gtk::on_menu_help_about()
{
  if(m_pAbout && m_bAboutShown) // "About" box hasn't been closed, so just raise it
  {
    m_pAbout->set_transient_for(*this);

    Glib::RefPtr<Gdk::Window> about_win = m_pAbout->get_window();
    about_win->show();
    about_win->raise();
  }
  else
  {
    //Re-create About box:
    if(m_pAbout)
    {
      delete m_pAbout;
      m_pAbout = 0;
    }

    m_pAbout = new Gtk::MessageDialog(*this,
      gettext("Application: ") + m_strAppName + "\n" +
      gettext("Copyright: ") + m_HelpInfo.m_strCopyright + "\n" );

    //TODO: Authors and Translators.
    
    /*
    m_pAbout = new Gnome::UI::About(m_strAppName, m_HelpInfo.m_strVersion,
                               m_HelpInfo.m_strCopyright,
                               m_HelpInfo.m_vecAuthors, m_HelpInfo.m_vecDocumenters,
                               m_HelpInfo.m_strDescription, m_HelpInfo.m_strTranslatorCredits,
                               refLogo);
    */

    m_pAbout->signal_hide().connect(SigC::slot(*this, &App::on_about_close));
    m_bAboutShown = true;
    static_cast<Gtk::Dialog*>(m_pAbout)->run(); //show() would be better. see below:
    m_pAbout->hide();
    //m_pAbout->show(); //TODO: respond to the OK button.
  }
}

void App_Gtk::on_about_close()
{
  m_bAboutShown = false;
}



} //namespace
