/**
 * ========================================
 * JFreeReport : a free Java report library
 * ========================================
 *
 * Project Info:  http://www.object-refinery.com/jfreereport/index.html
 * Project Lead:  Thomas Morgner (taquera@sherito.org);
 *
 * (C) Copyright 2000-2003, by Simba Management Limited and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * ----------------------------
 * JFreeReportResources_hu.java
 * ----------------------------
 * (C)opyright 2000-2002, by Simba Management Limited and Contributors.
 *
 * Original Author:  Demeter F. Tams;
 * Contributor(s):   -;
 *
 *
 * $Id: JFreeReportResources_hu.java,v 1.1 2003/05/16 13:24:42 taqua Exp $
 *
 *
 */
package com.jrefinery.report.resources;

import java.awt.event.KeyEvent;

/**
 * Hungarian Language Resources.
 *
 * @author Demeter F. Tams
 */
public class JFreeReportResources_hu extends JFreeReportResources
{

  /**
   * Unicode translation:
   *
   * &auml; - \u00E4
   * &Auml; - \u00C4
   * &ouml; - \u00f6
   * &Ouml; - \u00d6
   * &Uuml; - \u00dc
   * &uuml; - \u00fc
   * &szlig; - \u00df
   *
   */
  /**
   * Returns the array of strings in the resource bundle.
   *
   * @return an array of localised resources.
   */
  public Object[][] getContents()
  {
    return CONTENTS;
  }

  /** The resources to be localised. */
  private static final Object[][] CONTENTS =
      {
            {"action.save-as.name", "Ments mint PDF..."},
            {"action.save-as.description", "Ments PDF formtumban"},
            {"action.save-as.mnemonic", new Integer (KeyEvent.VK_M)},

            {"action.export-to-excel.name", "Exportld Excel-knt..."},
            {"action.export-to-excel.description", "Ments MS-Excel formtumban"},
            {"action.export-to-excel.mnemonic", new Integer (KeyEvent.VK_E)},

            {"action.export-to-html.name", "Exportld html-knt..."},
            {"action.export-to-html.description", "Ments HTML formtumban"},
            {"action.export-to-html.mnemonic", new Integer (KeyEvent.VK_H)},

            {"action.export-to-csv.name", "Exportld CSV-knt..."},
            {"action.export-to-csv.description", "Ments CSV formtumban"},
            {"action.export-to-csv.mnemonic", new Integer (KeyEvent.VK_C)},

            {"action.export-to-plaintext.name", "Ments mint text fjl..."},
            {"action.export-to-plaintext.description", "Ments egyszer szveges formtumban"},
            {"action.export-to-plaintext.mnemonic", new Integer (KeyEvent.VK_T)},

            {"action.page-setup.name", "Oldal belltsa"},
            {"action.page-setup.description", "Oldal belltsa"},
            {"action.page-setup.mnemonic", new Integer (KeyEvent.VK_O)},

            {"action.print.name", "Nyomtats..."},
            {"action.print.description", "Lista nyomtatsa"},
            {"action.print.mnemonic", new Integer (KeyEvent.VK_N)},

            {"action.close.name", "Bezrs"},
            {"action.close.description", "Az elnzet bezrsa"},
            {"action.close.mnemonic", new Integer (KeyEvent.VK_B)},

            {"action.gotopage.name", "Ugorj adott oldalra ..."},
            {"action.gotopage.description", "Egy oldalra kzvetlen ugrs"},
            {"action.gotopage.mnemonic", new Integer (KeyEvent.VK_G)},

            {"dialog.gotopage.message", "rd be az oldalszmot"},
            {"dialog.gotopage.title", "Ugorj az oldalra"},

            {"action.about.name", "Nvjegy..."},
            {"action.about.description", "Informci az alkalmazsrl"},
            {"action.about.mnemonic", new Integer (KeyEvent.VK_N)},

            {"action.firstpage.name", "Legels"},
            {"action.firstpage.mnemonic", new Integer (KeyEvent.VK_HOME)},
            {"action.firstpage.description", "Ugorj az els oldalra"},

            {"action.back.name", "Vissza"},
            {"action.back.description", "Lapozz az elz oldalra"},
            {"action.back.mnemonic", new Integer (KeyEvent.VK_PAGE_UP)},

            {"action.forward.name", "Elre"},
            {"action.forward.description", "Lapozz a kvetkez oldalra"},
            {"action.forward.mnemonic", new Integer (KeyEvent.VK_PAGE_DOWN)},

            {"action.lastpage.name", "Legutols"},
            {"action.lastpage.description", "Ugorj az utols oldalra"},
            {"action.lastpage.mnemonic", new Integer (KeyEvent.VK_END)},

            {"action.zoomIn.name", "Nagyts"},
            {"action.zoomIn.description", "Nagyts"},
            {"action.zoomIn.mnemonic", new Integer (KeyEvent.VK_PLUS)},

            {"action.zoomOut.name", "Kicsinyts"},
            {"action.zoomOut.description", "Kicsinyts"},
            {"action.zoomOut.mnemonic", new Integer (KeyEvent.VK_MINUS)},

            // preview frame...
            {"preview-frame.title", "Nyomtatsi elnzet"},

            // menu labels...
            {"menu.file.name", "Fjl"},
            {"menu.file.mnemonic", new Character ('F')},

            {"menu.navigation.name", "Navigci"},
            {"menu.navigation.mnemonic", new Character ('N')},

            {"menu.zoom.name", "Mretezs"},
            {"menu.zoom.mnemonic", new Character ('M')},

            {"menu.help.name", "Sg"},
            {"menu.help.mnemonic", new Character ('S')},

            {"file.save.pdfdescription", "PDF dokumentumok"},
            {"statusline.pages", "Oldal: {0}/{1}"},
            {"statusline.error", "A lista generlsakor hiba lpett fel: {0}"},
            {"statusline.repaginate", "Szmtom az oldaltrseket, krlek vrj."},
            {"error.processingfailed.title", "A lista feldolgozsa nem sikerlt"},
            {"error.processingfailed.message", "A lista ksztse sorn hiba trtnt: {0}"},
            {"error.savefailed.message", "Hiba a PDF fjl mentsekor: {0}"},
            {"error.savefailed.title", "Hiba a mentskor"},
            {"error.printfailed.message", "Hiba a nyomtats sorn: {0}"},
            {"error.printfailed.title", "Hiba a nyomtatskor"},
            {"error.validationfailed.message", "Hiba a az adatbevitel ellenrzsekor."},
            {"error.validationfailed.title", "Hiba az ellenrzskor"},

            {"tabletarget.page", "Oldal: {0}"},

            {"pdfsavedialog.dialogtitle", "Lista mentse PDF-fjlba ..."},
            {"pdfsavedialog.filename", "Fjlnv"},
            {"pdfsavedialog.author", "Szerz"},
            {"pdfsavedialog.title", "Cm"},
            {"pdfsavedialog.selectFile", "Vlassz egy fjlt"},
            {"pdfsavedialog.security", "Biztonsgi belltsok s titkosts"},
            {"pdfsavedialog.encoding", "Karakterkdols"},

            {"pdfsavedialog.securityNone", "Nincs titkosts"},
            {"pdfsavedialog.security40bit", "Titkostsd 40 bites kulccsal"},
            {"pdfsavedialog.security128bit", "Titkostsd 128 bites kulccsal"},
            {"pdfsavedialog.userpassword", "Felhasznli jelsz"},
            {"pdfsavedialog.userpasswordconfirm", "Megersts"},
            {"pdfsavedialog.userpasswordNoMatch", "A jelsz nem egyezik"},
            {"pdfsavedialog.ownerpassword", "Tulajdonos jelsz"},
            {"pdfsavedialog.ownerpasswordconfirm", "Megersts"},
            {"pdfsavedialog.ownerpasswordNoMatch", "A tulajdonosi jelsz nem egyezik."},
            {"pdfsavedialog.ownerpasswordEmpty", "A tulajdonosi jelsz res. A felhasznlk "
             + "megvltoztathatjk a biztonsgi megszortsokat. Folytathatom?" },

            {"pdfsavedialog.warningTitle", "Figyelmeztets"},
            {"pdfsavedialog.errorTitle", "Hiba"},
            {"pdfsavedialog.targetIsEmpty", "Krlek nevezd el a pdf fjlt."},
            {"pdfsavedialog.targetIsNoFile", "A kivlasztott cl nem fjl."},
            {"pdfsavedialog.targetIsNotWritable", "A kivlasztott fjl nem rhat."},
            {"pdfsavedialog.targetOverwriteConfirmation",
                "A(z) ''{0}'' fjl ltezik. Fellrhatom?"},
            {"pdfsavedialog.targetOverwriteTitle", "Fellrhatom a fjlt?"},


            {"pdfsavedialog.allowCopy", "Msols engedlyezse"},
            {"pdfsavedialog.allowPrinting", "Nyomtats engedlyezse"},
            {"pdfsavedialog.allowDegradedPrinting", "Gyenge minsg nyomtats engedlyezse"},
            {"pdfsavedialog.allowScreenreader", "Kpolvask hasznlatnak engedlyezse"},
            {"pdfsavedialog.allowAssembly", "(jra-)szerkeszs engedlyezse"},
            {"pdfsavedialog.allowModifyContents", "Tartalom mdostsnak engedlyezse"},
            {"pdfsavedialog.allowModifyAnnotations", "Megjegyzsek mdostsnak engedlyezse"},
            {"pdfsavedialog.allowFillIn", "Kitltsek engedlyezse formanyomtatvnyban"},

            {"pdfsavedialog.option.noprinting", "Nem nyomtathat"},
            {"pdfsavedialog.option.degradedprinting", "Alacsony minsg nyomtats"},
            {"pdfsavedialog.option.fullprinting", "Nyomtats engedlyezve"},

            {"pdfsavedialog.cancel", "Megszakt"},
            {"pdfsavedialog.confirm", "Jvhagy"},

            {"excelexportdialog.dialogtitle", "A lista exportlsa Excel fjlba ..."},
            {"excelexportdialog.filename", "Fjlnv"},
            {"excelexportdialog.author", "Szerz"},
            {"excelexportdialog.title", "Cm"},
            {"excelexportdialog.selectFile", "Vlassz egy fjlt"},

            {"excelexportdialog.warningTitle", "Figyelmeztets"},
            {"excelexportdialog.errorTitle", "Hiba"},
            {"excelexportdialog.targetIsEmpty", "Krlek nevezd el az Excel fjlt."},
            {"excelexportdialog.targetIsNoFile", "A kivlasztott cl nem fjl."},
            {"excelexportdialog.targetIsNotWritable", "A kivlasztott fjl nem rhat."},
            {"excelexportdialog.targetOverwriteConfirmation",
                "A(z) ''{0}'' fjl ltezik. Fellrhatom?"},
            {"excelexportdialog.targetOverwriteTitle", "Fellrhatom a fjlt?"},

            {"excelexportdialog.cancel", "Megszakt"},
            {"excelexportdialog.confirm", "Jvhagy"},
            {"excelexportdialog.strict-layout", "Pontos tblamegjelents az exportlskor."},

            {"htmlexportdialog.dialogtitle", "A lista exportlsa Html fjlba ..."},

            {"htmlexportdialog.filename", "Fjlnv"},
            {"htmlexportdialog.datafilename", "Adatknyvtr"},
            {"htmlexportdialog.copy-external-references", "Kls hivatkozsok msolsa"},

            {"htmlexportdialog.author", "Szerz"},
            {"htmlexportdialog.title", "Cm"},
            {"htmlexportdialog.encoding", "Karakterkdols"},
            {"htmlexportdialog.selectZipFile", "Vlassz egy fjlt"},
            {"htmlexportdialog.selectStreamFile", "Vlassz egy fjlt"},
            {"htmlexportdialog.selectDirFile", "Vlassz egy fjlt"},

            {"htmlexportdialog.strict-layout", "Pontos tblamegjelents az exportlskor."},
            {"htmlexportdialog.generate-xhtml", "XHTML 1.0 kimenet generlsa"},
            {"htmlexportdialog.generate-html4", "HTML 4.0 kimenet generlsa"},

            {"htmlexportdialog.warningTitle", "Figyelmeztets"},
            {"htmlexportdialog.errorTitle", "Hiba"},
            {"htmlexportdialog.targetIsEmpty", "Krlek nevezd el a Html fjlt."},
            {"htmlexportdialog.targetIsNoFile", "A kivlasztott cl nem fjl."},
            {"htmlexportdialog.targetIsNotWritable", "A kivlasztott fjl nem rhat."},
            {"htmlexportdialog.targetOverwriteConfirmation",
                "A(z) ''{0}'' fjl ltezik. Fellrhatom?"},
            {"htmlexportdialog.targetOverwriteTitle", "Fellrhatom a fjlt?"},

            {"htmlexportdialog.cancel", "Megszakt"},
            {"htmlexportdialog.confirm", "Jvhagy"},
            {"htmlexportdialog.targetPathIsAbsolute",
                "A megadott elrsi t egy abszolt knyvtrhivatkozs.\n"
                + "Krlek adj meg egy adatknyvtrat a ZIP fjlon bell."},
            {"htmlexportdialog.targetDataDirIsNoDirectory", 
                "A megadott adatknyvtr nem rvnyes."},
            {"htmlexportdialog.targetCreateDataDirConfirmation",
                "A megadott adatknyvtr nem ltezik.\n" 
                + "Hozzam ltre a hinyz alknyvtrakat?"},
            {"htmlexportdialog.targetCreateDataDirTitle", "Hozzam ltre az adatknytrat?"},

            {"csvexportdialog.dialogtitle", "A lista exportlsa CSV fjlba ..."},
            {"csvexportdialog.filename", "Fjlnv"},
            {"csvexportdialog.encoding", "Karakterkdols"},
            {"csvexportdialog.separatorchar", "Elvlaszt karakter"},
            {"csvexportdialog.selectFile", "Vlassz egy fjlt"},

            {"csvexportdialog.warningTitle", "Figyelmeztets"},
            {"csvexportdialog.errorTitle", "Hiba"},
            {"csvexportdialog.targetIsEmpty", "Krlek nevezd el a CSV fjlt."},
            {"csvexportdialog.targetIsNoFile", "A kivlasztott cl nem fjl."},
            {"csvexportdialog.targetIsNotWritable", "A kivlasztott fjl nem rhat."},
            {"csvexportdialog.targetOverwriteConfirmation",
                "A(z) ''{0}'' fjl ltezik. Fellrhatom?"},
            {"csvexportdialog.targetOverwriteTitle", "Fellrhatom a fjlt?"},

            {"csvexportdialog.cancel", "Megszakt"},
            {"csvexportdialog.confirm", "Jvhagy"},

            {"csvexportdialog.separator.tab", "Tabultor"},
            {"csvexportdialog.separator.colon", "Vessz (,)"},
            {"csvexportdialog.separator.semicolon", "Pontosvessz (;)"},
            {"csvexportdialog.separator.other", "Ms"},

            {"csvexportdialog.exporttype", "Exportls mdja"},
            {"csvexportdialog.export.data", "Adatsor exportlsa (Nyers adat)"},
            {"csvexportdialog.export.printed_elements", "Nyomtatott elemek exportlsa (Megjelentett adatok)"},
            {"csvexportdialog.strict-layout", "Pontos tblamegjelents az exportlskor."},


            {"plain-text-exportdialog.dialogtitle", "A lista exportlsa egyszer szveges fjlba..."},
            {"plain-text-exportdialog.filename", "Fjlnv"},
            {"plain-text-exportdialog.encoding", "Karakterkdols"},
            {"plain-text-exportdialog.printer", "Nyomtat tpusa"},
            {"plain-text-exportdialog.printer.plain", "Egyszer szveges kimenet"},
            {"plain-text-exportdialog.printer.epson", "Epson ESC/P kompatibilis"},
            {"plain-text-exportdialog.printer.ibm", "IBM kompatibilis"},
            {"plain-text-exportdialog.selectFile", "Vlassz egy fjlt"},

            {"plain-text-exportdialog.warningTitle", "Figyelmeztets"},
            {"plain-text-exportdialog.errorTitle", "Hiba"},
            {"plain-text-exportdialog.targetIsEmpty", 
                "Krlek nevezd el a CSV fjlt."},
            {"plain-text-exportdialog.targetIsNoFile", "A kivlasztott cl nem fjl."},
            {"plain-text-exportdialog.targetIsNotWritable", "A kivlasztott fjl nem rhat."},
            {"plain-text-exportdialog.targetOverwriteConfirmation",
                "A(z) ''{0}'' fjl ltezik. Fellrhatom?"},
            {"plain-text-exportdialog.targetOverwriteTitle", "Fellrhatom a fjlt?"},

            {"plain-text-exportdialog.cancel", "Megszakt"},
            {"plain-text-exportdialog.confirm", "Jvhagy"},

            {"plain-text-exportdialog.chars-per-inch", "cpi (Karakter per inch)"},
            {"plain-text-exportdialog.lines-per-inch", "lpi (Sor per inch)"},
            {"plain-text-exportdialog.font-settings", "Betttpus belltsok"},

            {"convertdialog.targetIsEmpty", "A clllomny nincs megadva"},
            {"convertdialog.errorTitle", "Hiba"},
            {"convertdialog.targetIsNoFile", "A megadott cl nem fjl." },
            {"convertdialog.targetIsNotWritable", "A megadott fjl nem rhat."},
            {"convertdialog.targetOverwriteConfirmation",
                "A(z) ''{0}'' fjl ltezik. Fellrhatom?"},
            {"convertdialog.targetOverwriteTitle", "Fellrhatom a fjlt?"},
            {"convertdialog.targetFile", "Cl fjl"},
            {"convertdialog.sourceIsEmpty", "A forrs fjl nincs megadva"},
            {"convertdialog.sourceIsNoFile", "A megadott forrs nem kznsges fjl."},
            {"convertdialog.sourceIsNotReadable", "A forrsfjl nem olvashat."},
            {"convertdialog.sourceFile", "Forrs fjl"},

            {"convertdialog.action.selectTarget.name", "Vlassz"},
            {"convertdialog.action.selectTarget.description", "Vlassz cl fjlt."},
            {"convertdialog.action.selectSource.name", "Vlassz"},
            {"convertdialog.action.selectSource.description", "Vlassz forrs fjlt."},
            {"convertdialog.action.convert.name", "Konvertls"},
            {"convertdialog.action.convert.description", "Konvertld a forrs fjlokat."},

            {"convertdialog.title", "Lista konvertl"},

      };

  /**
   * Debugging method, prints all defined contents.
   *
   * @param args not used
   */
  public static void main (String [] args)
  {
    ResourceCompareTool.main(new String[]{"hu"});
  }
  
}
