package com.clarkware.junitperf;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * The <code>ExampleResponseTimeUnderLoadTest</code> demonstrates how to 
 * decorate a <code>TimedTest</code> as a <code>LoadTest</code> to measure 
 * response time under load.
 *
 * @author <a href="mailto:mike@clarkware.com">Mike Clark</a>
 * @author <a href="http://www.clarkware.com">Clarkware Consulting, Inc.</a>
 *
 * @see com.clarkware.junitperf.LoadTest
 * @see com.clarkware.junitperf.TimedTest
 */

public class ExampleResponseTimeUnderLoadTest {

    public static Test suite() {
     
        int maxUsers = 10;
        long maxElapsedTime = 1050;
        
        Test testCase = new ExampleTestCase("testOneSecondResponse");
        Test timedTest = new TimedTest(testCase, maxElapsedTime);
        Test loadTest = new LoadTest(timedTest, maxUsers);
 
        TestSuite suite = new TestSuite();
        suite.addTest(loadTest);
        
        return suite;
    }
    
    public static void main(String args[]) {
        junit.textui.TestRunner.run(suite());
    }
}
