#!/usr/bin/perl

# Copyright 1998 by Marco Budde (Budde@tu-harburg.de)
# GNU GPL license



%config = ( "c't - magazin fr computer technik", 
               "/var/lib/heise-register/ct.cti",
            "iX", "/var/lib/heise-register/ix.cti",
            "Gateway", "/var/lib/heise-register/gw.cti",
            "Elrad", "/var/lib/heise-register/el.cti" );

#  c't - 12/83 bis 17/98
#  iX  - 11/88 bis 2/98
#  Gateway - 94 bis 97
#  Elrad - 1/93 bis 6/97

####################################
# some subroutines for cgi parsing #
####################################

sub url_decode 
{
    my $input = shift;
    $input =~ s/\+/ /g;
    $input =~ s/%([0-9A-Fa-f-]{2})/pack("C", hex($1))/eg;
    if ($input =~ /^([-\@\w.]+)$/)                 # anti hacker test
    {
      return $1;
    }
    else   
    {
      print "<H1>Fehler</H1>\n";
      print "<B>Fehler: </B>Ihre Suchanfrage enthlt nicht zulssige ";
      print "Zeichen.\n</BODY></HTML>\n";
      exit;
    }
}

sub parse_cgi
{
    my $input = shift;
    my %FORM;
    my (@PAIRS, $pair);

    @PAIRS = split (/&/, $input);
    foreach $pair (@PAIRS) 
    {
      ($key, $value) = split (/=/, $pair);
      $key = &url_decode ($key);
      $value = &url_decode ($value);
      if (defined $FORM {$key})
      {
	  $FORM {$key} .= "\0" . $value;
      }
    else
    {
	$FORM {$key} = $value;
    }
  }

    return %FORM;
}


###########################
#  parse the index files  #
###########################

sub parse_cti
{
    $cti{'head1'} = <INCTI>;
    $cti{'head2'} = <INCTI>;
    $cti{'autor'} = <INCTI>;
    chop $cti{'autor'};
    $cti{'autor_k'} = <INCTI>;
    chop $cti{'autor_k'};
    $cti{'seite'} = <INCTI>;
    $cti{'monat'} = <INCTI>;
    chop $cti{'monat'}; 
    $cti{'jahr'} = <INCTI>;
    $cti{'jahr'} =~ /[a-x](.*)/i;
    $cti{'jahr'} = $1;
    my $zw = <INCTI>;
    $cti{'stichworte'} = <INCTI>;
}


####################
#  output results  #
####################

sub html_head
{
    print "<TR BGCOLOR=#000090>\n";
    print "  <TD COLSPAN=4><FONT COLOR=#FFFFFF SIZE=+2>\n";
    print "  <CENTER><b>$datei</b></CENTER></FONT>\n";
    print "<TR BGCOLOR=#000090><TH><FONT COLOR=#FFFFFF>Titel</FONT>\n";
    print "                    <TH><FONT COLOR=#FFFFFF>Autor</FONT>\n";
    print "                    <TH><FONT COLOR=#FFFFFF>Ausgabe</FONT>\n";
    print "                    <TH><FONT COLOR=#FFFFFF>Seite</FONT>\n";
}

sub html_output
{
    printf ("<TR VALIGN=top><TD><B>%s</B><BR>", $cti{'head1'});
    printf ("%s", $cti{'head2'});
    printf ("    <TD>%s ", $cti{'autor'});
    printf (" (%s)\n", $cti{'autor_k'}) if ($cti{'autor_k'} ne "");
    printf ("    <TD>%s/%s", $cti{'monat'}, $cti{'jahr'});
    printf ("	 <TD>%s", $cti{'seite'});
}

sub html_tail
{
    print "<TR><TD>\n";
}


############
#   main   #
############

$start_zeit = time;

print "Content-type: text/html\n\n";
print "<HTML>\n<HEAD>\n";
print "<TITLE>Suche in Magazinen vom Heise Verlag</TITLE>\n";
print "</HEAD>\n<BODY BGCOLOR=#FFFFFF>\n";
%FORM = &parse_cgi ($ENV {'QUERY_STRING'});

print "<H1>Suche nach: $FORM{'search'}</H1>";

print "<TABLE>\n";

foreach $datei (keys %config)
{
  &html_head;
  open (INCTI, "< $config{$datei}");
  $hit = 0;
  
  while (&parse_cti)
  { 
    if ($cti{'stichworte'} =~ /$FORM{'search'}/ or
        $cti{'head1'} =~ /$FORM{'search'}/ or
        $cti{'head2'} =~ /$FORM{'search'}/ or
        $cti{'autor'} =~ /$FORM{'search'}/)
    {
      &html_output;
      $hit = 1;
    }
  }

  print "<TR><TD COLSPAN=4>kein Treffer" if ($hit eq 0);
 
  close (INCTI);
  &html_tail;
}

print "</TABLE>";

$zeit = time - $start_zeit;
print "<HR NOSHADE><EM>bentigte Zeit: ", $zeit, " Sekunden</EM>\n";

print "</BODY>\n</HTML>\n";
