.TH SUNCLOCK 1 "Apr 07, 1999"
.SH NAME
sunclock \- show illuminated portion of Earth
.SH SYNOPSIS
.B sunclock
[
.I options
]
.SH DESCRIPTION
.I sunclock
is an X11 application that displays a map of the Earth and
indicates the illuminated portion of the globe by drawing
sunlit areas dark on light, night areas as light on dark.
It also displays the current date and time. It is possible to define locations
on the main map that will display a place name. If the user clicks on one of
these places the time display will change to the timezone of that location.
.SH OPTIONS
The program does not use the X Toolkit, and hence only those
options explicitly enumerated below may be used.  Neither are
any resources used.
.TP
.B \-version
Show program version and patch level, and then exit.
.TP
.BI "\-display " dispname
Give the name of the X server to contact.
.TP
.B \-iconic
Start iconic.  Usually you will want to specify this option.
.TP
.BI "\-geometry " +x+y
Specify the position of the window.  Only the position is used; any size
information given is ignored.
.TP
.BI "\-icongeometry " +x+y
Specify the position of the icon.  Only the position is used; any size
information given is ignored.
.TP
.BI "\-animateicon"
.TP
.BI "\-a"
Animate the icon by continuous scrolling.  Many window managers permit
only a fixed icon size of 64x64 pixels.  This option makes the whole
icon map visible over time.
.TP
.BI "\-fg " Colour
Set the foreground colour to 'Colour'.  This is the colour which is used
to draw the map outline in the daylight areas.
.TP
.BI "\-bg " Colour
Set the background colour to 'Colour'. This is the colour which is used
for the background in the daylight areas.  Night areas are shown with
foreground and background colours reversed.
.RE
.PP
Users may keep a file in their home directory called ~/.sunclockrc. This
file can contain lines of the following format:
.PP
[+]name latitude longitude timezone
.PP
where name is the ascii name of the place to be shown on the map. If
the name starts with a '+', the label will be displayed above the dot
instead of below. latitude and longitude are floating point numbers
representing the geographical location of the place. Western
longitudes and southern latitudes should be entered as negative
numbers. timezone is the name of the timezone that the place is
in. This should be the name of a file under /usr/share/zoneinfo;
incorrect timezones cause the clock to display GMT. It is also
possible to reference a file in a directory relative to
/usr/share/zoneinfo, for example Canada/Eastern instead of EST5EDT.
.PP
The user may click on the dot on the map associated with a place
defined in the .sunclockrc
file. When this is done, the time displayed will now be shown in the timezone
for that location.
.SH "HOW IT WORKS"
.I sunclock
calculates the position of the Sun using the algorithm in chapter 18 of:
.PP
.I "Astronomical Formulae for Calculators"
by Jean Meeus, Third Edition, Richmond: Willmann-Bell, 1985.
.PP
and Mercator projects the illuminated area onto map image.  The
Sun's position is calculated to better than one arc-second
in accuracy.
.SH BUGS
The maps are not rescaled if you resize the open window or icon.  (I don't want
to have to store a vector database for the map.)  The program contravenes
section 4.1.9 of the ICCCM in that its icon window is a fixed size, and any
WM_ICON_SIZE property of the root window is ignored.
.PP
The illuminated area shown is the area which would be sunlit
if the Earth had no atmosphere.  The actual illuminated area is
larger because of atmospheric refraction and twilight.
.SH AUTHOR
John Mackin, Basser Department of Computer Science, University of Sydney,
Sydney, Australia; <john@cs.su.oz.AU>.  Based on a Suntools program
by John Walker, Autodesk, Inc.; <kelvin@acad.uu.NET>.
.PP
Stephen Martin, Fujitsu Systems Business of Canada, smartin@fujitsu.ca;
added support for interactive map.
.PP
Wolfram Gloger, wmglo@dent.med.uni-muenchen.de;
added animation of icon, miscellaneous minor fixes.
