/***************************************************************************
 *
 * $Header: /home/werner/ytree/RCS/dirwin.c,v 1.13 1998/05/10 20:02:24 werner Rel $
 *
 * Funktionen zur Handhabung des DIR-Windows
 *
 ***************************************************************************/


#include "ytree.h"


#define MIN( a, b ) ( ( (a) < (b) ) ? (a) : (b) )
#define MAX( a, b ) ( ( (a) > (b) ) ? (a) : (b) )



static DirEntryList *dir_entry_list;
static int current_dir_entry;
static int total_dirs;

static void ReadDirList(DirEntry *dir_entry);
static void PrintDirEntry(WINDOW *win, int entry_no, int y, unsigned char hilight);
static void DisplayTree(WINDOW *win, int start_entry_no, int hilight_no);
static void BuildDirEntryList(DirEntry *dir_entry);

static int dir_mode;


static void BuildDirEntryList(DirEntry *dir_entry)
{
  if( dir_entry_list ) 
  {
    free( dir_entry_list );
    dir_entry_list = NULL;
  }

  /* fuer !ANSI-Systeme.. */
  /*----------------------*/
  
  if( statistic.disk_total_directories == 0 )
  {
    dir_entry_list = NULL;
  }
  else
  {
    if( ( dir_entry_list = ( DirEntryList *) 
		             calloc( statistic.disk_total_directories,
	        	     sizeof( DirEntryList )
		           ) ) == NULL )
    {
      ERROR_MSG( "Calloc Failed*ABORT" );
      exit( 1 );
    }
  }

  current_dir_entry = 0;

  ReadDirList( dir_entry );

  total_dirs = current_dir_entry;

}

static void RotateDirMode(void)
{
  switch( dir_mode )
  {
    case MODE_1: dir_mode = MODE_2 ; break;
    case MODE_2: dir_mode = MODE_4 ; break;
    case MODE_3: dir_mode = MODE_1 ; break;
    case MODE_4: dir_mode = MODE_3 ; break;
  }
  if( (mode != DISK_MODE ) && 
      dir_mode == MODE_4 ) RotateDirMode();
}



static void ReadDirList(DirEntry *dir_entry)
{
  DirEntry    *de_ptr;
  static int  level = 0;
  static unsigned long indent = 0L;

  for( de_ptr = dir_entry; de_ptr; de_ptr = de_ptr->next )
  {
    indent &= ~( 1L << level );
    if( de_ptr->next ) indent |= ( 1L << level );

    dir_entry_list[current_dir_entry].dir_entry = de_ptr;
    dir_entry_list[current_dir_entry].level = (unsigned short) level;
    dir_entry_list[current_dir_entry].indent = indent;

    current_dir_entry++;
   
    if( !de_ptr->not_scanned && de_ptr->sub_tree ) 
    {
      level++;
      ReadDirList( de_ptr->sub_tree );
      level--;
    }
  }
}





static void PrintDirEntry(WINDOW *win, 
                          int entry_no, 
                          int y, 
                          unsigned char hilight)
{
  unsigned int j;
  int n; 
  int aux=0;
  int color, hi_color;
  char buffer[32*3+PATH_LENGTH+1];
  char format[60];
  char *line_buffer = NULL;
  char *dir_name;
  char attributes[11];
  char modify_time[13];
  char change_time[13];
  char access_time[13];
  char owner[OWNER_NAME_MAX + 1];
  char group[GROUP_NAME_MAX + 1];
  char *owner_name_ptr;
  char *group_name_ptr;
  DirEntry *de_ptr;


  if(win == f2_window) {
    color     = HST_COLOR;
    hi_color  = HIHST_COLOR;
  } else {
    color     = DIR_COLOR;
    hi_color  = HIDIR_COLOR;
  }
  buffer[0] = '\0';

  for(j=0; j < dir_entry_list[entry_no].level; j++) 
  {
    if( dir_entry_list[entry_no].indent & ( 1L << j ) )
      (void) strcat( buffer, "|  " );
    else
      (void) strcat( buffer, "   " );
  }
  de_ptr = dir_entry_list[entry_no].dir_entry;
  if( de_ptr->next )
    (void) strcat( buffer, "6--" );
  else
    (void) strcat( buffer, "3--" );

  switch( dir_mode )
  {
    case MODE_1 : 
                 (void)GetAttributes(de_ptr->stat_struct.st_mode, attributes);
                 (void)CTime( de_ptr->stat_struct.st_mtime, modify_time );
                 if ((line_buffer = (char *) malloc(36)) == NULL)
                 {
                    ERROR_MSG("malloc() Failed*Abort");
                    exit(1);
                 }
                 (void) strcpy( format, "%10s %3d %7d %12s");
                 (void) sprintf( line_buffer, format, attributes,
                                 de_ptr->stat_struct.st_nlink,
                                 de_ptr->stat_struct.st_size,
                                 modify_time
                                 );
                 aux = 36;
		 break;
    case MODE_2 :
                 (void)GetAttributes(de_ptr->stat_struct.st_mode, attributes);
                 owner_name_ptr = GetPasswdName(de_ptr->stat_struct.st_uid);
                 group_name_ptr = GetGroupName(de_ptr->stat_struct.st_gid);
                 if( owner_name_ptr == NULL )
                 {
                    (void)sprintf(owner,"%d",(int)de_ptr->stat_struct.st_uid);
                    owner_name_ptr = owner;
                 }
                 if( group_name_ptr == NULL )
                 {
                     (void) sprintf( group, "%d", (int) de_ptr->stat_struct.st_gid );
                     group_name_ptr = group;
                 }
                 if ((line_buffer = (char *) malloc(37)) == NULL)
                 {
                    ERROR_MSG("malloc() Failed*Abort");
                    exit(1);
                 }
                 (void) strcpy( format, "%10s %6d  %-8s %-8s");
                 (void) sprintf( line_buffer, format, 
                                 attributes, 
                                 de_ptr->stat_struct.st_ino, 
                                 owner_name_ptr,         
                                 group_name_ptr);
                 aux = 37;
                 break;
    case MODE_3 : aux = 0;
		  break;
    case MODE_4 : 
                 (void) CTime( de_ptr->stat_struct.st_ctime, change_time );
                 (void) CTime( de_ptr->stat_struct.st_atime, access_time );
                 (void) strcpy( format, "Chg.: %12s  Acc.: %12s");
                 if ((line_buffer = (char *) malloc(38+1)) == NULL)
                 {
                    ERROR_MSG("malloc() Failed*Abort");
                    exit(1);
                 }
                 (void)sprintf(line_buffer, format, change_time, access_time);
                 aux = 38;
                 break;
  }
  
  WbkgdSet(win, COLOR_PAIR(color)| A_BOLD );
  if (line_buffer)
     mvwaddstr(win, y, 0, line_buffer );
  n = (int) strlen( buffer );
  n = DIR_WINDOW_WIDTH - n - aux - 1;
  if (n > 1)
     PrintSpecialString( win, y, aux, buffer, color );
  else
     n = DIR_WINDOW_WIDTH - aux ;
/*     PrintSpecialString( win, y, aux, " ===== ", A_REVERSE );*/
  dir_name = de_ptr->name;
  (void) strcpy( buffer, ( *dir_name ) ? dir_name : "." );
  if( de_ptr->not_scanned ) {
    (void) strcat( buffer, "/" );
  }
  /* Scrollbares Dir-Window noch nicht implementiert... Sorry */
  /*----------------------------------------------------------*/
  aux = n;
  n = strlen(buffer);
  buffer[(n > aux) ? aux : n] = '\0';

#ifdef NO_HIGHLIGHT
  (void) strcat( buffer, (hilight) ? " <" : "  " ); 
#else /* NO_HIGHLIGHT */
#ifdef COLOR_SUPPORT
  if( hilight ) 
    WbkgdSet(win, COLOR_PAIR(hi_color)|A_BOLD);
  else
    WbkgdSet(win, COLOR_PAIR(color));

  waddstr( win, buffer );
  WbkgdSet(win, COLOR_PAIR(color)|A_BOLD);

#else
  if( hilight ) wattrset( win, A_REVERSE );
  waddstr( win, buffer );
  if( hilight ) wattrset( win, 0 );
#endif /* COLOR_SUPPORT */
#endif /* NO_HIGHLIGHT */
  if (line_buffer)
     free(line_buffer);
}




static void DisplayTree(WINDOW *win, int start_entry_no, int hilight_no)
{
  int i, y;
  int width, height;
 
  y = -1;
  GetMaxYX(win, &height, &width);
  for(i=0; i < height; i++)
  {
    wmove(win, i, 0);
    wclrtoeol(win); 
  }

  for(i=0; i < height; i++)
  {
    if( start_entry_no + i >= statistic.disk_total_directories ) break;
 
    if( start_entry_no + i != hilight_no )
      PrintDirEntry( win, start_entry_no + i, i, FALSE );
    else
      y = i;
  }

  if( y >= 0 ) PrintDirEntry( win, start_entry_no + y, y, TRUE );
  
}

static void Movedown(int *disp_begin_pos, int *cursor_pos, DirEntry **dir_entry)
{
   if( *disp_begin_pos + *cursor_pos + 1 >= total_dirs )
   {
      /* Element nicht vorhanden */
      /*-------------------------*/
      beep();
   }
   else
   {
      /* Element vorhanden */
      /*-------------------*/
      if( *cursor_pos + 1 < DIR_WINDOW_HEIGHT )
      {
          /* Element ist ohne scrollen erreichbar */
          /*--------------------------------------*/
          PrintDirEntry( dir_window,
                         *disp_begin_pos + *cursor_pos, 
                         *cursor_pos,
                         FALSE
                         );
          (*cursor_pos)++;
          PrintDirEntry( dir_window,
                         *disp_begin_pos + *cursor_pos,
                         *cursor_pos,
                         TRUE
                         );
      }
      else
      {
          /* Es muss gescrollt werden */
          /*--------------------------*/
          PrintDirEntry( dir_window,
                         *disp_begin_pos + *cursor_pos, 
                         *cursor_pos,
                         FALSE
                         );
          scroll( dir_window );
          (*disp_begin_pos)++;
          PrintDirEntry( dir_window,
                         *disp_begin_pos + *cursor_pos, 
                         *cursor_pos,
                         TRUE
                         );
      }
      *dir_entry = dir_entry_list[*disp_begin_pos + *cursor_pos].dir_entry;
      DisplayFileWindow( *dir_entry, 0, -1 );
      wnoutrefresh( file_window );
   }
   return;
}


static void Moveup(int *disp_begin_pos, int *cursor_pos, DirEntry **dir_entry)
{
   if( *disp_begin_pos + *cursor_pos - 1 < 0 )
   {
      /* Element nicht vorhanden */
      /*-------------------------*/
      beep();
   }
   else
   {
      /* Element vorhanden */
      /*-------------------*/
      if( *cursor_pos - 1 >= 0 )
      {
         /* Element ist ohne scrollen erreichbar */
         /*--------------------------------------*/
         PrintDirEntry( dir_window,
                        *disp_begin_pos + *cursor_pos, 
                        *cursor_pos,
                        FALSE
                        );
         (*cursor_pos)--;
         PrintDirEntry( dir_window,
                        *disp_begin_pos + *cursor_pos,
                        *cursor_pos,
                        TRUE
                        );
      }
      else
      {
          /* Es muss gescrollt werden */
          /*--------------------------*/
          PrintDirEntry( dir_window,
                         *disp_begin_pos + *cursor_pos, 
                         *cursor_pos,
                         FALSE
                         );
          wmove( dir_window, 0, 0 );
          winsertln( dir_window );
          (*disp_begin_pos)--;
          PrintDirEntry( dir_window,
                         *disp_begin_pos + *cursor_pos, 
                         *cursor_pos,
                         TRUE
                         );
      }
      *dir_entry = dir_entry_list[*disp_begin_pos + *cursor_pos].dir_entry;
      DisplayFileWindow( *dir_entry, 0, -1 );
      wnoutrefresh( file_window );
   }
   return;
}


static void Movenpage(int *disp_begin_pos, int *cursor_pos, DirEntry **dir_entry)
{
   if( *disp_begin_pos + *cursor_pos >= total_dirs - 1 )
   {
      /* Letzte Position */
      /*-----------------*/
      beep();
   }
   else
   {
      if( *cursor_pos < DIR_WINDOW_HEIGHT - 1 )
      {
          /* Cursor steht nicht auf letztem Eintrag
           * der Seite
           */
           PrintDirEntry( dir_window,
                          *disp_begin_pos + *cursor_pos, 
                          *cursor_pos,
                          FALSE
                          );
           if( *disp_begin_pos + DIR_WINDOW_HEIGHT > total_dirs  - 1 )
              *cursor_pos = total_dirs - *disp_begin_pos - 1;
           else
              *cursor_pos = DIR_WINDOW_HEIGHT - 1;
           *dir_entry = dir_entry_list[*disp_begin_pos + *cursor_pos].dir_entry;
           DisplayFileWindow( *dir_entry, 0, -1 );
           wnoutrefresh( file_window );
           PrintDirEntry( dir_window,
                          *disp_begin_pos + *cursor_pos, 
                          *cursor_pos,
                          TRUE
                          );
      }
      else
      {
          /* Scrollen */
          /*----------*/
          if( *disp_begin_pos + *cursor_pos + DIR_WINDOW_HEIGHT < total_dirs )
          {
              *disp_begin_pos += DIR_WINDOW_HEIGHT;
              *cursor_pos = DIR_WINDOW_HEIGHT - 1;
          }
          else
          {
              *disp_begin_pos = total_dirs - DIR_WINDOW_HEIGHT;
              if( *disp_begin_pos < 0 ) *disp_begin_pos = 0;
              *cursor_pos = total_dirs - *disp_begin_pos - 1;
          }
          *dir_entry = dir_entry_list[*disp_begin_pos + *cursor_pos].dir_entry;
          DisplayFileWindow( *dir_entry, 0, -1 );
          wnoutrefresh( file_window );
          DisplayTree(dir_window,*disp_begin_pos,*disp_begin_pos+*cursor_pos);
      }
   }
   return;
}

static void Moveppage(int *disp_begin_pos, int *cursor_pos, DirEntry **dir_entry)
{
   if( *disp_begin_pos + *cursor_pos <= 0 )
   {
      /* Erste Position */
      /*----------------*/
      beep();
   }
   else
   {
      if( *cursor_pos > 0 )
      {
          /* Cursor steht nicht auf erstem Eintrag
           * der Seite
           */
           PrintDirEntry( dir_window,
                          *disp_begin_pos + *cursor_pos, 
                          *cursor_pos,
                          FALSE
                          );
           *cursor_pos = 0;
           *dir_entry = dir_entry_list[*disp_begin_pos + *cursor_pos].dir_entry;
           DisplayFileWindow( *dir_entry, 0, -1 );
           wnoutrefresh( file_window );
           PrintDirEntry( dir_window,
                          *disp_begin_pos + *cursor_pos, 
                          *cursor_pos,
                          TRUE
                          );
      }
      else
      {
         /* Scrollen */
         /*----------*/
         if( (*disp_begin_pos -= DIR_WINDOW_HEIGHT) < 0 )
         {
             *disp_begin_pos = 0;
         }
         *cursor_pos = 0;
         *dir_entry = dir_entry_list[*disp_begin_pos + *cursor_pos].dir_entry;
         DisplayFileWindow( *dir_entry, 0, -1 );
         wnoutrefresh( file_window );
         DisplayTree(dir_window,*disp_begin_pos,*disp_begin_pos+*cursor_pos);
      } 
   }
   return;
}


int HandleDirWindow(DirEntry *start_dir_entry,
		    int disp_begin_pos,
		    int cursor_pos
		   )
{
  DirEntry  *dir_entry, *de_ptr;
  FileEntry *fe_ptr;
  int i, ch, unput_char;
  BOOL need_dsp_help;
  char new_name[PATH_LENGTH + 1];
  char new_login_path[PATH_LENGTH + 1];

  unput_char = 0;


  /* Merker loeschen */
  /*-----------------*/

  statistic.disp_begin_pos = 0;
  statistic.cursor_pos     = 0;
  dir_mode = MODE_3;

  need_dsp_help = TRUE;

  BuildDirEntryList( start_dir_entry );
  
  dir_entry = dir_entry_list[disp_begin_pos + cursor_pos].dir_entry;
 
  DisplayDiskStatistic();

  DisplayFileWindow( dir_entry, 0, -1 );
  wnoutrefresh( file_window );
  DisplayTree( dir_window, disp_begin_pos, disp_begin_pos + cursor_pos );
  touchwin(dir_window);

  if( dir_entry->login_flag )
  {
    dir_entry->login_flag = FALSE;
    if( dir_entry->global_flag )
    {
      unput_char = 'S';
    }
    else
    {
      unput_char = CR;
    }
  }
  do
  {
    if( need_dsp_help )
    {
      need_dsp_help = FALSE;
      DisplayDirHelp();
    }
    DisplayDirParameter( dir_entry );
    wnoutrefresh( dir_window );
    if( unput_char )
    {
      ch = unput_char;
      unput_char = '\0';
    }
    else
    {
      doupdate();
      ch = getch();
      if( ch == LF ) ch = CR;
    }
#ifdef VI_KEYS
    ch = ViKey( ch );
#endif /* VI_KEYS */
    switch( ch )
    {
      case ' ':      /*break;   Quick-Key */
      case KEY_DOWN: Movedown(&disp_begin_pos, &cursor_pos, &dir_entry);
                     break;
      case KEY_UP  : Moveup(&disp_begin_pos, &cursor_pos, &dir_entry);
                     break;
      case KEY_NPAGE:Movenpage(&disp_begin_pos, &cursor_pos, &dir_entry);		     
                     break;
      case KEY_PPAGE:Moveppage(&disp_begin_pos, &cursor_pos, &dir_entry);
                     break;
      case KEY_HOME: if( disp_begin_pos == 0 && cursor_pos == 0 )
		     { 
		       /* Position 1 bereits errecht */
		       /*----------------------------*/
		       beep();
		     }
		     else
		     {
		       disp_begin_pos = 0;
		       cursor_pos     = 0;
		       dir_entry = dir_entry_list[disp_begin_pos + cursor_pos].dir_entry;
                       DisplayFileWindow( dir_entry, 0, -1 );
                       wnoutrefresh( file_window );
                       DisplayTree( dir_window, disp_begin_pos, 
				    disp_begin_pos + cursor_pos 
				  );
		     }
                     break;
      case KEY_END : disp_begin_pos = MAX(0, total_dirs - DIR_WINDOW_HEIGHT);
		     cursor_pos     = total_dirs - disp_begin_pos - 1;
		     dir_entry = dir_entry_list[disp_begin_pos + cursor_pos].dir_entry;
                     DisplayFileWindow( dir_entry, 0, -1 );
                     wnoutrefresh( file_window );
                     DisplayTree( dir_window, disp_begin_pos, 
				  disp_begin_pos + cursor_pos 
				);
                     break;
      case KEY_RIGHT:
      case '+':       if( !dir_entry->not_scanned ) {
                        beep();
		      } else {
		        for( de_ptr=dir_entry->sub_tree; de_ptr; de_ptr=de_ptr->next) {
		          GetPath( de_ptr, new_login_path );
		          ReadTree( de_ptr, new_login_path, 0 );
			  SetMatchingParam( de_ptr );
		        }
		        dir_entry->not_scanned = FALSE;
	                BuildDirEntryList( start_dir_entry );
                        DisplayTree( dir_window, disp_begin_pos, 
		                     disp_begin_pos + cursor_pos 
		                   );
			DisplayDiskStatistic();
	                DisplayAvailBytes();
	                need_dsp_help = TRUE;
		      }
	              break;
      case '\t':
      case '*':       ScanSubTree( dir_entry );
	              BuildDirEntryList( start_dir_entry );
                      DisplayTree( dir_window, disp_begin_pos, 
		                   disp_begin_pos + cursor_pos 
		                 );
		      DisplayDiskStatistic();
	              DisplayAvailBytes();
	              need_dsp_help = TRUE;
	              break;
      case KEY_LEFT:
      case '-':
      case KEY_BTAB:  if( dir_entry->not_scanned ||
                         (dir_entry->sub_tree == NULL) ) {
                        beep();
		      } else {
		        for( de_ptr=dir_entry->sub_tree; de_ptr; de_ptr=de_ptr->next) {
		          UnReadTree( de_ptr );
			}
		        dir_entry->not_scanned = TRUE;
	                BuildDirEntryList( start_dir_entry );
                        DisplayTree( dir_window, disp_begin_pos, 
		                     disp_begin_pos + cursor_pos 
		                   );
	                DisplayAvailBytes();
	                need_dsp_help = TRUE;
		      }
	              break;
      case 'F':
      case 'f':      ReadFileSpec();
                     DisplayFileWindow( dir_entry, 0, -1 );
                     wnoutrefresh( file_window );
		     DisplayDiskStatistic();
		     need_dsp_help = TRUE;
                     break;
      case 'T' :
      case 't' :     for(fe_ptr=dir_entry->file; fe_ptr; fe_ptr=fe_ptr->next)
		     {
		       if( fe_ptr->matching ) 
		       {
			 if( !fe_ptr->tagged )
			 {
			   fe_ptr->tagged = TRUE;
	       	           dir_entry->tagged_files++;
		           dir_entry->tagged_bytes += fe_ptr->stat_struct.st_size;
	       	           statistic.disk_tagged_files++;
		           statistic.disk_tagged_bytes += fe_ptr->stat_struct.st_size;
			 }
		       }
		     }
                     DisplayFileWindow( dir_entry, 0, -1 );
                     wnoutrefresh( file_window );
		     DisplayDiskStatistic();
		     break;

      case 'U' :
      case 'u' :     for(fe_ptr=dir_entry->file; fe_ptr; fe_ptr=fe_ptr->next)
		     {
		       if( fe_ptr->matching ) 
		       {
			 if( fe_ptr->tagged )
			 {
			   fe_ptr->tagged = FALSE;
	       	           dir_entry->tagged_files--;
		           dir_entry->tagged_bytes -= fe_ptr->stat_struct.st_size;
	       	           statistic.disk_tagged_files--;
		           statistic.disk_tagged_bytes -= fe_ptr->stat_struct.st_size;
			 }
		       }
		     }
                     DisplayFileWindow( dir_entry, 0, -1 );
                     wnoutrefresh( file_window );
		     DisplayDiskStatistic();
		     break;
      case 'T' & 0x1F :
		     for(i=0; i < total_dirs; i++)
		     {
                       for(fe_ptr=dir_entry_list[i].dir_entry->file; 
			   fe_ptr; 
			   fe_ptr=fe_ptr->next
			  )
		       {
		         if( fe_ptr->matching ) 
		         {
			   if( !fe_ptr->tagged )
			   {
			     fe_ptr->tagged = TRUE;
	       	             dir_entry->tagged_files++;
		             dir_entry->tagged_bytes += fe_ptr->stat_struct.st_size;
	       	             statistic.disk_tagged_files++;
		             statistic.disk_tagged_bytes += fe_ptr->stat_struct.st_size;
			   }
			 }
		       }
		     }
                     DisplayFileWindow( dir_entry, 0, -1 );
                     wnoutrefresh( file_window );
		     DisplayDiskStatistic();
		     break;
      case 'U' & 0x1F :
		     for(i=0; i < total_dirs; i++)
		     {
                       for(fe_ptr=dir_entry_list[i].dir_entry->file; 
			   fe_ptr; 
			   fe_ptr=fe_ptr->next
			  )
		       {
		         if( fe_ptr->matching ) 
		         {
			   if( fe_ptr->tagged )
			   {
			     fe_ptr->tagged = FALSE;
	       	             dir_entry->tagged_files--;
		             dir_entry->tagged_bytes -= fe_ptr->stat_struct.st_size;
	       	             statistic.disk_tagged_files--;
		             statistic.disk_tagged_bytes -= fe_ptr->stat_struct.st_size;
			   }
			 }
		       }
		     }
                     DisplayFileWindow( dir_entry, 0, -1 );
                     wnoutrefresh( file_window );
		     DisplayDiskStatistic();
		     break;
      case 'F' & 0x1F : 
		     RotateDirMode();
                     /*DisplayFileWindow( dir_entry, 0, -1 );*/
                     DisplayTree( dir_window, disp_begin_pos, 
                                  disp_begin_pos + cursor_pos 
                                  );
                     /*wnoutrefresh( file_window );*/
		     DisplayDiskStatistic();
		     need_dsp_help = TRUE;
		     break;
      case 'S':
      case 's':      if( statistic.disk_matching_files )
		     {
		       /* Cursor-Position sichern */
		       /*-------------------------*/
		       statistic.disp_begin_pos = disp_begin_pos;
		       statistic.cursor_pos     = cursor_pos;
		       if( HandleFileWindow( dir_entry, 
					     dir_entry->start_file,
					     dir_entry->cursor_pos,
					     TRUE, TRUE ) != LOGIN_ESC )
		       {
		         DisplayDiskStatistic();
                         DisplayFileWindow( dir_entry, 0, -1 );
                         wnoutrefresh( small_file_window );
                         wnoutrefresh( big_file_window );
		         BuildDirEntryList( start_dir_entry );
                         DisplayTree( dir_window, disp_begin_pos, 
				      disp_begin_pos + cursor_pos 
				    );
			 /* Cursor-Position zuruecksetzen */
		         /*-------------------------------*/
		         statistic.disp_begin_pos = 0;
		         statistic.cursor_pos     = 0;
		       }
		       else
		       {
			 /* wie bei Login */
			 /*---------------*/
		         BuildDirEntryList( statistic.tree );
                         DisplayTree( dir_window, disp_begin_pos, 
				      disp_begin_pos + cursor_pos 
				    );
			 ch = 'L';
		       }
		     }
		     else
		     {
		       beep();
		     }
		     need_dsp_help = TRUE;
		     break;
      case LF :
      case CR :      if( dir_entry->matching_files )
		     {
		       /* Cursor-Position sichern */
		       /*-------------------------*/
		       statistic.disp_begin_pos = disp_begin_pos;
		       statistic.cursor_pos     = cursor_pos;
		       if( HandleFileWindow( dir_entry, 
					     dir_entry->start_file,
					     dir_entry->cursor_pos,
					     dir_entry->global_flag,
					     dir_entry->big_window 
					   ) != LOGIN_ESC )
                       {
			 DisplayFileWindow( dir_entry, 0, -1 );
                         wnoutrefresh( small_file_window );
                         wnoutrefresh( big_file_window );
		         BuildDirEntryList( start_dir_entry );
                         DisplayTree( dir_window, disp_begin_pos, 
				      disp_begin_pos + cursor_pos 
				    );
			 DisplayDiskStatistic();
			 /* Cursor-Position zuruecksetzen */
		         /*-------------------------------*/
		         statistic.disp_begin_pos = 0;
		         statistic.cursor_pos     = 0;
		       }
		       else
		       {
			 /* wie bei Login */
			 /*---------------*/
		         BuildDirEntryList( statistic.tree );
                         DisplayTree( dir_window, disp_begin_pos, 
				      disp_begin_pos + cursor_pos 
				    );
			 ch = 'L';
		       }
		       DisplayAvailBytes();
		       need_dsp_help = TRUE;
		     }
		     else
		     {
		       beep();
		     }
		     break;
      case 'X':
      case 'x':      (void) Execute( dir_entry, NULL );
		     need_dsp_help = TRUE;
		     DisplayAvailBytes();
		     break;
      case 'M':      
      case 'm':      if( !MakeDirectory( dir_entry ) )
		     {
		       BuildDirEntryList( start_dir_entry );
                       DisplayTree( dir_window, disp_begin_pos, 
				    disp_begin_pos + cursor_pos 
				  );
		       DisplayAvailBytes();
		     } 
		     need_dsp_help = TRUE;
		     break;
      case 'D':
      case 'd':      if( !DeleteDirectory( dir_entry ) ) {
		       if( disp_begin_pos + cursor_pos > 0 )
		       {
		         if( cursor_pos > 0 ) cursor_pos--;
		         else disp_begin_pos--;
		       }
      		     }
		     /* Unabhaengig vom Erfolg aktualisieren */
		     BuildDirEntryList( start_dir_entry );
		     dir_entry = dir_entry_list[disp_begin_pos + cursor_pos].dir_entry;
                     DisplayFileWindow( dir_entry, 0, -1 );
                     wnoutrefresh( file_window );
		     DisplayTree( dir_window, disp_begin_pos, 
				  disp_begin_pos + cursor_pos 
				);
		     DisplayAvailBytes();
		     need_dsp_help = TRUE;
		     break;
      case 'r':
      case 'R':      if( !GetRenameParameter( dir_entry->name, new_name ) )
                     {
		       if( !RenameDirectory( dir_entry, new_name ) )
		       {
			 /* Rename OK */
			 /*-----------*/
		         BuildDirEntryList( start_dir_entry );
                         DisplayTree( dir_window, disp_begin_pos, 
				      disp_begin_pos + cursor_pos 
				    );
		         DisplayAvailBytes();
		         dir_entry = dir_entry_list[disp_begin_pos + cursor_pos].dir_entry;
                       }
		     }
		     need_dsp_help = TRUE;
		     break;
      case 'G':
      case 'g':      (void) ChangeDirGroup( dir_entry );
                     DisplayTree( dir_window, disp_begin_pos, disp_begin_pos + cursor_pos );
		     need_dsp_help = TRUE;
		     break;
      case 'O':
      case 'o':      (void) ChangeDirOwner( dir_entry );
                     DisplayTree( dir_window, disp_begin_pos, disp_begin_pos + cursor_pos );
		     need_dsp_help = TRUE;
		     break;
      case 'A':
      case 'a':      (void) ChangeDirModus( dir_entry );
                     DisplayTree( dir_window, disp_begin_pos, disp_begin_pos + cursor_pos );
		     need_dsp_help = TRUE;
		     break;
      case 'Q':
      case 'q':      need_dsp_help = TRUE;
                     break;

#ifndef VI_KEYS
      case 'l':
#endif /* VI_KEYS */
      case 'L':      if( mode != DISK_MODE ) 
		       (void) strcpy( new_login_path, disk_statistic.login_path );
		     else
		       (void) GetPath( dir_entry, new_login_path );
		     if( !GetNewLoginPath( new_login_path ) )
		     {
		       DisplayMenu();
		       doupdate();
		       /* Cursor-Position sichern */
		       /*-------------------------*/
		       statistic.disp_begin_pos = disp_begin_pos;
		       statistic.cursor_pos     = cursor_pos;
		       (void) LoginDisk( new_login_path );
		     }
		     need_dsp_help = TRUE;
		     break;
      case 'L' & 0x1F:
		     clearok( stdscr, TRUE );
		     break;
      default :      beep();
		     break;
    } /* switch */
  } while( (ch != 'q') && (ch != 'Q') && (ch != 'l') && (ch != 'L') );
  return( ch );
}



int ScanSubTree( DirEntry *dir_entry )
{
  DirEntry *de_ptr;
  char new_login_path[PATH_LENGTH + 1];

  if( dir_entry->not_scanned ) {
    for( de_ptr=dir_entry->sub_tree; de_ptr; de_ptr=de_ptr->next) {
      GetPath( de_ptr, new_login_path );
      ReadTree( de_ptr, new_login_path, 999 );
      SetMatchingParam( de_ptr );
    }
    dir_entry->not_scanned = FALSE;
  } else {
    for( de_ptr=dir_entry->sub_tree; de_ptr; de_ptr=de_ptr->next) {
      ScanSubTree( de_ptr );
    }
  }
  return( 0 );
}




int KeyF2Get(DirEntry *start_dir_entry, 
             int disp_begin_pos, 
	     int cursor_pos,
             char *path)
{
  DirEntry  *dir_entry;
  int ch;
  int result = -1;
  int win_width, win_height;


  dir_entry = start_dir_entry;
  GetMaxYX(f2_window, &win_height, &win_width);
  MapF2Window();
  DisplayTree( f2_window, disp_begin_pos, disp_begin_pos + cursor_pos );
  do
  {
    wnoutrefresh( f2_window );
    doupdate();
    ch = getch();
    if( ch == LF ) ch = CR;
  

#ifdef VI_KEYS
    
    ch = ViKey( ch );

#endif /* VI_KEYS */

    switch( ch )
    {
      case ' ':      break;  /* Quick-Key */
      case KEY_DOWN: if( disp_begin_pos + cursor_pos + 1 >= total_dirs )
		     { 
		       beep(); 
		     }
		     else
		     {
		       if( cursor_pos + 1 < win_height )
		       {
			 PrintDirEntry( f2_window, 
			                disp_begin_pos + cursor_pos, 
					cursor_pos, FALSE);
			 cursor_pos++;

			 PrintDirEntry( f2_window, disp_begin_pos + cursor_pos,
					cursor_pos, TRUE);
                       }
		       else
		       {
			 disp_begin_pos++;
                         DisplayTree( f2_window, disp_begin_pos, 
				      disp_begin_pos + cursor_pos);
                       }
		     }
                     break;

      case KEY_UP  : if( disp_begin_pos + cursor_pos - 1 < 0 )
		     { 
		       beep(); 
		     }
		     else
		     {
		       if( cursor_pos - 1 >= 0 )
		       {
			 PrintDirEntry( f2_window,
			                disp_begin_pos + cursor_pos, 
					cursor_pos, FALSE );
			 cursor_pos--;
			 PrintDirEntry( f2_window, 
			                disp_begin_pos + cursor_pos,
					cursor_pos, TRUE );
                       }
		       else
		       {
			 disp_begin_pos--;
                         DisplayTree( f2_window, disp_begin_pos, 
				      disp_begin_pos + cursor_pos);
                       }
		     }
                     break;

      case KEY_NPAGE:
		     if( disp_begin_pos + cursor_pos >= total_dirs - 1 )
		     { 
		       beep(); 
		     }
		     else
		     {
		       if( cursor_pos < win_height - 1 )
		       {
			 PrintDirEntry( f2_window,
			                disp_begin_pos + cursor_pos, 
					cursor_pos, FALSE );
		         if( disp_begin_pos + win_height > total_dirs  - 1 )
			   cursor_pos = total_dirs - disp_begin_pos - 1;
			 else
			   cursor_pos = win_height - 1;
			 PrintDirEntry( f2_window,
			                disp_begin_pos + cursor_pos, 
					cursor_pos, TRUE );
		       }
		       else
		       {
			 if( disp_begin_pos + cursor_pos + win_height < total_dirs )
			 {
			   disp_begin_pos += win_height;
			   cursor_pos = win_height - 1;
			 }
			 else
			 {
			   disp_begin_pos = total_dirs - win_height;
			   if( disp_begin_pos < 0 ) disp_begin_pos = 0;
			   cursor_pos = total_dirs - disp_begin_pos - 1;
			 }
                         DisplayTree( f2_window, disp_begin_pos, 
				      disp_begin_pos + cursor_pos);
		       } 
		     }
                     break;

      case KEY_PPAGE:
		     if( disp_begin_pos + cursor_pos <= 0 )
		     { 
		       beep(); 
		     }
		     else
		     {
		       if( cursor_pos > 0 )
		       {
			 PrintDirEntry( f2_window,
			                disp_begin_pos + cursor_pos, 
					cursor_pos, FALSE );
			 cursor_pos = 0;
			 PrintDirEntry( f2_window,
			                disp_begin_pos + cursor_pos, 
					cursor_pos, TRUE );
		       }
		       else
		       {
			 if( (disp_begin_pos -= win_height) < 0 )
			 {
			   disp_begin_pos = 0;
			 }
                         cursor_pos = 0;
                         DisplayTree( f2_window, disp_begin_pos, 
				      disp_begin_pos + cursor_pos);
		       } 
		     }
                     break;

      case KEY_HOME: if( disp_begin_pos == 0 && cursor_pos == 0 )
		     { beep(); }
		     else
		     {
		       disp_begin_pos = 0;
		       cursor_pos     = 0;
                       DisplayTree( f2_window, disp_begin_pos, 
				    disp_begin_pos + cursor_pos);
		     }
                     break;

      case KEY_END : disp_begin_pos = MAX(0, total_dirs - win_height);
		     cursor_pos     = total_dirs - disp_begin_pos - 1;
                     DisplayTree( f2_window, disp_begin_pos, 
				  disp_begin_pos + cursor_pos);
                     break;

      case LF :
      case CR :
                     GetPath(dir_entry_list[cursor_pos + disp_begin_pos].dir_entry, path);
		     result = 0;
		     break;
      case ESC:
      case 'Q':
      case 'q':      break;

      default :      beep();
		     break;
    } /* switch */
  } while( (ch != 'q') && (ch != ESC) && (ch != 'Q') && (ch != CR) );

  UnmapF2Window();
  return( result );
}



