/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#include "vfu.h"
#include "vfuopt.h"
#include "vfufiles.h"
#include "vfucopy.h"
#include "vfudir.h"
#include "vfuview.h"
#include "vfumenu.h"
#include "vfuuti.h"
#include "vfusys.h"
#include "vfuarc.h"
#include "vfutools.h"
#include "grep.h"

////////////////////////////////////////////////////////////////////////
//
// externals
//

int WorkMode;
char AName[MAX_PATH]; // archive name
int AX; // archive index

TF* Files[MaxFiles];

pathstr_t PresetDir[10];

pathstr_t ExtColors[16] =
                          {
                            "", // cBLACK
                            "", // cBLUE
                            "", // cGREEN
                            ".[].<>.h.c.cpp.cc.cxx.pas.pl.", // cCYAN
                            ".dotfiles.", // cRED
                            ".**.", // cMAGENTA
                            ".uc2.zip.arj.tgz.tar.rar.lzh.j.ha.lim.", // cYELLOW
                            "", // cWHITE
                            "", // cDGRAY
                            ".==.++.().##.", // chBLUE
                            ".txt.TXT.rc.", // chGREEN
                            "", // chCYAN
                            "", // chRED
                            "", // chMAGENTA
                            "", // chYELLOW
                            "", // chWHITE
                          };

char Browser[MAX_PATH] = "less %f";
char Editor [MAX_PATH] = "joe %f" ;

int  draw       = 1;
int  FilesCount = 0;
int  SelCount   = 0;
fsize_t SelSize = 0;
fsize_t AllSize = 0;
fsize_t FSFree  = -1;
fsize_t FSTotal = -1;
fsize_t FSBSize = -1;

TScrollPos FINDEX; // index in the files list

char sss[2048]           = "";
char TargetDir[MAX_PATH] = "";
char CPath[MAX_PATH]     = "";
char SD[MAX_PATH]        = "";
char HOME[MAX_PATH]      = "";
char TEMP[MAX_PATH]      = "";

char FMASK[MAX_PATH]     = "*";
pathstr_t FMASKARRAY[MAX_FMASKS] = {"*","","","","","","","","",""};

char ShellOpt[1024]      = "";
char UIDstr[32]          = "";
char GIDstr[32]          = "";
char HOSTstr[32]         = "";

char SHELL[MAX_PATH]     = "";
char VFUSHELL[MAX_PATH]  = "";

////////////////////////////////////////////////////////////////////////
//
//
//

void say1(const char *o, int attr )
{
  ConOut(1, MAXY-1, o, attr );
  ConCE( attr );
}

void say2(const char *o, int attr )
{
  ConOut(1, MAXY, o, attr );
  ConCE( attr );
}

void DescribeErrno()
{
  sprintf(sss, "errno: %s", strerror(errno));
  say2(sss);
}

void DescribeErrno( const char *format, const char *par1 )
{
  sprintf( sss, format, par1 );
  say1( sss );
  DescribeErrno();
}

void Shell( const char *command, int waitafter, int chdir_back )
{
  char temp[1024];
  char Options[1024] = "";
  int res =  UpdateShellStr( (char*)command, temp, Options);
  StrCutSpc( temp );
  if (temp[0] == 0) res = 3;
  if (res == 3)
    say1("Shell aborted.");
  else
  if (res != 0)
    say1("Error update shell line.");
  if (res != 0) return;

  if (!strchr(Options, 'n'))
    {
    if ( opt.CLSonShell ) ConCS();
    ConXY( 1, 1 );
    ConCShow();
    ConSuspend();
    }

  res = system( temp );
  if ( res != 0 )
    {
    sprintf( sss, "*** execution failed, system() == %d, press enter ***", res );
    printf( sss ); fflush( stdout );
    fgetc( stdin );
    //ConGetch();
    }

  if (strchr( Options, 'w' ) || waitafter)
    {
    printf( "*** press enter ***" ); fflush( stdout );
    fgetc( stdin );
    //ConGetch();
    }

  if (!strchr(Options, 'n'))
    {
    ConRestore();
    ConCHide();
    if ( opt.CLSonShell )
      ConCS();
    }

  if (chdir_back) chdir( CPath ); // in case SHELL changed directory... (DOS only :))

  if (strchr(Options, 'R')) ReadFiles( RF_NORMAL, 1 );

  draw = 1;

  if (strchr(Options, 'n')) draw = 0;
  if (strchr(Options, 'i')) __Dn();
  say1("");
  say2("");
}

/////////////////////////////////////////////
//
// misc utils
//

void CalcStat()
{
  int z;
  SelSize = 0;
  SelCount = 0;
  for(z = 0; z < FilesCount; z++ )
    if (Files[z]->sel)
      {
      SelSize += Files[z]->st.st_size;
      SelCount++;
      }
}

void GetCPath()
{
  getcwd(CPath, MAX_PATH);
  FixPath(CPath);
}

/////////////////////////////////////////////
//
// edit file
//
// seed.cpp externals -- no .h file
extern int SeedSLColor; // status line color
extern int SeedInit();
extern int SeedAddFile( const char* fname );
extern int Seed();

void EditFile()
{
  if (FilesCount == 0 || Files[FLI]->is_dir ) return;
  ConCS();
  if (opt.IntEditor)
    {
    SeedSLColor = cINFO;
    SeedInit();
    SeedAddFile( Files[FLI]->name );
    Seed();
    }
  else
    {
    Shell(Editor, 0);
    }
  draw = 1;
}

/////////////////////////////////////////////
//
// Browse command
//

// see.cpp externals -- no .h file
extern int SeeSLColor; // status line color
extern int SeeAddFile( const char* fname );
extern int See();

void BrowseSelectedFiles()
{
  int z;
  for ( z = 0; z < FilesCount; z++ )
    if ( Files[z]->sel )
      if ( !Files[z]->is_dir )
        SeeAddFile( Files[z]->name );
  SeeSLColor = cINFO;
  See();
  draw = 1;
  say1("");
  say2("");
}

void Browse( const char *fname )
{
  if (opt.IntBrowser)
    {
    SeeSLColor = cINFO;
    SeeAddFile( fname );
    See();
    }
  else
    {
    String str = Browser;
    StrReplace( str, "%f", fname );
    StrReplace( str, "%F", fname );
    Shell( str, 0 );
    }
  draw = 1;
  say1("");
  say2("");
}

/////////////////////////////////////////////
//
// action +/-
//
void ActionPlus( int key )
{
  if ( FilesCount == 0 ) return;

  TF *fi = Files[FLI];

  if ( WorkMode == wmNormal )
    { // wmNormal
    if ( fi->is_dir )
      { // dir
      ChDir( fi->name );
      }
    else
      { // file
      if ( (AX = FindArc( fi->name )) != -1 )
        {
        WorkMode = wmInArchive;
        strcpy( AName, Files[FLI]->name );
        ReadFiles();
        say1( "InArchive mode activated. (Most keys/commands are disabled!)" );
        } else
      if ( key == 13 && FindUserExternal( 13 ) != -1 )
        {
        UserExternals( 13 );
        }
      else
        {
        ConCS();
        Browse( Files[FLI]->name );
        }
      }
    }
  else
    { // wmInArchive
    if ( key == 13 && FindUserExternal( 13 ) != -1 )
      {
      UserExternals( 13 );
      }
    else
    if ( fi->is_dir )
      { // dir
      say1( "This is not defined ( please ignore this message )" );
      }
    else
      { // file
      ViewArchiveFile();
      }
    };
  // draw = 1; opala
}

void ActionMinus()
{
  char   od[1024];
  char temp[1024];

  strcpy(od, CPath);
  if ( WorkMode == wmNormal )
    {
      #ifdef _TARGET_GO32_
      if (CPath[1] == ':' && ( CPath[2] == '/' || CPath[2] == '\\' ) && CPath[3] == 0 ) return;
      #endif
      if (CPath[0] == '/' && CPath[1] == 0) return;
      ChDir( ".." );
    } else
  if ( WorkMode == wmInArchive )
    {
    strcat( od, AName ); strcat( od, "/" );
    WorkMode = wmNormal;
    AName[0] = 0;
    AX = -1;
    ChDir(".");
    say1( "Normal mode activated. (All keys/command are enabled)" );
    } else
  ASSERT(!"Bad WorkMode");

  int z = 0;

  for (z = 0; z < FilesCount; z++)
    {
    sprintf(temp, "%s%s/", CPath, Files[z]->name);
    if (PathCmp(temp, od) == 0)
      {
      FGO(z);
      break;
      }
    temp[0] = 0;
    }
  if (temp[0] == 0) FGO(0);
  draw = 1;
}

/////////////////////////////////////////////
//
//
//

// global select / different
// returns 0 for ok
int CompareFilesCRC32( const char* src, const char* dst, const char* name )
{
  char fn1[MAX_PATH];
  char fn2[MAX_PATH];
  struct stat stat_src;
  struct stat stat_dst;
  strcpy( fn1, src ); strcat( fn1, name );
  strcpy( fn2, dst ); strcat( fn2, name );

  if (!FileExist( fn1 )) return 1;
  if (!FileExist( fn2 )) return 2;

  if (stat( fn1, &stat_src )) return 3;
  if (stat( fn2, &stat_dst )) return 4;

  if (S_ISDIR( stat_src.st_mode )) return 5;
  if (S_ISDIR( stat_dst.st_mode )) return 6;

  if ( stat_src.st_size != stat_dst.st_size ) return 7;

  if ( FileCRC32( fn1 ) != FileCRC32( fn2 ) ) return 8;

  return 0;
}

#define GSAME_NAME      1
#define GSAME_EXT       2
#define GSAME_SIZE      3
#define GSAME_DATETIME  4
#define GSAME_DATE      5
#define GSAME_TIME      6
#define GSAME_TIME1     7
#define GSAME_OWNER     8
#define GSAME_GROUP     9
#define GSAME_MODE     10
#define GSAME_TYPE     11

#define TIMECMP_DT     0 // compare date and time
#define TIMECMP_D      1 // compare only date
#define TIMECMP_T      2 // compare only time
#define TIMECMP_T1     3 // compare only time (to 1 minute round)
// return 0=don't match and 1=match
int TimeCmp( time_t t1, time_t t2, int type = TIMECMP_DT )
{
  char tmp1[32];
  char tmp2[32];
  strcpy( tmp1, ctime(&t1) );
  strcpy( tmp2, ctime(&t2) );
  if ( type == TIMECMP_T )
    {
    strcpy( tmp1, tmp1+11 ); tmp1[8] = 0;
    strcpy( tmp2, tmp2+11 ); tmp2[8] = 0;
    } else
  if ( type == TIMECMP_T1 )
    {
    strcpy( tmp1, tmp1+11 ); tmp1[5] = 0;
    strcpy( tmp2, tmp2+11 ); tmp2[5] = 0;
    } else
  if ( type == TIMECMP_D )
    {
    strcpy( tmp1+10, tmp1+19 );
    strcpy( tmp2+10, tmp2+19 );
    }
  return (strcmp( tmp1, tmp2 ) == 0);
}

void SelectSame( int same_mode )
{

char same_str[255] = "";
long same_int = 0;
fsize_t same_fsize = 0;

switch( same_mode )
  {
  case GSAME_NAME  : FileName( Files[FLI]->name, same_str ); break;
  case GSAME_EXT   : FileExt(Files[FLI]->name, same_str); break;
  case GSAME_SIZE  : same_fsize = Files[FLI]->size; break;
  case GSAME_DATETIME  :
  case GSAME_DATE      :
  case GSAME_TIME      :
  case GSAME_TIME1     :
                     same_int = OptTime( Files[FLI]->st );
                     break;
  case GSAME_OWNER : same_int = Files[FLI]->st.st_uid; break;
  case GSAME_GROUP : same_int = Files[FLI]->st.st_gid; break;
  case GSAME_MODE  : same_int = Files[FLI]->st.st_mode; break;
  case GSAME_TYPE  : strcpy( same_str, Files[FLI]->sttype ); break;
  default          : return;
  }

TF* fi;
int z = 0;
for (z = 0; z < FilesCount; z++)
  {
  fi = Files[z];
  int sel = 0;
  switch( same_mode )
    {
    case GSAME_NAME  : {
                         char tmp[255];
                         FileName(fi->name,tmp);
                         sel = (PathCmp(same_str, tmp) == 0);
                       }; break;
    case GSAME_EXT   : {
                         char tmp[255];
                         FileExt(fi->name,tmp);
                         sel = (PathCmp(same_str, tmp) == 0);
                       }; break;
    case GSAME_SIZE  : sel = (same_fsize == fi->size); break;
    case GSAME_DATETIME  :
                       sel = TimeCmp( same_int, OptTime( fi->st ) );
                       break;
    case GSAME_DATE      :
                       sel = TimeCmp( same_int, OptTime( fi->st ), TIMECMP_D );
                       break;
    case GSAME_TIME      :
                       sel = TimeCmp( same_int, OptTime( fi->st ), TIMECMP_T );
                       break;
    case GSAME_TIME1     :
                       sel = TimeCmp( same_int, OptTime( fi->st ), TIMECMP_T1 );
                       break;
    case GSAME_OWNER : sel = (same_int == fi->st.st_uid); break;
    case GSAME_GROUP : sel = (same_int == fi->st.st_gid); break;
    case GSAME_MODE  : sel = (same_int == fi->st.st_mode); break;
    case GSAME_TYPE  : sel = (strcmp( same_str, fi->sttype) == 0); break;
    }
  fi->sel = sel;
  }
}

void GlobalSelect()
{
  char ch;

  mb.freeall();
  mb.add( "S All" );
  mb.add( "A All (+Dirs)" );
  mb.add( "R Reverse" );
  mb.add( "C Clear" );
  mb.add( "P Pack" );
  mb.add( "H Hide" );
  mb.add( "D Different" );
  mb.add( ". Hide dirs" );
  mb.add( "= Mask add (+dirs)" );
  mb.add( "+ Mask add (-dirs)" );
  mb.add( "- Mask sub        " );
  mb.add( "L Same..." );
  mb.add( "X EXtended select..." );
  if ( MenuBox( 50, 5, "Global Select" ) == -1 ) return;
  ch = MenuBoxExitCh;
  if (ch == 'X')
    {
    if ( WorkMode == wmInArchive ) { say1( "GlobalSelect/Extended not available in this mode." ); return; };
    mb.freeall();
    mb.add( "--searching--" );
    mb.add( "F Find string (no case)" );
    mb.add( "S Scan string" );
    mb.add( "B Scan string (compat.)" );
    mb.add( "H Hex  string" );
    mb.add( "/ Regular expression" );
    mb.add( "\\ Reg.exp (no case)" );
//    mb.add( "--other--" );
//    mb.add( "M Mode/Attributes" );
    if ( MenuBox( 50, 5, "Extended G.Select" ) == -1 ) return;
    ch = MenuBoxExitCh;
    if (ch == 'S') ch = 'B'; // 'B' trans
    if (ch == 'H') ch = 'E'; // 'E' trans
    }

  switch(ch)
    {
    case 'S' : {
               for (int z = 0; z < FilesCount; z++)
                 if (!S_ISDIR(Files[z]->st.st_mode))
                   Files[z]->sel = 1;
               }; break;
    case 'A' : {
               for (int z = 0; z < FilesCount; z++)
                 Files[z]->sel = 1;
               }; break;
    case 'R' : {
               int z;
               for (z = 0; z < FilesCount; z++)
                 {
                 if (!S_ISDIR(Files[z]->st.st_mode))
                   {
                   if(Files[z]->sel)
                     Files[z]->sel = 0;
                   else
                     Files[z]->sel = 1;
                   }
                 }
               }; break;
    case 'C' : {
               int z;
               for (z = 0; z < FilesCount; z++)
                 {
                 //if (!S_ISDIR(Files[z]->st.st_mode))
                   {
                   Files[z]->sel = 0;
                   }
                 }
               }; break;
    case 'P' :
               {
               int z;
               for (z = 0; z < FilesCount; z++)
                 {
                 if (!Files[z]->sel)
                   {
                   delete Files[z];
                   Files[z] = NULL;
                   }
                 }
               Pack();
               }; break;
    case 'H' :
               {
               int z;
               for (z = 0; z < FilesCount; z++)
                 {
                 if (Files[z]->sel)
                   {
                   delete Files[z];
                   Files[z] = NULL;
                   }
                 }
               Pack();
               }; break;
    case '.' :
               {
               int z;
               for (z = 0; z < FilesCount; z++)
                 {
                 if (S_ISDIR(Files[z]->st.st_mode))
                   {
                   delete Files[z];
                   Files[z] = NULL;
                   }
                 }
               Pack();
               }; break;
    case '+' :
    case '=' :
    case '-' :
              {
              char gsmask[128];
              int selaction = 0;
              if (ch != '-') selaction = 1;
              if (ch == '+')
                say1("Select by mask: (w/o directories)");
              else
              if (ch == '=')
                say1("Select by mask: (with directories)");
              else
                say1("Deselect by mask:");
              gsmask[0] = 0;
              if (GetStr( gsmask, HID_GS_MASK ))
                {
                if (opt.GENExpandMask)
                  ExpandMask( gsmask );
                int z = 0;
                for (z = 0; z < FilesCount; z++)
                  {
                  if (Files[z]->is_dir && ch == '+') continue;
                  if (fnmatch(gsmask,Files[z]->name,FNMATCH_FLAGS) == 0)
                    Files[z]->sel = selaction;
                  }
                }
              say1( " " );
              say2( " " );
              }; break;
    case 'D' :
              {
              if ( WorkMode == wmInArchive ) { say1( "GlobalSelect/Different not available in this mode." ); break; };
              sss[0] = 0;
              if (GetDirName( "Target directory:", sss ))
                {
                FixPath( sss );
                int z = 0;
                for (z = 0; z < FilesCount; z++)
                  {
                  if (Files[z]->is_dir) continue;
                  say1( Files[z]->name );
                  Files[z]->sel = ( CompareFilesCRC32( CPath, sss, Files[z]->name ) != 0 );
                  }
                }
              say1( "Done." );
              say2( " " );
              }; break;
    case '/':
    case '\\':
    case 'E':
    case 'F':
    case 'B': {
              say1("Search string: ");
              char pat[256];
              strcpy( pat, "+" );
              if (GetStr( pat+1, HID_GS_GREP ))
                {
                fsize_t size = 0;
                say1("");
                say2("");
                // strcpy( pat+1, opt.LastGrep );
                if (ch == 'F' ) pat[0] = '\\'; else
                if (ch == 'B' ) pat[0] = '\\'; else
                if (ch == 'E' ) pat[0] = '$'; else
                if (ch == '/' ) pat[0] = '~'; else
                if (ch == '\\') pat[0] = '~'; else
                   ;
                int nocase = ( ( ch == '\\' ) || ( ch == 'F' ) );
                // Vl@A
                size = 0;
                for ( int z = 0; z < FilesCount; z++ )
                  {
                  size += Files[z]->size;
                  if ( Files[z]->is_dir ) continue;
                  Files[z]->sel = ( FSearchStr( pat, Files[z]->name, nocase ) >= 0 );
                  sprintf( sss, "Scanning %4.1f%% (%12.0f bytes in %s ) ", (100.0 * size) / (AllSize+1.0), Files[z]->size, Files[z]->name );
                  say1( sss );
                  }
                }
              say1("");
              say2("");
              break;
              }

    case 'L':
              {
              mb.freeall();
              mb.add( "N Name" );
              mb.add( "E Extension" );
              mb.add( "S Size" );
              mb.add( "T Time" );
              mb.add( "I Time (1 min.round)" );
              mb.add( "D Date" );
              mb.add( "M Date+Time" );
              mb.add( "A Attr/Mode" );
              #ifndef _TARGET_GO32_
              mb.add( "O Owner" );
              mb.add( "G Group" );
              #endif
              mb.add( "P Type (TP)" );

              MenuBox( 50, 5, "Select Same..." );
              ch = MenuBoxExitCh;
              switch ( ch )
                {
                case 'N' : SelectSame( GSAME_NAME  ); break;
                case 'E' : SelectSame( GSAME_EXT   ); break;
                case 'S' : SelectSame( GSAME_SIZE  ); break;
                case 'M' : SelectSame( GSAME_DATETIME  ); break;
                case 'T' : SelectSame( GSAME_TIME  ); break;
                case 'I' : SelectSame( GSAME_TIME1 ); break;
                case 'D' : SelectSame( GSAME_DATE  ); break;
                case 'O' : SelectSame( GSAME_OWNER ); break;
                case 'G' : SelectSame( GSAME_GROUP ); break;
                case 'A' : SelectSame( GSAME_MODE  ); break;
                case 'P' : SelectSame( GSAME_TYPE  ); break;
                }
              }; break;
    case 'M': {
              attrs_t attr;
              strcpy( attr, ATTR_STRING );
              if(EditAttr( attr, 0 ))
                {
                for ( int z = 0; z < FilesCount; z++ )
                  Files[z]->sel = (strcmp( Files[z]->stmode+1, attr+1 ) == 0);
                draw = 1;
                }
              }; break;
    }
  CalcStat();
  draw = 1;
}

/////////////////////////////////////////////
//
//  User externals
//

int FindUserExternal( int pKey )
{
  char fext[64];
  char ftyp[64];
  fext[0] = 0;
  ftyp[0] = 0;
  sprintf(fext, ".%s.", FileExt(Files[FLI]->name, sss ));
  sprintf(ftyp, ".%s.", Files[FLI]->sttype);
  #ifdef _TARGET_GO32_
  LowString( fext );
  #endif
  int z;
  TUX ux;
  for(z = 0; z < TUXes.count(); z++) // search for extension
    {
    TUXes.get( z, &ux );
    if (pKey != ux.key) continue;
    if (ux.ext[0] != 0 && strstr(ux.ext, fext) == NULL
                       && strstr(ux.ext, ftyp) == NULL) continue;
    return z;
    }
  return -1;
};

void UserExternals( int pKey )
{
  if ( FilesCount == 0 )
    {
    say1( "Directory is empty: UserExternals are disabled!" );
    return;
    }
  int found = FindUserExternal( pKey );
  if (found != -1)
    {
    TUX ux;
    TUXes.get( found, &ux );
    if ( WorkMode == wmNormal )
      Shell( ux.sline, 0 );
    else
    if ( WorkMode == wmInArchive )
      ArcUserExternal( ux.sline );
    // draw = 1; this is set bu Shell
    }
  else
    {
    say1( "No <UX> defined for this key+extension." );
    }
}

/////////////////////////////////////////////
//
//
//

void GotoPresetDir( int n )
{
  char target[MAX_PATH];
  char ch;
  if (n == 0)
    {
    say1("Press 0-9 to change current path or (`) for list.");
    ch = ConGetch();
    say1("");
    target[0] = 0;
    }
  else
    ch = n;

  if (ch == '`')
    {
    int z;
    mb.freeall();
    for(z = 1; z < 10; z++)
      {
      sprintf(sss, "%d %-60s", z%10, PresetDir[z]);
      mb.add(sss);
      }
    if (MenuBox( 5, 5, "Preset (Favourite) Dirs") == -1) return;
    ch = MenuBoxExitCh;
    draw = 1;
    return;
    }

  if (ch == '1' && PresetDir[1]) strcpy(target, PresetDir[1]); else
  if (ch == '2' && PresetDir[2]) strcpy(target, PresetDir[2]); else
  if (ch == '3' && PresetDir[3]) strcpy(target, PresetDir[3]); else
  if (ch == '4' && PresetDir[4]) strcpy(target, PresetDir[4]); else
  if (ch == '5' && PresetDir[5]) strcpy(target, PresetDir[5]); else
  if (ch == '6' && PresetDir[6]) strcpy(target, PresetDir[6]); else
  if (ch == '7' && PresetDir[7]) strcpy(target, PresetDir[7]); else
  if (ch == '8' && PresetDir[8]) strcpy(target, PresetDir[8]); else
  if (ch == '9' && PresetDir[9]) strcpy(target, PresetDir[9]); else
  return;

  if ( target[0] != 0 )
    ChDir( target );
}

/////////////////////////////////////////////
//
//
//

// return Files[n].dir size or -1 if aborted...
fsize_t __do_dirsize( int n )
{
  ASSERT( Files[n] != NULL );
  ASSERT( n >= 0 && n < FilesCount );
  if (!Files[n]->is_dir) return 0;
  Files[n]->size = DirSize( Files[n]->name );;
  RefreshView( n );
  draw = 1;
  return Files[n]->size;
}

void DirsSizes( int n )
{
  time_t t = time(NULL);

  say1("working...");
  if ( n == -2 )
    {
    String str;
    GetDirName( "Dir size: ", CPath );
    say1("");
    if ( TargetDir[0] == 0 ) return;
    str.setfi( DirSize( TargetDir ) );
    StrComma( str );
    sprintf( sss, "Dir size: %s = %s bytes (%d files).", TargetDir, str.asis(), DirSizeFCount );
    say1( sss );
    } else
  if ( n == -1 )
    {
    for(int z = 0; z < FilesCount; z++) if (__do_dirsize(z) == -1) break;
    say1(" ");
    draw = 1;
    }
  else
    {
    __do_dirsize( n );
    say1(" ");
    draw = 1;
    }

  t = time(NULL) - t;
  sprintf( sss, "Elapsed seconds: %d", t );
  say2( sss );
  UpdateStats();
  if ( opt.SortOrder == 'S' && n < 0 ) ReSortFiles( 1 ); // don't for single dir size calc
}

void Tools()
{
  mb.freeall();
  mb.add( "R Real path" );
  mb.add( "D ChDir to Real path" );
  mb.add( "T Make directory" );
  mb.add( "P Preset dirs menu" );
  mb.add( "A Rename tools..." );
  mb.add( "C Classify files" );
  if (MenuBox( 50, 5, "Tools" ) == -1) return;
  switch( MenuBoxExitCh )
    {
    case 'R' :
               ExpandPath(Files[FLI]->name, sss);
               say1( sss );
               break;
    case 'D' :
               GetCPath();
               ChDir( "." );
               break;
    case 'T' :
               say1( "Make directory(ies) (use space for separator)" );
               sss[0] = 0;
               if (GetStr( sss, HID_MKPATH ))
                 {
                 int err = 0;
                 String str = sss;
                 while(StrGetFirstWord( str, " ;\t", sss ))
                   {
                   if(MakePath(sss))
                     {
                     say1( "Cannot create directory:" );
                     say2( sss );
                     ConGetch();
                     err++;
                     }
                   }
                 if ( err == 0 ) say1( "MKDIR: ok." );
                 break;
                 }
    case 'P' : GotoPresetDir('`'); break;
    case 'A' : RenameTools(); break;
    case 'C' : Classify(); break;
    }
}

/////////////////////////////////////////////////////////////////////////
//
//
//

extern char ConMenuHideMagic[32];
void UserMenu()
{
  String str;
  TUX ux;
  int z;

  mb.freeall();
  for ( z = 0; z < TUXes.count(); z++ )
    {
    TUXes.get( z, &ux );
    if ( ux.key >= 0 ) continue;

    str = ux.des+1;
    str = "  " + str + " (" + ux.ext + ")$$";
    str += ux.key;

    StrSetCh( str, 0, ux.des[0] );
    mb.add( str );
    };
  z = -1;
  if (mb.count() > 0)
    {
    strcpy( ConMenuHideMagic, "$$" );
    z = MenuBox( 25, 5, "User Menu (Extern)" );
    strcpy( ConMenuHideMagic, "" );
    }
  else
    say1( "User Menu is not available -- no externals attached" );
  if ( z == -1 ) return;
  str = mb[z];

  StrTrimL( str, StrRFind( str, "$$" ) );
  StrCut( str, "$" );

  z = atoi( str );
  if ( z >= 0 ) return;
  UserExternals( z );
};

/////////////////////////////////////////////////////////////////////////
//
//
//

/*
void ChFileMaskHistory( int key, String &s, int &pos )
{
  if ( key != KEY_NPAGE && key != KEY_PPAGE ) return;
  ConCHide();
  int z = MenuHist10( strlen(CPath)+1, 3, "Last Masks", opt.LastMasks );
  ConCShow();
  if ( z == -1 ) return;
  s = opt.LastMasks[z];
  StrCutSpc( s );
  pos = StrLen( s );
}
*/

void ChFileMask( char *pS )
{
  String tmp = FMASK;
  int new_mask = 0;

  if (pS)
    {
    tmp = pS;
    new_mask = 1;
    }
  else
    {
    strcpy( sss, tmp.asis() );
//    new_mask = TextInput( strlen(CPath)+1, 2, CPath, MAX_PATH, MAXX-strlen(CPath)-4, sss, ChFileMaskHistory );
    new_mask = GetStr( sss, HID_FMASK, strlen(CPath)+1, 2 );
    tmp = sss;
    }
  if(new_mask)
    {
    StrCutSpc( tmp );
    //AddHist10( tmp, opt.LastMasks );
    if ( tmp.len() == 0) tmp = "*";
    StrCutSpc( tmp );
    strcpy(FMASK, tmp.asis());
    if ( StrGetCh( tmp, -1 ) == '|' ) // external panelize
      {
      ReadFiles( RF_NORMAL, 1 );
      draw = 1;
      return;
      }
    PathSplit( tmp, PATH_DELIMS, FMASKARRAY, MAX_FMASKS);
    if ( opt.FMExpandMask && StrCount( tmp, "*?" ) == 0 && StrGetCh( tmp, -1 ) != '|' )
      {
      FMASK[0] = 0;
      int i = 0;
      for ( i = 0; i < MAX_FMASKS; i++ )
        if ( FMASKARRAY[i][0] )
          {
          strcat( FMASKARRAY[i], "*" );
          if ( FMASKARRAY[i][0] == '.' ) StrInsert( FMASKARRAY[i], 0, "*" );
          StrReplace( FMASKARRAY[i], "**", "*" );
          strcat( FMASK, FMASKARRAY[i] );
          strcat( FMASK, " " );
          }
      }
    ReadFiles( RF_NORMAL, 1 );
    draw = 1;
    }
    draw = 1;
  // say1( "" );
}

void ChFileMaskMenu()
{
};

/////////////////////////////////////////////
//
//
//

PSZCluster ffr; // filefind results
static char f_pat[MAX_PATH];
static int  f_patlen;
static char f_mask[MAX_PATH];
static int  f_nocase;

int __filefind( const char *fname, struct stat *st, int flag )
{
  if (BreakOp()) return 1;

  char *name = strrchr( fname, '/' ) + 1;
  if ( flag == FTWALK_D )
    {
    ConPuts( fname, cNORMAL );
    ConCE( cNORMAL );
    ConPuts( "\r" );
    }
  if ( name[0] == 0 || fnmatch( f_mask, name, FNMATCH_FLAGS )) return 0;

  if (f_patlen)
    {
    ConPuts( fname, cNORMAL );
    ConCE( cNORMAL );
    ConPuts( "\r" );
    if ( FSearchStr( f_pat, fname, f_nocase ) == -1) return 0;
    }

  char tmp[32];
  strcpy( tmp, ctime(&(st->st_mtime)));
  tmp[24] = 0;
  strcpy( tmp, tmp+4);
  strcpy( tmp+12, tmp+17);
  tmp[12] = ' ';

  if ( flag == FTWALK_D )
    sprintf(sss, " %s%12s | %s", tmp, "[DIR]", fname );
  else
    sprintf(sss, " %s%12ld | %s", tmp, st->st_size, fname );
  ffr.add( sss+1 );
  strcat( sss, "\n" );
  ConPuts( sss );

  return 0;
}

void FileFind( int menu )
{
  String str;
  char ch;

  if (menu)
    {
    if ( MenuBox("File find", "N File find,L Last find result,F Find string,S Scan string,B Scan string (compat),E hEx string,/ Regular expresion,\\ Reg.exp (no case)", 5 ) == -1 ) return;
    ch = MenuBoxExitCh;
    }
  else
    ch = 'N';
  if ( ch == 'L' )
    {
    FileFindResults();
    return;
    }

  char f_path[MAX_PATH];

  strcpy( f_mask , "" );
  strcpy( f_path , "" );
  strcpy( f_pat+1, "" );

  say1("Enter find mask:");

  if(!GetStr( f_mask, HID_FFMASK ))
    {
    say1( "" );
    say2( "" );
    return;
    }
  StrCut(f_mask, " ");

//  GetDirName("Enter find path:", f_path);
  GetDirName("Enter find path:", CPath );
  if (TargetDir[0] == 0)
    {
    say1( "" );
    say2( "" );
    return;
    }
  strcpy(f_path, TargetDir);

  f_patlen = 0;
  if ( strchr("FSBE\\/", ch) )
    {
    f_nocase = ( strchr("F\\", ch) != 0 );
    say1("Enter search string:");
    //strcpy( f_pat+1, opt.LastGrep );
    if(!GetStr( f_pat+1, HID_FFGREP ))
      {
      say1( "" );
      say2( "" );
      return;
      }
    if (ch == 'F' ) f_pat[0] = '\\'; else
    if (ch == 'S' ) f_pat[0] = '\\'; else
    if (ch == 'B' ) f_pat[0] = '\\'; else
    if (ch == 'E' ) f_pat[0] = '$'; else
    if (ch == '\\') f_pat[0] = '~'; else
    if (ch == '/' ) f_pat[0] = '~'; else;
    f_patlen = strlen(f_pat);
    }

  // strcpy(opt.LastFindMask, f_mask);
  // strcpy(opt.LastFindPath, f_path);

  if ( opt.FFExpandMask )
    ExpandMask( f_mask );

  ConCS();
  ConTA(chYELLOW);
  ConPuts( HEADER ); ConCE();
  ConXY(1,MAXY-1);
  sprintf( str, "Find: %s, starting from: %s\n", f_mask, f_path );
  ConPuts( str );
  ConTA(cSTATUS);
  ConXY(1,MAXY);
//  __file_find( f_mask, f_path );
  ffr.freeall();
  ftwalk( f_path, __filefind );
  FileFindResults();
}

void FileFindResults()
{
  String str;
  sprintf( str, "VFU: File find results... (%d hits)", ffr.count() );
  if (ffr.count() == 0)
    {
    say1( "No files found..." );
    draw = 1;
    return;
    }
  ConCS();
  say1( "ENTER = ChDir to current file, R/P = Rescan/Panelize all files, ESC or BS = exit" );
  PSZViewCN = cCYAN;
  PSZViewCH = cINPUT;
  PSZViewTI = cINPUT2;
  strcat( PSZViewConfirm, "\n\rRrPp" );
  int z = PSZView( 1, 1, MAXX-5, MAXY-4, str, &ffr, -1 );
  draw = 1;
  if (z == -1) return;

  if ( strchr( "RrPp", tolower(MenuBoxExitKey)) )
    {
    PSZCluster sc;
    sc.create( 16, 16 );
    for ( z = 0; z < ffr.count(); z++ )
      {
      str = ffr[z];
      int i = StrFind( str, '|' );
      StrTrimL( str, i+2 ); // and for the following ' ' after '|'
      sc.add( str );
      };
    ReadFiles( RF_NORMAL, 0, &sc );
    }
  else
    {
    str = ffr[z];
    z = StrFind( str, '|' );
    StrTrimL( str, z+2 ); // and for the following ' ' after '|'
    z = StrRFind( str, '/' );
    if (z != -1) StrSLeft( str, z+1 ); // +1 for the trailing '/'
    ChDir( str );
    }
}


/////////////////////////////////////////////
//
//
//
/*
  void CommandHistory( int key, String &s, int &pos )
  {
    if ( key != KEY_NPAGE && key != KEY_PPAGE ) return;
    ConCHide();
    int z = MenuHist10( 5, 5, "Last Commands", opt.LastCommands );
    ConCShow();
    if ( z == -1 ) return;
    s = opt.LastCommands[z];
    StrCutSpc( s );
    pos = s.len();
  };
*/
void Command()
{
  if(SHELL[0] == 0)
    {
    #ifdef _TARGET_GO32_
    say1("No $COMSPEC defined.");
    #else
    say1("No $SHELL defined.");
    #endif
    return;
    }
  draw = 1;
  char tmp[1024] = "";

  // strcpy( tmp, opt.LastCommands[0] );
  // int res = TextInput( 1, MAXY, CPath, MAX_PATH, MAXX-4, tmp, CommandHistory );
  int res = GetStr( tmp, HID_COMMANDS );
  say1("");
  say2("");
  if (!res) return;

  // AddHist10( tmp, opt.LastCommands );

  ConCS();
  // Shell(SHELL, 0);
  Shell( tmp, 0 );
  return;
}


/////////////////////////////////////////////
//
//
//

void EditNameInPlace()
{
TF *fi = Files[FLI];

if (strcmp(fi->name, "." ) == 0) return;
if (strcmp(fi->name, "..") == 0) return;

int y = (FINDEX.pos - FINDEX.page) + 4;
int x = TagMarkPos + 2;

String str = fi->name;

if(TextInput( x, y, "", MAX_PATH, MAXX - TagMarkPos - 3, &str ) &&
//  PathCmp( fi->name, str.asis() )
  strcmp( fi->name, str.asis() )
  )
  {
  if ( FileExist(str) )
    say1( "Cannot rename: destination name exists!" );
  else
  if(rename(fi->name, str.asis()) == 0)
    {
    strcpy(fi->name, str.asis());
    say1("RENAME: ok.");
    RefreshView( FLI );
    }
  else
    {
    say1("RENAME: failed.");
    DescribeErrno();
    }
  }

DrawItem( FLI, 1 );
DrawPointer();
}
////////////////////////////////////////////////////////////////////////////
//
//
//
void EditEntry( )
{
  int one = (SelCount == 0);
  int z;
  String str;
  mb.freeall();
  mb.add( "A Attributes" );
  mb.add( "O Owner/Group" );
  mb.add( "N Name (TAB)" );
  mb.add( "T Time/Touch Both Times" );
  mb.add( "M Modify Time" );
  mb.add( "S Access Time" );
  mb.add( "L Edit SymLink Reference" );
  mb.add( "--");
  mb.add( "+ Target: Toggle" );
  mb.add( "C Target: Current File" );
  mb.add( "S Target: Selection" );

  while(1)
    {
    while(1)
      {
      str = "Edit entry: ";
      str += one?"Current File":"*SELECTION* ";
      strcpy( PSZViewConfirm, "\r\t");
//      extern int MenuBoxAC;
      ConMenuBoxAC = 9;
      z = MenuBox( 50, 5, str );
      if (z == -1) return;
      if (ConMenuBoxAC == -2) MenuBoxExitCh = 'N';
      if (MenuBoxExitCh == '+') { one = !one; continue; }
      if (MenuBoxExitCh == 'S') { one = 0; continue; }
      if (MenuBoxExitCh == 'C') { one = 1; continue; }
      if ( !one && SelCount == 0 ) one = 1;
      break;
      }

    if ( MenuBoxExitCh == 'N' )
      {
      EditNameInPlace();
      break;
      } else
    if ( MenuBoxExitCh == 'A' )
      {
        char newattr[16];
        int err = 0;
        if (one)
          fgetattr_s(Files[FLI]->name, newattr);
        else
          strcpy(newattr, ATTR_MASK);
        if(EditAttr(newattr, !one ))
          {
          for ( z = 0; z < FilesCount; z++ )
            if ( (one && FLI == z) || (!one && Files[z]->sel) )
              {
              TF *fi = Files[z];
              if(fsetattr_s(fi->name, newattr) == 0)
                {
                stat(fi->name, &(fi->st));
                fgetattr_s(fi->name, fi->stmode);
//                draw = 1;
                RefreshView(z);
//                if ( z >= FLP && z <= FLP+PS )
                DrawItem( z, z == FLI );
                }
              else
                err++;
              }
          }
        if (err)
          sprintf( sss, "Change attr/mode errors: %d", err );
        else
          strcpy( sss, "Change attr/mode ok." );
        say1( sss );
        if (err)
          DescribeErrno();
        break;
      } else
    if ( MenuBoxExitCh == 'T' || MenuBoxExitCh == 'M' || MenuBoxExitCh == 'S' )
      {
        char tmp[128];
        strcpy( tmp, "");
        strcpy( sss, "Change times: " );
        strcat( sss, (MenuBoxExitCh == 'T') ? "MODIFY,ACCESS" : ( (MenuBoxExitCh == 'M') ? "MODIFY" : "ACCESS" ) );
        strcat( sss, one ? " for the current file:" : " for SELECTED files:" );
        strcpy( tmp, time2str(time(NULL))); tmp[24] = 0;
        strcat( sss, "    PLEASE MIND THE FORMAT!" );
        say1( sss );
        int z = GetStr(tmp, HID_EE_TIME );
        say1(""); say2("");
        if( !(z && strlen(tmp) > 0) ) break;

        time_t newtime = str2time( tmp );
        if ( newtime == 0 ) // well, this is 1.1.1970 but I consider it wrong
          {
          say1( "Wrong time string format." );
          break;
          }
        int err = 0;
        struct utimbuf tb;
        for ( z = 0; z < FilesCount; z++ )
          if ( (one && FLI == z) || (!one && Files[z]->sel) )
            {
            TF *fi = Files[z];
            tb.actime  = fi->st.st_atime;
            tb.modtime = fi->st.st_mtime;
            if (MenuBoxExitCh == 'M') tb.modtime = newtime;
            if (MenuBoxExitCh == 'S') tb.actime  = newtime;
            if (MenuBoxExitCh == 'T') tb.modtime = newtime;
            if (MenuBoxExitCh == 'T') tb.actime  = newtime;
            if (utime( fi->name, &tb ) == 0)
              {
              fi->st.st_atime = tb.actime;
              fi->st.st_mtime = tb.modtime;
              RefreshView( z );
              DrawItem( z, z == FLI );
              }
            else
              err++;
            }
        if (err)
          sprintf( sss, "Time touch errors: %d", err );
        else
          strcpy( sss, "Time touch ok." );
        say1( sss );
        if (err)
          DescribeErrno();
        break;
      } else
    if ( MenuBoxExitCh == 'O' )
      {
        #ifdef _TARGET_GO32_
        say1( "Change owner/group function is not supported under DOS filesystem" );
        break;
        #endif

        char tmp[128];
        strcpy(tmp, "");
        if (one)
          say1("Enter new `user.group | user | .group' for current file:");
        else
          say1("Enter new `user.group | user | .group' for all SELECTED files:");
        if( !(GetStr(tmp, HID_EE_OWNER ) && strlen(tmp) > 0) )
          {
          say1(" "); say2(" ");
          break;
          }

        say1(" "); say2(" ");
        int uid = 0;
        int gid = 0;
        char temp[100];
        regexp *re = regcomp("^ *([^\\.]*)(\\.([^\\.]*))? *$");
        if( !regexec(re, tmp) )
          {
          say1("Format is 'uid.gid', for example 'cade.users', 'cade.', '.users'");
          break;
          }

        struct passwd *pwd; regsubn(re, 1, temp);
        uid = -1; (pwd = getpwnam(temp))? uid = pwd->pw_uid : -2;
        struct group  *grp; regsubn(re, 3, temp);
        gid = -1; (grp = getgrnam(temp))? gid = grp->gr_gid : -2;
        free(re);

        int err = 0;
        for ( z = 0; z < FilesCount; z++ )
          if ( (one && FLI == z) || (!one && Files[z]->sel) )
            {
            TF *fi = Files[z];
            int u = uid;
            int g = gid;
            if (u == -1) u = fi->st.st_uid;
            if (g == -1) g = fi->st.st_gid;
            if(chown(fi->name, u, g) == 0)
              {
              stat(fi->name, &(fi->st));
              RefreshView( z );
              DrawItem(z, z == FLI);
              }
            else
              err++;
            }

        if (err)
          sprintf( sss, "Change owner/group errors: %d", err );
        else
          strcpy( sss, "Change owner/group ok." );
        say1( sss );
        if (err)
          DescribeErrno();
        break;
      } else
    if ( MenuBoxExitCh == 'L' )
      {
      #ifdef _TARGET_GO32_
      say1( "Edit SymLink reference is not supported under DOS filesystem" );
      #else
      if (!one)
        {
        say1( "Cannot edit symlink reference for selection..." );
        break;
        }
      TF* fi = Files[FLI];
      if ( !fi->is_link )
        {
        say1( "This is not a symlink..." );
        break;
        }
      sss[readlink( fi->name, sss, sizeof(sss) )] = 0;
      if (GetStr( sss, 0 ))
        {
        say2( "" );
        if ( unlink( fi->name ) || symlink( sss, fi->name ) )
          {
          say1( "Edit SymLink reference error..." );
          DescribeErrno();
          }
        else
          {
          say1( "Edit SymLink reference ok." );
          }
        }
      #endif
      break;
      } else
    ;
    }
  return;

/*
char newname[MAX_PATH];

say1("EditEntry: TAB=name, a/A=attribs curr/sel, o/O=uid/gid sel/curr");
char ch = ConGetch();
say1(" ");
if (ch == 27) return;

TF *fi = Files[FLI];

if (strcmp(fi->name, "." ) == 0) return;
if (strcmp(fi->name, "..") == 0) return;

switch( ch )
  {
  case  9  : EditNameInPlace(); break;
  case 'o' :
  case 'O' :
           if (SelCount == 0 && ch == 'o') ch = 'O';

           strcpy(newname, "");
           if (ch == 'o')
             say1("Enter new `user.group' for current file:");
           else
             say1("Enter new `user.group' for all selected files:");
           if(GetStr(newname) && strlen(newname) > 0)
             {
             say1(" ");
             say2(" ");
             int uid = 0;
             int gid = 0;
             char temp[100];
             regexp *re = regcomp(" *([^\\.]*)\\.([^\\.]*)");
             if( !regexec(re, newname) )
               {
               say1("Format is 'uid.gid', for example 'cade.users', 'cade.', '.users'");
               break;
               }

             struct passwd *pwd;
             struct group  *grp;

             regsubn(re, 1, temp);
             if (temp[0] == 0)
               uid = -1; //don't change the owner
             else
               {
               pwd = getpwnam(temp);
               if (pwd != NULL)
                 uid = pwd->pw_uid;
               else
                 uid = -2; // user not found
               }

             regsubn(re, 2, temp);
             if (temp[0] == 0)
               gid = -1; // don't change the group
             else
               {
               grp = getgrnam(temp);
               if (grp != NULL)
                 gid = grp->gr_gid;
               else
                 gid = -2; // user not found
               }

             free(re);
             int err = 0;
             if ( ch == 'O' )
               {
               int u = uid;
               int g = gid;
               if (u == -1) u = fi->st.st_uid;
               if (g == -1) g = fi->st.st_gid;
               if(chown(fi->name, u, g) == 0)
                 {
                 stat(fi->name, &(fi->st));
                 draw = 1;
                 RefreshView( FLI );
                 }
               else
                 err++;
               }
             else
               {
               for(z = 0; z < FilesCount; z++)
                 {
                 fi = Files[z];
                 if(fi->sel)
                   {
                   int u = uid;
                   int g = gid;
                   if (u == -1) u = fi->st.st_uid;
                   if (g == -1) g = fi->st.st_gid;
                   if(chown(fi->name, u, g) == 0)
                     {
                     stat(fi->name, &(fi->st));
                     draw = 1;
                     RefreshView(z);
                     }
                   else
                     err++;
                   }
                 }
               }
             if(err == 0)
               {
               draw = 1;
               say1("Change uid/gid: ok.");
               }
             else
               {
               sp(sss, "Change uid/gid errors: %d", err);
               say1(sss);
               DescribeErrno();
               }
             }
           else
             {
             say1(" ");
             say2(" ");
             }
           break;
  case 'a' :
  case 'A' :
           if (SelCount == 0 && ch == 'a') ch = 'A';

           if (ch == 'A')
//             fgetattr_s(Files[FLI]->st.st_mode, newname);
             fgetattr_s(Files[FLI]->name, newname); // for compatibility
           else
             strcpy(newname, ATTR_MASK);
           if (ch == 'A')
             say1("-123456789 <-toggle attrib's for current file. (press 'H' or F1 to get help)");
           else
             say1("-123456789 <-toggle attrib's for all selected files. (press 'H' or F1 to get help)");
           z = EditAttr(newname, ch != 'A' );
           say1(" ");
           say2(" ");
           if(z)
             {
             int err = 0;
             if ( ch == 'A' )
               {
               if(fsetattr_s(fi->name, newname) == 0)
                 {
                 stat(fi->name, &(fi->st));
                 fgetattr_s(fi->name, fi->stmode);
                 draw = 1;
                 RefreshView(FLI);
                 }
               else
                 err++;
               }
             else
               {
               for(z = 0; z < FilesCount; z++)
                 {
                 fi = Files[z];
                 if(fi->sel)
                   {
                   if(fsetattr_s(fi->name, newname) == 0)
                     {
                     stat(fi->name, &(fi->st));
                     fgetattr_s(fi->name, fi->stmode);
                     draw = 1;
                     RefreshView(z);
                     }
                   else
                     err++;
                   }
                 }
               }
             if(err == 0)
               {
               draw = 1;
               say1("Change attr's: ok.");
               }
             else
               {
               sp(sss, "Change attr's errors: %d", err);
               say1(sss);
               DescribeErrno();
               }
             }
           break;
  }
*/
}

/////////////////////////////////////////////
//
//
//
extern int MenuBoxAC;
void JumpToMount( int ALL = 0 )
{
  String str;
  int z;
  PSZCluster sc;
  sc.create( 8, 8 );
#ifdef _TARGET_UNIX_
  if (LoadFromFile( "/etc/mtab", &sc, 1024 )) return;
#endif
#ifdef _TARGET_GO32_
  str = HOME;
  str += "_vfu.mtb";
  if (LoadFromFile( str, &sc, 1024 )) return;
  if (ALL)
    {
    sc.ins( 0, "-  b:/" );
    sc.ins( 0, "-  a:/" );
    }
#endif
  if (sc.count() < 1) return;

  mb.freeall();
  for(z = 0; z < sc.count(); z++)
    {
    str = sc[z];
    StrCut( str, " \t");
    StrGetFirstWord( str, " \t", sss );
    StrCut( str, " \t");
    StrGetFirstWord( str, " \t", sss );
    sc.put( z, sss );

    struct statfs stafs;
    statfs( sss, &stafs );
    int hk = ('A'+z);
    #ifdef _TARGET_GO32_
    if (toupper(sss[0]) >= 'A' && toupper(sss[0]) <= 'Z' && toupper(sss[1]) == ':')
      hk = toupper(sss[0]);
    #endif
    sprintf( str, "%c | %-20s | %8.1fM | %8.1fM | ", hk, sss, stafs.f_bsize * (opt.RealFreeSpace?stafs.f_bfree:stafs.f_bavail) / (1024.0*1024.0),stafs.f_bsize * stafs.f_blocks / (1024.0*1024.0));

    mb.add(str);
    }
  ConMenuBoxAC = KEY_CTRL_U;
  z = MenuBox( 20, 5, "Jump to mount-point (free/total) Ctrl+U=umount" );
  if ( z == -1 )   return;
  if (ConMenuBoxAC == -2)
    {
    str = sc.get(z);
    FixPath( str );
    if ( PathCmp( str, CPath ) == 0 )
      {
      say1( "Warning: cannot unmount current directory" );
      return;
      }
    str = "umount " + str + " 2> /dev/null";
    sprintf( sss, "Unmounting, exec: %s", str.asis() );
    say1( sss );
    if (system( str ) == 0)
      say1( "umount ok" );
    else
      say1( "umount failed" );
    }
  else
    ChDir( sc.get(z) );
}
/////////////////////////////////////////////
//
//
//

extern char ConMenuHideMagic[32];
void ReadFilesMenu()
{
  int z;
  String str;
  mb.freeall();
  mb.add( "T Rescan DirTree" );
  mb.add( "F Rescan Files" );
  mb.add( "R Rescan Files Recursive" );
  mb.add( "E External Read Files" );
  mb.add( "D ReDraw Screen" );
  if ( Panelizers.count() > 0 )
    {
    mb.add( "--panelizers---" );
    for ( z = 0; z < Panelizers.count(); z++ )
      {
      str = Panelizers[z];
      StrGetFirstWord( str, ",", sss );
      str = sss+1;
      str = "  " + str + "$$";
      str += z;
      StrSetCh( str, 0, sss[0] );
      mb.add( str );
      };
    }
  strcpy( ConMenuHideMagic, "$$" );
  z = MenuBox( 25, 5, "Read/Rescan Files" );
  if ( z == -1 ) return;
  strcpy( ConMenuHideMagic, ""   );
  str = mb[z];
  if ( StrRFind(str, "$$") != -1 )
    {
    StrTrimL( str, StrRFind( str, "$$" ) );
    StrCut( str, "$" );
    z = atoi( str );
    if ( z < 0 || z > Panelizers.count()-1 ) return;
    str = Panelizers[z];
    StrGetFirstWord( str, ",", sss );

    str += "|";
    String save_mask = FMASK;
    UpdateShellStr( str.asis(), FMASK, sss);
    ReadFiles( RF_NORMAL, 1 );
    strcpy( FMASK, save_mask );
    draw = 1;
    }
  else
  switch(toupper(MenuBoxExitCh))
    {
    case 'T' : RebuildTree(); break;
    case 'F' : ReadFiles( RF_NORMAL, 1 ); break;
    case 'R' : ReadFiles( RF_RECURSIVE ); break;
    case 'D' : ConCS(); RefreshAllViews(); draw = 1; break;
    }
};

/////////////////////////////////////////////
//
//
//
void Options()
{
  say1("OPTIONS: ...none yet... try `O' for Toggles");
  say2("         ");
  ConGetch();
  say1( " " );
  say2( " " );
}

/////////////////////////////////////////////
//
// init/done's and help
//
void Help()
{

  mb.freeall();
  mb.add( "Arrows, PageUp/Dn, [, ], {, } -- Navigation keys" );
  mb.add( "+, =, ENTER  -- Enter into directory/View file"     );
  mb.add( "-, BS, ^H    -- Change current dir to '..'"         );
  mb.add( " -->    -- Rename current file ( Right Arrow ) " );
  mb.add( "TAB     -- Edit entry: filename, atrrib's/mode, owner, group");
  mb.add( "space   -- Select/deselect current file/directory"   );
  mb.add( "d       -- Change directory"                         );
  mb.add( "D       -- ChDir History ( Alt+D should also work )" );
  mb.add( "Ctrl+D  -- Directory tree "                          );
  mb.add( "~       -- Change current dir to HOME directory"     );
  mb.add( "A, a    -- Arrange/Sort file list"                   );
  mb.add( "r       -- Rescan directory/refresh file list"       );
  mb.add( "R       -- refresh screen only."                     );
  mb.add( "Ctrl+R  -- Rescan Files/Tree menu ( Recursive Scan too )" );
  mb.add( "f       -- Change file masks (space-delimited)       ");
  mb.add( "           or `command |' for external scanning (i.e. add `|' at the end)" );
  mb.add( "F       -- Reset file mask to '*'"                    );
  mb.add( "b/B     -- Browse/View selected/current file"         );
  mb.add( "G, g    -- Global select/deselect"                    );
  mb.add( "e/E     -- Erase/remove selected/current file(s)!"    );
  mb.add( "c/C     -- Copy selected/current file(s)"             );
  mb.add( "m/M     -- Move selected/current file(s)"             );
  mb.add( "l/L     -- SymLink selected/currnet file(s) into new directory" );
  mb.add( "J, j    -- Jump to mountpoint"                       );
  mb.add( "n       -- File find"                                );
  mb.add( "N       -- Last File find results ( or Alt+N )"      );
  mb.add( "Ctrl+N  -- File find menu ( Find/Scan/Hex/Regexp string search )");
  mb.add( "o       -- Toggles/Options menu ( or Alt+O )"       );
  mb.add( "t/T     -- Tools menu"                              );
  mb.add( "u/U     -- UserMenu (user external commands bound to menu instead of key)" );
  mb.add( "z       -- calculate dir size"                      );
  mb.add( "Z       -- show all directories sizes ( or Alt+Z )" );
  mb.add( "Ctrl+Z  -- show size of the current (under the cursor >>) directory");
  mb.add( "v/V     -- Edit vfu.conf file");
  mb.add( "!       -- Shell (also available with '?')"                         );
  mb.add( "/       -- Command line"                                            );
  mb.add( "`       -- Goto preset dir ( or Alt+0..9 )");
  mb.add( ">       -- Toggle show filenames only (screen wide) ( or Alt+= )");
  mb.add( "ESC+ESC -- exits VFU ( with confirmation )");
  mb.add( "q/Q     -- exit here ( to the current directory)");
  mb.add( "x/X     -- exit to old/startup directory ( or Alt+X )");
  mb.add( "NOTE: Alt+Letter keys are equal to Capital letters in the same context");
  mb.add( "vfu uses these config files:");
  mb.add( "        1. $HOME/$RC_PREFIX/.vfu/vfu.conf");
  mb.add( "        2. " VFU_RCPATH0 "vfu.conf ");
  mb.add( "        3. " VFU_RCPATH1 "vfu.conf ");
  mb.add( "        4. " VFU_RCPATH2 "vfu.conf ");
  mb.add( "" );
  MenuBox( 1, 4, "VFU Help ( PageUp/PageDown to scroll )" );
  mb.freeall();
  draw = 1;
/*
ConXY(1,LastRow);
// tcsetattr(1, TCSANOW,&oldstate);
ConFG( cCYAN );
ConPuts(
HEADER
"\nArrows, PageUp/Dn, [, ], {, } -- Navigation keys\n"
"+, =, ENTER  -- Enter into directory/View file\n"
"-, BS, ^H    -- Change current dir to '..'\n"
"d      -- Change directory\n"
"D      -- ChDir History ( Alt+D should also work )\n"
"Ctrl+D -- Directory tree \n"
"~      -- Change current dir to HOME directory\n"
"A, a   -- Arrange/Sort file list\n"
"r      -- Rescan directory/refresh file list\n"
"R      -- refresh screen only.\n"
"Ctrl+R -- Rescan Files/Tree menu ( Recursive Scan too )\n"
"f      -- Change file masks (space-delimited)\n          or `command |' to use external scanning ( i.e. add `|' at the end )\n"
"F      -- Reset file mask to '*'\n"
"b/B    -- Browse/View selected/current file\n"
"G, g   -- Global select/deselect\n"
"e/E    -- Erase/remove selected/current file(s)!\n"
"c/C    -- Copy selected/current file(s)\n"
"m/M    -- Move selected/current file(s)\n"
"l/L    -- SymLink selected/currnet file(s) into new directory/filename\n"
"\n--press a key---\n"
);
ConGetch();
ConPuts(
"RightArrow -- Rename current file\n"
"TAB    -- Edit entry: filename, atrribs, owner, group\n"
"J, j   -- Jump to mountpoint\n"
"n      -- File find\n"
"N      -- Last File find results ( or Alt+N )\n"
"Ctrl+N -- File find menu ( Find/Scan/Hex/Regexp string search )\n"
"space  -- Select/deselect file\n"
"o      -- Toggles/Options ( or Alt+O )\n"
"t/T    -- Tools\n"
"z      -- calculate dir size\n"
"Z      -- show all directories sizes ( or Alt+Z )\n"
"Ctrl+Z -- show size of the current (under the cursor >>) directory\n"
"!      -- Shell (also available with '?')\n"
"/      -- Command line\n"
"`      -- Goto preset dir (Alt+0..9 also available on some terminals)\n"
"ESC+ESC -- exits VF/U, `Q' or `q' -- exit here, `X' or `x' -- exit to old dir\n"
"NOTE: Alt-Letter keys are equal to Upper case letters in the commands context\n"
"vfu uses these config files:  $HOME/.vfurc  or  " VFU_RCPATH0 "vfurc " VFU_RCPATH1 "vfurc " VFU_RCPATH2 "vfurc " "\n"
"\n--press a key---\n"
);
// tcsetattr(1, TCSANOW,&newstate);
ConGetch();
say1(" ");
say2(" ");
draw = 1;
*/
};

void VFUinit()
{
  WorkMode = wmNormal;
  AName[0] = 0;
  AX = -1;
  
  srand( time( NULL ) );
  
  uid_t _uid = getuid();
  gid_t _gid = getgid();
  struct passwd* _pwd = getpwuid(_uid);
  struct group*  _grp = getgrgid(_gid);
  if (_pwd) strcpy(UIDstr, _pwd->pw_name); else sprintf(UIDstr, "%d", _uid);
  if (_grp) strcpy(GIDstr, _grp->gr_name); else sprintf(GIDstr, "%d", _gid);
  gethostname( HOSTstr, 32-1 );
  
  #ifdef _TARGET_GO32_
  strcpy( UIDstr, "dosuser" );
  strcpy( GIDstr, "dos" );
  __opendir_flags = __OPENDIR_FIND_HIDDEN;
  #endif
  
  if (getenv("SHELL")) strcpy(SHELL, getenv("SHELL"));
  #ifdef _TARGET_GO32_
  if ( SHELL[0] == 0 ) if (getenv("COMSPEC")) strcpy(SHELL, getenv("COMSPEC"));
  #endif
  if (getenv("VFUSHELL")) strcpy(SHELL, getenv("VFUSHELL"));
  
  if (getenv("HOME")) strcpy(HOME, getenv("HOME"));
  StrTR( HOME, "\\", "/" );
  if ( HOME[0] && HOME[strlen(HOME) - 1] != '/' ) strcat( HOME, "/" );
  #ifdef _TARGET_GO32_
  if ( HOME[0] == 0 ) strcpy(HOME, SD);
  #endif
  
  strcpy(TEMP, ".");
  if (getenv("TEMP")) strcpy(TEMP, getenv("TEMP"));
  StrTR( TEMP, "\\", "/" );
  FixPath(TEMP);

  RCDir = GetRcDir( "vfu" );
  
  int z;
  
  for (z=0; z < MaxFiles; z++) Files[z] = NULL;
  for (z=0; z < 10; z++) PresetDir[z][0] = 0;
  
  //########################################################################
  // init 'opt'inons
  //
  memset( &opt, 0, sizeof(opt) );
  
  opt.SortOrder = 'U';
  opt.Reversed = 'A';
//  opt.GlobalSelectMask[0] = 0;
  // opt.toggles
  opt.LongNameView = 0;
  opt.ShowLinks = 1;
  #ifdef _TARGET_GO32_
  opt.VFStyle = 1;
  #else
  opt.VFStyle = 1; // normally should looks like VF
  #endif
  
  opt.fSize = 1;
  opt.fTime = 1;
  opt.fTimeType = 0;
  opt.fAttr = 1;
  opt.fGroup = 1;
  opt.fOwner = 1;
  opt.fType = 1;
  
  #ifdef _TARGET_GO32_
  opt.fGroup = 0;
  opt.fOwner = 0;
  #endif
  
  opt.AutoTree = 1;
  opt.CompactTree = 1;
  opt.DynamicScroll = 0;
  opt.TopDirs = 1;
  opt.HideDotNames = 0;
  #ifdef _TARGET_GO32_
  opt.VFFilenames = 0;
  opt.DOSSlashes = 1;
  #endif
  opt.DirTreeSizes = 0;
  opt.AutoUpdateDSize = 1;
  opt.AllowBeep = 1;
  opt.CDTree = 0;
  opt.AltMenus = 0;
  opt.ExitCDHack = 0;
  
  opt.AskExit = 1;
  opt.FileColors = 1;
  opt.UseDirColors = 0;
  opt.FreeSpaceCheck = 1;
  
  opt.TagMark = 0;
  opt.NoCaseArcs = 0;
  opt.AltArrowsNav = 0;
  
  opt.IntBrowser = 1;
  opt.IntEditor = 1;
  opt.FFExpandMask = 1;
  opt.FMExpandMask = 1;
  opt.GENExpandMask = 1;
  opt.CLSonShell = 1;
  
  opt.SameCaseKeys = 0;

  opt.KeepArrangePos = 1;

  opt.ZapROs = 0;
  opt.FileCopyOwner = 1;
  strcpy( ArcTempFile, "__vful__.tmp" );
  
  opt.RealFreeSpace = 0;
  opt.MenuBorders = 0;
  opt.AutoMount = 0;
  opt.PreserveSelection = 1;

  opt.BashComplete = 1;
  
  // load options and settings -- vfurc & vfu.opt
  SetupFiles();
  LoadSettings();
  
  // HACK!!!
  // if (opt.SortOrder == 'M') opt.SortOrder = 'N';
  
  DirTree.create(16,16);
  mb.create( 32, 16 ); // menu box items
  ffr.create( 32, 32 );
  
  FINDEX.settype( opt.DynamicScroll );
  FINDEX.min = 0;
  FINDEX.max = 0;
  PS  = MAXY - 7; // this should be before FGO()!!!
  FGO(0);
  
  GetCPath();
  strcpy( SD, CPath );
  
  if (opt.DirTreeSizes )
    {
    if (DirTree.count() == 0) LoadTree();
    if (DirTree.count() == 0) RebuildTree();
    }

  //////////////////////////////////////////
  // setup signals to VFUdone
  // this is a patch but at least will reset terminal and save settings
  signal( SIGINT  , VFUsignal );
  signal( SIGHUP  , VFUsignal );
  signal( SIGTERM , VFUsignal );
  signal( SIGQUIT , VFUsignal );
  // this is for xterm resize refresh handle
  // signal( SIGWINCH, VFUsignal );
  // still doesn't work?...
  // HELP: I tried (as it is said in the curses-intro doc)
  // that I have to do endwin and wrefresh and all will be ok...
  // but it is not... :(
  
  //////////////////////////////////////////
    
  ReadFiles();
  draw = 1;
}

//////////////////////////////////////////////////////////////////////////
//
//
//

void ExitCDHack( const char *s )
{
  #ifdef _TARGET_GO32_
  return; // this is meaningless under DOS
  #else
  if ( !opt.ExitCDHack ) return;

  String str = RCDir;
  str += "vfu.hcd";

  FILE *f = fopen( str, "wt" );
  if (!f) return;
  fputs(s, f);
  fclose(f);
  #endif
}

int ExitVFU() // returns 0 for exit
{
  int z;
  mb.freeall();
  mb.add( "X Exit (old dir)" );
  mb.add( "Q Quit (here)   " );
  if (opt.AskExit)
    {
    Beep();
    z = MenuBox( 50, 5, "  Exit VFU?" );
    }
  else
    z = 1;
  if (z != 0 && z != 1) return 1;
  if (z == 0) { ExitCDHack( SD    ); chdir( SD    ); return 0; }
  if (z == 1) { ExitCDHack( CPath ); chdir( CPath ); return 0; }
  return 1;
  // break;
}

//////////////////////////////////////////////////////////////////////////
//
//
//

void IncSearch()
{
  CharSet cset; // used for searching
  cset.setr( 'a', 'z' );
  cset.setr( 'A', 'Z' );
  cset.setr( '0', '9' );
  cset.set ( "._-~" );
  cset.set ( "?*>" );

  String str;
  say1( "Enter search string: ( use TAB to advance, `>pattern' accepted as well! )" );
  int key = ConGetch();
  while( cset.in( key ) || key == 8 || key == KEY_BACKSPACE || key == 9 )
    {
    if ( key == 8 || key == KEY_BACKSPACE )
      StrTrimR( str, 1 );
    else
    if ( key != 9 )
      StrAddCh( str, key );
    say2( str );
    int z;
    if ( key == 9 )
      {
      z = FLI+1;
      if ( z > FINDEX.max ) z = FINDEX.min;
      }
    else
      z = FLI;
    int direction = 1;
    int found = 0;
    while(1)
      {
      if ( FLI > 0 && z == FLI-1 ) break;
      if ( FLI == 0 && z == FINDEX.max ) break;

      int rr;
      if (StrGetCh( str, 0) == '>')
        rr = FNMATCH( str.asis()+1, Files[z]->name);
      else
        rr = PathNCmp( str, Files[z]->name, str.len() );
      found = ( rr == 0 );
      if (found) break;
      z += direction;
      if ( z > FINDEX.max ) z = FINDEX.min;
      if ( z < FINDEX.min ) z = FINDEX.max;
      }
    if (found)
      {
      FGO(z);
      ReDraw();
      ShowPos( FLI+1, FilesCount );
      }
    key = ConGetch();
    }
  say1( "" );
  say2( "" );
}

//////////////////////////////////////////////////////////////////////////
//
//
//

void VFUrun()
{
// sprintf( sss, "XFiles: %s %s %s %s", HOME, (const char*)(CFGFILE), (const char*)(OPTFILE), (const char*)(TREEFILE) ); say1(sss);
sprintf( sss, "(rcdir: %s)", (const char*)(RCDir) );
if ( strcmp( UIDstr, "root" ) == 0 )
  {
  say1( "*** WARNING: YOU HAVE GOT ROOT PRIVILEGES! ***" );
  say2( sss );
  }
else
  say1( sss );

int ch = 'r';
while (4)
  {
  if (draw) { ReDraw(); ReDrawSta(); draw = 0; }
  ShowPos( FLI+1, FilesCount );
//  ConCE(); // tova trie sledvashtiq red :(
  ch = ConGetch();
  if (opt.SameCaseKeys) if ( ch >= 'A' && ch <= 'Z' ) ch = tolower( ch );
  say1( "" ); say2( "" );
  if ( WorkMode == wmNormal || WorkMode == wmInArchive ) switch (ch)
    {
    case KEY_CTRL_S: IncSearch(); break;

    case 'q'       : ExitCDHack( CPath ); chdir( CPath ); return;
    case 'Q'       : ExitCDHack( CPath ); chdir( CPath ); return;

    case KEY_ALT_X :
    case 'x'       :
    case 'X'       : ExitCDHack( SD ); chdir( SD ); return;

    case 27        : if(ExitVFU() == 0) return; break;

    case KEY_UP    : __Up(); break;
    case KEY_DOWN  : __Dn(); break;
    case KEY_PPAGE : __PU(); break;
    case KEY_NPAGE : __PD(); break;
    case KEY_HOME  : __Home(); break;
    case KEY_END   : __End(); break;

    case 'h' : Help(); break;
    case 'H' : Help(); break;

    case '[' : __Up(); break;
    case ']' : __Dn(); break;
    case '{' : __PU(); break;
    case '}' : __PD(); break;

    case KEY_CTRL_D : ViewTree(); break;
    case KEY_CTRL_R : ReadFilesMenu(); break;

    case 'R' : ConCS(); RefreshAllViews(); draw = 1; break;
    case ' ' : __Select(); break;

#ifdef _TARGET_UNIX_
    case KEY_BACKSPACE :
#endif
    case 8   :
    case '-' : ActionMinus(); break;

    case 13  :
    case '+' :
    case '=' : ActionPlus( ch ); break;

    case KEY_LEFT  : if (opt.AltArrowsNav) ActionMinus(); break;
    case KEY_RIGHT : if (!opt.AltArrowsNav)
                       EditNameInPlace();
                     else
                       ActionPlus( '+' );
                     break;

    case 'd' : ChDir(); break;
    case 'D' : ChDirHistory(); break;
    case KEY_ALT_D : ChDirHistory(); break;

    case 'b' :
    case 'B' :
    case KEY_ALT_B : if ( WorkMode == wmNormal ) {
                     draw = 1; ConCS();
                     if ( ch == 'b' && SelCount > 0 )
                       BrowseSelectedFiles();
                     else
                       Browse( Files[FLI]->name );
                     break; }

    case KEY_ALT_EQ :
    case '>' : opt.LongNameView = !opt.LongNameView; RefreshAllViews(); draw = 1; break;

    case 'a' : SortFiles(); break;
    case 'A' : SortFiles(); break;

    case 'g' : GlobalSelect(); break;
    case 'G' : GlobalSelect(); break;

    case 'o' : DoToggles(1); break;
    case 'O' : DoToggles(); break;
    case KEY_ALT_O : DoToggles(); break;

    case 'v' :
    case 'V' : EditCfgFile(); break;

    case '!' :
    case '?' : ConCS(); Shell( SHELL, 0 ); draw = 1; break;

    case KEY_CTRL_T  : {
      say1( "Timing screen draws (x1000)..." ); clock_t t = clock();
      for(int z = 0; z < 1000; z++) ReDraw(); t = clock() - t;
      sprintf(sss,"Draw speed: %f dps.",(100.0/((double)t/CLOCKS_PER_SEC))); say1(sss);
      break; }

    case '*' : FGO( rand() % FilesCount ); draw = 1; break;

    case 'z' : DirsSizes( -2 ); break;
    case KEY_ALT_Z :
    case 'Z' : DirsSizes( -1); break;
    case KEY_CTRL_Z : DirsSizes(FLI); break;
    }
  if ( WorkMode == wmInArchive ) switch (ch)
    {
    case 'r' : ReadFiles( RF_NORMAL, 1 ); draw = 1; break;

    case 'c' : ExtractArchiveFiles(0); break;
    case 'C' : ExtractArchiveFiles(1); break;
    case KEY_ALT_C : ExtractArchiveFiles(1); break;
    }
  if ( WorkMode == wmNormal ) switch (ch)
    {

    case 'n' : FileFind( 0 ); break;
    case 'N' : FileFindResults(); break;
    case KEY_ALT_N  : FileFindResults(); break;
    case KEY_CTRL_N : FileFind( 1 ); break;

    case 'r' : ReadFiles( RF_NORMAL, 1 ); draw = 1; break;

    case '~' : ChDir(HOME); break;

    case '/' : Command(); break;

    case 'i' : EditFile(); break;
    case 'I' : EditFile(); break;

    case 'm'       : CopyMoveFiles(0, cmMOVE); break;
    case 'M'       : CopyMoveFiles(1, cmMOVE); break;
    case KEY_ALT_M : CopyMoveFiles(1, cmMOVE); break;

    case 'c'       : CopyMoveFiles(0, cmCOPY); break;
    case 'C'       : CopyMoveFiles(1, cmCOPY); break;
    case KEY_ALT_C : CopyMoveFiles(1, cmCOPY); break;

    case 'l'       : CopyMoveFiles(0, cmLINK); break;
    case 'L'       : CopyMoveFiles(1, cmLINK); break;
    case KEY_ALT_L : CopyMoveFiles(1, cmLINK); break;

    case 'e'       : EraseFiles(0); break;
    case 'E'       : EraseFiles(1); break;
    case KEY_ALT_E : EraseFiles(1); break;

    case 'f'       : ChFileMask( NULL ); break;
    case 'F'       : ChFileMask( "*" ); break;
    case KEY_ALT_F : ChFileMask( "*" ); break;

    case 'j'       :
    case 'J'       : JumpToMount(); break;
    case KEY_ALT_J : JumpToMount( 1 ); break;

    case '`'       : GotoPresetDir( 0 ); break;
    case KEY_ALT_1 : GotoPresetDir( '1' ); break;
    case KEY_ALT_2 : GotoPresetDir( '2' ); break;
    case KEY_ALT_3 : GotoPresetDir( '3' ); break;
    case KEY_ALT_4 : GotoPresetDir( '4' ); break;
    case KEY_ALT_5 : GotoPresetDir( '5' ); break;
    case KEY_ALT_6 : GotoPresetDir( '6' ); break;
    case KEY_ALT_7 : GotoPresetDir( '7' ); break;
    case KEY_ALT_8 : GotoPresetDir( '8' ); break;
    case KEY_ALT_9 : GotoPresetDir( '9' ); break;
    case KEY_ALT_0 : GotoPresetDir( '0' ); break;

    case  9        : EditEntry(); break;

    case 't'       :
    case 'T'       : Tools(); break;

    case 'U'       :
    case 'u'       : UserMenu(); break;

    }
  if (  (/*WorkMode == wmNormal &&*/ KEY_F1 <= ch && ch <= KEY_F10)
     || (/*WorkMode == wmNormal &&*/ KEY_SH_F1 <= ch && ch <= KEY_SH_F10)
     || (/*WorkMode == wmNormal &&*/ KEY_ALT_F1 <= ch && ch <= KEY_ALT_F10)
     || (/*WorkMode == wmNormal &&*/ KEY_CTRL_F1 <= ch && ch <= KEY_CTRL_F10)
     || (/*WorkMode == wmNormal &&*/ ch == KEY_IC) )
         UserExternals(ch);
  }
}

void VFUCLIHelp()
{
ConXY(1,1);
// tcsetattr(1, TCSANOW,&oldstate);
  ConFG( cCYAN );
  ConPuts(
    HEADER
    "Command line switches:\n"
    "  none    -- run in interactive mode (DEFAULT)\n"
    "  -h      -- this help screen\n"
    "  -i      -- go temporarily into interactive mode\n"
    "  -d path -- change current path to `path'\n"
    "  -r      -- rebuild DirTree (under DOS -- tip: see -d)\n"
    "  -t      -- view DirTree\n"
    "  -v      -- version information\n"
    "tips:\n"
    "  1. command line switches are executed in order!\n"
    "  2. example: vfu -d c:/dos/ -r -i\n"
    "  3. example: vfu -d c:/ -r -d d:/ -r -d e:/ -r\n"
    "compile information:\n"
    "  target description: " _TARGET_DESCRIPTION_ "\n"
    "  compile date: " __DATE__ "\n"
    "\n*** press a key ***"
    );
  ConGetch();
}

void VFUCLI( int argc, char* argv[] )
{
  char tmp[1024];
  GETOPT("hrd:ti")
    {
    switch(optc)
      {
      case 'h'  : VFUCLIHelp(); break;
      case 'i'  : VFUrun(); break;
      case 'd'  : strcpy( tmp, optarg ); StrTR( tmp, "\\", "/" ); ChDir( tmp ); break;
      case 'r'  : ConOut(1,1,HEADER,chYELLOW); sprintf(sss, "Rebuilding DirTree... (CPath: %s)", CPath ); say2(sss); RebuildTree(); break;
      case 't'  : ConOut(1,1,HEADER,chYELLOW);
                  ViewTree();
                  ExitCDHack( CPath );
                  break;
      default:
        VFUCLIHelp();
        break;
      }
    }
}

void VFUdone()
{
  if ( DirTreeChanged && opt.AutoTree ) SaveTree();
  DirTree.done();
  mb.done();
  ffr.done();
  SaveSettings();
}

void VFUsignal( int sig )
{
/*
  if ( sig == SIGWINCH )
    {
    ConSuspend();
    ConRestore();
    PS  = MAXY - 7;
    draw = 1;
    sprintf( sss, "SIGWINCH catch -- reset terminal %dx%d", ConMaxX(), ConMaxY() );
    say1( sss );
    signal( SIGWINCH, VFUsignal );
    return;
    }
*/
  ConBeep();
  ConCShow();
  ConCS();
  ConDone();
  printf( "VFU: Signal received: %d -- Terminated\n", sig );
  exit(200);
};

/////////////////////////////////////////////
//
// main()
//

int main( int argc, char* argv[] )
{
  printf(HEADER);
//  printf("\n\n\n");

  ConInit();
  ConCS();
  ConFG( cNORMAL );
  ConBG( cBLACK );
  ConCHide();

  draw = 1;

  VFUinit();
  if (argc > 1)
    VFUCLI( argc, argv );
  else
    VFUrun();
  VFUdone();

  ConCShow();
  ConCS();
  ConDone();

  printf("\nThank You for using VFU!\nContact author: cade@biscom.net, VFU WWW: http://www.biscom.net/~cade/vfu\n" );

  return 0;
}

