/* # skkinput (Simple Kana-Kanji Input)
 * skkldic.c --- search/create/update local dictionary.
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <sys/stat.h>

#include "skkmain.h"
#include "config.h"

/*
 * ؿΥץȥ
 */
int check_skkinput_jisyo_code( unsigned char *path ) ;
static int skkinput_copyFile( unsigned char *from, unsigned char *to ) ;
/*
 * ؿΥץȥ
 */
SkkinpSearchVector *add_SkkinpSearchVector
( SkkinpSearchVector *topp,   char *str,
  SkkinpSearchVector **rnode, int *rpos ) ;
SkkinpSearchVector *searchSudeniHenkanKakuteiShitamono
( char *henkankey, SkkinpSearchVector *top, int okuri ) ;
VectorIndex *makeSearchVectorIndex
( SkkinpSearchVector *top, int *totalnum, int flag ) ;
void free_SkkinpSearchVector( SkkinpSearchVector **top ) ;
void free_VectorIndex( VectorIndex **top ) ;
/* skkldrec.c */
unsigned long recentlyHenkanKakuteiKouhoWoFileNiKaku
( FILE *fp, int okuri ) ;
void clearHenkanKakuteiHash( void ) ;
SkkinpSearchVector *searchSudeniPurgeSaretamono
( unsigned char *henkankey, SkkinpSearchVector *top, int okuri ) ;

/* skkinput Ѥɽ꼭Υѥ*/
static unsigned char *skkinput_local_jisyo_path ;
/* local-jisyo θΥѡߥå*/
static mode_t skkinput_local_jisyo_mode ;
/* skkinput Ѥɽ꼭ΥХååפΥѥ*/
static unsigned char *skkinput_jisyo_backup_path ;
/* skk Ѥɽ꼭Υѥ*/
static unsigned char *skk_local_jisyo_path ;
/* skkinput record Υѥ*/
static unsigned char *skkinput_record_path ;
static unsigned char *skkinput_record_path_tmp ;
/* skkinput Ѥɽ꼭δɡ*/
static int  skkinput_local_jisyo_coding_system ;
/* skkinput Ѥɽ꼭 backup δɡ*/
static int  skkinput_jisyo_backup_coding_system ;
/* ~/.skk-jisyo Ѥɽ꼭δɡ*/
static int  skk_local_jisyo_coding_system ;
/* 񤬱Ƥ뤫ɤġ*/
extern int skkinput_jisyo_dirty ;

/* skk-local-jisyo õ뤫ɤ*/
extern int skkinput_search_skk_jisyo ;
/* skkinput-record 뤫ɤ*/
extern int skkinput_keep_record ;

extern unsigned long skkinput_j_count_kakutei ;
extern unsigned long skkinput_j_count_touroku ;

/*
 * emacs-lisp ˤ expand-file-name ؿ
 *-----
 * ֺǽ "~" ä home directory Ÿ뵡ǽ
 * Ƥ롣wild-card ʤȤˤбƤʤ
 * δؿƤ̤ skk-local-jisyo-path 뤳Ȥˤʤ롣
 * skk-local-jisyo-path  NULL Ǥʤä顢δؿƤФʤ
 * ȻפƤ¦Ǥ¿ʬåǤʤΤǡǥå
 * 롣
 */
unsigned char *expand_file_name( unsigned char *path )
{
  unsigned char *ptr ;
  unsigned char *home ;
  int len = strlen( path ) ;

  /* "~" Ȥ home directory ɽ뵭椬äƤν*/
  if( *path == '~' ){
    /* HOME Directory 褫롣*/
    home = getenv( "HOME" ) ;
    /* Home directory + ĤΥѥĹ malloc 롣*/
    ptr = malloc( strlen( home ) + len ) ;
    if( ptr == NULL ){
      /* malloc ԡĤ̿Ūʥ顼ʤΤǷ³ưϤʤ*/
      fprintf( stderr, "Memory fault.\n" ) ;
      exit( 1 ) ;
    }
    /* "~" Ÿơľ*/
    strcpy( ptr, home ) ;
    strcat( ptr, path + 1 ) ;
  } else {
    /* ɬפ̵硣*/
    ptr = ( unsigned char *)malloc( len ) ;
    strcpy( ptr, path ) ;
  }
  return ptr ;
}

/*
 * ɽ꼭˴ؤԤؿ
 */
int set_localjisyo
( unsigned char *jisyo_path,  unsigned char *jisyobak_path,
  unsigned char *record_path, unsigned char *master_localjisyo )
{
  struct stat local_jisyo_buf ;

  /* ΤʥѥĴ٤롣*/
  skkinput_local_jisyo_path  = expand_file_name( jisyo_path ) ;
  skkinput_jisyo_backup_path = expand_file_name( jisyobak_path ) ;
  skkinput_record_path       = expand_file_name( record_path ) ;
  skk_local_jisyo_path       = expand_file_name( master_localjisyo ) ;
  /* record ¤Ӥդ֥ե뤬ɬפˤʤ롣*/
  skkinput_record_path_tmp   =
    malloc( strlen( skkinput_record_path ) + 1 ) ;
  if( skkinput_record_path_tmp == NULL ){
    /* malloc ԡĤ̿Ūʥ顼ʤΤǷ³ưϤʤ*/
    fprintf( stderr, "Memory fault.\n" ) ;
    exit( 1 ) ;
  }
  strcpy( skkinput_record_path_tmp, skkinput_record_path ) ;
  strcat( skkinput_record_path_tmp, "~" ) ;
  /* coding system å롣*/
  skkinput_local_jisyo_coding_system =
    check_skkinput_jisyo_code( skkinput_local_jisyo_path ) ;
  skkinput_jisyo_backup_coding_system =
    check_skkinput_jisyo_code( skkinput_jisyo_backup_path ) ;
  skk_local_jisyo_coding_system =
    check_skkinput_jisyo_code( skk_local_jisyo_path ) ;
  
  /* skkinput-local-jisyo ΥѡߥåĴ٤롣*/
  if( stat( skkinput_local_jisyo_path, &local_jisyo_buf ) ){
    /* ޤumask 롣 umask  000 Ǥ롣*/
    skkinput_local_jisyo_mode = umask( 0 ) ;
    /*  umask ᤹*/
    umask( skkinput_local_jisyo_mode ) ;
    /* umask 򤫤ĤΥ⡼ɤ롣*/
    skkinput_local_jisyo_mode = 
      ( S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH ) &
      ( ~( skkinput_local_jisyo_mode ) ) ;
  } else {
    /* ȤäѡߥåѾ롣*/
    skkinput_local_jisyo_mode = local_jisyo_buf.st_mode ;
  }
  skkinput_j_count_touroku = 0 ;
  skkinput_j_count_kakutei = 0 ;
  return 0 ;
}

/*
 * ɽ꼭Τ˳ݤƤؿ
 */
int close_localjisyo( void )
{
  free( skkinput_local_jisyo_path ) ;
  free( skkinput_jisyo_backup_path ) ;
  free( skkinput_record_path ) ;
  free( skkinput_record_path_tmp ) ;
  free( skk_local_jisyo_path ) ;
  return 0 ;
}

/*
 * "["  "\0" ȸ򴹤ؿ
 */
static int replace_kakkoToNul( unsigned char *string )
{
  while( *string != '\0' ){
    if( *string == '[' ){
      *string = '\0' ;
      return True ;
    }
    string ++ ;
  }
  return False ;
}

/*
 * ե뤫ʸɤ߹ߡJIS ȻפΤʤ EUC Ѵʸ
 * ؿ
 */
int euc_fgets
( unsigned char *buffer, int len, FILE *fp, int echara,
  int coding_system, int ecflag )
{
  int c, status = 0, kflag = False ;

  while( len > 0 ){
    if( ( c = fgetc( fp ) ) == EOF )
      break ;
    if( coding_system ){
      /* JIS ξˤϵǽʸĴ٤롣*/
      switch( c ){
	/* ǽʸγϥɡ*/
      case 0x1b :
	status = c ;
	continue ;
	/* ʸ 0x1b ³ˤϵǽʸǤ롣*/
      case 0x24 :
      case 0x28 :
	if( status == 0x1b ){
	  status = c ;
	  continue ;
	} 
	break ;
	/* ʸ 0x1b,0x24/0x28 ³ˤϵǽʸǤ롣*/
      case 0x42 :
	if( status == 0x28 ){
	  kflag = False ;
	  status = 0 ;
	  continue ;
	} else if( status == 0x24 ){
	  kflag = True ;
	  status = 0 ;
	  continue ;
	}
	break ;
	/* ʳʸġ*/
      default :
	break ;
      }
      /* ե饰ΩäƤ顢8bitܤ򤿤Ƥ롣*/
      if( kflag )
	c |= 0x80 ;
    }
    /* ԥɤ򸫤ƤޤäˤϽλ롣*/
    if( c == echara ){
      /* Υե饰äƤ顢END ʸäƤޤ*/
      if( ecflag ){
	*buffer ++ = echara ;
	len -- ;
      }
      break ;
    }
    /* ɤ߹ʸ򤷤ޤ*/
    *buffer ++ = c ;
    len -- ;
  }
  /* ;͵Сü롣*/
  if( len > 0 )
    *buffer ++ = '\0' ;
  /* ɤ߻Ĥʸ֤*/
  return len ;
}

/*
 * ԥɤޤǥեɤФؿ
 */
int skip_file_until_jnewline( FILE *fp )
{
  int c ;
  /* פʤäˤϲԤޤɤФ*/
  while( ( c = fgetc( fp ) ) != EOF ){
    if( c == '\n' )
      return True ;
  }
  return False ;
}

/*
 * ʸо줹ޤǡեɤФؿ
 */
int skip_file_until( FILE *fp, unsigned char *string, int coding_system )
{
  char buffer[ TRANSBUFSIZE ] ;

  while( !feof( fp ) ){
    /* ʸɤ򸫤ơ EUC ؤѴ롣*/
    if( !euc_fgets( buffer, TEXTMAXLEN, fp, '\n', coding_system, False ) ){
      /* ԤǸޤɤळȤǤʤäĤĹΤа㤦*/
      if( !skip_file_until_jnewline( fp ) )
	return False ;
      continue ;
    }
    /* ꤵ줿ʸȰפ뤫ɤȽꤹ롣*/
    if( !strcmp( buffer, string ) )
      return True ;
  }
  return False ;
}

/*
 * 겾̵̾ζɽ꼭θԤؿ
 */
static SkkinpSearchVector *j_okurinasi_search_skkinput_jisyo_with_path
( unsigned char *jisyo_path, unsigned char *key,
  SkkinpSearchVector *top, int coding_system )
{
  FILE *fp ;
  unsigned char buffer[ TRANSBUFSIZE ] ;
  int status = 0, kflag, klen, found ;

  /* ޤ񤬳ʤСäˤʤʤ*/
  if( ( fp = fopen( jisyo_path, "rb" ) ) == NULL )
    return top ;

  /* 겾̾γϰ֤ޤ֡*/
  skip_file_until( fp, ";; okuri-nasi entries.", coding_system ) ;

  /* ĹƤ strncmp Τɬס*/
  klen = strlen( key ) ;
  found = False ;

  /* եƬ˸Ƥ*/
  while( !feof( fp ) ){
    /* ʸɤ򸫤ơ EUC ؤѴ롣*/
    euc_fgets( buffer, TEXTMAXLEN, fp, 0x20,
	       coding_system, False ) ;
    /* ȤιԤäˤϡԤޤɤФ*/
    if( buffer[ 0 ] == ';' || strncmp( buffer, key, klen ) || 
	buffer[ klen ] != '\0' ){
      /* ޤԥɤޤǤäȤФ*/
      if( !skip_file_until_jnewline( fp ) )
	break ;
      /* 겾̾ˤʤäƤޤä齪λ롣*/
      if( !strcmp( buffer, ";; okuri-ari entries." ) ){
	/* ޤ뤫⤷ʤȥõġ*/
	if( !skip_file_until( fp, ";; okuri-nasi entries.", 
			      coding_system ) )
	  break ;
      }
      status = 0 ;
      kflag = False ;
    } else {
      /* Ƥʸ󤬸դäν*/
      found = True ;
      break ;
    }
  }
  /* դʤäˤϡNULL ֤*/
  if( !found ){
    fclose( fp ) ;
    return top ;
  }
  /* դäνɤ߹ʸˤäƤϰԤɤ *
   * Ƥʤǽ⤢롣ա*/
  do{
    status = euc_fgets( buffer, TEXTMAXLEN, fp, '\n', 
			coding_system, False ) ;
    buffer[ TEXTMAXLEN ] = '\0' ;
    top = add_SkkinpSearchVector( top, buffer, NULL, NULL ) ;
  } while( !status ) ;

  fclose( fp ) ;
  return top ;
}

/*
 * 겾̾ζɽ꼭θԤؿ
 */
static SkkinpSearchVector *j_okuriari_search_skkinput_jisyo_with_path
( unsigned char *jisyo_path, unsigned char *key,
  SkkinpSearchVector *top, int coding_system )
{
  FILE *fp ;
  unsigned char buffer[ TRANSBUFSIZE ] ;
  int status = 0, kflag, klen, found ;

  /* ޤ񤬳ʤСäˤʤʤ*/
  if( ( fp = fopen( jisyo_path, "rb" ) ) == NULL )
    return top ;

  /* ĹƤ strncmp Τɬס*/
  klen = strlen( key ) ;
  found = False ;

  /* 겾̾γϰ֤ޤ֡*/
  skip_file_until( fp, ";; okuri-ari entries.", coding_system ) ;

  /* եƬ˸Ƥ*/
  while( !feof( fp ) ){
    /* ʸɤ򸫤ơ EUC ؤѴ롣*/
    euc_fgets( buffer, TEXTMAXLEN, fp, 0x20, coding_system, False ) ;
    /* ȤιԤäˤϡԤޤɤФ*/
    if( buffer[ 0 ] == ';' || strncmp( buffer, key, klen ) ||
	buffer[ klen ] != '\0' ){
      /* ޤԥɤޤǤäȤФ*/
      if( !skip_file_until_jnewline( fp ) )
	break ;
      /* 겾̵̾ˤʤäƤޤä齪λ롣*/
      if( !strcmp( buffer, ";; okuri-nasi entries." ) ){
	/* ޤ뤫⤷ʤȥõġ*/
	if( !skip_file_until( fp, ";; okuri-ari entries.", coding_system ) )
	  break ;
      }
      status = 0 ;
      kflag = False ;
    } else {
      /* Ƥʸ󤬸դäν*/
      found = True ;
      break ;
    }
  }
  /* դʤäˤϡNULL ֤*/
  if( !found ){
    fclose( fp ) ;
    return top ;
  }
  /* դäνɤ߹ʸˤäƤϰԤɤ *
   * Ƥʤǽ⤢롣ա*/
  do{
    /* 񤫤ɤ߽Ф*/
    status = euc_fgets( buffer, TEXTMAXLEN, fp, '\n', coding_system, False ) ;
    buffer[ TEXTMAXLEN ] = '\0' ;
    /* ľѴˤϴط̵ "/[/]/" ʬõ롣*/
    found = replace_kakkoToNul( buffer ) ;
    top = add_SkkinpSearchVector( top, buffer, NULL, NULL ) ;
    /* Ԥ򤭤ɤ߹Ƥʤ⤷ϡʾɤ *
     * "[" ̵Ѵ˴ط̵ʬʤΤʤ顢ȴ */
  } while( !status && !found ) ;

  fclose( fp ) ;
  return top ;
}

/*
 * ɽ꼭θԤؿ
 */
SkkinpSearchVector *j_search_skkinput_local_jisyo
( unsigned char *key, SkkinpSearchVector *top, int okuri )
{
  if( okuri ){
    /* ɽ꼭񤫤õޤ礦ġ*/
    top = j_okuriari_search_skkinput_jisyo_with_path
      ( skkinput_local_jisyo_path, key, top,
	skkinput_local_jisyo_coding_system ) ;
    /* .skk-jisyo 򸫤ΤߤʤΡ */
    if( skkinput_search_skk_jisyo )
      top = j_okuriari_search_skkinput_jisyo_with_path
	( skk_local_jisyo_path, key, top,
	  skk_local_jisyo_coding_system ) ;
  } else {
    /* ɽ꼭񤫤õޤ礦ġ*/
    top = j_okurinasi_search_skkinput_jisyo_with_path
      ( skkinput_local_jisyo_path, key, top,
	skkinput_local_jisyo_coding_system ) ;
    /* .skk-jisyo 򸫤ΤߤʤΡ */
    if( skkinput_search_skk_jisyo )
      top = j_okurinasi_search_skkinput_jisyo_with_path
	( skk_local_jisyo_path, key, top,
	  skk_local_jisyo_coding_system ) ;
  }
  return top ;
}

/*
 * ɽ꼭backup鸡Ԥؿ
 */
SkkinpSearchVector *j_search_skkinput_jisyo_backup
( unsigned char *key, SkkinpSearchVector *top, int okuri )
{
  if( okuri ){
    /* ɽ꼭񤫤õޤ礦ġ*/
    return j_okuriari_search_skkinput_jisyo_with_path
      ( skkinput_jisyo_backup_path, key, top,
	skkinput_jisyo_backup_coding_system ) ;
  } else {
    /* ɽ꼭񤫤õޤ礦ġ*/
    return j_okurinasi_search_skkinput_jisyo_with_path
      ( skkinput_jisyo_backup_path, key, top,
	skkinput_jisyo_backup_coding_system ) ;
  }
}

/*
 * ɽ꼭 completion Ԥؿ
 */
static SkkinpSearchVector *j_completion_skkinput_local_jisyo_sub
( unsigned char *jisyo_path, unsigned char *key,
  SkkinpSearchVector *top,  int coding_system )
{
  FILE *fp ;
  unsigned char buffer[ TRANSBUFSIZE + 1 ] ;
  int status = 0, kflag, klen, found ;

  /* ޤ񤬳ʤСäˤʤʤ*/
  if( ( fp = fopen( jisyo_path, "rb" ) ) == NULL )
    return top ;

  /* 겾̾γϰ֤ޤ֡*/
  skip_file_until( fp, ";; okuri-nasi entries.", coding_system ) ;
  
  /* ĹƤ strncmp Τɬס*/
  klen = strlen( key ) ;
  found = False ;

  /* եƬ˸Ƥ*/
  while( !feof( fp ) ){
    /* ʸɤ򸫤ơ EUC ؤѴ롣*/
    euc_fgets( buffer, TEXTMAXLEN, fp, 0x20,
	       coding_system, False ) ;
    /* ȤιԤäˤϡԤޤɤФ*/
    if( buffer[ 0 ] == ';' || strncmp( buffer, key, klen ) ||
	buffer[ klen ] == '\0' ){
      /* ޤԥɤޤǤäȤФ*/
      if( !skip_file_until_jnewline( fp ) )
	break ;
      /* 겾̾ˤʤäƤޤä齪λ롣*/
      if( !strcmp( buffer, ";; okuri-ari entries." ) ){
	/* ޤ뤫⤷ʤȥõġ*/
	if( !skip_file_until( fp, ";; okuri-nasi entries.", 
			      coding_system ) )
	  break ;
      }
      status = 0 ;
      kflag = False ;
    } else {
      /* Ƥʸ󤬸դäν*/
      if( !found ){
	/* Ƭ '/' Ƥ*/
	top = add_SkkinpSearchVector( top, "/", NULL, NULL ) ;
	found = True ;
      }
      top = add_SkkinpSearchVector( top, buffer, NULL, NULL ) ;
      top = add_SkkinpSearchVector( top, "/", NULL, NULL ) ;
    }
  }
  fclose( fp ) ;
  return top ;
}

/*
 * completion search ɽ꼭ФƤؿ
 */
SkkinpSearchVector *j_completion_skkinput_local_jisyo
( SkkinpSearchVector *top, unsigned char *completion_key )
{
  top = j_completion_skkinput_local_jisyo_sub
    ( skkinput_local_jisyo_path, completion_key, top,
      skkinput_local_jisyo_coding_system ) ;
  /* .skk-jisyo 򸫤ΤߤʤΡ */
  if( skkinput_search_skk_jisyo )
    top = j_completion_skkinput_local_jisyo_sub
      ( skk_local_jisyo_path, completion_key, top,
	skk_local_jisyo_coding_system ) ;
  return top ;
}

/*
 * եįơESC äƤ JIS8bit ܤΩäƤ륳
 * äƤ EUC ȤȽǤ뤫ʤŬʴؿ
 *----
 * skkinput-jisyo Ѥʴɤʤ褦ˡġ
 */
int check_skkinput_jisyo_code( unsigned char *path )
{
  FILE *fp ;
  int c, ret ;

  /* ե뤬¸ߤʤˤϡǾcoding system *
   * 򤹤롣*/
  if( ( fp = fopen( path, "rb" ) ) == NULL ){
    return CODING_SYSTEM_IS_EUC ;
  }
  ret = CODING_SYSTEM_IS_EUC ;
  while( ( c = fgetc( fp ) ) != EOF ){
    /* ʸդν*/
    if( c == 0x1b )
      ret = CODING_SYSTEM_IS_JIS ;
    /* 8bit ܤΩäƤν*/
    if( c & 0x80 )
      break ;
  }
  fclose( fp ) ;
  return ret ;
}

/*
 * VectorIndexList ˤҤüեؤžؿ
 */
void writeVectorIndexToFile( FILE *fp, VectorIndex *vNode )
{
  int len ;
  SkkinpSearchVector *sNode ;
  unsigned char *ptr ;
  /* ޤǽ "/" ɽ롣*/
  fputc( '/', fp ) ;
  /* ʲ򤿤ɤ롣*/
  while( vNode != NULL ){
    sNode = vNode->node ;
    ptr   = sNode->text + vNode->position ;
    len   = vNode->length ;
    while( len > 0 ){
      if( *ptr == '\0' ){
	sNode = sNode->next ;
	/* ޤ̵ȤϡԳФä㤢ʤ롼פȴ *
	 * 褫*/
	if( sNode == NULL ){
#ifdef DEBUG
	  fprintf( stderr, "I lost next skkinput-search-vector!\n" ) ;
#endif
	  fputc( '\n', fp ) ;
	  return ;
	}
	ptr = sNode->text ;
      }
      fputc( *ptr ++, fp ) ;
      len -- ;
    }
    /* θΤ "/" ɽ롣*/
    fputc( '/', fp ) ;
    vNode = vNode->next ;
  }
  fputc( '\n', fp ) ;
  return ;
}

/*
 * Ѵη̤񤭽Фؿ
 *-----
 * int okuri  char *daimoku ˤäꤢȤʤζ̤ĤƤޤ
 */
static unsigned long skkinput_updateHenkanResult
( FILE *fpSrc, FILE *fpDest, int okuri,
  unsigned char *daimoku, int coding_system )
{
  SkkinpSearchVector *top, *purgeTop ;
  VectorIndex *vTop, *vTopPurge ;
  char buffer[ TRANSBUFSIZE ] ;
  int ret, status, len ;
  unsigned long count = 0 ;

  /* ޤܤ򾧤롣󥫥ޥ參*/
  fprintf( fpDest, "%s\n", daimoku ) ;
  fflush( fpDest ) ;
  count ++ ;

  /* ˴ϿƤѴ¤٤򤹤롣*/
  count += recentlyHenkanKakuteiKouhoWoFileNiKaku( fpDest, okuri ) ;

  /* ͤˤե뤬̵ä顢ʲν̵롪 ɬ *
   * Ϥʤ */
  if( fpSrc == NULL )
    return count ;

  /* եƬޤᤷƤ*/
  rewind( fpSrc ) ;

  /* 겾̾γϰ֤ޤ֡*/
  skip_file_until( fpSrc, daimoku, coding_system ) ;

  /* եνλޤǥ󤹤롣*/
  while( !feof( fpSrc ) ){
    /* ʸɤ򸫤ơ EUC ؤѴ롣*/
    ret = euc_fgets( buffer, TEXTMAXLEN, fpSrc, 0x20, coding_system, False ) ;
    /* ȤιԤäˤϡԤޤɤФ*/
    /* ޤĹ᤮Ѵ⤹äȤФʤλȤʤ */
    if( buffer[ 0 ] == ';' || ret == 0 || buffer[ 0 ] == '\0' ){
      /* ޤԥɤޤǤäȤФ*/
      if( !skip_file_until_jnewline( fpSrc ) )
	break ;
      /* ޤ뤫⤷ʤȥõġ*/
      if( !skip_file_until( fpSrc, daimoku, coding_system ) )
	break ;
      /* 餫Υȥ꤬դäˤϡļġʤ *
       * Ȥ⺣ ";" ʤƥܥܥɽƤϤʤ*/
      continue ;
    }
    top = NULL ;
    /* ѴꤷΤ¸ߤ뤫ɤå롣*/
    top = searchSudeniHenkanKakuteiShitamono( buffer, top, okuri ) ;
    if( top == NULL ){
      purgeTop = NULL ;
      /* ѡ٤ΤǤ뤫ɤȽǤɬפǤ롣*/
      purgeTop = searchSudeniPurgeSaretamono( buffer, purgeTop, okuri ) ;
      if( purgeTop != NULL ){
	/* ѴꤷΤäƤʤȤȤϡΤ *
	 * ޽񤭽ФƤסĤǤȤǤȤ*/
	do {
	  /* 񤫤ɤ߽Ф*/
	  status = euc_fgets( buffer, TEXTMAXLEN, fpSrc, '\n',
			      coding_system, False ) ;
	  buffer[ TEXTMAXLEN ] = '\0' ;
	  top = add_SkkinpSearchVector( top, buffer, NULL, NULL ) ;
	  /* TEXTMAXLEN ɤƤˤϡޤ³뤫⤷ *
	   * ʤ*/
	} while( !status ) ;
	/* öѡ¦ϥåơ֥áࡣ*/
	vTopPurge = makeSearchVectorIndex( purgeTop, &len, False ) ;
	/* 줫顢ϥåơ֥򸫤ʤñڤФ*/
	vTop = makeSearchVectorIndex( top, &len, True ) ;
	/* ĤǤѴ̤¸ߤΤʤġ */
	if( vTop != NULL && len > 0 ){
	  /* դäѴ񤭽Ф*/
	  fprintf( fpDest, "%s ", buffer ) ;
	  /* VectorIndex եݤФĤοͤϺǸ'\n'  *
	   * Ƥ롣*/
	  writeVectorIndexToFile( fpDest, vTop ) ;
	  count ++ ;
	}
	/* ݤβ*/
	free_VectorIndex( &vTop ) ;
	free_VectorIndex( &vTopPurge ) ;
	free_SkkinpSearchVector( &top ) ;
	free_SkkinpSearchVector( &purgeTop ) ;
      } else {
	/* դäѴ񤭽Ф*/
	fprintf( fpDest, "%s ", buffer ) ;
	/* ѴꤷΤäƤʤȤȤϡΤ *
	 * ޽񤭽ФƤסĤǤȤǤȤ*/
	do {
	  /* 񤫤ɤ߽Ф*/
	  status = euc_fgets( buffer, TEXTMAXLEN, fpSrc, '\n',
			      coding_system, False ) ;
	  buffer[ TEXTMAXLEN ] = '\0' ;
	  fprintf( fpDest, "%s", buffer ) ;
	  /* TEXTMAXLEN ɤƤˤϡޤ³뤫⤷ *
	   * ʤ*/
	} while( !status ) ;
	fprintf( fpDest, "\n" ) ;
	fflush( fpDest ) ;
	count ++ ;
      }
    } else {
      /* ѴꤷƤΤǤФƤ롣ΤƤ롣*/
      free_SkkinpSearchVector( &top ) ;
      /* ޤԥɤޤǤäȤФ*/
      if( !skip_file_until_jnewline( fpSrc ) )
	break ;
    }
  }
  return count ;
}

/*
 * ե¸ߤ̵ͭĴ٤ؿ
 */
static int isFileExist( unsigned char *path )
{
  FILE *fp ;
  /* եɤ߹ߥ⡼ɤǳƤߤ롣*/
  if( ( fp = fopen( path, "rb" ) ) == NULL )
    return False ;
  /* Τʤ¸ߤ롣եĤ return True! */ 
  fclose( fp ) ;
  return True ;
}

static void skkinput_updateRecord( unsigned long lines )
{
  FILE *fpd, *fps ;
  time_t tval ;
  char buffer[ TRANSBUFSIZE ] ;
  int exist_record_p ;

  /* 1970/1/1ηв롣*/
  if( time( &tval ) == -1 )
    return ;

  /* ꤷȤʤäΤƤ롣*/
  if( skkinput_j_count_kakutei <= 0 )
    return ;
  /* 顼ȯܤǤ礦*/
  exist_record_p = isFileExist( skkinput_record_path ) ;
  if( exist_record_p ){
    /* ե򥳥ԡ롣link Ǥɤɤͤġ*/
    if( !skkinput_copyFile
       ( skkinput_record_path, skkinput_record_path_tmp ) ){
      return ;
    }
  }
  /* ե뤬ʤä顢롣*/
  if( ( fpd = fopen( skkinput_record_path, "w" ) ) == NULL )
    return ;
  /* ǯβǤ뤫롣*/
  (void)strftime
    ( buffer, TEXTBUFSIZE, "%a %b %d %T %Y", localtime( &tval ) ) ;
  fprintf
    ( fpd, "%s  Ͽ: %3ld  : %4ld  Ψ: %3ld%%  : %6ld\n",
     buffer, skkinput_j_count_touroku, skkinput_j_count_kakutei,
     ( skkinput_j_count_kakutei - skkinput_j_count_touroku ) * 100 /
     skkinput_j_count_kakutei, lines ) ;

  if( exist_record_p ){
    size_t num ;

    if( ( fps = fopen( skkinput_record_path_tmp, "r" ) ) == NULL ){
      fclose( fpd ) ;
      return ;
    }
    /* Ĥϥԡ롣*/
    while( !feof( fps ) ){
      num = fread( buffer, sizeof( char ), TEXTBUFSIZE, fps ) ;
      /* ǥե륷ƥեΥåäƤäɤȻפΤ */
      /* ɡ */
      if( fwrite( buffer, sizeof( char ), num, fpd ) < num ){
	/* ȥ顼ȯϴǤ*/
	fclose( fps ) ;
	fclose( fpd ) ;
	/* 񤳤Ȥեϻߤᡣ*/
	unlink( skkinput_record_path ) ;
	/* Ȥ᤹Ǥϥ顼åʤäƤ */
	/* äɤΡ */
	/* ա֤줸㡢ꤵ󡣤ɤޤ礦*/
	/* 1. դ̼ˤ롣*/
	/* 2. οͤ˻Ƥ餦*/
	/* 3. Τ󤾡*/
	link( skkinput_record_path_tmp, skkinput_record_path ) ;
	return ;
      }
    }
    fclose( fps ) ;
    /* եõ롣*/
    unlink( skkinput_record_path_tmp ) ;
  }
  fclose( fpd ) ;
  skkinput_j_count_kakutei = 0 ;
  skkinput_j_count_touroku  = 0 ;
  return ;
}

/*
 * ե򥳥ԡؿġ
 */
static int skkinput_copyFile( unsigned char *from, unsigned char *to )
{
  FILE *fpTo, *fpFrom ;
  int rnum ;
  unsigned char buffer[ TRANSBUFSIZE ] ;

  /* ԡ褬ʤäФ̣*/
  if( ( fpTo = fopen( to, "wb" ) ) == NULL )
    return False ;
  /* ԡʤäƤ⼺ԡ*/
  if( ( fpFrom = fopen( from, "rb" ) ) == NULL ){
    fclose( fpTo ) ;
    return False ;
  }
  rnum = 0 ;
  while( !feof( fpFrom ) ){
    rnum =
      fread( buffer, sizeof( unsigned char ), TRANSBUFSIZE, fpFrom ) ;
    /* ɤ߹᤿̤񤭹ġ*/
    if( fwrite( buffer, sizeof( unsigned char ), rnum, fpTo ) < rnum ){
      /* 񤭹̤ΤʤʤäƤĤϰ۾ȯ */
      /* ̤ϥե륷ƥե򵿤ɤ͡*/
      fclose( fpFrom ) ;
      fclose( fpTo ) ;
      /* Ȥ櫓ǡԡߤƺ꤫Υեõ롣*/
      unlink( to ) ;
      /* ԡȡ*/
      return False ;
    }
  }
  fclose( fpTo ) ;
  fclose( fpFrom ) ;
  return True ;
}

/*
 * ˺ѴꤷƤ񤭹ؿ
 */
void skkinput_updateLocalJisyo( void )
{
  FILE *fpSrc, *fpDest ;
  int isLocalJisyoExist, isJisyoBackupExist ;
  unsigned long lines ;

#ifdef DEBUG_LDIC
  fprintf( stderr, "Now saving ....\"%s\"\n", skkinput_local_jisyo_path ) ;
#endif
  /*
   * ֤ࡣɤäƼ褦ġ
   * ֤ͰͤλƤ뿿¤ʤɤ٤ΤΤǤʤΤ
   * ֤餳르ꥺ
   * ֤ɡߤʤϥܥΥ르ꥺʤΤʡ
   * ֤󤿡Х
   */
  /*
   * ʤơġ
   * 椫ꤷΤäƤΤʤ뤳ȤϰĤ
   *  A->B ؤ COPY ʤ顢դä٤Τä
   * 롣
   * A  backup ˤơbackup  B եˤ롣
   *  OK ΤϤǤϤ뤱ɡ
   * ֡ķ purge Ȥդ˺Ƥʡ߷
   */
  /* Хåå׼õ롣󡣤äȲİʡ */

  /* Ȥ BACKUP JISYO ¸ߤʤ硢ơLOCAL-JISYO  *
   * ¸ߤʤϤɤΤ */
  isLocalJisyoExist  = isFileExist( skkinput_local_jisyo_path ) ;
  isJisyoBackupExist = isFileExist( skkinput_jisyo_backup_path ) ;

  /* ɽ꼭ΥХååפ롣*/
  if( isLocalJisyoExist && isJisyoBackupExist )
    unlink( skkinput_jisyo_backup_path ) ;
  if( isLocalJisyoExist ){
    /* ɽ꼭񤫤Хåå׼ؤȥԡ롣*/
    if( !skkinput_copyFile
	( skkinput_local_jisyo_path, skkinput_jisyo_backup_path ) ){
#if DEBUG_LDIC
      fprintf( stderr, "cannot move local-jisyo to backup-jisyo...error!\n" ) ;
#endif
      /* 顼ȯ顢ȤꤢߡࡢХåå *
       * ϲ줿ޤޤ(^^;;;*/
      return ;
    }
    chmod( skkinput_jisyo_backup_path, skkinput_local_jisyo_mode ) ;
    /* ɽ꼭õ롣*/
    unlink( skkinput_local_jisyo_path ) ;
    /* ǥХååפ coding system  skkinput-local-jisyo  * 
     * coding system Ʊˤʤä*/
    skkinput_jisyo_backup_coding_system =
      skkinput_local_jisyo_coding_system ;
  }
  /* ࡣrename Ȧζɽ꼭ɤʤȤϤ *
   * ¸ߤʤǽ⤢뤫*/
  if( ( fpSrc = fopen( skkinput_jisyo_backup_path, "rb" ) ) == NULL ){
#ifdef DEBUG_LDIC
    fprintf( stderr, "cannot create backup jisyo...error!\n" ) ;
#endif
  }
  /* 񤭹ʤĤ̵ġ*/
  if( ( fpDest = fopen( skkinput_local_jisyo_path, "wb" ) ) == NULL ){
#ifdef DEBUG_LDIC
    fprintf( stderr, "cannot create local jisyo...error!\n" ) ;
#endif
    if( fpSrc != NULL )
      fclose( fpSrc ) ;
    /* backup 򸵤̾˥͡ह롣Ԥ뤫⤷ʤɡĤ *
     * ξˤ̵뤹뤷ʤʡ */
    skkinput_copyFile
      ( skkinput_jisyo_backup_path, skkinput_local_jisyo_path ) ;
    /* permission 򸵤᤹*/
    chmod( skkinput_local_jisyo_path, skkinput_local_jisyo_mode ) ;
    /* file coding system Ĵľ*/
    skkinput_local_jisyo_coding_system = 
      check_skkinput_jisyo_code( skkinput_local_jisyo_path ) ;
    return ;
  }
  lines = 0 ;
  /* 겾̾Ѵη̤񤭹ࡣ*/
  lines += skkinput_updateHenkanResult
    ( fpSrc, fpDest, True, ";; okuri-ari entries.",
      skkinput_jisyo_backup_coding_system ) ;
  /* 겾̵̾Ѵη̤񤭹ࡣ*/
  lines += skkinput_updateHenkanResult
    ( fpSrc, fpDest, False, ";; okuri-nasi entries.",
      skkinput_jisyo_backup_coding_system ) ;
  /* եݥ󥿤Ĥ롣*/
  if( fpSrc != NULL )
    fclose( fpSrc ) ;
  fclose( fpDest ) ;
  /* permission ꡣ*/
  chmod( skkinput_local_jisyo_path, skkinput_local_jisyo_mode ) ;
  /* ϥå򥯥ꥢåľ*/
  clearHenkanKakuteiHash() ;
  skkinput_local_jisyo_coding_system =
    check_skkinput_jisyo_code( skkinput_local_jisyo_path ) ;
  /* skkinput-keep-record ʤСġ*/
  if( skkinput_keep_record ){
    /* record file 򹹿롣*/
    skkinput_updateRecord( lines ) ;
  }
  skkinput_jisyo_dirty = False ;
#ifdef DEBUG_LDIC
  fprintf( stderr, ".......Done\n" ) ;
#endif
  return ;
}
