/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

/* Intel-specific information */
void Decode_Intel(void)
{
	unsigned int eax,ebx,ecx,edx;

	if (cpu0_data.MaxCPUID >= 1) {
		cpuid (1, &eax,&ebx,&ecx,&edx);

		cpu0_data.stepping = eax & 0xf;
        	cpu0_data.model = (eax >> 4) & 0xf;
        	cpu0_data.family = (eax >> 8) & 0xf;
	}

	if (cpu0_data.MaxCPUID >= 2) {
		cpuid(2, &eax,&ebx,&ecx,&edx);

		edx &= 0xff;	/* Just LSB */

		switch (edx) {
			case 0x40:	cpu0_data.ICACHE_size = 0;
					break;
			case 0x41:	cpu0_data.ICACHE_size = 128;
					break;
			case 0x42:	cpu0_data.ICACHE_size = 256;
					break;
			case 0x43:	cpu0_data.ICACHE_size = 512;
					break;
			case 0x44:	cpu0_data.ICACHE_size = 1024;
					break;
			case 0x45:	cpu0_data.ICACHE_size = 2048;
					break;
			default:	cpu0_data.ICACHE_size = 0;
					break;
		}
	}
}
