/*
 * GTimer
 *
 * Copyright:
 *	(C) 1998 Craig Knudsen, cknudsen@radix.net
 *	See accompanying file "COPYING".
 * 
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 * 
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 * 
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the
 *	Free Software Foundation, Inc., 59 Temple Place,
 *	Suite 330, Boston, MA  02111-1307, USA
 *
 * Description:
 *	Helps you keep track of time spent on different tasks.
 *
 * Author:
 *	Craig Knudsen, cknudsen@radix.net, http://www.radix.net/~cknudsen
 *
 * Home Page:
 *	http://www.radix.net/~cknudsen/gtimer/
 *
 * History:
 *	18-Mar-1998	Added calls to gtk_window_set_wmclass so the windows
 *			behave better for window managers.
 *	03-Mar-1998	Created
 *
 ****************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <pwd.h>
#include <time.h>
#include <memory.h>
#include <ctype.h>

#include <gtk/gtk.h>

#include "task.h"
#include "gtimer.h"

#ifdef GTIMER_MEMDEBUG
#include "memdebug/memdebug.h"
#endif

extern TaskData **visible_tasks;
extern int num_visible_tasks;
extern TaskData **tasks;
extern int num_tasks;
extern GtkWidget *status;
extern guint status_id;

typedef struct {
  TaskData *taskdata;
  GtkWidget *window;
  GtkWidget *name;
} EditData;


static void ok_callback ( widget, data )
GtkWidget *widget;
gpointer data;
{
  EditData *ed = (EditData *) data;
  TaskData *td;
  char *str;

  /* Update existing task */
  if ( ed->taskdata ) {
    str = gtk_entry_get_text ( GTK_ENTRY(ed->name) );
    if ( strcmp ( str, ed->taskdata->task->name ) ) {
      free ( ed->taskdata->task->name );
      ed->taskdata->task->name = (char *) malloc ( strlen ( str ) + 1 );
      strcpy ( ed->taskdata->task->name, str );
      ed->taskdata->name_updated = 1;
    }
    gtk_statusbar_push ( GTK_STATUSBAR ( status ), status_id, "Task updated" );
  }

  /* New Task */
  else {
    td = (TaskData *) malloc ( sizeof ( TaskData ) );
    memset ( td, '\0', sizeof ( TaskData ) );
    td->new_task = 1;
    str = gtk_entry_get_text ( GTK_ENTRY(ed->name) );
    td->task = taskCreate ( str );
    taskAdd ( td->task );
    tasks = (TaskData **) realloc ( tasks,
      ( num_tasks + 1 ) * sizeof ( TaskData * ) );
    tasks[num_tasks] = td;
    visible_tasks = (TaskData **) realloc ( visible_tasks,
      ( num_visible_tasks + 1 ) * sizeof ( TaskData * ) );
    visible_tasks[num_visible_tasks] = td;
    num_visible_tasks++;
    gtk_statusbar_push ( GTK_STATUSBAR ( status ), status_id, "Task added" );
  }

  gtk_grab_remove ( ed->window );
  gtk_widget_destroy ( ed->window );
  free ( ed );

  /* redraw the task list */
  update_list ();
}


static void cancel_callback ( widget, data )
GtkWidget *widget;
gpointer data;
{
  EditData *ed = (EditData *) data;
  gtk_grab_remove ( ed->window );
  gtk_widget_destroy ( ed->window );
  free ( ed );
}




/*
** Create the add/edit window.
** It's an add if taskdata is NULL.
*/
GtkWidget *create_edit_window ( taskdata )
TaskData *taskdata;
{
  GtkWidget *edit_window;
  GtkWidget *table;
  /*GtkTooltips *tooltips;*/
  GtkWidget *label, *name_text, *ok_button, *cancel_button;
  EditData *ed;

  ed = (EditData *) malloc ( sizeof ( EditData ) );
  ed->taskdata = taskdata;
  ed->window = edit_window = gtk_dialog_new ();
  gtk_window_set_wmclass ( GTK_WINDOW ( ed->window ), "GTimer", "gtimer" );
  if ( taskdata )
    gtk_window_set_title (GTK_WINDOW (edit_window), "GTimer: Edit Task" );
  else
    gtk_window_set_title (GTK_WINDOW (edit_window), "GTimer: Add Task" );
  gtk_window_position ( GTK_WINDOW(edit_window), GTK_WIN_POS_MOUSE );
  gtk_grab_add ( edit_window );
  gtk_widget_realize ( edit_window );

  table = gtk_table_new (1, 3, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (table), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table), 8);
  gtk_container_border_width (GTK_CONTAINER (table), 6);
  gtk_box_pack_start ( GTK_BOX ( GTK_DIALOG (edit_window)->vbox ),
    table, TRUE, FALSE, 5 );

  label = gtk_label_new ( "Task name: " );
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1,
    GTK_FILL, GTK_FILL, 0, 0);
  gtk_widget_show ( label );

  ed->name = name_text = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), name_text, 1, 3, 0, 1);
  if ( taskdata )
    gtk_entry_set_text ( GTK_ENTRY(name_text),
      taskdata->task->name );
  else {
    gtk_entry_set_text ( GTK_ENTRY(name_text), "Unnamed Task" );
    gtk_entry_select_region ( GTK_ENTRY(name_text), 0, 12 );
  }
  gtk_window_set_focus ( &GTK_DIALOG ( edit_window )->window,
    name_text );
  gtk_widget_show ( name_text );

  gtk_widget_show ( table );
  
  /* add command buttons */
  /*tooltips = gtk_tooltips_new ();*/

  ok_button = gtk_button_new_with_label ("Ok");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (edit_window)->action_area),
    ok_button, TRUE, TRUE, 5);
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
    GTK_SIGNAL_FUNC (ok_callback), ed);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (ok_button);
  gtk_widget_show (ok_button);
  /*gtk_tooltips_set_tips (tooltips, ok_button,
    "Save this task" );*/

  cancel_button = gtk_button_new_with_label ("Cancel");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (edit_window)->action_area),
    cancel_button, TRUE, TRUE, 5);
  gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
    GTK_SIGNAL_FUNC (cancel_callback), ed);
  gtk_widget_show (cancel_button);
  /*gtk_tooltips_set_tips (tooltips, cancel_button,
    "Edit the selected task" );*/

/*
  gtk_widget_show (hbox);
  gtk_widget_show (vbox);
*/
  gtk_widget_show (edit_window);

  return ( edit_window );
}


