#undef HAVE_CONFIG_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kiconloader.h>
#include <qpopmenu.h>
#include <ktopwidget.h>
#include "klocale.h"
#include "accountwidget.h"
#include <ktoolbar.h>

#include "balancedlg.h"
#include "reconciledlg.h"
#include "transferdlg.h"

/* #include <qdbt/qdbttabular.h>
#include <qdbt/qdbtsection.h>
#include <qdbt/qdbttabcell.h> */

#define IDX_ASSETS  1
#define IDX_PROFITS 2

/* void setText (QdbtTabular *tabular, int row, int col, char *text) {
  QdbtTableCell *cell2;

  cell2 = tabular->cell (row, col);
  cell2->setText (text); 
  tabular->changeCell (cell2,row, col);
} */


int AccountWidget::initMenu() {
  QPopupMenu *activities = new QPopupMenu;
  activities->insertItem( klocale->translate("&Transfer..."),ID_ACTIV_TRANSFER);
  activities->insertSeparator(); 
  activities->insertItem(  klocale->translate("&Reconcile..."),ID_ACTIV_RECONCILE);
  activities->insertItem(  klocale->translate("&Adjust Balance..."),ID_ACTIV_ADJBAL );
  activities->insertItem(  klocale->translate("&Report..."),ID_ACTIV_REPORT );
  activities->insertSeparator();
  activities->insertItem(  klocale->translate("&Delete Transaction"), ID_ACTIV_DELETE);
  activities->insertSeparator();
  activities->insertItem(  klocale->translate("&Close Window"), ID_ACTIV_CLOSE);

  QPopupMenu *help = new QPopupMenu;
  help->insertItem( klocale->translate("&About..."),ID_HELP_ABOUT);
  help->insertItem(  klocale->translate("&Help..."), ID_HELP_HELP);
  help->insertSeparator();
  help->insertItem(  klocale->translate("&License..."), ID_HELP_LICENSE);

//  connect (activities, SIGNAL (activated (int)), SLOT (menuCallback (int)));
//  connect (help, SIGNAL (activated (int)), SLOT (menuCallback (int)));

  menu = new KMenuBar( this );
  CHECK_PTR( menu );
  menu->insertItem( klocale->translate("&Activities"), activities );
  menu->insertSeparator();
  menu->insertItem( klocale->translate("&Help"), help );
  menu->show();
  setMenu(menu);

}

AccountWidget::AccountWidget() : KTopLevelWidget() {
  initMenu();

  KIconLoader *loader = kapp->getIconLoader();

  KToolBar * tb;
  KStatusBar *sb;

//  QdbtTabular *tabular;

  QPixmap pixmap;

  tb = new KToolBar (this);
  addToolBar (tb);

  pixmap = loader->loadIcon ("filenew2.xpm");
  tb->insertButton (pixmap,-1); 

//  connect(tb, SIGNAL(clicked(int)), this, SLOT(menuCallback(int)));  

  sb = new KStatusBar(this);
  setStatusBar (sb);

  sb->insertItem ("Assets: 12233,34 DM",IDX_ASSETS);   
  sb->insertItem ("Profits: 12233,34 DM",IDX_PROFITS);
  sb->insertItem ("",-1);

  resize(640,380);
  show();

  return;

/*  tabular = new QdbtTabular (this);
  setView (tabular);

  tabular->setMinimumSize (100,100);
  tabular->setDimensions(13,9);
  
  tabular->setColumnWidth(0,55);
  tabular->setColumnWidth(1,55);
  tabular->setColumnWidth(2,90);
  tabular->setColumnWidth(3,150);
  tabular->setColumnWidth(4,20);
  tabular->setColumnWidth(5,90);
  tabular->setColumnWidth(6,90);
  tabular->setColumnWidth(7,90); 
  tabular->hideHeader();

  QdbtSection *section; */

/*  section = tabular->section(0);
  section->setText("Date");
  section->setResizable (true);

  section = tabular->section(1);
  section->setText("Num");
  section->setResizable (true);

  section = tabular->section(2);
  section->setText("Transfer From");
  section->setResizable (true);

  section = tabular->section(3);
  section->setText("Description");
  section->setResizable (true);

  section = tabular->section(5);
  section->setText("Payment");
  section->setAlignment(AlignRight);
  section->setResizable (true);

  section = tabular->section(6);
  section->setText("Deposit");
  section->setAlignment(AlignRight);
  section->setResizable (true);

  section = tabular->section(7);
  section->setText("Balance");
  section->setAlignment(AlignRight);
  section->setResizable (true); */

  int x, y;

/*  QdbtTableCell cell;

  for (y=0; y < 13; y++) {
    for (x = 0; x < 8; x++) {
      cell.setEditable (true);
      if (x<5) cell.setAlignment (AlignLeft); else cell.setAlignment (AlignRight);
      if ((y & 0x01) != 0) cell.setBackground (cyan); else cell.setBackground (white);

      tabular->changeCell (&cell,y,x);
    }
  }

  setText (tabular, 0, 0, "Date");
  setText (tabular, 0, 1, "Num");
  setText (tabular, 0, 2, "Date");
  setText (tabular, 0, 3, "Transfer From");
  setText (tabular, 0, 4, "Description");
  setText (tabular, 0, 6, "Payment");
  setText (tabular, 0, 7, "Deposit"); 

  setText (tabular, 1, 0, "10/20");
  setText (tabular, 2, 0, "1997");
  setText (tabular, 3, 0, "10/21");
  setText (tabular, 4, 0, "1997"); 
  setText (tabular, 5, 0, "10/22");
  setText (tabular, 6, 0, "1997");
  setText (tabular, 7, 0, "10/28");
  setText (tabular, 8, 0, "1997"); 
  setText (tabular, 9, 0, "10/21");*/

}

AccountWidget::~AccountWidget() {
  delete menu;
}

void AccountWidget::menuCallback (int item) {
  switch (item) {
    case ID_ACTIV_TRANSFER : doTransfer(); break;
    case ID_ACTIV_RECONCILE : doReconcile(); break;
    case ID_ACTIV_ADJBAL : doAdjustBalance (); break;
    case ID_ACTIV_REPORT : break;
    case ID_ACTIV_DELETE : break;
    case ID_ACTIV_CLOSE : hide(); break;

    case ID_HELP_ABOUT : break;
    case ID_HELP_HELP : break;
    case ID_HELP_LICENSE : break;
  }
}

void AccountWidget::doTransfer () {
  TransferDlg *td = new TransferDlg();
  td->exec();  
}

void AccountWidget::doReconcile () {
  ReconcileDlg *rd = new ReconcileDlg();
  rd->exec();  

}

void AccountWidget::doAdjustBalance () {
  BalanceDlg *bd = new BalanceDlg();
  bd->exec();
}


#include "accountwidget.moc"




