/******************************************************************************\
 gnofin/gnofin.h   $Revision: 1.8 $
 Copyright (C) 1999 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef FIN_GNOFIN_H
#define FIN_GNOFIN_H

#include <config.h>

//#define FIN_TRACE_ENABLE

#define FIN_TITLE	"Gnofin"
#define FIN_VERSION	VERSION

#define FIN_WITH_TOOLBAR 

#include <gtk/gtkwidget.h>
//#include "account.h"

extern gchar		* prog;		/* program name */

#ifdef FIN_SAFE_LIST_ENABLE
/* safety when accessing data through a GList */
gboolean fin_check_list(gpointer list, const gchar * file, gint lineno);
#define LIST_GET(type,list)  ((type *)(fin_check_list(list,__FILE__,__LINE__) ? (list)->data : NULL))
#else
#define LIST_GET(type,list)  ((type *)((list)->data))
#endif

#ifdef FIN_TRACE_ENABLE
void fin_pause();
void fin_real_trace(const char *,char *,...);
#define fin_trace(fmt, args...) fin_real_trace(__PRETTY_FUNCTION__, fmt, ## args)
#else
#define fin_pause()
#define fin_trace(fmt, args...) 
#endif

#define fin_exit gtk_main_quit

/* dialogs */
void fin_message_dialog(GtkWidget * parent, const gchar * message_type, const gchar * message, ... );
#define fin_info_dialog(w, m...)     fin_message_dialog(GTK_WIDGET(w), GNOME_MESSAGE_BOX_INFO, ##m)
#define fin_warning_dialog(w, m...)  fin_message_dialog(GTK_WIDGET(w), GNOME_MESSAGE_BOX_WARNING, ##m)
#define fin_error_dialog(w, m...)    fin_message_dialog(GTK_WIDGET(w), GNOME_MESSAGE_BOX_ERROR, ##m)

#define FIN_YES    0
#define FIN_NO     1
#define FIN_CANCEL 2
gint fin_question_dialog (GtkWidget * parent, const gchar * message);

gchar * fin_get_filename_dialog (GtkWidget   * parent, 
			 	 const gchar * title, 
				 const gchar * def_filename, 
				 gint          overwrite_protect);

#define sizeof_array(x)  (sizeof(x)/sizeof((x)[0]))

/* helper functions */
void fin_date_stringize  (gchar * buf, gint len, GDate * date);

#endif
