/******************************************************************************\
 gnofin/export.h   $Revision: 1.1 $
 Copyright (C) 1999 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef FIN_EXPORT_H
#define FIN_EXPORT_H

#include "account.h"

typedef struct _FinExportFilter FinExportFilter;

/* this export interface is meant to be very flexible by placing most if not all
 * of the burden of iterating over the account set on the export module.  perhaps
 * this will prove to be too little structure, preventing others from contributing
 * export filters.  we will just have to wait and see.
 *
 * the HTML and LaTeX export filters should be referenced as guides for writing
 * other export filters.
 *
 * make sure your module gets listed in gnofin.c or else it won't appear on the menu.
 */

struct _FinExportFilter
{
  /* indicates the name of export module, as seen in menu */
  const gchar * name;

  /* returns free form info string describing module
   * this is currently not used, but would be useful
   * for describing available modules */
  const gchar * info;

  /* called to export an account_set, the module might prompt
   * for more information at this point via a popup dialog 
   *
   * file     - output stream
   * filename - name of current data file (possibly NULL)
   * set      - address of current data set
   */
  gboolean  (* export)  (FILE          * file,
			 const gchar   * filename,
			 FinAccountSet * set);
};

#endif
