#ifndef BON_IO
#define BON_IO

#include <stdio.h>
#include "bonnie.h"
#include "bon_time.h"

typedef unsigned long MASK_TYPE;

class COpenTest
{
public:
  COpenTest();
  ~COpenTest();

  int create(CPCCHAR dirname, BonTimer &timer, int num, int max_size
                    , int min_size, int num_directories, bool do_random);
  int delete_random(BonTimer &timer);
  int delete_sequential(BonTimer &timer);
  int stat_random(BonTimer &timer);
  int stat_sequential(BonTimer &timer);

private:
  void make_names(bool do_random);
  int stat_file(CPCCHAR file);
  int create_a_file(const char *filename, char *buf, int size);
  int create_a_link(const char *original, const char *filename);

  int m_number;
  int m_number_directories;
  int m_max;
  int m_min;
  int m_size_range;
  char *m_dirname;
  char *m_file_name_buf;
  char **m_file_names;

  void random_sort();

  COpenTest(const COpenTest &t);
  COpenTest & operator =(const COpenTest &t);
};

#endif
