#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <sys/mman.h>
#include "ix_code.h"
#include "strop.h"

#define BUF_MAX 1000000

typedef struct {
    char*	ifname;
    FILE*	ifp;
    char*	afname;
    FILE*	afp;
    int		af_ps_mode;
    char*	xfname;
    FILE*	xfp;
    long	xfsize;    /* ƥȥեΥ */
    caddr_t	xfmap;     /* ƥȥեΥޥåץɥ쥹 */
} Opt;

Opt FD;

void message (char* str) { fputs(str, stderr); }

void encode (void)
{
    char buf[BUF_MAX];
    IxCodeInfo info;
    IxCode code;
    char ids[50];
    char *sp;
    unsigned int id;
    unsigned int bp = 0;
    unsigned int bp0 = 0;
    int MAX_INFO_NUM = 0;

    int i, euc, len, x;
    int count = 0;

    if (FD.ifname[0] == '*') {
/*	fputs("INPUT:  stdin\n", stderr);*/
	FD.ifp = stdin;
    } else {
/*	fprintf(stderr, "INPUT:  %s\n", FD.ifname);*/
	if ( (FD.ifp = fopen(FD.ifname, "r")) == NULL ) {
	    message("cannot open file"); exit(1);
	}
    }
/*    fprintf(stderr, "OUTPUT: %s\n", FD.xfname);*/
    if ( (FD.xfp = fopen(FD.xfname, "w+")) == NULL ) {
	message("cannot open file"); exit(1);
    }
/*    fprintf(stderr, "OUTPUT: %s\n", FD.afname);*/
    if ( (FD.afp = fopen(FD.afname, "w+")) == NULL ) {
	message("cannot open file"); exit(1);
    }

    info.str = (char*)malloc(BUF_MAX);
    info.files = NULL;

    while ( fgets(buf, BUF_MAX, FD.ifp) != NULL) {
	if (++count == 99) { count = 0; fprintf(stderr, ".");}
	/* Ф */
	if (sscanf(buf, "%s", info.str) < 1) break;
	info.s_len = strlen(info.str);
	/* ary */
	sp = buf; bp = bp0;
	if (FD.af_ps_mode == 1) {
	    fwrite(&bp, sizeof(int), 1, FD.afp);
	    len = strlen(info.str);
	    bp += len; sp += len;
	} else {
	    euc = 0;
	    for (i = 0; i < strlen(info.str); i++) {
		if (euc) {
		    euc = 0;
		} else {
		    fwrite(&bp, sizeof(int), 1, FD.afp);
		    if (*sp & 0x80) euc = 1;
		}
		bp++; sp++;
	    }
	}
	bp++;
	/*  */
	sscanf(sp, "%s", ids);
	info.num = atoi(ids);
	sp += strlen(ids) + 1;
	if (MAX_INFO_NUM < info.num) {
	    MAX_INFO_NUM = info.num;
	    free(info.files);
	    free(info.score);
	    info.files = (long*)malloc(sizeof(long)*info.num);
	    info.score = (char*)malloc(sizeof(char)*info.num);
	}
	for (i = 0; i < info.num; i++) {
	    /* ID  */
	    sscanf(sp, "%s", ids);
	    id = atoi(ids);
	    info.files[i] = id;
	    sp += strlen(ids) + 1;
	    /* score  */
	    sscanf(sp, "%s", ids);
	    id = atoi(ids);
	    info.score[i] = id;
	    sp += strlen(ids) + 1;
	}
	code = ix_encode(info);
	/*  */
	fwrite(code.buf, code.len, 1, FD.xfp);
	free(code.buf);
	bp0 += code.len;
    }
    fprintf(stderr, "\n");
}

void decode (void)
{
    int c;
    struct stat st;
    off_t sz;  /* ե륵 */
    int  xfd, i;
    unsigned char* xpt;
    unsigned char* last;
    IxCode     code;
    IxCodeInfo info;
    
    /* ϥե  */
/*    fprintf(stderr, "INPUT:  %s\n", FD.xfname);*/
    if ( (xfd = open(FD.xfname, O_RDONLY)) < 0 ) {
	message("cannot open file"); exit(1);
    }
    fstat(xfd, &st);
    sz = st.st_size;
    /* ޥå */
    if ((FD.xfmap = mmap((caddr_t)0, sz, PROT_READ, MAP_SHARED, xfd, 0))
	== (caddr_t)-1 ){
	fprintf (stderr, "file mapping error. '%s'\n",FD.xfname);
	exit(1);
    }
    /* եΥΤ뤿ν */
    if ((FD.xfp = fopen(FD.xfname, "r")) == NULL){
	fprintf(stderr,"cannot open array file '%s'.\n",FD.xfname);
	exit(1);
    }
    fseek(FD.xfp, 0L, 2);
    FD.xfsize = ftell(FD.xfp); /* / sizeof(long);*/
    /* Ĥ */
    fclose(FD.xfp);
    
/*    fprintf(stderr, "OUTPUT: stdout\n");*/
/*    printf("OUTPUT: %s\n", FD.ifname);
    if ( (FD.ifp = fopen(FD.ifname, "w+")) == NULL ) {
	message("cannot open file"); exit(1);
    }*/

    xpt = (char*)FD.xfmap;
    last = (char*)FD.xfmap + FD.xfsize;

    for (;;) {
	code.buf = xpt;
	info = ix_decode(code);
	printf("%s %d", info.str, info.num);
	for (i = 0; i < info.num; i++) {
	    printf(" %d %d", info.files[i], info.score[i]);
	}
	printf ("\n");
	xpt += info.code_len;
	free(info.files);
	if (xpt >= last) return;
    }
}

void print_help (void)
{
    printf ("IND text <-> Binary Converter\n"\
	    "  usage: indc (options) [fname]\n"\
	    "  options:\n"\
	    "     -d  : decode .ix file\n"\
	    "     -S  : input data from stdin\n"\
	    "     -l  : make .ary for prefix search\n"\
	    "     -h  : show this help\n");
    exit(0);
}

int main (int argc, char* argv[])
{
    int i;
    /* option default */
    char mode = 'e';
    int std_input = 0;
    char* filename = "MKIND";
    FD.af_ps_mode = 0;

    /* parse arguments */
    for (i = 1; i < argc; i++) {
	if (argv[i][0] != '-') {
	    filename = argv[i];
	    continue;
	}
	switch (argv[i][1]) {
	  case 'd':
	    mode = 'd';
	    break;
	  case 'S':
	    std_input = 1;
	    break;
	  case 'l':
	    FD.af_ps_mode = 1;
	    break;
	  default:
	    print_help();
	}
    }
    if (std_input)
	FD.ifname = "*";
    else
	FD.ifname = str_append(filename, ".ind");
    FD.afname = str_append(filename, ".ix.ary");
    FD.xfname = str_append(filename, ".ix");

    if (mode == 'e')
	encode();
    else
	decode();
}
