/*
 * Copyright (c) 1997, 1999  Motoyuki Kasahara
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <sys/types.h>

#include "eb.h"
#include "text.h"


/*
 * EUC JP to ASCII conversion table.
 */
static unsigned char
euc2ascii_table_a1[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x00 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x08 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x28 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x30 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x40 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x48 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x50 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x58 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x60 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x68 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x70 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x78 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x80 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x88 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x90 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x98 */
    0x00, 0x20, 0x00, 0x00, 0x2c, 0x2e, 0x00, 0x3a,     /* 0xa0 */
    0x3b, 0x3f, 0x21, 0x00, 0x00, 0x00, 0x60, 0x00,     /* 0xa8 */
    0x5e, 0x7e, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0xb0 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x2f,     /* 0xb8 */
    0x5c, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x27,     /* 0xc0 */
    0x00, 0x22, 0x28, 0x29, 0x00, 0x00, 0x5b, 0x5d,     /* 0xc8 */
    0x7b, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0xd0 */
    0x00, 0x00, 0x00, 0x00, 0x2b, 0x2d, 0x00, 0x00,     /* 0xd8 */
    0x00, 0x3d, 0x00, 0x3c, 0x3e, 0x00, 0x00, 0x00,     /* 0xe0 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c,     /* 0xe8 */
    0x24, 0x00, 0x00, 0x25, 0x23, 0x26, 0x2a, 0x40,     /* 0xf0 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0xf8 */
};

static unsigned char
euc2ascii_table_a3[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x00 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x08 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x10 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x18 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x20 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x28 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x30 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x38 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x40 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x48 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x50 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x58 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x60 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x68 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x70 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x78 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x80 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x88 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x90 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0x98 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0xa0 */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0xa8 */
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,     /* 0xb0 */
    0x38, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0xb8 */
    0x00, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,     /* 0xc0 */
    0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,     /* 0xc8 */
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,     /* 0xd0 */
    0x58, 0x59, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0xd8 */
    0x00, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,     /* 0xe0 */
    0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,     /* 0xe8 */
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,     /* 0xf0 */
    0x78, 0x79, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00,     /* 0xf8 */
};


/*
 * Convert the `workbuf' string from EUC to ASCII.
 */
int
eb_hook_euc_to_ascii(book, appendix, workbuf, code, argc, argv)
    EB_Book *book;
    EB_Appendix *appendix;
    char *workbuf;
    EB_Hook_Code code;
    int argc;
    const int *argv;
{
    int inc1, inc2;
    int outc = 0;

    inc1 = *((unsigned char *)workbuf);
    inc2 = *((unsigned char *)workbuf + 1);

    if (inc1 == 0xa1)
	outc = euc2ascii_table_a1[inc2];
    else if (inc1 == 0xa3)
	outc = euc2ascii_table_a3[inc2];

    if (outc == 0) {
	*workbuf = inc1;
	*(workbuf + 1) = inc2;
	*(workbuf + 2) = '\0';
    } else {
	*workbuf = outc;
	*(workbuf + 1) = '\0';
    }
    return 0;
}


/*
 * Hook for stop-code.
 */
int
eb_hook_stopcode(book, appendix, workbuf, code, argc, argv)
    EB_Book *book;
    EB_Appendix *appendix;
    char *workbuf;
    EB_Hook_Code code;
    int argc;
    const int *argv;
{
    if (appendix == NULL || appendix->sub_current == NULL
	|| appendix->sub_current->stop0 == 0) {
	if (argv[1] <= 0x01)
	    return -1;
    } else {
	if (argv[0] == appendix->sub_current->stop0
	    && argv[1] == appendix->sub_current->stop1)
	    return -1;
    }

    return 0;
}


/*
 * Hook for stop-code (obsoleted).
 */
int
eb_hook_stopcode_mixed(book, appendix, workbuf, code, argc, argv)
    EB_Book *book;
    EB_Appendix *appendix;
    char *workbuf;
    EB_Hook_Code code;
    int argc;
    const int *argv;
{
    return eb_hook_stopcode(book, appendix, workbuf, code, argc, argv);
}


/*
 * Hook for stop-code (obsoleted).
 */
int
eb_hook_stopcode_dummy(book, appendix, workbuf, code, argc, argv)
    EB_Book *book;
    EB_Appendix *appendix;
    char *workbuf;
    EB_Hook_Code code;
    int argc;
    const int *argv;
{
    return eb_hook_stopcode(book, appendix, workbuf, code, argc, argv);
}


/*
 * Hook for narrow local character.
 */
int
eb_hook_narrow_character_text(book, appendix, workbuf, code, argc, argv)
    EB_Book *book;
    EB_Appendix *appendix;
    char *workbuf;
    EB_Hook_Code code;
    int argc;
    const int *argv;
{
    if (appendix == NULL 
	|| eb_narrow_alt_character_text(appendix, argv[0], workbuf) < 0) {
	*workbuf = '<';
	*(workbuf + 1) = '?';
	*(workbuf + 2) = '>';
	*(workbuf + 3) = '\0';
    }

    return 0;
}


/*
 * Hook for wide local character.
 */
int
eb_hook_wide_character_text(book, appendix, workbuf, code, argc, argv)
    EB_Book *book;
    EB_Appendix *appendix;
    char *workbuf;
    EB_Hook_Code code;
    int argc;
    const int *argv;
{
    if (appendix == NULL
	|| eb_wide_alt_character_text(appendix, argv[0], workbuf) < 0) {
	*workbuf = '<';
	*(workbuf + 1) = '?';
	*(workbuf + 2) = '>';
	*(workbuf + 3) = '\0';
    }

    return 0;
}


/*
 * Convert `workbuf' to empty.
 */
int
eb_hook_empty(book, appendix, workbuf, code, argc, argv)
    EB_Book *book;
    EB_Appendix *appendix;
    char *workbuf;
    EB_Hook_Code code;
    int argc;
    const int *argv;
{
    *workbuf = '\0';
    return 0;
}


