#! /bin/bash
#
# Copyright (C) 1997-1998 Federico Di Gregorio.
#
# This program is part of the Defnitive Type Manager package.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTIBILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.

# This is a simple shell script that install four free fonts 
# and four aliases in a system wide directory.
# It takes just one parameter: add or remove

# IMPORTANT NOTE FOR DEBIAN DEVELOPERS
# You should not do as me and generate the catalog snippet
# on the fly! Generate it before and then double-check it
# for errors; when you are sure include in in your package.
# (I had to do it that way to put the right paths in because
# this script runs both as root and std user.)
# AGAIN: don't do that, please.

CURDIR=`pwd`
cd /usr/doc/dtm/examples

if ! test root = "`whoami`" ; then
  echo "you are not root: installing in your home directory..."
  SNIPPETS_DIR=$HOME/fonts/catalogs/type1
  OUTLINES_DIR=$HOME/fonts/type1/outlines
  DTM_OPTIONS="--local"
else
  echo "you are root: installing system wide..."
  SNIPPETS_DIR=/etc/dtm/catalogs/type1	
  OUTLINES_DIR=/usr/share/fonts/type1/outlines
  DTM_OPTIONS=""
fi

case "$1" in
  add)
    if [ ! -f $SNIPPETS_DIR ] ; then
      install -d $SNIPPETS_DIR
    fi
    if [ ! -f $OUTLINES_DIR ] ; then
      install -d $OUTLINES_DIR
    fi
    echo -n "copying the alias catalog snippet to $SNIPPETS_DIR..." && \
      install -m 644 aipotu $SNIPPETS_DIR && \
      echo " done"
    echo -n "copying font outlines to $OUTLINES_DIR..." && \
      install -m 644 UT*.pfa $OUTLINES_DIR && \
      echo " done"
    echo -n "generating the real catalog snippet in $SNIPPETS_DIR..." && \
      dtm-type1 -I "$OUTLINES_DIR/UT*.pfa" >$SNIPPETS_DIR/utopia && \
    echo " done"
    echo "running \`dtm --add $DTM_OPTIONS' to update font dirs..." 
    dtm --add $DTM_OPTIONS $SNIPPETS_DIR/utopia $SNIPPETS_DIR/aipotu
    if ! test root = "`whoami`" ; then
	echo -n "Using xset to add fonts to X11... " && \
	    xset +fp $OUTLINES_DIR && \
	    echo done
	echo Now set GS_LIB=$OUTLINES_DIR to have Ghostscript use the new fonts
    fi
  ;;
  remove)
    echo -n "removing font outlines from $OUTLINES_DIR..." && \
      rm -f $OUTLINES_DIR/UT*.pfa && \
      echo " done"
    echo "running \`dtm --purge $DTM_OPTIONS' to update font dirs..."
    dtm --purge $DTM_OPTIONS $SNIPPETS_DIR/aipotu $SNIPPETS_DIR/utopia
    echo -n "removing the catalog snippets from $SNIPPETS_DIR..." && \
      rm -f $SNIPPETS_DIR/aipotu $SNIPPETS_DIR/utopia && \
      echo " done"
  ;;
  aipotu)
    echo "running \`dtm --purge $DTM_OPTIONS' to update font dirs..."
    dtm --purge $DTM_OPTIONS $SNIPPETS_DIR/aipotu
    echo -n "removing the catalog snippet from $SNIPPETS_DIR..." && \
      rm -f $SNIPPETS_DIR/aipotu && \
      echo " done"
  ;;
  *)
    echo "usage: $0 {add|remove|aipotu}"
    echo "note: aipotu just removes the named fonts"
esac

cd $CURDIR
