/***********************************************************************
 *               Copyright (C) 1995 Joe English
 *                   Freely redistributable
 ***********************************************************************
 *
 * File:	strmap.h
 * Author: 	Joe English
 * Created: 	1 Feb 1995
 * Description:	Associative arrays mapping strings to strings.
 *
 * 1997/08/07 11:08:47
 * 1.5
 * 
 */

#ifndef STRMAP_H
#define STRMAP_H 1

typedef struct strmapRec *strmap;

extern strmap 	strmap_create	(void);
extern void	strmap_destroy	(strmap);

extern void	strmap_set	(strmap, const char *key, const char *value);
	/* saves copy of value */
extern char*	strmap_get	(strmap, const char *key);
	/* returns ptr to private storage, NULL if not found */
extern void 	strmap_unset	(strmap, const char *key);
	/* remove key binding */

#endif /* STRMAP_H */
