#include "primes.hh"
#include <cmath>

namespace autil {

  using namespace std;

  void Primes::resize(size_type s) {
    size_type i, j = 2;
    data.resize(s);
    for(i = 0; i < s; ++i) 
      data[i] = true;
    if (s > 0)
      data[0] = false;
    if (s > 1)
      data[1] = false;
    size_type sqrt_s = static_cast<size_type>(sqrt(s));
    while (j < sqrt_s) {
      for (i = 2*j; i < s; i += j) {
	data[i] = false;
      }
      ++j;
      for (;j < sqrt_s && !data[j]; ++j);
    }
  }

  bool Primes::is_prime(size_type n) const {
    if (n < size()) {
      return data[n];
    } else {
      size_type e = static_cast<size_type>(sqrt(n));
      for (const_iterator i = begin(); *i < e; ++i) 
	if (!(n % *i)) return false;
      return true;
    }
  }
}
