
#include <iostream>
#include <string>

namespace autil {

  struct PhonetParms {
    string version;
    
    bool followup;
    bool collapse_result;

    static const char * const rules_end;
    const char * * rules;

    char to_upper[256];
    bool is_alpha[256];

    static const int hash_size = 256;
    int hash[hash_size];

    virtual PhonetParms * clone() const = 0;
    virtual void assign(const PhonetParms *) = 0;
    virtual ~PhonetParms() {}
  };

  void init_phonet_charinfo(PhonetParms & parms);
  void init_phonet_hash(PhonetParms & parms);
  int phonet (const char * inword, char * target, 
	      const PhonetParms & parms);

  void dump_phonet_rules(ostream & out, const PhonetParms & parms);
  // the istream must be seekable
  PhonetParms * load_phonet_rules(const string & file);

}
