#ifndef __autil_edit_distance_hh__
#define __autil_edit_distance_hh__

#include "weights.hh"

namespace autil {

  // edit_distance finds the shortest edit distance.  The edit distance is 
  // (cost of swap)(# of swaps) + (cost of deletion)(# of deletions) 
  //   + (cost of insertion)(# of insertions) 
  //   + (cost of substitutions)(# of substitutions)
  //   + (cost of "similea" match)(# of similar match)

  // A similar match is generally a match that is not case sensitive

  // Preconditions:
  // max(strlen(a), strlen(b))*max(of the edit weights) <= 2^15
  //   a[i] == b[j] implies a2[i] == b2[j]
  //   strlen(a) == strlen(a2) && strlen(b) == strlen(b2)
  //   a,a2,b,b2 are not null pointers
  // a2 and b2 are typicaly the lower case version of a string but
  // they don't have to be.  If a2[i] == b2[j] but a[i] != b[j] then
  // weight.simalar is added the the total cost and i and j are
  // incremented as if they matched exactly.  This means that
  // weight.simalar is expected to be rather low.
  // Returns:
  //   the edit distance between a and b

  short edit_distance(const char *a, const char *b,
		       const char *a2, const char *b2,
		       const EditDistanceWeights &);

  inline short edit_distance(const char *a, const char *b,
			     const EditDistanceWeights & w 
			     = EditDistanceWeights()) 
  {
    return edit_distance(a,b,a,b,w);
  }
  
}

#endif
