
#include <string>

#include "clone_ptr.hh"

namespace afilter {
  class FilterItrPart;
  class FilterItrRoot;
}

namespace aspell {

  class Language;

  using namespace autil;
  using namespace afilter;

  class TokenItr {
  private:
    bool                     is_word_;
    ClonePtr<FilterItrPart>  begin_;
    ClonePtr<FilterItrPart>  end_;
    char                     end_char;
    string                   word_;
    ClonePtr<FilterItrPart>  next;
    const Language *         lang;

  public:
    TokenItr(const Language & l) : lang(&l) {}

    void start_over();
    void reset();
    void backup(); 
    //: back up to the beginning of the current token.
    // Only valid when is_word is true.
    void restart(const FilterItrRoot & start);
    //: restart with a new iterator.  
    //  The iterator must be pointing one past word_end.
    //  If backup was called the iterator should point to the
    //  beginning of the word.
    void scan(const FilterItrRoot & stop);
    void add(FilterItrPart * to_add);

    const FilterItrPart & word_begin() const {return *begin_;}
    const FilterItrPart & word_end()   const {return *end_;}
    const string & word() const {return word_;}
    bool is_word() const {return is_word_;}

    void advance();

    bool at_end() const {return word_.empty();}
  };
  
}
  

  
